                           THE - The Hessling Editor
     
     OVERVIEW
     
     THE is a text editor that uses both command line commands and key bindings
     to operate.
     
     The screen display consists of several windows:
        - a main body window which displays the contents of the file being
          editted,
        - a command line from which commands may be issued,
        - a prefix window which shows the line number (no prefix commands yet),
        - an id window which displays the file name, row/col etc. for the
          current file and
        - a status line which indicates global status info like number of files
          being editted, time etc.
     
     An important distinction must be made between what is called the current
     line and the focus line. The focus line is that line in the main body in
     which the cursor is displayed. All commands bound to function keys use the
     focus line as the initial line from which to begin executing the command.
     Commands issued from the command line use the current line as the starting
     line for execution of commands. The current line is the line in the main
     body that is highlighted; by default line 6.
     
     To move between the command line and the main body the 'tabcmd' command is
     used. By default it is bound to the Home key (on PCs), the Do key
     (on vt220s) and F12 (on xterms). To determine what keys are bound to what
     commands, type 'show' followed by Return on the command line, then follow
     the directions displayed.
     Key bindings may be changed for the current session by using the 'define'
     command.
     
     Various session default may be changed on startup for an individual by
     using a profile file. This file contains various commands that set the
     current environment, including key bindings. This profile file can also be
     used to process commands in a batch mode. For example, to change all
     occurrences of 'alligator' to 'crocodile' in the file file.ext in batch
     mode a profile file (prf.prf) with the following commands would be used:
     
          c/alligator/crocodile/ * *
          file
     
     and the command
     
          the -p prf.prf file.ext
     
     would be issued.
     
     This changes the first string enclosed in delimiters (either /,\ or @) to
     the second string for every line (*) starting at the current line
     (0 initially) changing each occurrence on a line (*).
     Maybe you only want to change a string after the first line that contains
     the string 'donkey', but only change the second occurrence of that string.
     The profile commands would then be:
     
          /donkey/
          c/alligator/crocodile/ * 1 2
          file
     
     The change command uses a 'target' specification as its first parameter
     after the string details. A target can be a number of lines, an absolute
     line number or a string.
     Number of line targets consist of either a positive integer, for
     referencing lines toward the end of the file, negative for referencing
     toward the start of the file or '*', which is all the remaining lines in
     the file or '-*' which is all lines toward the start of the file.
     An absolute line number in the form of ':n' is the line number in a file,
     starting with line number 1.
     A target is any string within the allowable target delimiters.
     
     For more information on default key bindings see the *.hlp files. Detailed
     documentation of each command is present in each of the comm*.c files.
     
     
     --------------------------------------------------------------------------
     
     
     COMMAND REFERENCE



     --------------------------------------------------------------------------
     COMMAND
          add - add blank line
     
     SYNTAX
          ADD [n]
     
     DESCRIPTION
          The ADD command inserts the specified number of blank lines after
          the current_line (if issued from the command line) or after the
          focus_line (if issued in the main of prefix windows).
          The cursor is positioned in the column corresponding to the first
          column not containing a space in the line above.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          With no parameters, 1 line is added.
     
     SEE ALSO
          Sos_addline
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          all - select and display restricted set of lines
     
     SYNTAX
          ALL [string target]
     
     DESCRIPTION
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
     
     SEE ALSO
     
     STATUS
          Not Started



     --------------------------------------------------------------------------
     COMMAND
          autosave - set autosave period
     
     SYNTAX
          AUtosave n|OFF
     
     DESCRIPTION
          The AUTOSAVE command sets the interval between automatic saves
          of the file, or turns it off altogether.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          backward - scroll backwards one screen
     
     SYNTAX
          BACkward [n]
     
     DESCRIPTION
          The BACKWARD command scrolls the file contents backwards one full
          screen.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          With no parameters, 1 screen is scrolled.
     
     SEE ALSO
          forward,top
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          bottom - move to the bottom of the file
     
     SYNTAX
          BOTtom
     
     DESCRIPTION
          The BOTTOM command moves to the very end of the current file.
          The "Bottom-of-file" line is set to the current_line.
     
          "BOTTOM" is equivalent to "FORWARD *".
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          forward,top
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          cancel - quickly exit from THE
     
     SYNTAX
          CANcel
     
     DESCRIPTION
          The CANCEL command exits from THE quickly by QQUITting out of all
          files currently in the ring that do not have any outstanding
          alterations.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          ccancel
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          case - set case sensitivity parameters
     
     SYNTAX
          CASE Mixed|Lower|Upper [Respect|Ignore] [Respect|Ignore]
     
     DESCRIPTION
          The CASE command sets the editor's handling of the case of text.
     
          The first option (which is mandatory) controls how text is entered
          by the user. When LOWER or UPPER are in effect, the shift or caps
          lock keys have no effect on the text being entered. When MIXED is
          in effect, text is entered in the case set by the use of the shift
          and caps lock keys.
     
          The second option determines how the editor determines if a string
          target matches text in the file when the target is used in a LOCATE
          command.  With IGNORE in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With RESPECT in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
          The third option determines how the editor determines if a string
          target matches text in the file when the target is used in a CHANGE
          command.  With IGNORE in effect, a match is
          found irrespective of the case of the target or the found text.
          The following strings are treated as equivalent: the THE The ThE...
          With RESPECT in effect, the target and text must be the same case.
          Therefore a target of 'The' only matches text containing 'The', not
          'THE' or 'ThE' etc.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          MIXED IGNORE RESPECT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          ccancel - quickly exit from THE
     
     SYNTAX
          CCancel
     
     DESCRIPTION
          The CCANCEL command exits from THE quickly by QQUITting out of all
          files currently in the ring. Any changes made to any of the files
          will be lost.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          cancel
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          change - change file text
     
     SYNTAX
          Change /string1/string2/ [target] [n] [m]
     
     DESCRIPTION
          The CHANGE command changes one string of text to another.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The allowable delimiters are '/' '\' and '@'.
     
          The second parameter is the target; how many lines are to be
          searched for occurrences of the first string to be changed.
     
          The third parameter determines how many occurrences of 'string1'
          are to be changed on each line.
     
          The fourth parameter determines at which occurrences of 'string1'
          on the line are changes to commence.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          schange
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmatch - find matching bracket character
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The CMATCH command searches for the matching bracket character to
          the character under the cursor.
     
          It handles nested sets of matching pairs.
          The matching character pairs are '[]{}<>()'.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          cmdarrows - sets the functionality of the up and down arrows on the
                       command line.
     
     SYNTAX
          CMDArrows RETRIEVE|TAB
     
     DESCRIPTION
          The CMDARROWS command determines the action that occurs when the up
          and down arrows are hit while the cursor is on the command line.
          CMDARROWS RETRIEVE (the default) will set the up and down arrows
          to retrieve the last or next command entered on the command line.
          CMDARROWS TAB will set the up and down arrows to move to the last
          or first line respectively of the main window.
     
     COMPATIBILITY
          New function.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          colour - set colours for display
     
     SYNTAX
          [SET] colour | color area [modifier] [foreground background]
     
     DESCRIPTION
          The COLOUR command changes the colours or display attributes of
          various display areas in THE.
     
          Valid values for 'area':
            filearea - area containing file lines
            curline  - the current line
            block    - marked block
            cblock   - current line if in marked block
            cmdline  - command line
            idline   - line containing file specific info
            msgline  - error messages
            arrow    - command line prompt
            prefix   - prefix area
            pending  - pending commands in prefix
            scale    - line showing scale line (N/A)
            tofeof   - *** Top of File *** and *** Bottom of File *** lines
            ctofeof  - as above if the same as current line
            tabline  - line showing tab positions (N/A)
            shadow   - hidden line marker lines (N/A)
            statarea - line showing status of editting session
            divider  - dividing line between vertical split screens
     
          Valid values for 'foreground' and 'background':
            black,blue,green,cyan,red,magenta,yellow,white
     
          Valid values for 'modifier':
            normal,blink,bold,reverse,underline
     
     COMPATIBILITY
          Does not implement all modifiers.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          control_char - allow control characters to be entered
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The CONTROL_CHAR command prompts the user to enter a control character.
     
     COMPATIBILITY
          New feature.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          copy - copies text from one position to another
     
     SYNTAX
          COPY BLOCK
     
     DESCRIPTION
          The COPY command copies text from one part of a file to another.
          The text can be in the same file or a different file.
     
     COMPATIBILITY
          Does not implement target option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          define - assign a command to a key
     
     SYNTAX
          DEFine key-name command [parameters]
     
     DESCRIPTION
          The DEFINE command allows the user assign a command and an optional
          parameter to a key.
     
          key-names correspond to the key values specified in the 'curses.h'
          file.
     
     COMPATIBILITY
          Minimal. No support for in-memory macro commands.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          delete - delete lines from a file
     
     SYNTAX
          DELete [target]
     
     DESCRIPTION
          The DELETE command allows the user remove lines from the current
          file. The number of lines removed depends on the target specified.
          Lines are removed starting with the current_line.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          1 (the current line)
     
     SEE ALSO
          Sos_delete
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          directory - list the specified directory
     
     SYNTAX
          DIRectory [directory]
     
     DESCRIPTION
          The DIRECTORY command displays all files in the specified directory.
          When no parameter is supplied, the current directory is displayed.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          down_arrow - move the cursor down one line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The down_arrow command moves the cursor down one line in the main
          window. Scrolling of the window occurs if the cursor is on the last
          line of the window.
     
          When on the command line, this command moves forward through the
          list of previous command line commands or tabs to the first line of
          the main window depending on the value set by the function
          cmdarrows. (default is the former)
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Up_arrow
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          edit - edit another file
     
     SYNTAX
          Edit [filename]
     
     DESCRIPTION
          The EDIT command allows the user to edit another file. The new file
          is placed in the file ring. The previous file being editted remains
          in memory and can be returned to by issuing an EDIT command without
          any parameters. Several files can be editted at once, and all files
          are arranged in a ring, with subsequent EDIT commands moving through
          the ring, one file at a time.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          enter - execute a command
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The ENTER command executes the command currently displayed on the
          command line, if the cursor is currently displayed there.
          If the key associated with ENTER is pressed while in the main or
          prefix window, then the cursor will move to the first column of the
          next line. If the mode is currently in 'insert', then a new line
          is added and the cursor placed at the first column of the new line.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          eolout - set end of line terminator
     
     SYNTAX
          EOLout CRLF|LF
     
     DESCRIPTION
          The EOLOUT command allows the user to specify the combination of
          characters that terminate a line. Lines of text in U*ix files are
          usually terminated with a LF, whereas in DOS they usually end with
          a CR and LF combination.
     
     COMPATIBILITY
          Does not implement CR option.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          ffile - force file the current file to disk
     
     SYNTAX
          FFile  [filename]
     
     DESCRIPTION
          The FFILE command writes the current file to disk to the current
          file name or to the supplied filename.
          Unlike the FILE command, if the optional filename exists, this
          command will overwrite the file.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          file,save,ssave
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          file - file the current file to disk
     
     SYNTAX
          FILE  [filename]
     
     DESCRIPTION
          The FILE command writes the current file to disk to the current
          file name or to the supplied filename.
          Unlike the FFILE command, if the optional filename exists, this
          command will not overwrite the file.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          With no parameters, the current file is written.
     
     SEE ALSO
          ffile,save,ssave
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          forward - scroll forwards a number of screens
     
     SYNTAX
          FORward [n]
     
     DESCRIPTION
          The FORWARD command scrolls the file contents forwards the number
          of screens specified.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          With no parameters, 1 screen is scrolled.
     
     SEE ALSO
          backward,top
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          get - read another file into current file
     
     SYNTAX
          GET [fileid]
     
     DESCRIPTION
          The GET command reads a file into the current file, inserting
          lines after the current line.
          When no fileid is supplied the temporary file is used.
     
     COMPATIBILITY
          Does not support optional fromlines - forlines.
     
     SEE ALSO
          put,putd
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          help - display help for the editor
     
     SYNTAX
          HELP
     
     DESCRIPTION
          The HELP command displays help for the editor.
          Uses THE_HELP environment variable to point to the help file.
     
     COMPATIBILITY
          Should be similar.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          input - insert the command line contents into the file
     
     SYNTAX
          Input contents
     
     DESCRIPTION
          The INPUT command inserts the remainder of the command line into the
          file aafter the current line.
     
     COMPATIBILITY
          Should be similar.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          insertmode - put editor into insert mode
     
     SYNTAX
          INSERTMode
     
     DESCRIPTION
          The insertmode command toggles the insert mode within THE.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          left_arrow - move the cursor left one column
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The left_arrow command moves the cursor left one column in the
          current window. Scrolling of the main window horizontally, occurs
          if the cursor is at the left-most column and the left-most column
          is not the first column of the line.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Right_arrow
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          locate - find the next/prev occurrence of a string
     
     SYNTAX
          [Locate] [string target]
     
     DESCRIPTION
          The LOCATE command looks for the next or previous occurrence of the
          specified string target.  If no parameter is supplied, LOCATE
          searches for the string that was used as the last string target, if
          such a string exists.
     
     COMPATIBILITY
          Compatible.
          Does not support not,and,or combinations of string targets.
          ie ~,& and | not supported.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          mark - mark a portion of text
     
     SYNTAX
          MARK Line|Box|Stream
     
     DESCRIPTION
          The MARK command marks a portion of text for later processing
          usually by a COPY or MOVE command.
     
     COMPATIBILITY
          Does not implement Box or Stream...yet.
     
     STATUS
          Complete...LINE option is anyway.



     --------------------------------------------------------------------------
     COMMAND
          move - move a portion of text
     
     SYNTAX
          MOVE BLOCK
     
     DESCRIPTION
          The MARK command marks a portion of text for later processing
          usually by a COPY or MOVE command.
     
     COMPATIBILITY
          Does not implement Box or Stream...yet.
     
     STATUS
          Bug with positioning of cursor when moving text from one view to
          another. The cursor is left where it was when in that view. If the
          delete of lines causes the bottom of the file to be positioned
          above the focus line, the cursor will appear in no-man's land.
          Use refresh to correct display.



     --------------------------------------------------------------------------
     COMMAND
          next - move forward in the file a number of lines
     
     SYNTAX
          Next [target]
     
     DESCRIPTION
          The NEXT command moves the current_line forwards the number of
          lines specified by the target. Negative targets move backwards
          through the file.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Up
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          nextwindow - switch focus of editting session to other window
     
     SYNTAX
          NEXTWindow
     
     DESCRIPTION
          The NEXTWINDOW command moves the focus of the editting session to
          the other window (if more than one window is currently displayed)
          or to the next file in the ring.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Edit,Screen
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          os_cmd - execute an operating system command
     
     SYNTAX
          !|dos [command]
     
     DESCRIPTION
          The OS_CMD command executes the supplied os command.
     
          This command is not called directly but is called with the ! or
          dos commands.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          prefix - set prefix area attributes
     
     SYNTAX
          PREfix ON|OFF [Left|Right]
     
     DESCRIPTION
          The PREFIX set command determines if the prefix area is displayed
          and if so, where it is displayed.
          Executed from within the profile, the only effect is that the
          defaults for all files is changed.
          Executed from the command line, the PREFIX command changes the
          current window displays to reflect the required options.
     
     COMPATIBILITY
          Does not support PREFIX NULLS or PREFIX SYNONYM.
     
     DEFAULT
          PREFIX ON LEFT
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          print - send text to default printer or print spooler
     
     SYNTAX
          PRint [target] [n]
          PRint LINE [text]
          PRint STRING [text]
          PRint FORMfeed
          PRint CLOSE
     
     DESCRIPTION
          The PRINT command writes a portion of the current file to the default
          printer or print spooler, or text entered on the command line.
          PRINT LINE sends the remainder of the text on the command line to
          the printer followed by a CR/LF (DOS) or LF(UNIX).
          PRINT STRING sends the remainder of the text on the command line to
          the printer without any trailing line terminator.
          PRINT FORMFEED sends a formfeed (^L) character to the printer.
          PRINT CLOSE closes the printer spooler.
          PRINT target sends text from the file contents up to the target to
          the printer followed by a CR/LF (DOS) or LF(UNIX) after each line.
          When an optional [n] isspecified, this sends a formfeed after [n]
          successive lines of text.
     
     COMPATIBILITY
          Does not allow for different printer ports or print spoolers...yet.
     
     SEE ALSO
          printer
     
     STATUS
          Incomplete



     --------------------------------------------------------------------------
     COMMAND
          printer - define printer spooler name
     
     SYNTAX
          PRINTER spooler
     
     DESCRIPTION
          The PRINTER command sets up the print spooler name to determine
          where output from the PRINT command goes.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          print
     
     STATUS
          Incomplete



     --------------------------------------------------------------------------
     COMMAND
          put - write part of a file to another
     
     SYNTAX
          PUT [target] [fileid]
     
     DESCRIPTION
          The PUT command writes a portion of the current file to another
          file, either explicit or temporary.
          When no fileid is supplied the temporary file is overwritten.
          When a fileid is supplied the portion of the file written out
          is appended to the specified file.
     
     COMPATIBILITY
          Complete.
     
     SEE ALSO
          put,get
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          putd - write part of a file to another and delete
     
     SYNTAX
          PUTD [target] [fileid]
     
     DESCRIPTION
          The PUTD command writes a portion of the current file to another
          file, either explicit or temporary and deletes those lines written.
          When no fileid is supplied the temporary file is overwritten.
          When a fileid is supplied the portion of the file written out
          is appended to the specified file.
     
     COMPATIBILITY
          Complete.
     
     SEE ALSO
          put,get
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          quit - exit from the current file
     
     SYNTAX
          QUIT
     
     DESCRIPTION
          The QUIT command exits the user from the current file, provided
          no changes have been made to the file. An error message will be
          displayed if changes have been made.
          The previous file in the ring then becomes the current file.
          If the current file is the only file in the ring, the user is
          returned to the Operating System.
     
     COMPATIBILITY
          Complete.
     
     SEE ALSO
          qquit
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          qquit - exit from the current file
     
     SYNTAX
          QQuit
     
     DESCRIPTION
          The QQUIT command exits the user from the current file, whether
          changes have been made to the file or not.
          The previous file in the ring then becomes the current file.
          If the current file is the only file in the ring, the user is
          returned to the Operating System.
     
     COMPATIBILITY
          Complete.
     
     SEE ALSO
          quit
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          query - display various option settings
     
     SYNTAX
          Query RING|etc
     
     DESCRIPTION
          The QUERY command displays the various settings for options set
          by THE.
     
     COMPATIBILITY
          Shows some options.
     
     STATUS
          Not started.



     --------------------------------------------------------------------------
     COMMAND
          recover - recover changed or deleted lines
     
     SYNTAX
          RECover [n|*]
     
     DESCRIPTION
          The RECOVER command restores the last n changed or deleted lines
          back into the body of the file.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Just started.



     --------------------------------------------------------------------------
     COMMAND
          refresh - redraw the current screen
     
     SYNTAX
          REFresh
     
     DESCRIPTION
          The REFRESH command redraws the current contents of the screen.
          This is usually used when some outside influence has stuffed the
          display up.
     
     COMPATIBILITY
          Not applicable.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          reset - cancel the marked block or prefix commands or both
     
     SYNTAX
          RESet ALL|Block|Prefix
     
     DESCRIPTION
          The RESET command unmarks any marked block or outstanding prefix
          commands or both.
     
     COMPATIBILITY
          Only supports BLOCK... at the moment.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          retrieve - return the next/prior command
     
     SYNTAX
          ? [+]
     
     DESCRIPTION
          The ? command returns the next or prior command from the command
          line stack and displays it on the command line.
          With no parameters, the most recent command entered on the command
          line is retrieved.
     
     COMPATIBILITY
          Does not support multiple '?' as in ??? to retrieve the third last
          command.
          This command is bound to the up and down arrows when on the
          command line.
     
     SEE ALSO
          cmdarrows
     STATUS
          Incomplete. Arrows key binding is functional.



     --------------------------------------------------------------------------
     COMMAND
          right_arrow - move the cursor to the right
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The right_arrow key causes the cursor to move one column to the
          right. If the cursor is on the right most column of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          Does not line wrap when encountering the right edge of the screen.
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          save - save changes to current file
     
     SYNTAX
          SAVE [fileid]
     
     DESCRIPTION
          The save command writes the current file to disk. If a fileid is
          supplied, the current file is saved in that file, unless the file
          already exists when an error is displayed.
          The 'Alterations' counter on the heading line is reset to zero.
     
     COMPATIBILITY
          Complete
     
     SEE ALSO
          ssave, file, ffile
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          schange - selectively change strings
     
     SYNTAX
          Change /string1/string2/ [target] [n] [m]
     
     DESCRIPTION
          The CHANGE command changes one string of text to another.
     
          The first parameter to the change command is the old and new
          string values, seperated by delimiters.
          The allowable delimiters are '/' '\' and '@'.
     
          The second parameter is the target; how many lines are to be
          searched for occurrences of the first string to be changed.
     
          The third parameter determines how many occurrences of 'string1'
          are to be changed on each line.
     
          The fourth parameter determines at which occurrences of 'string1'
          on the line are changes to commence.
     
     COMPATIBILITY
          Compatible.
     
     DEFAULT
          1 1 1
     
     SEE ALSO
          change
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          screen - specifiy number of screens displayed
     
     SYNTAX
          SCReen n [Horizontal|Vertical]
     
     DESCRIPTION
          The SCREEN command specifies the number of views of file(s) to
          display on screen at once. If the number of views specified is 2
          and only one file is currently in the ring, two views of the
          same file are displayed.
          Only 2 views are supported.
     
     COMPATIBILITY
          Only supports above option.
     
     STATUS
          Not complete. (Unavailable)



     --------------------------------------------------------------------------
     COMMAND
          set - execute various set commands
     
     SYNTAX
          SET set command [set command parameter ...]
     
     DESCRIPTION
          The SET command is a front end to existing 'set' commands. It treats
          the first parameter it receives as a command and executes it.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          showkey - display current key value and command assignation
     
     SYNTAX
          SHOWKey KEY
     
     DESCRIPTION
          The SHOWKEY command prompts the user to enter a key and responds
          with the key name and associated command (if applicable).
     
     COMPATIBILITY
          New feature.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          spltjoin - split/join two lines
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The SPLTJOIN command splits the focus line into two or joins the
          focus line with the next line depending on the position of the
          cursor. If the cursor is after the last column of a line, a 'join'
          is executed, otherwise a 'split' is executed.
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Incomplete. Does not have [aligned] option.



     --------------------------------------------------------------------------
     COMMAND
          ssave - save changes to current file
     
     SYNTAX
          SSave [fileid]
     
     DESCRIPTION
          The ssave command writes the current file to disk. If a fileid is
          supplied, the current file is saved in that file, otherwise the
          current name of the file is used.
          If a fileid is supplied and that fileid already exists, the previous
          contents of that fileid will be replaced with the current file.
          The 'Alterations' counter on the heading line is reset to zero.
     
     COMPATIBILITY
          Complete
     
     SEE ALSO
          save, file, ffile
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          stay - set condition of cursor position after CHANGE/LOCATE commands
     
     SYNTAX
          STAY ON|OFF
     
     DESCRIPTION
          The STAY set command determines what line is displayed as the current
          line after an unsuccessful LOCATE command or after a CHANGE command.
          With STAY ON, the current line remains where it currently is. With
          STAY OFF, after an unsuccessful LOCATE, the current line is "Bottom
          of File". After a successful CHANGE, the current line is the last
          line affected by the CHANGE command.
     
     COMPATIBILITY
          Complete
     
     DEFAULT
          STAY ON
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          tabcmd - switch windows (main/prefix command) for the current file
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The TABCMD command switches the focus of the editor from the
          main or prefix windows to the command line and vice versa, depending
          on which window is currently active.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          tabpre
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabkey - set characteristics of the tab key
     
     SYNTAX
          TABKey Insert|Overstrike|Both Tab|Character
     
     DESCRIPTION
          The TABKEY sets the action to be taken when the tab key is hit.
          Depending on the insert mode, the tab key will either display
          a raw tab character or will move to the next tab column.
     
     COMPATIBILITY
          New function.
     
     DEFAULT
          INSERT CHARACTER, OVERSTRIKE TAB
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          tabpre - switch windows (main prefix) for the current file
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The TABPRE command switches the focus of the editor from the
          main window to the prefix window and vice versa, depending
          on which window is currently active.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          tabcmd
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabs - set tab length for TAB key
     
     SYNTAX
          TABS INCR n
     
     DESCRIPTION
          The TABS command determines the position of tab columns when the
          TAB key is pressed.
     
     COMPATIBILITY
          Does not support specification of actual tab columns.
     
     SEE ALSO
          sos_tabf
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabsin - set tab processing on file input
     
     SYNTAX
          TABSIn ON|OFF [n]
     
     DESCRIPTION
          The TABSIN command determines if tabs read from a file are to be
          expanded to spaces and if so how many spaces.
     
     COMPATIBILITY
          Does not support TABQUOTE option.
     
     SEE ALSO
          tabsout
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          tabsout - set tab processing on file output
     
     SYNTAX
          TABSOut ON|OFF [n]
     
     DESCRIPTION
          The TABSOUT command determines if spaces written to a file are to be
          compressed to tabs and if so how many spaces.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          tabsin
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          top - move to the top of the file
     
     SYNTAX
          TOP
     
     DESCRIPTION
          The TOP command moves to the very start of the current file.
          The "Top-of-file" line is set to the current_line.
     
          "TOP" is equivalent to "BACKWARD *".
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          backward,bottom
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          up - move backward in the file a number of lines
     
     SYNTAX
          Up [target]
     
     DESCRIPTION
          The UP command moves the current_line backwards the number of
          lines specified by the target. Negative targets move forwards
          through the file.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Next
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          up_arrow - move the cursor up one line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The up_arrow command moves the cursor up one line in the main
          window. Scrolling of the window occurs if the cursor is on the first
          line of the window.
     
          When on the command line, this command moves backward through the
          list of previous command line commands or tabs to the last line of
          the main window depending on the value set by the function
          cmdarrows. (default is the former)
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Down_arrow
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          verify - set column display limits
     
     SYNTAX
          Verify first [last]
     
     DESCRIPTION
          The VERIFY command sets the column limits for the display of the
          current file. 'first' specifies the first column to be displayed
          and 'last' specifies the last column to be displayed.
     
          If no 'last' option is specified '*' is assumed.
     
     COMPATIBILITY
          Does not implement HEX display nor multiple column pairs.
     
     SEE ALSO
          Zone
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          zone - set column limits for editting
     
     SYNTAX
          Zone first [last]
     
     DESCRIPTION
          The ZONE command sets the column limits for various other editor
          commands, such as 'locate' and 'change'. It effectively restricts
          the editable (?) portion of the file to the specified columns.
     
          If no 'last' option is specified '*' is assumed.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          Verify
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_addline - add blank line after focus line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_addline command inserts a blank line in the file following
          the focus line. The cursor is placed in the column under the first
          non-blank in the focus line.
     
     COMPATIBILITY
          Reasonable.
     
     SEE ALSO
          sos_delline
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos_delback - delete the character to the left of the cursor
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_delback command moves the cursor one character to the left
          and deletes the character now under the cursor.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          sos_delchar
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos_delchar - delete character under cursor
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_delchar command deletes the character under the cursor.
          Text to the right is shifted to the left.
     
     COMPATIBILITY
          Complete
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos_delend - delete to end of line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_delend command deletes all characters from the current
          column to the end of line.
     
     COMPATIBILITY
          Complete
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_delline - delete focus line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_delline command deletes the focus line.
     
     COMPATIBILITY
          Complete
     
     STATUS
          Complete



     --------------------------------------------------------------------------
     COMMAND
          sos_edit - edit a file from directory list
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_edit command allows the user to edit a file, chosen from
          a directory list.(the file DIR.DIR).
     
     COMPATIBILITY
          Compatible.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_endchar - move cursor to end/start of focus line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_endchar command moves the cursor to the first character
          displayed in the current window, if the cursor is after the last
          character displayed in the current window, or to the position after
          the last character displayed in the current window, if the cursor is
          anywhere else.
     
     COMPATIBILITY
          The possible combinations of VERIFY etc. make mimicing *EDIT very
          difficult. The command is, on the surface, compatible.
     
     STATUS
          incomplete-problem determining exactly where the cursor should go
          when a verify end is in place and we are going to the end of line



     --------------------------------------------------------------------------
     COMMAND
          sos_tabf - move cursor to next tab stop
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_tabf command causes the cursor to move to the next tab column
          as set by the TABS command. (The default is 8).
          If the resulting column is beyond the right hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          Does not line tab to next line if after the right hand tab column.
     
     SEE ALSO
          tabs
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_tabwordb - move cursor to beginning of previous word
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_tabwordb command causes the cursor to move to the first character
          of the word to the left or to the start of the line if no more
          words precede.
          If the resulting column is beyond the left hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          sos_tabwordf
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_tabwordf - move cursor to start of next word
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_tabwordf command causes the cursor to move to the first character
          of the next word to the right or to the end of the line if no more
          words follow.
          If the resulting column is beyond the right hand edge of the main
          window, the window will scroll half a window.
     
     COMPATIBILITY
          Compatible.
     
     SEE ALSO
          sos_tabwordb
     
     STATUS
          Complete.



     --------------------------------------------------------------------------
     COMMAND
          sos_undo - undo changes to the current line
     
     SYNTAX
          ** effective only if bound to a key **
     
     DESCRIPTION
          The sos_undo command causes the contents of the focus line (or the
          command line) to be reset to the contents before the cursor was
          positioned there.
     
     COMPATIBILITY
          Basically compatible. Doesn't restore the cursor to the original
          column position.
     
     STATUS
          Complete.



     --------------------------------------------------------------------------





