/* ALGEN.C -- Copyright 1992 -- By Richard Butler -- EUROPA Software

    This code carries no warranties, whether expressed or implied.

    This code, it's listings, object file, and executable may not be
    distributed in any modified form.

    Thanks to Harvey Parisien for his HLIST program upon which ALGEN is based.
    ALGEN's file list output is nearly identical to HLIST.

    Thanks to Erik Vanriper for releasing the source for his FILELIST program.
    It was a very useful reference for writing ALGEN.
*/

#define INCL_DOSFILEMGR

#include <stdio.h>
#include <time.h>
#include <sys\types.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <os2.h>
#include <errno.h>
#include "mstruct.h"

#define VERSION "ALGEN v1.15 - (c)1992 Richard Butler - EUROPA Software"
#define MAXAREAS 256
#define MAXLSIZE 512

int Check_Exclude(char *key, char *list[], int num);

int Check_Empty_Area(char *file_path);

char *whitespace = " \t\n\r";

main(int argc, char *argv[])
{
    char system_name[40];
    char header_file[80];
    char new_header_file[80];
    int new_days = 14;
    char list_file[80];
    char new_list_file[80];
    struct xx {
        char path[80];
        char desc[80];
        char files_bbs[80];
    };
    struct xx *area[MAXAREAS];
    struct tm current_date;
    struct tm new_date;
    struct tm *tm_ptr;
    time_t current_time;
    time_t new_time;
    time_t file_time;
    unsigned long ws_new_date;
    unsigned area_count = 0;
    unsigned new_area_count = 0;
    unsigned total_count = 0;
    unsigned total_new_count = 0;
    unsigned long area_bytes = 0;
    unsigned long new_area_bytes = 0;
    unsigned long total_bytes = 0;
    unsigned long total_new_bytes = 0;
    FILE *config_file_p;
    FILE *header_file_p;
    FILE *list_file_p;
    FILE *new_list_file_p = NULL;
    FILE *fp;
    char config_file[80] = "ALGEN.CFG";     /* Default config file */
    int i = 0;
    size_t len;
    char io_buf[MAXLSIZE];
    char *ptr;
    char *ws_ptr;
    int num_areas = 0;
    char file_path[128];
    char file_name[13];
    unsigned char new;
    char *fd_ptr;
    int length;
    char stripflags = 0;
    char noibmchars = 0;
    char showmaxnames = 0;
    char noemptyareas = 0;
    ULONG PathInfoLevel = 1;
    FILESTATUS3 PathInfoBuf;
    APIRET rc;
    char buffer[80];
    char *p_buffer;
    char f_date[25];
    FILE *area_fp;
    struct _area areadat;
    char areadat_path[80];
    char *exclude[MAXAREAS];
    int num_exclude = 0;
    char drive[3];
    char dir[66];
    char fname[9];
    char ext[5];
    char temp_fl[80];
    char temp_nfl[80];
    char area_banner[256];
    char indent = 0;
    int x;
    char file_desc[MAXLSIZE];

    printf("\nķ");
    printf("\n %-58s Fidonet 1:396/61 ",VERSION);
    printf("\nĽ");
    fflush(stdout);
    for(i=0; i < MAXAREAS; i++) {
        if((area[i] = malloc(sizeof(struct xx))) == NULL) {
            printf("\n\nNot enough memory!  Exiting....\n");
            exit(255);
        }
    }
    current_time = time(NULL);
    tm_ptr = localtime(&current_time);
    current_date = *tm_ptr;
    strftime(f_date,24,"%a %b %d, %Y %H:%M",&current_date);
    if(argc > 1)            /* assume that argv[1] is a valid config file */
        strncpy(config_file, argv[1], 79);
    if((config_file_p = fopen(config_file,"r")) == NULL) {
        printf("\n\nError opening ConfigFile '%s'!  Exiting....\n",config_file);
        exit(255);
    }

/*---------------------------------------------------------------------------*/
    /* Parse config file */

    printf("\n\nReading %s....",config_file);
    fflush(stdout);
    while(fgets(io_buf,MAXLSIZE,config_file_p)) {
        if(ptr = strchr(io_buf,'\n'))
            *ptr = '\0';
        if(io_buf[0] == '\0')
            continue;
        ws_ptr = io_buf + strspn(io_buf,whitespace);
        if(*ws_ptr == '\0' || *ws_ptr == ';')
            continue;
        sscanf(ws_ptr,"%79s",&buffer);
        for(i = 0; buffer[i] != '\0'; i++)
            buffer[i] = toupper(buffer[i]);

        if(strcmp("SYSTEM",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(system_name,ptr,39);
            }
        }
        else if(strcmp("HEADER",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(header_file,ptr,79);
            }
        }
        else if(strcmp("NEWHEADER",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(new_header_file,ptr,79);
            }
        }
        else if(strcmp("NEWDAYS",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                new_days = atoi(ptr);
                new_time = (current_time - (new_days * 86400));
                tm_ptr = localtime(&new_time);
                new_date = *tm_ptr;
                ws_new_date = ((new_date.tm_year * 10000) + ((new_date.tm_mon + 1) * 100) + new_date.tm_mday);
            }
        }
        else if(strcmp("INDENT",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                indent = atoi(ptr);
                if(indent < 0)
                    indent = 0;
                if(indent > 16)
                    indent = 16;
            }
        }
        else if(strcmp("FILELIST",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(list_file,ptr,79);
            }
        }
        else if(strcmp("NEWFILELIST",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(new_list_file,ptr,79);
            }
        }
        else if(strcmp("STRIPFLAGS",buffer) == 0) {
            stripflags = 1;
        }
        else if(strcmp("NOIBMCHARS",buffer) == 0) {
            noibmchars = 1;
        }
        else if(strcmp("SHOWMAXNAMES",buffer) == 0) {
            showmaxnames = 1;
        }
        else if(strcmp("NOEMPTYAREAS",buffer) == 0) {
            noemptyareas = 1;
        }
        else if(strcmp("MAXAREAS",buffer) == 0) {
            if(ptr = strchr(ws_ptr,' ')) {
                ptr += (strspn(ptr,whitespace));
                strncpy(areadat_path,ptr,79);
            }
        }
        else if(strcmp("AREAINCLUDE",buffer) == 0) {
            num_areas = 0;
            while(fgets(io_buf,MAXLSIZE,config_file_p) != NULL) {
                if(ptr = strchr(io_buf,'\n'))
                    *ptr = '\0';
                if(io_buf[0] == '\0')
                    continue;
                ws_ptr = io_buf + strspn(io_buf,whitespace);
                if(*ws_ptr == '\0' || *ws_ptr == ';')
                    continue;
                sscanf(ws_ptr,"%79s",&buffer);
                for(i = 0; buffer[i] != '\0'; i++)
                    buffer[i] = toupper(buffer[i]);
                if(strcmp("END",buffer) == 0)
                    break;
                strncpy(area[num_areas]->path,ws_ptr,79);
                len = strcspn(area[num_areas]->path,whitespace);
                area[num_areas]->path[len] = '\0';
                if(area[num_areas]->path[len - 1] != '\\')
                    strncat(area[num_areas]->path,"\\",79 - len);
                if(ptr = strchr(ws_ptr, ' ')) {
                    ptr += (strspn(ptr,whitespace));
                    strcpy(area[num_areas]->desc," ");
                    strncat(area[num_areas]->desc,ptr,77);
                }
                if(ptr = strchr(area[num_areas]->desc, '^')) {
                    *ptr++ = ' ';
                    *ptr = '\0';
                }
                else {
                    strcat(area[num_areas]->desc," ");
                }
                if(ptr = strchr(ws_ptr, '^')) {
                    strncpy(area[num_areas]->files_bbs,++ptr,79);
                }
                else {
                    strcpy(area[num_areas]->files_bbs,area[num_areas]->path);
                    strncat(area[num_areas]->files_bbs,"FILES.BBS",78 - len);
                }
                num_areas++;
            }
        }
        else if(strcmp("END",buffer) == 0) {
            continue;
        }
        else if(strcmp("AREAEXCLUDE",buffer) == 0) {
            num_exclude = 0;
            for(i=0; i < MAXAREAS; i++) {
                if((exclude[i] = malloc(sizeof(areadat.name))) == NULL) {
                    printf("\n\nNot enough memory!  Exiting....\n");
                    exit(255);
                }
            }
            while(fgets(io_buf,MAXLSIZE,config_file_p) != NULL) {
                if(ptr = strchr(io_buf,'\n'))
                    *ptr = '\0';
                if(io_buf[0] == '\0')
                    continue;
                ws_ptr = io_buf + strspn(io_buf,whitespace);
                if(*ws_ptr == '\0' || *ws_ptr == ';')
                    continue;
                sscanf(ws_ptr,"%79s",&buffer);
                for(i = 0; buffer[i] != '\0'; i++)
                    buffer[i] = toupper(buffer[i]);
                if(strcmp("END",buffer) == 0)
                    break;
                strncpy(exclude[num_exclude],buffer,39);
                num_exclude++;
            }
        }
        else if(strcmp("END",buffer) == 0) {
            continue;
        }
        else {
            printf("\n\nUnknown Keyword '%s'  Exiting....\n",buffer);
            exit(255);
        }
    }
    fclose(config_file_p);

    /* Read Area.Dat */

    if(areadat_path[0] != '\0') {
        if((area_fp = fopen(areadat_path,"rb")) == NULL) {
            printf("\n\nError opening MaxAreas '%s'!  Exiting....\n",areadat_path);
            exit(255);
        }
        printf("\nReading %s....",areadat_path);
        fflush(stdout);
        fread(&areadat,sizeof(struct _area),1,area_fp);
        length = areadat.struct_len;
        for(i = 0; ! feof(area_fp); i++) {
            fseek(area_fp,i*(long)length,SEEK_SET);
            fread(&areadat,sizeof(struct _area),1,area_fp);
            if(areadat.filepath[0] != '\0' && areadat.filepath[0] != ' ' &&
               Check_Exclude(areadat.name,exclude,num_exclude) != 1) {
                strncpy(area[num_areas]->path,areadat.filepath,79);
                len = strcspn(area[num_areas]->path,whitespace);
                area[num_areas]->path[len] = '\0';
                if(area[num_areas]->path[len - 1] != '\\')
                    strncat(area[num_areas]->path,"\\",79 - len);
                if(areadat.fileinfo[0] != '\0' && areadat.fileinfo[0] != ' ') {
                    if(showmaxnames) {
                        strcpy(area[num_areas]->desc," ");
                        strcat(area[num_areas]->desc,areadat.name);
                        strcat(area[num_areas]->desc,": ");
                        strncat(area[num_areas]->desc,areadat.fileinfo,75 - strlen(areadat.name));
                        strcat(area[num_areas]->desc," ");
                    }
                    else {
                        strcpy(area[num_areas]->desc," ");
                        strncat(area[num_areas]->desc,areadat.fileinfo,77);
                        strcat(area[num_areas]->desc," ");
                    }
                }
                if(areadat.filesbbs[0] != '\0' && areadat.filesbbs[0] != ' ') {
                    strncpy(area[num_areas]->files_bbs,areadat.filesbbs,79);
                }
                else {
                    strcpy(area[num_areas]->files_bbs,area[num_areas]->path);
                    strncat(area[num_areas]->files_bbs,"FILES.BBS",78 - len);
                }
                num_areas++;
            }
        }
        fclose(area_fp);
    }

    /* free memory used by exclude array */

    if(num_exclude != 0) {
        for(i = num_exclude - 1; i >= 0; i--) {
            free(exclude[i]);
        }
    }

/*---------------------------------------------------------------------------*/

    printf("\n\nProcessing....\n");
    fflush(stdout);

    /* open output files */

    if(list_file[0]) {
        _splitpath(list_file,drive,dir,fname,ext);
        strcpy(ext,".$$$");
        _makepath(temp_fl,drive,dir,fname,ext);
    }
    else {
        printf("\n\nA FileList name is required!  Exiting....\n");
        exit(255);
    }

    if((list_file_p = fopen(temp_fl,"w")) == NULL) {
        printf("\n\nError opening FileList '%s'!  Exiting....\n",temp_fl);
        exit(255);
    }
    if(new_list_file[0]) {
        _splitpath(new_list_file,drive,dir,fname,ext);
        strcpy(ext,".$$$");
        _makepath(temp_nfl,drive,dir,fname,ext);
        if((new_list_file_p = fopen(temp_nfl,"w")) == NULL) {
            printf("\n\nError opening NewFileList '%s'!  Exiting....\n",temp_nfl);
            exit(255);
        }
    }
    if(header_file[0]) {
        if((header_file_p = fopen(header_file,"r")) != NULL) {
            while(fgets(io_buf,MAXLSIZE,header_file_p) != NULL)
                fputs(io_buf,list_file_p);
            fclose(header_file_p);
        }
        else {
            printf("\nError opening Header '%s'!  Continuing....\n",header_file);
            fflush(stdout);
        }
    }
    if(new_header_file[0] && new_list_file_p) {
        if((header_file_p = fopen(new_header_file,"r")) != NULL) {
            while(fgets(io_buf,MAXLSIZE,header_file_p) != NULL)
                fputs(io_buf,new_list_file_p);
            fclose(header_file_p);
        }
        else {
            printf("\nError opening NewHeader '%s'!  Continuing....\n",new_header_file);
            fflush(stdout);
        }
    }

    if(noibmchars) {
        fprintf(list_file_p,"+-----------------------------------------------------------------------------+\n");
        fprintf(list_file_p,"|        This is a complete list of all files available on this system        |\n");
        fprintf(list_file_p,"|                                                                             |\n");
        sprintf(io_buf,"|   File dates followed by a * are < than %d days old, which is >= %.2d-%.2d-%d",new_days,(new_date.tm_mon + 1),new_date.tm_mday,new_date.tm_year);
        strcat(io_buf,"          ");
        io_buf[78] = '|';
        io_buf[79] = '\0';
        fprintf(list_file_p,"%s\n",io_buf);
        fprintf(list_file_p,"|                                                                             |\n");
        fprintf(list_file_p,"| %-53s%s |\n",system_name,f_date);
        fprintf(list_file_p,"+-----------------------------------------------------------------------------+\n");
        fprintf(list_file_p," %-60s Fidonet 1:396/61 \n\n",VERSION);
    }
    else {
        fprintf(list_file_p,"ķ\n");
        fprintf(list_file_p,"        This is a complete list of all files available on this system        \n");
        fprintf(list_file_p,"                                                                             \n");
        sprintf(io_buf,"   File dates followed by a * are < than %d days old, which is >= %.2d-%.2d-%d",new_days,(new_date.tm_mon + 1),new_date.tm_mday,new_date.tm_year);
        strcat(io_buf,"          ");
        io_buf[78] = '';
        io_buf[79] = '\0';
        fprintf(list_file_p,"%s\n",io_buf);
        fprintf(list_file_p,"                                                                             \n");
        fprintf(list_file_p," %-53s%s \n",system_name,f_date);
        fprintf(list_file_p,"Ľ\n");
        fprintf(list_file_p," %-60s Fidonet 1:396/61 \n\n",VERSION);
    }

    if(new_list_file_p) {
        if(noibmchars) {
            fprintf(new_list_file_p,"+-----------------------------------------------------------------------------+\n");
            fprintf(new_list_file_p,"|         This is a list of all 'NEW' files available on this system          |\n");
            fprintf(new_list_file_p,"|                                                                             |\n");
            sprintf(io_buf,"|             Files are < than %d days old, which is >= %.2d-%.2d-%d",new_days,(new_date.tm_mon + 1),new_date.tm_mday,new_date.tm_year);
            strcat(io_buf,"               ");
            io_buf[78] = '|';
            io_buf[79] = '\0';
            fprintf(new_list_file_p,"%s\n",io_buf);
            fprintf(new_list_file_p,"|                                                                             |\n");
            fprintf(new_list_file_p,"| %-53s%s |\n",system_name,f_date);
            fprintf(new_list_file_p,"+-----------------------------------------------------------------------------+\n");
            fprintf(new_list_file_p," %-60s Fidonet 1:396/61 \n\n",VERSION);
        }
        else {
            fprintf(new_list_file_p,"ķ\n");
            fprintf(new_list_file_p,"         This is a list of all 'NEW' files available on this system          \n");
            fprintf(new_list_file_p,"                                                                             \n");
            sprintf(io_buf,"             Files are < than %d days old, which is >= %.2d-%.2d-%d",new_days,(new_date.tm_mon + 1),new_date.tm_mday,new_date.tm_year);
            strcat(io_buf,"               ");
            io_buf[78] = '';
            io_buf[79] = '\0';
            fprintf(new_list_file_p,"%s\n",io_buf);
            fprintf(new_list_file_p,"                                                                             \n");
            fprintf(new_list_file_p," %-53s%s \n",system_name,f_date);
            fprintf(new_list_file_p,"Ľ\n");
            fprintf(new_list_file_p," %-60s Fidonet 1:396/61 \n\n",VERSION);
        }
    }

    /* process files.bbs */

    for(i = 0 ; i < num_areas ; i++) {
        printf("\n\t%s",area[i]->desc);
        fflush(stdout);
        if(noemptyareas) {
            if(Check_Empty_Area(area[i]->files_bbs)) {
                printf("\nSkipping empty area....");
                continue;
            }
        }
        area_count = 0;
        new_area_count = 0;
        area_bytes = 0;
        new_area_bytes = 0;
        if(noibmchars) {
            strcpy(area_banner,"############");
            strcat(area_banner,area[i]->desc);
            strcat(area_banner,"###################################################################");
        }
        else {
            strcpy(area_banner,"");
            strcat(area_banner,area[i]->desc);
            strcat(area_banner,"");
        }
        fprintf(list_file_p,"\n%.79s\n",area_banner);
        if(new_list_file_p && !noemptyareas)
            fprintf(new_list_file_p,"\n%.79s\n",area_banner);

        if((fp = fopen(area[i]->files_bbs,"r")) == NULL) {
            printf("\nError opening %s!  Continuing....",area[i]->files_bbs);
            fflush(stdout);
        }
        else {
            while(fgets(io_buf,MAXLSIZE,fp) != NULL) {
                if(io_buf[0] == '-' || io_buf[0] == ' ' || io_buf[0] == '\n') {
                    if(ptr = strchr(io_buf, '\n'))
                        *ptr = '\0';
                    io_buf[79] = '\0';
                    fprintf(list_file_p,"\n%s",io_buf);
                }
                else {
                    strncpy(file_name,io_buf,12);
                    if(ptr = strpbrk(file_name,whitespace))
                        *ptr = '\0';
                    strcpy(file_path,area[i]->path);
                    strcat(file_path,file_name);
                    rc = DosQueryPathInfo(file_path,PathInfoLevel,&PathInfoBuf,sizeof(FILESTATUS3));
                    if(rc != 0) {
                        fprintf(list_file_p,"\n%-12s (stored offline)  ",file_name);
                        new = 0;
                    }
                    else {
                        p_buffer = _itoa(PathInfoBuf.fdateLastWrite.year + 80,buffer,10);
                        len = strlen(p_buffer);
                        fprintf(list_file_p,"\n%-12s %7ld %.2d-%.2d-%c%c",file_name,PathInfoBuf.cbFile,PathInfoBuf.fdateLastWrite.month,PathInfoBuf.fdateLastWrite.day,buffer[len - 2],buffer[len - 1]);
                        area_count++;
                        total_count++;
                        area_bytes += PathInfoBuf.cbFile;
                        total_bytes += PathInfoBuf.cbFile;
                        if(new = ((((PathInfoBuf.fdateLastWrite.year + 80) * 10000) + (PathInfoBuf.fdateLastWrite.month * 100) + PathInfoBuf.fdateLastWrite.day) >= ws_new_date)) {
                            fprintf(list_file_p,"* ");
                            if(new_list_file_p) {
                                if(noemptyareas && new_area_count == 0)
                                    fprintf(new_list_file_p,"\n%.79s\n",area_banner);
                                fprintf(new_list_file_p,"\n%-12s %7ld %.2d-%.2d-%c%c",file_name,PathInfoBuf.cbFile,PathInfoBuf.fdateLastWrite.month,PathInfoBuf.fdateLastWrite.day,buffer[len - 2],buffer[len - 1]);
                                fprintf(new_list_file_p,"* ");
                                new_area_count++;
                                total_new_count++;
                                new_area_bytes += PathInfoBuf.cbFile;
                                total_new_bytes += PathInfoBuf.cbFile;
                            }
                        }
                        else
                            fprintf(list_file_p,"  ");
                    }
                    strcpy(file_desc,io_buf);
                    if(fd_ptr = strchr(file_desc,' ')) {
                        fd_ptr += (strspn(fd_ptr,whitespace));
                        if(stripflags && (fd_ptr[0] == '/')) {
                            fd_ptr = strpbrk(fd_ptr,whitespace);
                            fd_ptr += (strspn(fd_ptr,whitespace));
                        }
                        if(ptr = strchr(fd_ptr,'\n'))
                            *ptr = '\0';
                        strncpy(io_buf,fd_ptr,49);
                        io_buf[49] = '\0';
                        if(strlen(io_buf) > 48) {
                            if(ptr = strrchr(io_buf,' '))
                                *ptr = '\0';
                        }
                        fprintf(list_file_p,"%s",io_buf);
                        if(new && new_list_file_p)
                            fprintf(new_list_file_p,"%s",io_buf);
                        fd_ptr += (strlen(io_buf));
                        fd_ptr += (strspn(fd_ptr,whitespace));
                        while(*fd_ptr != '\0') {
                            strcpy(io_buf,"                                                  ");
                            io_buf[31 + indent] = '\0';
                            fprintf(list_file_p,"\n%s",io_buf);
                            if(new && new_list_file_p)
                                fprintf(new_list_file_p,"\n%s",io_buf);
                            strncpy(io_buf,fd_ptr,(49 - indent));
                            io_buf[49 - indent] = '\0';
                            if(strlen(io_buf) > (48 - indent)) {
                                if(ptr = strrchr(io_buf,' '))
                                    *ptr = '\0';
                            }
                            fprintf(list_file_p,"%s",io_buf);
                            if(new && new_list_file_p)
                                fprintf(new_list_file_p,"%s",io_buf);
                            fd_ptr += (strlen(io_buf));
                            fd_ptr += (strspn(fd_ptr,whitespace));
                        }
                    }
                }
            }
            fclose(fp);
        }
        fprintf(list_file_p,"\n\n  ** %d files in this area (%ld bytes)\n\n",area_count,area_bytes);
        if(new_list_file_p && (!noemptyareas || new_area_count > 0))
            fprintf(new_list_file_p,"\n\n  ** %d new files in this area (%ld bytes)\n\n",new_area_count,new_area_bytes);
    }

    /* finish things up */

    if(noibmchars) {
        fprintf(list_file_p,"\n %-55s%s\n",system_name,f_date);
        fprintf(list_file_p,"+-----------------------------------------------------------------------------+\n");
        sprintf(io_buf,"| There are a total of %d files on this system (%ld bytes)",total_count,total_bytes);
        strcat(io_buf,"                               ");
        io_buf[78] = '|';
        io_buf[79] = '\0';
        fprintf(list_file_p,"%s\n",io_buf);
        fprintf(list_file_p,"|                                                                             |\n");
        fprintf(list_file_p,"| %-58s Fidonet 1:396/61 |\n",VERSION);
        fprintf(list_file_p,"+-----------------------------------------------------------------------------+\n");
    }
    else {
        fprintf(list_file_p,"\n %-55s%s\n",system_name,f_date);
        fprintf(list_file_p,"ķ\n");
        sprintf(io_buf," There are a total of %d files on this system (%ld bytes)",total_count,total_bytes);
        strcat(io_buf,"                               ");
        io_buf[78] = '';
        io_buf[79] = '\0';
        fprintf(list_file_p,"%s\n",io_buf);
        fprintf(list_file_p,"                                                                             \n");
        fprintf(list_file_p," %-58s Fidonet 1:396/61 \n",VERSION);
        fprintf(list_file_p,"Ľ\n");
    }
    fclose(list_file_p);
    if(remove(list_file) != 0 && errno == EACCESS)
        printf("\n\nError deleting old FileList '%s'!",list_file);
    if(rename(temp_fl,list_file) != 0)
        printf("\n\nError renaming '%s' to '%s'!",temp_fl,list_file);

    if(new_list_file_p) {
        if(noibmchars) {
            fprintf(new_list_file_p,"\n %-55s%s\n",system_name,f_date);
            fprintf(new_list_file_p,"+-----------------------------------------------------------------------------+\n");
            sprintf(io_buf,"| There are a total of %d new files on this system (%ld bytes)",total_new_count,total_new_bytes);
            strcat(io_buf,"                               ");
            io_buf[78] = '|';
            io_buf[79] = '\0';
            fprintf(new_list_file_p,"%s\n",io_buf);
            fprintf(new_list_file_p,"|                                                                             |\n");
            fprintf(new_list_file_p,"| %-58s Fidonet 1:396/61 |\n",VERSION);
            fprintf(new_list_file_p,"+-----------------------------------------------------------------------------+\n");
        }
        else {
            fprintf(new_list_file_p,"\n %-55s%s\n",system_name,f_date);
            fprintf(new_list_file_p,"ķ\n");
            sprintf(io_buf," There are a total of %d new files on this system (%ld bytes)",total_new_count,total_new_bytes);
            strcat(io_buf,"                               ");
            io_buf[78] = '';
            io_buf[79] = '\0';
            fprintf(new_list_file_p,"%s\n",io_buf);
            fprintf(new_list_file_p,"                                                                             \n");
            fprintf(new_list_file_p," %-58s Fidonet 1:396/61 \n",VERSION);
            fprintf(new_list_file_p,"Ľ\n");
        }
        fclose(new_list_file_p);
        if(remove(new_list_file) != 0 && errno == EACCESS)
            printf("\n\nError deleting old NewFileList '%s'!",new_list_file);
        if(rename(temp_nfl,new_list_file) != 0)
            printf("\n\nError renaming '%s' to '%s'!",temp_nfl,new_list_file);
    }
    printf("\n\n....Done!\n");
}

int Check_Exclude(char *key, char *list[], int num)
{
    int i = 0;
    char found = 0;

    while(i < num && !found) {
        if(strcmp(key,list[i]) == 0) {
            found = 1;
        }
        i++;
    }
    return(found);
}

int Check_Empty_Area(char *file_path)
{
    FILE *fp;
    char io_buf[MAXLSIZE];

    if((fp = fopen(file_path,"r")) == NULL) {
        printf("\nError opening %s!  Continuing....",file_path);
        fflush(stdout);
        return(1);
    }
    else {
        while(fgets(io_buf,MAXLSIZE,fp) != NULL) {
            if(io_buf[0] != '-' && io_buf[0] != ' ' && io_buf[0] != '\n') {
                fclose(fp);
                return(0);
            }
        }
        fclose(fp);
        return(1);
    }
}
