
/*////////////////////////////////////////////////////////////////////////////
//                                                                          //
//  Maximus Random Tune Selector                                            //
//  Copyright 1991 by Peter G. Zion.  All rights reserved.                  //
//  Source code may be freely distributed as long as copyright message is   //
//  not removed from this file or the compiled executable.                  //
//                                                                          //
//  Supplementary code by Richard Butler of 1:396/61                        //
//                                                                          //
////////////////////////////////////////////////////////////////////////////*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define NLEN    80
#define MAXLLEN 512

char tunes_bbs[NLEN] = "Tunes.BBS", events_bbs[NLEN] = "Events00.BBS";
int num_tunes, tune_nums[256];
char *prog;
char *whitespace = " \t\n\r";

void HelpMe(void) {

  int i;

  strupr(prog);
  printf( "Usage:\n        %s [<events_bbs> [<tunes_bbs>]]\n\n<events_bbs> is the name of the events file for Maximus\n(optional, defaults to EVENTS00.BBS).\n\n<tunes_bbs> is the name of the Maximus \"tunes\" file\n(optional, defaults to TUNES.BBS).\n",prog);
  exit(0);

}

void GetTunes(void) {

  FILE *fp;
  char line[MAXLLEN];
  char *ptr;

  if( NULL == (fp = fopen( tunes_bbs, "r" )) ) {
    printf( "Error: tunes file \"%s\" not found\n\n", tunes_bbs );
    HelpMe();
  }

  printf( "Getting tunes from \"%s\"...", tunes_bbs );
  fflush(stdout);
  num_tunes = 0;

  while(fgets(line,MAXLLEN,fp) != NULL) {
    ptr = line + strspn(line,whitespace);
    if( strnicmp( ptr, "* YELL", 6 ) == 0 )
      tune_nums[num_tunes++] = atoi( ptr + 6 );
  }

  fclose( fp );

  if( num_tunes == 0 ) {
    printf( "\nError: No tunes found in \"%s\"\n\n", tunes_bbs );
    HelpMe();
  }

  printf( "\n" );

}

void WriteNewTune(void) {

  FILE *in, *out;
  char tmpname[NLEN];
  char line[MAXLLEN], *p;
  char *ptr;

  tmpnam( tmpname );

  if( NULL == (in = fopen( events_bbs, "r" )) ) {
    printf( "Error: events file \"%s\" not found\n", events_bbs );
    HelpMe();
  }

  if( NULL == (out = fopen( tmpname, "w" )) ) {
    printf( "Error: unable to create temporary file \"%s\"\n", tmpname );
    HelpMe();
  }

  printf( "Writing new random tune..." );
  fflush(stdout);
  srand( (unsigned)time(NULL) );

  while(fgets(line,MAXLLEN,in) != NULL) {
    ptr = line + strspn(line,whitespace);
    if( strnicmp( ptr, "EVENT", 5 ) == 0 ) {
      if( NULL != (p = strchr( line, 'y' )) || NULL != (p = strchr( line, 'Y' )) ) {
        if( NULL != (p = strchr( p, '/' )) ) {
          ++p;
          if( NULL != (p = strchr( p, '/' )) ) {
            sprintf( p, "/%d\n", tune_nums[rand()%num_tunes] );
          }
        }
      }
    }
    fputs( line, out );
  }

  fclose(in);
  fclose(out);

  remove( events_bbs );
  rename( tmpname, events_bbs );

  printf( "\n" );

}

void main( int argc, char *argv[] ) {

  printf( "\nRandTune/2 -- Random Tune Selector for Maximus 2.00\nCopyright 1991 by Peter G. Zion.  All rights reserved.\n" );
  printf( "Supplementary code by Richard Butler of 1:396/61\n\n");
  fflush(stdout);

  prog = argv[0];

  if( argc > 3 )
    HelpMe();

  if( argc > 1 ) {
    strncpy( events_bbs, argv[1], NLEN );
    if( argc > 2 )
      strncpy( tunes_bbs, argv[2], NLEN );
  }

  GetTunes();

  WriteNewTune();

  printf( "Done!\n" );

}


