/*

CVTINC -- Converts USAGE 2.1 and 2.2 /I files to USAGE 2.3 format

Version 1.1  (11/10/92)

Written by Bob Quinlan of Austin, Texas, USA
Sysop of Red October at 512-834-2593 (1:382/111)

Copyright 1992 by Bob Quinlan


CVTINC converts old USAGE /I files from the 2.1 or 2.2 formats to the
2.3 format.  It requires two command line parameters and accepts an
optional third.  The first is the name of the old file to be converted.
The second is the name of the 2.3 format file to create from it.  The
third is the decimal of the old version number (1 for 2.1 or 2 for 2.2).
If no version is specified 2.2 is assumed.


CVTINC returns ERRORLEVEL 0 after a successful run.  ERRORLEVEL 1 is
returned to indicate an error.

NOTICE:  You may use, copy, and distribute this program freely as long
as you insure that both the executable and the documentation (.DOC)
files are included in the distribution package.  The source code does
not need to be included.  You may modify this program and document, so
long as reasonable credit is given to the original author if a
substantial portion of the original remains intact.  The author is not
responsible for any losses which may occur either directly or indirectly
as a result of using this program.

HISTORY:
Version 1.1  (11/10/92) -- Modify to convert from 2.1 and 2.2 to 2.3.
Version 1.0  (11/07/92) -- Original release.  Written in Borland C.

Large memory model
*/


#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <share.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>
#include <sys\types.h>


#define VERSION     "1.1"
#define DATE        "11/10/92"

#define MAXLINE     (512)
#define MAXSTAMP    (16)

#ifndef FALSE
    #define FALSE 0
    #define TRUE 1
#endif


typedef struct _increments
{
    long    lastpos;
    char    last[MAXSTAMP];
    int     online;
    char    start[MAXSTAMP];
    int     slen;
} increments;


int main(int argc, char *argv[])
{
    int     oldinc_fh;
    int     newinc_fh;

    int     version = 2;

    increments      increment;

    char   line[MAXLINE];


/************/
/*  CVTINC  */
/************/

    printf("CVTINC %s -- Copyright 1992 by Bob Quinlan (%s)\n\n", VERSION, DATE);

    if (argc < 3)
    {
        fprintf(stderr, "Usage:  CVTINC old.INC new.INC [1 | 2]\n\n");
        exit(1);
    }
    if (argc > 3)
    {
        version = atoi(argv[3]);
        if ((version < 1) || (version > 2))
        {
            fprintf(stderr, "CVTINC: Illegal version specification: %d\n",
                version);
            exit(1);
        }
    }

    if ((oldinc_fh = sopen(argv[1], O_RDONLY | O_BINARY | O_DENYNONE,
        SH_DENYNO, S_IREAD | S_IWRITE)) == -1)
    {
        fprintf(stderr, "CVTINC: Unable to open %s\n", argv[1]);
        exit(1);
    }

    /*  Fill in all fields  */
    memset(&increment, 0, sizeof(increments));

    if ((newinc_fh = sopen(argv[2], O_WRONLY | O_CREAT | O_BINARY | O_DENYALL,
        SH_DENYRW, S_IREAD | S_IWRITE)) == -1)
    {
        fprintf(stderr, "CVTINC: Unable to open %s\n", argv[2]);
        exit(1);
    }

    while (read(oldinc_fh, &increment.lastpos, sizeof(long)) >= sizeof(long))
    {
        if (version == 2)
        {
            if (read(oldinc_fh, &increment.online, sizeof(int)) < sizeof(int))
            {
                break;
            }
            if (read(oldinc_fh, &increment.start, MAXSTAMP) < MAXSTAMP)
            {
                break;
            }
        }
        if (read(oldinc_fh, &increment.slen, sizeof(int)) < sizeof(int))
        {
            break;
        }
        if (read(oldinc_fh, line, increment.slen) < increment.slen)
        {
            break;
        }

        /*  Write data in new format  */
        write(newinc_fh, &increment, sizeof(increments));
        write(newinc_fh, line, increment.slen);
    }

    close(newinc_fh);
    close(oldinc_fh);

    return 0;
}


