////////////////////////////////////////////////////////////////////////////////
//
//                FileBar - OS/2 Application Launch Facility
//                              Version 1.00
//
//                         Written By Eric A. Wolf
//                 Copyright (C) 1994 - All Rights Reserved
//
// This source code may be used for reference ONLY!  It is provided AS-IS and no
// guarantees are made as to its utility, functionality or correctness.  It is
// provided solely as a guide to aid aspiring OS/2 2.x Presentation Manager
// programmers in developing their own PM applications.  No modifications are
// to be made to this code for re-release as a same or different product.  This
// code must be distributed (in its original entirety) with the executable
// portion of this product.
//
//          -- Please register this shareware product for $10 today --
//                          See documentation for details
//
// Project Start Date:      December 26, 1993
// Project Completion Date: January   1, 1994
//
// Written using Borland C++ for OS/2, version 1.0, Borland Resource Workshop,
//               and the IBM OS/2 2.1 bitmap/icon editor
//
// File Last Modified:      January   3, 1994
//
////////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// set compile-time flags for what os/2 header information should be included
////////////////////////////////////////////////////////////////////////////////
#define INCL_WIN
#define INCL_DOSSESMGR
#define INCL_DOSMISC
#define INCL_WINPOINTERS
#define INCL_WINSTDFILE


////////////////////////////////////////////////////////////////////////////////
// include C, C++, OS/2, application and resource header files
////////////////////////////////////////////////////////////////////////////////
#include <os2.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <time.h>
#include "filebar.h"


////////////////////////////////////////////////////////////////////////////////
// MakeHourglassPointer - macro to make the mouse pointer the hourglass
////////////////////////////////////////////////////////////////////////////////
#define MakeHourglassPointer() {                                                               \
                                 HPOINTER pointer;                                             \
                                 pointer = WinQuerySysPointer( HWND_DESKTOP, SPTR_WAIT, FALSE);\
                                 WinSetPointer( HWND_DESKTOP, pointer );                       \
                               }


////////////////////////////////////////////////////////////////////////////////
// MakeArrowPointer - macro to make the mouse pointer the arrow
////////////////////////////////////////////////////////////////////////////////
#define MakeArrowPointer() {                                                                \
                             HPOINTER pointer;                                              \
                             pointer = WinQuerySysPointer( HWND_DESKTOP, SPTR_ARROW, FALSE);\
                             WinSetPointer( HWND_DESKTOP, pointer );                        \
                           }


////////////////////////////////////////////////////////////////////////////////
// writeString - writes a string out with quotes on either side
////////////////////////////////////////////////////////////////////////////////
#define writeString(stream, string) fprintf(stream, "\"%s\"\n", string)


////////////////////////////////////////////////////////////////////////////////
// define application constants
////////////////////////////////////////////////////////////////////////////////
#define AT_TOP                TRUE
#define AT_BOTTOM             FALSE
#define TIMERID               1
#define MAXTASKS              50
#define MAXMENUS              6
#define MAXITEMS              24
#define MAXACTIONSTRINGLENGTH CCHMAXPATH
#define MAXITEMNAMELENGTH     24
#define MAXMENUNAMELENGTH     20
#define MAXARGSTRINGLENGTH    32
#define MAXDIRSTRINGLENGTH    CCHMAXPATH
#define WINDOWED              1
#define FULLSCREEN            2
#define PM                    4
#define DOS                   8
#define OS2                   16
#define WINOS2                32
#define STARTMIN              64
#define STARTMAX              128
#define OS2SHELL              "CMD.EXE"
#define OPTIONFILE            "FILEBAR.INI"
#define LAUNCHFILE            "STARTPRG.CMD"
#define LAUNCHINPUTS          "/C STARTPRG.CMD"
#define SEPARATOR             ""


////////////////////////////////////////////////////////////////////////////////
// define function prototypes
////////////////////////////////////////////////////////////////////////////////
VOID readOptionFile( VOID );
VOID writeOptionFile( VOID );
VOID readString( FILE* stream, CHAR* buffer );
VOID restartTimer( VOID );
VOID displayTimeDate( VOID );
VOID SwapTwoMenus( SHORT menu1, SHORT menu2 );
VOID SwapTwoItems(SHORT Menu, SHORT item1, SHORT item2);
VOID updateItemList( HWND hWnd );
APIRET startApplication( SHORT menu, SHORT item );
MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY GenericProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY TimeDateProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY EditMenuProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AddAMenuProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY EditItemProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY EditItemDataProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);
MRESULT EXPENTRY AddAnItemProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2);


////////////////////////////////////////////////////////////////////////////////
// define global variables
////////////////////////////////////////////////////////////////////////////////
FILEDLG  fileDlgInfo;
LONG     ScreenSizeX = WinQuerySysValue(HWND_DESKTOP, SV_CXSCREEN) + 2;
LONG     ScreenSizeY = WinQuerySysValue(HWND_DESKTOP, SV_CYSCREEN);
LONG     MenuHeight  = WinQuerySysValue(HWND_DESKTOP, SV_CYMENU) + 2;
ULONG    timerNumber;
HAB      hab;
HMQ      hmq;
HWND     hwndClient;
HWND     hwndFrame;
HWND     hwndMenu;
HWND     TaskHandle[MAXTASKS];
BOOL     BarPosition = AT_TOP;
BOOL     UpdateMenu[MAXMENUS];
BOOL     timeSync;
BYTE     ProgType[MAXMENUS][MAXITEMS];
PID      TaskId[MAXTASKS];
MENUITEM menuData[MAXMENUS];
CHAR     MenuName[MAXMENUS][MAXMENUNAMELENGTH];
CHAR     ItemName[MAXMENUS][MAXITEMS][MAXITEMNAMELENGTH];
CHAR     ActionToDo[MAXMENUS][MAXITEMS][MAXACTIONSTRINGLENGTH];
CHAR     CmdLnArgs[MAXMENUS][MAXITEMS][MAXARGSTRINGLENGTH];
CHAR     Directory[MAXMENUS][MAXITEMS][MAXACTIONSTRINGLENGTH];
CHAR     tmpBuffer[80];
SHORT    NumMenus;
SHORT    NumItems[MAXMENUS];
SHORT    timeOption = TIMEANDDATE;
SHORT    MenuSelection;
SHORT    ItemSelection;


////////////////////////////////////////////////////////////////////////////////
// main function - application entry point
////////////////////////////////////////////////////////////////////////////////
main( void )
{
    hab = WinInitialize(0);                   // handle: anchor block
    hmq = WinCreateMsgQueue(hab, 0);          // handle: message queue
    CHAR ClassName[] = "FileBar";             // store a name for our class
    CHAR noName[] = "";                       // used for empty menus
    MENUITEM menuItem;                        // used to modify menu data

    MakeHourglassPointer ();                  // switch to hourglass cursor
                                              // during initialization
    //--------------------------------------------------------------------------
    // register the window class
    //--------------------------------------------------------------------------
    WinRegisterClass(hab,
                     ClassName,      // name of class being registered
                     ClientWndProc,  // window procedure for class
                     0,              // class style
                     0);             // extra memory to reserve

    //--------------------------------------------------------------------------
    // create a window with a menu bar added on.  Note that the menu bar could
    // be defined in the WinCreateStdWindow call (set the resource id equal= to
    // MENUBAR) but is not since I need a handle to the menu (so I can later
    // modify the menu).  Thus, WinLoadMenu is used following WinCreateStdWindow
    //--------------------------------------------------------------------------
    ULONG FrameFlags = FCF_AUTOICON|FCF_TASKLIST|FCF_BORDER;
    hwndFrame = WinCreateStdWindow(HWND_DESKTOP,       // parent
                                        WS_VISIBLE,    // style
                                        &FrameFlags,   // control data
                                        ClassName,     // client name
                                        "FileBar",     // title bar text
                                        0,             // client style
                                        0,             // resource handle
                                        0,             // resource id
                                        &hwndClient);  // client pointer
    hwndMenu = WinLoadMenu( hwndFrame, (HMODULE)0, MENUBAR );

    //--------------------------------------------------------------------------
    // move and size application to span entire top of desktop
    //--------------------------------------------------------------------------
    WinSetWindowPos( hwndFrame, (HWND)0, 0, (ScreenSizeY-MenuHeight),
                     ScreenSizeX, MenuHeight, SWP_MOVE|SWP_SIZE);


    //--------------------------------------------------------------------------
    // perform basic initialization
    //--------------------------------------------------------------------------
    NumMenus = 0;
    MenuSelection = 100;
    for ( short i = 0; i < MAXMENUS; i++ ) {
        WinSendMsg( hwndMenu, MM_QUERYITEM, MPFROM2SHORT(MenuSelection,TRUE),MPFROMP(&menuData[i]));
        menuItem = menuData[i];
        menuItem.afStyle = MIS_STATIC;
        menuItem.afAttribute = MIA_DISABLED;
        menuItem.hwndSubMenu = (HWND)0;
        WinSendMsg( hwndMenu, MM_SETITEM, MPFROM2SHORT(MenuSelection,TRUE),MPFROMP(&menuItem));
        WinSetMenuItemText( hwndMenu, MenuSelection, noName);
        UpdateMenu[ i ] = FALSE;
        NumItems[ i ] = 0;
        MenuSelection = MenuSelection + 100;
        }
    memset( &fileDlgInfo, 0, sizeof(FILEDLG));
    fileDlgInfo.cbSize = sizeof(fileDlgInfo);

    //--------------------------------------------------------------------------
    // read in the user option file and set up the menu bar appropriately
    // check the user time/date option and put it on the menu bar
    // reset our timer in case they want the current time displayed
    //--------------------------------------------------------------------------
    readOptionFile();                         // read in option file
    displayTimeDate();                        // put time/date in menubar
    restartTimer();                           // resync our clock
    MakeArrowPointer ();                      // switch back to arrow pointer,
                                              // we're done with initialization

    //--------------------------------------------------------------------------
    // create a message queue and then as long as there are messages to get,
    // get them and dispatch them to our message handlers
    //--------------------------------------------------------------------------
    {
        QMSG qmsg;                             // create a message queue

        while( WinGetMsg( hab, &qmsg, (HWND)0, 0, 0 ) !=FALSE )
            WinDispatchMsg( hab, &qmsg );
    }

    //--------------------------------------------------------------------------
    // our application is done.  Destroy timer, the window and the message queue
    // call the system to destroy our anchor block and do final clean up work
    //--------------------------------------------------------------------------
    if (timerNumber != 0)
        WinStopTimer( hab, hwndClient, timerNumber );
    WinDestroyWindow(hwndFrame);
    WinDestroyMsgQueue(hmq);
    WinTerminate(hab);

    return 0;
}


////////////////////////////////////////////////////////////////////////////////
// This is the message processing facility for the main application thread
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY ClientWndProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch (msg) {
        //----------------------------------------------------------------------
        // if the application is terminating, write user settings to a file
        //----------------------------------------------------------------------
        case WM_CLOSE:
        case WM_SAVEAPPLICATION:
        case WM_QUIT: {
            writeOptionFile();
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            }
        //----------------------------------------------------------------------
        // the application has been designed such that a WM_TIMER is sent by the
        // system every minute (so that we can update our time on the menubar
        // if necessary)
        //----------------------------------------------------------------------
        case WM_TIMER: {
            if (!timeSync) {
                WinStopTimer( hab, hwndClient, timerNumber );
                timerNumber = WinStartTimer( hab, hwndClient, TIMERID, 60000);
                timeSync = TRUE;
                }
            displayTimeDate();
            return WinDefWindowProc(hwnd, msg, mp1, mp2);
            }
        //----------------------------------------------------------------------
        // a WM_INITMENU message is sent just prior to any pulldown menu being
        // displayed.  This gives us a chance to change its contents before it
        // is displayed.
        //----------------------------------------------------------------------
        case WM_INITMENU: {
            SHORT menuId = SHORT1FROMMP(mp1);
            //------------------------------------------------------------------
            // if the FileBar menu is being readied for display, make sure the
            // move-bar top/bottom item reads appropriately!
            //------------------------------------------------------------------
            if (menuId == FILEBAR_MENU) {
                if (BarPosition == AT_TOP )
                    WinSetMenuItemText( HWNDFROMMP( mp2 ), FILEBAR_MOVEBAR,
                                        "~Move to Bottom");
                else
                    WinSetMenuItemText( HWNDFROMMP( mp2 ), FILEBAR_MOVEBAR,
                                        "~Move to Top");
                return WinDefWindowProc(hwnd, msg, mp1, mp2);
                }
            //------------------------------------------------------------------
            // if the user is pulling down the task list, put a current copy of
            // the task list in the menu and store copies of all the tasks id
            // numbers and handles just in case they want to jump to one of them
            //------------------------------------------------------------------
            if (menuId == TASKLIST_MENU) {
                MENUITEM menuItem;
                ULONG numItems;
                ULONG Buffer;
                PSWBLOCK SwitchBlockPtr;

                // clear out the menu, get it ready for new task entries
                for (short i = menuId+1; i < menuId+MAXITEMS+1; i++ )
                    WinSendMsg( HWNDFROMMP( mp2 ), MM_DELETEITEM,
                                MPFROM2SHORT( i, TRUE ), 0 );

                // get the # of items and the switch list from the system
                numItems = WinQuerySwitchList( hab, NULL, 0 );
                Buffer = (numItems * sizeof(SWENTRY)) + sizeof(HSWITCH);
                PVOID my = new BYTE[Buffer];
                WinQuerySwitchList( hab, (SWBLOCK*)my, Buffer );

                // insert each task as an entry under the task list menu
                SwitchBlockPtr = (PSWBLOCK)(my);
                menuItem.iPosition = 0;
                menuItem.afStyle = 0;
                menuItem.afAttribute = 0;
                menuItem.hwndSubMenu = (HWND)0;
                menuItem.hItem = 0;
                menuItem.id = TASKLIST_MENU;
                for (short j = 1; j < numItems-1; j++ ) {
                    menuItem.id++;
                    if ((SwitchBlockPtr->aswentry[j].swctl.uchVisibility != SWL_GRAYED) &&
                        (SwitchBlockPtr->aswentry[j].swctl.uchVisibility != SWL_INVISIBLE) &&
                        (SwitchBlockPtr->aswentry[j].swctl.hwnd != hwndFrame)) {
                        WinSendMsg( HWNDFROMMP(mp2), MM_INSERTITEM,
                                   (MENUITEM*)&menuItem,
                                  &(SwitchBlockPtr->aswentry[j].swctl.szSwtitle) );
                        TaskId[j] = SwitchBlockPtr->aswentry[j].swctl.idProcess;
                        TaskHandle[j] = SwitchBlockPtr->aswentry[j].swctl.hwnd;
                        }
                    }
                delete( my );
                return WinDefWindowProc(hwnd, msg, mp1, mp2);
                }
            //------------------------------------------------------------------
            // one of the user menus is being initialized; if it has been marked
            // as needing to be updated, fill the menu with the current items
            // the user has set up
            //------------------------------------------------------------------
            if (menuId >= 100) {
                int MenuToUpdate = menuId / 100 - 1;

                if ( UpdateMenu[ MenuToUpdate ] ) {
                    UpdateMenu[ MenuToUpdate ] = FALSE;
                        {
                        MENUITEM menuItem;

                        for (short i = menuId+1; i < menuId+MAXITEMS+1; i++ )
                            WinSendMsg( HWNDFROMMP( mp2 ), MM_DELETEITEM,
                                        MPFROM2SHORT( i, TRUE ), 0 );
                        menuItem.iPosition = MIT_END;
                        menuItem.afStyle = MIS_TEXT;
                        menuItem.afAttribute = 0;
                        menuItem.hItem = 0;
                        menuItem.hwndSubMenu = (HWND)0;
                        menuItem.id = menuId;
                        for (short j = 0; j < NumItems[ MenuToUpdate ]; j++ ) {
                            menuItem.id++;
                            if (ItemName[MenuToUpdate][j][0] != '\0')
                                WinSendMsg( HWNDFROMMP(mp2), MM_INSERTITEM,
                                            (MENUITEM*)&menuItem,
                                            ItemName[MenuToUpdate][j] );
                            else {
                                menuItem.afStyle = MIS_SEPARATOR;
                                WinSendMsg( HWNDFROMMP(mp2), MM_INSERTITEM,
                                            (MENUITEM*)&menuItem,
                                            ItemName[MenuToUpdate][j] );
                                menuItem.afStyle = MIS_TEXT;
                                }
                            }
                        }
                    }
                return WinDefWindowProc(hwnd, msg, mp1, mp2);
                }
            }

        //----------------------------------------------------------------------
        // process a command message from the system
        //----------------------------------------------------------------------
        case WM_COMMAND: {
            USHORT command = SHORT1FROMMP(mp1);

            //------------------------------------------------------------------
            // the user has selected something from the tasklist menu, switch
            // control to that task, if possible
            //------------------------------------------------------------------
            if (( command > TASKLIST_MENU ) && (command < TASKLIST_MENU + MAXTASKS)) {
                HSWITCH switchHandle;

                switchHandle = WinQuerySwitchHandle( TaskHandle[command - TASKLIST_MENU],
                                                     TaskId[command - TASKLIST_MENU]);
                if (switchHandle == 0) {
                    CHAR title[] = "FileBar Task Switch Error";
                    CHAR text[] = "ERROR!  Could not locate task!  The task may have already terminated.";
                    WinMessageBox( HWND_DESKTOP, hwnd, text, title, 0,
                                   MB_MOVEABLE|MB_ERROR|MB_OK);
                    }
                else if (WinSwitchToProgram( switchHandle ) != 0) {
                    CHAR title[] = "FileBar Task Switch Error";
                    CHAR text[] = "ERROR!  Could not switch to task!";
                    WinMessageBox( HWND_DESKTOP, hwnd, text, title, 0,
                                   MB_MOVEABLE|MB_ERROR|MB_OK);
                    }
                return 0;
                }
            //------------------------------------------------------------------
            // the user has selected an option off the user menus.  Activate the
            // item they have selected
            //------------------------------------------------------------------
            if (( command > 99 ) && (command % 100)) {
                APIRET errorCode = 0;
                INT MenuToUpdate = command / 100 - 1;
                INT ItemToUpdate = command % 100 - 1;

                //char mesg[160];
                //sprintf(mesg, "launch menu %d item %d", MenuToUpdate,ItemToUpdate);
                //    WinMessageBox( HWND_DESKTOP, hwnd, mesg, 0, 0,
                //                   MB_MOVEABLE|MB_ERROR|MB_OK);

                if ((MenuToUpdate >= 0) && (MenuToUpdate<MAXMENUS))
                    errorCode = startApplication( MenuToUpdate, ItemToUpdate );
                if (errorCode != 0) {
                    CHAR title[34];
                    char message[500];
                    ULONG MessageLength;

                    memset( &message, 0, sizeof(message));
                    DosGetMessage(NULL,0,message,sizeof(message),errorCode,"OSO001.MSG",&MessageLength);

                    sprintf(title, "FileBar - DosStartSession Error");
                    WinMessageBox( HWND_DESKTOP, hwnd, message, title, 0,
                                   MB_MOVEABLE|MB_ERROR|MB_OK);
                    }
                return 0;
                }
            //------------------------------------------------------------------
            // it was not a tasklist or user item, process now as usual
            //------------------------------------------------------------------
            switch( command ) {
                //--------------------------------------------------------------
                // the user wants to edit the menu structure
                //--------------------------------------------------------------
                case FILEBAR_EDITMENU: {
                    return (VOID*)WinDlgBox(HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)EditMenuProc,
                                            0,
                                            EDITMENU,
                                            (PVOID)NULL);
                    }
                //--------------------------------------------------------------
                // the user wants to select their time/date display options
                //--------------------------------------------------------------
                case FILEBAR_TIMEOPTION: {
                    return (VOID*)WinDlgBox(HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)TimeDateProc,
                                            0,
                                            TIMEOPTIONS,
                                            (PVOID)NULL);
                    }
                //--------------------------------------------------------------
                // the user wants to get general help on filebar
                //--------------------------------------------------------------
                case FILEBAR_GENHELP: {
                    return (VOID*)WinDlgBox(HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)GenericProc,
                                            0,
                                            GENERAL_HELP,
                                            (PVOID)NULL);
                    }
                //--------------------------------------------------------------
                // the user wants to see product information for filebar
                //--------------------------------------------------------------
                case FILEBAR_PRODINFO: {
                    return (VOID*)WinDlgBox(HWND_DESKTOP,
                                            hwnd,
                                            (PFNWP)GenericProc,
                                            0,
                                            PRODUCT_INFO,
                                            (PVOID)NULL);
                    }
                //--------------------------------------------------------------
                // the user wishes to move the filebar from its current position
                // to either to the top or bottom of the desktop
                //--------------------------------------------------------------
                case FILEBAR_MOVEBAR: {
                    if (BarPosition==AT_TOP) {
                        BarPosition = AT_BOTTOM;
                        WinSetWindowPos( hwndFrame, (HWND)0, 0, 0,
                                         ScreenSizeX, MenuHeight, SWP_MOVE);
                        }
                    else {
                        BarPosition = AT_TOP;
                        WinSetWindowPos( hwndFrame, (HWND)0, 0, (ScreenSizeY-MenuHeight),
                                         ScreenSizeX, MenuHeight, SWP_MOVE);
                        }
                    return 0;
                    }
                //--------------------------------------------------------------
                // the user wishes to exit the filebar application
                //--------------------------------------------------------------
                case FILEBAR_EXIT: {
                    return (VOID*)WinPostMsg( hwnd, WM_QUIT, 0, 0);
                    }
                //--------------------------------------------------------------
                // something besides our menus sent a message, pass the message
                // to the system for default processing
                //--------------------------------------------------------------
                default:
                    return WinDefWindowProc(hwnd, msg, mp1, mp2);  // default processing
                }
            }
        //----------------------------------------------------------------------
        // we were sent a message that we don't care about, pass it onto system
        // for default processing
        //----------------------------------------------------------------------
        default:
            return WinDefWindowProc(hwnd, msg, mp1, mp2);  // default processing
        };
}


////////////////////////////////////////////////////////////////////////////////
// readOptionFile - will read the option file (generated by the app) from disk,
// if it exists and will restore the application to the state in which it was
// last left
////////////////////////////////////////////////////////////////////////////////
void readOptionFile( void )
{
    SHORT currentMenu = 100;
    FILE *optionFile;

    //--------------------------------------------------------------------------
    // if the option file exists on disk, read it in and restore old menu,
    // otherwise we will return and rely on default values
    //--------------------------------------------------------------------------
    if ((optionFile = fopen(OPTIONFILE,"rt")) != NULL) {
        // restore user's desired bar position
        fscanf(optionFile, "%d %d", &timeOption, &BarPosition);
        if (BarPosition==AT_BOTTOM)
            WinSetWindowPos( hwndFrame, (HWND)0, 0, 0,
                             ScreenSizeX, MenuHeight, SWP_SIZE|SWP_MOVE);

        // restore user's menus and menu choices
        fscanf(optionFile, "%d", &NumMenus);
        for (short i = 0; i < NumMenus; i++ ) {
            UpdateMenu[i] = TRUE;
            readString( optionFile, (CHAR*)&MenuName[i] );

            WinSendMsg( hwndMenu, MM_SETITEM, MPFROM2SHORT(100*i+100,TRUE),MPFROMP(&menuData[i]));
            WinSetMenuItemText( hwndMenu, 100*i+100, &MenuName[i]);

            fscanf(optionFile, "%d", &NumItems[i]);
            for (short j = 0; j < NumItems[i]; j++) {
                readString( optionFile, (CHAR*)&ItemName[i][j] );
                readString( optionFile, (CHAR*)&ActionToDo[i][j] );
                readString( optionFile, (CHAR*)&CmdLnArgs[i][j] );
                readString( optionFile, (CHAR*)&Directory[i][j] );
                fscanf( optionFile, "%d", &ProgType[i][j] );
                }
            currentMenu = currentMenu + 100;
            }
        fclose( optionFile );
        }
}


////////////////////////////////////////////////////////////////////////////////
// writeOptionFile - will write the application state to the option file
////////////////////////////////////////////////////////////////////////////////
void writeOptionFile( void )
{
    SHORT currentMenu = 100;
    FILE *optionFile;

    //--------------------------------------------------------------------------
    // if the option file exists on disk, read it in and restore old menu,
    // otherwise we will return and rely on default values
    //--------------------------------------------------------------------------
    if ((optionFile = fopen(OPTIONFILE, "wt")) == NULL) {
        // if not able to save, alert the user
        CHAR title[] = "FileBar Error";
        CHAR text[] = "Error writing application configuration file!  Application data was NOT saved!";
        WinMessageBox( HWND_DESKTOP, hwndClient, text, title, 0,
            MB_MOVEABLE|MB_ERROR|MB_OK);
        fclose( optionFile );
        return;
        }
    else {
        // save user's desired bar position
        fprintf(optionFile, "%d %d\n", timeOption, BarPosition);
        // save user's menus and menu choices
        fprintf(optionFile, "%d\n", NumMenus);
        for (short i = 0; i < NumMenus; i++ ) {
            writeString( optionFile, (CHAR*)&MenuName[i] );
            fprintf(optionFile, "%d\n", NumItems[i]);
            for (short j = 0; j < NumItems[i]; j++) {
                writeString( optionFile, (CHAR*)&ItemName[i][j] );
                writeString( optionFile, (CHAR*)&ActionToDo[i][j] );
                writeString( optionFile, (CHAR*)&CmdLnArgs[i][j] );
                writeString( optionFile, (CHAR*)&Directory[i][j] );
                fprintf( optionFile, "%d\n", ProgType[i][j] );
                }
            currentMenu = currentMenu + 100;
            }
        fclose( optionFile );
        }
}


////////////////////////////////////////////////////////////////////////////////
// readString will read a sequence of characters that is bounded on both sides
// by quote (") characters (We can't use fscanf because it won't read spaces)
////////////////////////////////////////////////////////////////////////////////
VOID readString( FILE* stream, CHAR* buffer )
{
    do {                               // search for first " character
        fscanf( stream, "%c", buffer);
    } while ( (*buffer) !='"');
    buffer--;
    do {                               // keep putting characters into the buffer
        buffer++;                      // " character
        fscanf( stream, "%c", buffer); // until we hit the 2nd and terminating
    } while ( (*buffer) !='"');
    *buffer = '\0';                    // store a NULL to terminate the string
}


////////////////////////////////////////////////////////////////////////////////
// Message handler for a generic information-only dialog box (help & prod info)
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY GenericProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // if we receive any system message, dismiss the dialog box
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            WinDismissDlg( hWnd, TRUE );
            return 0;
        }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// starts or restarts a timer to signal our program when the next minute occurs
////////////////////////////////////////////////////////////////////////////////
VOID restartTimer( VOID )
{
    if ((timeOption == TIMEONLY) || (timeOption==TIMEANDDATE)) {
        // only do this if the user needs to see the current time
        struct tm *time_now;
        time_t currentTime;

        tzset();
        time(&currentTime);
        time_now = localtime( &currentTime );
        timeSync = FALSE;
        timerNumber = WinStartTimer( hab, hwndClient, TIMERID, (60-(time_now->tm_sec))*1000);
        }
}


////////////////////////////////////////////////////////////////////////////////
// displayTimeDate is used to place current date and/or time on the FileBar
////////////////////////////////////////////////////////////////////////////////
VOID displayTimeDate( VOID )
{
    CHAR buffer[40] = { '\0' };
    struct tm *time_now;
    time_t currentTime;

    tzset();
    time(&currentTime);
    time_now = localtime( &currentTime );

    if (timeOption == TIMEONLY)
        strftime( buffer, sizeof(buffer), "%I:%M %p  ", time_now);
    else if (timeOption == DATEONLY)
        strftime( buffer, sizeof(buffer), "%B %d, %Y  ", time_now);
    else if (timeOption == TIMEANDDATE)
        strftime( buffer, sizeof(buffer), "%I:%M %p  %B %d, %Y  ", time_now);
    if (buffer[0] == '0')
        buffer[0] = ' ';
    WinSetMenuItemText( hwndMenu, TIMEDATE, &buffer );
}


////////////////////////////////////////////////////////////////////////////////
// Message handler for time and date option setting dialog
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY TimeDateProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and check
        // the appropriate radio button for whatever setting they currently have
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            WinSendDlgItemMsg( hWnd, timeOption, BM_SETCHECK,
                               MPFROM2SHORT( 1, 0 ), 0);
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // if we receive any system message, dismiss dialog and store new option
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            timeOption = NONE + SHORT1FROMMP( WinSendDlgItemMsg( hWnd,
                                                                 timeOption,
                                                                 BM_QUERYCHECKINDEX,
                                                                 0, 0 ) );
            // stop current timer (if one exists) and start a new one
            // display new time and date according to new option setting
            WinStopTimer( hab, hwndClient, timerNumber );
            restartTimer();
            displayTimeDate();
            WinDismissDlg( hWnd, TRUE );
            return 0;
        }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// EditMenuProc - the message handler for editing a menu dialog box
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY EditMenuProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and put
        // the current data into appropriate list boxes
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;

            for (short i=0; i<NumMenus; i++)
                WinSendDlgItemMsg( hWnd, CURMENULIST, LM_INSERTITEM,
                                   MPFROM2SHORT( LIT_END, 0 ),
                                   MenuName[i] );
            if (NumMenus > 0) {
                WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                   MPFROM2SHORT( 0, 0 ),
                                   MPFROM2SHORT( TRUE, 0 ) );
                }
            else {
                WinEnableControl( hWnd, EDITMENUBUTTON, FALSE );
                WinEnableControl( hWnd, REMOVEMENU, FALSE );
                WinEnableControl( hWnd, MOVEMENULEFT, FALSE );
                WinEnableControl( hWnd, MOVEMENURIGHT, FALSE );
                }
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // process a command message received from the system
        //----------------------------------------------------------------------
        case WM_COMMAND: {
            USHORT command = SHORT1FROMMP(mp1);
            switch( command )
                {
                //--------------------------------------------------------------
                // if they pressed OK button, dismiss dialog and return
                //--------------------------------------------------------------
                case DID_OK: {
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
                //--------------------------------------------------------------
                // they want to edit a menu
                //--------------------------------------------------------------
                case EDITMENUBUTTON: {
                    if (NumMenus == 0) {
                        WinAlarm(HWND_DESKTOP, WA_ERROR);
                        return 0;
                        }
                    // find out what menu they've selected in list box
                    MenuSelection = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, CURMENULIST,
                                                                     LM_QUERYSELECTION,
                                                                     MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                     0 ) );
                    // display edit menu dialog box
                    WinDlgBox(HWND_DESKTOP,
                              hWnd,
                              (PFNWP)EditItemProc,
                              0,
                              EDITITEM,
                              (PVOID)NULL);
                    // change the item in the list box and select it
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_DELETEALL, 0, 0 );
                    for (short i=0; i<NumMenus; i++)
                        WinSendDlgItemMsg( hWnd, CURMENULIST, LM_INSERTITEM,
                                           MPFROM2SHORT( LIT_END, 0 ),
                                           MenuName[i] );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                       MPFROM2SHORT( MenuSelection, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    return 0;
                    }
                //--------------------------------------------------------------
                // the user wants to add another menu to the menubar
                //--------------------------------------------------------------
                case ADDMENU: {
                    MenuSelection = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, CURMENULIST,
                                                                     LM_QUERYSELECTION,
                                                                     MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                     0 ) );
                    // error if no room for another menu
                    if (NumMenus >= MAXMENUS) {
                        char text[]="Error!  Maximum number of user-menus already defined!";
                        char title[]="Add A Menu";
                        WinMessageBox( HWND_DESKTOP, hWnd, text, title, 0,
                                       MB_MOVEABLE|MB_ERROR|MB_OK);
                        return 0;
                        }
                    WinDlgBox(HWND_DESKTOP,
                              hWnd,
                              (PFNWP)AddAMenuProc,
                              0,
                              ADDAMENU,
                              (PVOID)NULL);
                    // if first menu to be added, enable buttons
                    if (NumMenus > 0) {
                        WinEnableControl( hWnd, EDITMENUBUTTON, TRUE );
                        WinEnableControl( hWnd, REMOVEMENU, TRUE );
                        WinEnableControl( hWnd, MOVEMENULEFT, TRUE );
                        WinEnableControl( hWnd, MOVEMENURIGHT, TRUE );
                        }

                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_DELETEALL, 0, 0 );
                    for (short i=0; i<NumMenus; i++)
                        WinSendDlgItemMsg( hWnd, CURMENULIST, LM_INSERTITEM,
                                           MPFROM2SHORT( LIT_END, 0 ),
                                           MenuName[i] );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                       MPFROM2SHORT( MenuSelection, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    return 0;
                    }
                //--------------------------------------------------------------
                // the user wants to remove a menu from the menu list box
                //--------------------------------------------------------------
                case REMOVEMENU: {
                    char text[]="If you remove this menu, there will be no way to recover it.  Are you sure you want to remove this menu?";
                    char title[]="Remove Menu";

                    if (NumMenus == 0) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }

                    if (NumMenus > 0)
                        if (WinMessageBox( HWND_DESKTOP, hWnd, text, title, 0,
                                           MB_MOVEABLE|MB_WARNING|MB_YESNO|MB_DEFBUTTON2) == MBID_YES ) {
                            short index = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, CURMENULIST,
                                                                           LM_QUERYSELECTION,
                                                                           MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                           0 ) );
                            CHAR noName[]="";
                            MENUITEM menuItem;

                            // delete it from the lisr box
                            WinSendDlgItemMsg( hWnd, CURMENULIST, LM_DELETEITEM,
                                               MPFROM2SHORT( index, 0 ), 0 );

                            // delete it from menu structure
                            MakeHourglassPointer ();
                            WinSetMenuItemText( hwndMenu, 100*index+100, noName);
                            for (short i=index+1; i<MAXMENUS; i++) {
                                SwapTwoMenus( i-1, i );
                                }
                            NumItems[MAXMENUS-1] = 0;
                            MenuName[MAXMENUS-1][0] = '\0';
                            if (NumMenus > 0)
                                WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                                   MPFROM2SHORT( 0, 0 ),
                                                   MPFROM2SHORT( TRUE, 0 ) );
                            NumItems[NumMenus] = 0;
                            WinSendMsg( hwndMenu, MM_QUERYITEM, MPFROM2SHORT(NumMenus*100,TRUE),MPFROMP(&menuData[index]));
                            menuItem = menuData[index];
                            menuItem.afStyle = MIS_STATIC;
                            menuItem.afAttribute = MIA_DISABLED;
                            menuItem.hwndSubMenu = (HWND)0;
                            WinSendMsg( hwndMenu, MM_SETITEM, MPFROM2SHORT(NumMenus*100,TRUE),MPFROMP(&menuItem));
                            WinSetMenuItemText( hwndMenu, 100*MAXMENUS, noName);
                            NumItems[ NumMenus ] = 0;
                            UpdateMenu[ NumMenus ] = FALSE;
                            NumMenus--;

                            // if we deleted only menu, disable menu buttons
                            if (NumMenus == 0) {
                                WinEnableControl( hWnd, EDITMENUBUTTON, FALSE );
                                WinEnableControl( hWnd, REMOVEMENU, FALSE );
                                WinEnableControl( hWnd, MOVEMENULEFT, FALSE );
                                WinEnableControl( hWnd, MOVEMENURIGHT, FALSE );
                                }
                            MakeArrowPointer ();
                            }
                    return 0;
                    }
                //--------------------------------------------------------------
                // move menu left in menu structure
                //--------------------------------------------------------------
                case MOVEMENULEFT: {
                    short index = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, CURMENULIST,
                                                             LM_QUERYSELECTION,
                                                             MPFROM2SHORT( LIT_FIRST, 0 ),
                                                             0 ) );
                    if ((NumMenus == 0) || (index == 0)) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }
                    MakeHourglassPointer ();
                    SwapTwoMenus( index-1, index );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_DELETEITEM,
                                       MPFROM2SHORT( index, 0 ), 0 );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_INSERTITEM,
                                       MPFROM2SHORT( index-1, 0 ), MenuName[index-1] );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                       MPFROM2SHORT( index-1, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    MakeArrowPointer ();
                    return 0;
                    }
                //--------------------------------------------------------------
                // move menu right in menu structure
                //--------------------------------------------------------------
                case MOVEMENURIGHT: {
                    short index = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, CURMENULIST,
                                                             LM_QUERYSELECTION,
                                                             MPFROM2SHORT( LIT_FIRST, 0 ),
                                                             0 ) );
                    if ((NumMenus == 0) || (index == (NumMenus)-1)) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }
                    MakeHourglassPointer ();
                    SwapTwoMenus( index, index+1 );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_DELETEITEM,
                                       MPFROM2SHORT( index, 0 ), 0 );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_INSERTITEM,
                                       MPFROM2SHORT( index+1, 0 ), MenuName[index+1] );
                    WinSendDlgItemMsg( hWnd, CURMENULIST, LM_SELECTITEM,
                                       MPFROM2SHORT( index+1, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    MakeArrowPointer ();
                    return 0;
                    }
                //--------------------------------------------------------------
                // nothing we care about, pass it onto the system default proc
                //--------------------------------------------------------------
                default:
                    return WinDefDlgProc( hWnd, msg, mp1, mp2 );
                }
            }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// SwapTwoMenus will swap the FileBar stored information entries for two menus
// indicated by menu1 and menu2.  The text on the displayed menubar will also
// be changed to indicate the swap.
////////////////////////////////////////////////////////////////////////////////
void SwapTwoMenus( short menu1, short menu2 )
{
    SHORT t1;
    for (short i=0; i<MAXITEMS; i++) {
        strcpy( tmpBuffer, ItemName[menu1][i] );
        strcpy( ItemName[menu1][i], ItemName[menu2][i] );
        strcpy( ItemName[menu2][i], tmpBuffer );
        strcpy( tmpBuffer, ActionToDo[menu1][i] );
        strcpy( ActionToDo[menu1][i], ActionToDo[menu2][i] );
        strcpy( ActionToDo[menu2][i], tmpBuffer );
        strcpy( tmpBuffer, CmdLnArgs[menu1][i] );
        strcpy( CmdLnArgs[menu1][i], CmdLnArgs[menu2][i] );
        strcpy( CmdLnArgs[menu2][i], tmpBuffer );
        strcpy( tmpBuffer, Directory[menu1][i] );
        strcpy( Directory[menu1][i], Directory[menu2][i] );
        strcpy( Directory[menu2][i], tmpBuffer );
        t1 = ProgType[menu2][i];
        ProgType[menu2][i] = ProgType[menu1][i];
        ProgType[menu1][i] = t1;
        }
    t1 = NumItems[menu2];
    NumItems[menu2] = NumItems[menu1];
    NumItems[menu1] = t1;
    strcpy( tmpBuffer, MenuName[menu1] );
    strcpy( MenuName[menu1], MenuName[menu2] );
    strcpy( MenuName[menu2], tmpBuffer );
    UpdateMenu[menu1] = TRUE;
    UpdateMenu[menu2] = TRUE;
    WinSetMenuItemText( hwndMenu, 100+menu1*100, MenuName[menu1] );
    WinSetMenuItemText( hwndMenu, 100+menu2*100, MenuName[menu2] );
}


////////////////////////////////////////////////////////////////////////////////
// AddAMenuProc - message handler for the dialog box that allows the user to
// add a menu to the menubar
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY AddAMenuProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and put
        // the current data into controls
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            WinSendDlgItemMsg( hWnd, MENUNAME, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXMENUNAMELENGTH-1, 0 ), 0 );
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // process a command message received from the system
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            USHORT command = SHORT1FROMMP(mp1);
            switch( command )
                {
                //--------------------------------------------------------------
                // user press OK button.  Add the menu name they entered into
                // the menu structure and return
                //--------------------------------------------------------------
                case DID_OK: {
                    WinQueryDlgItemText( hWnd, MENUNAME, MAXMENUNAMELENGTH, MenuName[NumMenus]);
                    UpdateMenu[NumMenus] = TRUE;
                    NumItems[NumMenus] = 0;
                    menuData[NumMenus].afStyle = 0;
                    menuData[NumMenus].afAttribute = 0;
                    WinSendMsg( hwndMenu, MM_SETITEM, MPFROM2SHORT(100*NumMenus+100,TRUE),MPFROMP(&menuData[NumMenus]));
                    WinSetMenuItemText( hwndMenu, 100*NumMenus+100, &MenuName[NumMenus]);
                    MenuSelection = NumMenus;
                    NumMenus++;
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
                //--------------------------------------------------------------
                // they decided not to add a menu, dismiss dialog and return
                //--------------------------------------------------------------
                case DID_CANCEL: {
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
                //--------------------------------------------------------------
                // nothing we care about, pass on for default processing
                //--------------------------------------------------------------
                default:
                    return WinDefDlgProc( hWnd, msg, mp1, mp2 );
                }
        }
        // ---------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        // ---------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// Swap menu items item1 and item2 on menu Menu in the menu information arrays
////////////////////////////////////////////////////////////////////////////////
VOID SwapTwoItems(SHORT Menu, SHORT item1, SHORT item2)
{
    strcpy( tmpBuffer, ItemName[Menu][item2] );
    strcpy( ItemName[Menu][item2], ItemName[Menu][item1] );
    strcpy( ItemName[Menu][item1], tmpBuffer );
    strcpy( tmpBuffer, ActionToDo[Menu][item2] );
    strcpy( ActionToDo[Menu][item2], ActionToDo[Menu][item1] );
    strcpy( ActionToDo[Menu][item1], tmpBuffer );
    strcpy( tmpBuffer, CmdLnArgs[Menu][item2] );
    strcpy( CmdLnArgs[Menu][item2], CmdLnArgs[Menu][item1] );
    strcpy( CmdLnArgs[Menu][item1], tmpBuffer );
    strcpy( tmpBuffer, Directory[Menu][item2] );
    strcpy( Directory[Menu][item2], Directory[Menu][item1] );
    strcpy( Directory[Menu][item1], tmpBuffer );
    short t1 = ProgType[Menu][item2];
    ProgType[Menu][item2] = ProgType[Menu][item1];
    ProgType[Menu][item1] = t1;
}


////////////////////////////////////////////////////////////////////////////////
// updateItemList - refreshes the contents of the item list list-box in a dialog
////////////////////////////////////////////////////////////////////////////////
VOID updateItemList( HWND hWnd )
{
    CHAR Separator[] = SEPARATOR;
    WinSendDlgItemMsg( hWnd, ITEMMENU, LM_DELETEALL, 0, 0 );
    for (short i=0; i<NumItems[MenuSelection]; i++)
        if (ItemName[MenuSelection][i][0] != '\0')
            WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                               MPFROM2SHORT( LIT_END, 0 ),
                               ItemName[MenuSelection][i] );
        else
            WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                               MPFROM2SHORT( LIT_END, 0 ),
                               Separator );
    if (NumItems[MenuSelection] > 0)
        WinSendDlgItemMsg( hWnd, ITEMMENU, LM_SELECTITEM,
                           MPFROM2SHORT( ItemSelection, 0 ),
                           MPFROM2SHORT( TRUE, 0 ) );
}


////////////////////////////////////////////////////////////////////////////////
// EditItemProc - the message handler for the edit menu item dialog box
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY EditItemProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and put
        // the current data into control fields
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            WinSendDlgItemMsg( hWnd, MENUNAME, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXMENUNAMELENGTH-1, 0 ), 0 );
            WinSetDlgItemText( hWnd, MENUNAME, MenuName[MenuSelection]);
            ItemSelection = 0;
            updateItemList( hWnd );
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // process a command message received from the system
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            USHORT command = SHORT1FROMMP(mp1);
            switch( command )
                {
                //--------------------------------------------------------------
                // insert a separator into item list, if there is room
                //--------------------------------------------------------------
                case INSERTSEPARATOR: {
                    ItemSelection = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                                     LM_QUERYSELECTION,
                                                                     MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                     0 ) );
                    if (NumItems[MenuSelection] >= MAXITEMS-1) {
                        // error and return if no room
                        char text[]="Error!  Maximum number of items for this menu already defined!";
                        char title[]="Add A Separator";
                        WinMessageBox( HWND_DESKTOP, hWnd, text, title, 0,
                                       MB_MOVEABLE|MB_ERROR|MB_OK);
                        return 0;
                        }
                    // since this is a separator, blank out launch information
                    for (short i=NumItems[MenuSelection]-1; i>=ItemSelection; i--)
                        SwapTwoItems( MenuSelection, i, i+1 );
                    ItemName[MenuSelection][ItemSelection][0]='\0';
                    ActionToDo[MenuSelection][ItemSelection][0]='\0';
                    CmdLnArgs[MenuSelection][ItemSelection][0]='\0';
                    Directory[MenuSelection][ItemSelection][0]='\0';
                    ProgType[MenuSelection][ItemSelection]=0;
                    if (NumItems[MenuSelection]==0)
                        ItemSelection = 0;
                    NumItems[MenuSelection]++;
                    UpdateMenu[MenuSelection] = TRUE;
                    updateItemList( hWnd );
                    return 0;
                    }
                //--------------------------------------------------------------
                // user wants to add an item to the current menu
                //--------------------------------------------------------------
                case ADDITEM: {
                    ItemSelection = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                                     LM_QUERYSELECTION,
                                                                     MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                     0 ) );
                    // error and return if no room for another item
                    if (NumItems[MenuSelection] >= MAXITEMS) {
                        char text[]="Error!  Maximum number of items for this menu already defined!";
                        char title[]="Add An Item";
                        WinMessageBox( HWND_DESKTOP, hWnd, text, title, 0,
                                       MB_MOVEABLE|MB_ERROR|MB_OK);
                        return 0;
                        }
                    // get new item via add item dialog box
                    WinDlgBox(HWND_DESKTOP,
                              hWnd,
                              (PFNWP)AddAnItemProc,
                              0,
                              ADDANITEM,
                              (PVOID)NULL);
                    // update item list with possible new item
                    updateItemList( hWnd );
                    return 0;
                    }
                //--------------------------------------------------------------
                // user wants to change a menu item
                //--------------------------------------------------------------
                case CHANGEITEM: {
                    ItemSelection = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                                     LM_QUERYSELECTION,
                                                                     MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                     0 ) );
                    if ((NumItems[MenuSelection] == 0) || (ItemName[MenuSelection][ItemSelection][0] == '\0')) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }
                    WinDlgBox(HWND_DESKTOP,
                              hWnd,
                              (PFNWP)EditItemDataProc,
                              0,
                              EDITITEMDATA,
                              (PVOID)NULL);
                    updateItemList( hWnd );
                    return 0;
                    }
                //--------------------------------------------------------------
                // move item down in menu order
                //--------------------------------------------------------------
                case MOVEITEMDOWN: {
                    CHAR Separator[] = SEPARATOR;
                    short i = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                               LM_QUERYSELECTION,
                                                               MPFROM2SHORT( LIT_FIRST, 0 ),
                                                               0 ) );
                    if ((i == NumItems[MenuSelection]-1) || (NumItems[MenuSelection] == 0)) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }
                    SwapTwoItems( MenuSelection, i, i+1 );
                    WinSendDlgItemMsg( hWnd, ITEMMENU, LM_DELETEITEM,
                                       MPFROM2SHORT( i, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    if (ItemName[MenuSelection][i+1][0] == '\0')
                        WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                                           MPFROM2SHORT( i+1, 0 ),
                                           Separator );
                    else WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                                            MPFROM2SHORT( i+1, 0 ),
                                            &ItemName[MenuSelection][i+1] );
                    WinSendDlgItemMsg( hWnd, ITEMMENU, LM_SELECTITEM,
                                       MPFROM2SHORT( i+1, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    return 0;
                    }
                //--------------------------------------------------------------
                // move item up in menu order
                //--------------------------------------------------------------
                case MOVEITEMUP: {
                    CHAR Separator[] = SEPARATOR;
                    short i = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                               LM_QUERYSELECTION,
                                                               MPFROM2SHORT( LIT_FIRST, 0 ),
                                                               0 ) );
                    if ((i == 0) || (NumItems[MenuSelection] == 0)) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }
                    SwapTwoItems( MenuSelection, i-1, i );
                    WinSendDlgItemMsg( hWnd, ITEMMENU, LM_DELETEITEM,
                                       MPFROM2SHORT( i, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    if (ItemName[MenuSelection][i-1][0] == '\0')
                        WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                                           MPFROM2SHORT( i-1, 0 ),
                                           Separator );
                    else WinSendDlgItemMsg( hWnd, ITEMMENU, LM_INSERTITEM,
                                            MPFROM2SHORT( i-1, 0 ),
                                            &ItemName[MenuSelection][i-1] );
                    WinSendDlgItemMsg( hWnd, ITEMMENU, LM_SELECTITEM,
                                       MPFROM2SHORT( i-1, 0 ),
                                       MPFROM2SHORT( TRUE, 0 ) );
                    return 0;
                    }
                //--------------------------------------------------------------
                // remove a menu item
                //--------------------------------------------------------------
                case REMOVEITEM: {
                    char text[]="If you remove this item, there will be no way to recover it.  Are you sure you want to remove this item?";
                    char title[]="Remove Menu Item";

                    if (NumItems[MenuSelection] == 0) {
                        WinAlarm(HWND_DESKTOP, WA_WARNING);
                        return 0;
                        }

                    if (NumItems[MenuSelection] > 0)
                        if (WinMessageBox( HWND_DESKTOP, hWnd, text, title, 0,
                                           MB_MOVEABLE|MB_WARNING|MB_YESNO|MB_DEFBUTTON2) == MBID_YES ) {
                            short index = SHORT1FROMMP( WinSendDlgItemMsg( hWnd, ITEMMENU,
                                                                           LM_QUERYSELECTION,
                                                                           MPFROM2SHORT( LIT_FIRST, 0 ),
                                                                           0 ) );
                            WinSendDlgItemMsg( hWnd, ITEMMENU, LM_DELETEITEM,
                                               MPFROM2SHORT( index, 0 ), 0 );

                            for (short i=index; i<MAXITEMS-1; i++) {
                                strcpy( ItemName[MenuSelection][i], ItemName[MenuSelection][i+1]);
                                strcpy( ActionToDo[MenuSelection][i], ActionToDo[MenuSelection][i+1]);
                                strcpy( CmdLnArgs[MenuSelection][i], CmdLnArgs[MenuSelection][i+1]);
                                strcpy( Directory[MenuSelection][i], Directory[MenuSelection][i+1]);
                                ProgType[MenuSelection][i] = ProgType[MenuSelection][i+1];
                                }
                            NumItems[MenuSelection]--;
                            if (NumItems[MenuSelection] > 0)
                                WinSendDlgItemMsg( hWnd, ITEMMENU, LM_SELECTITEM,
                                                   MPFROM2SHORT( 0, 0 ),
                                                   MPFROM2SHORT( TRUE, 0 ) );
                            }
                    return 0;
                    }
                //--------------------------------------------------------------
                // user is done editing a menu, save menu name and return
                //--------------------------------------------------------------
                case DID_OK: {
                    WinQueryDlgItemText( hWnd, MENUNAME, MAXMENUNAMELENGTH, MenuName[MenuSelection]);
                    WinSetMenuItemText( hwndMenu, 100*MenuSelection+100, &MenuName[MenuSelection]);
                    UpdateMenu[MenuSelection] = TRUE;
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
                //--------------------------------------------------------------
                // no message we care about, pass it onto the system
                //--------------------------------------------------------------
                default:
                    return WinDefDlgProc( hWnd, msg, mp1, mp2 );
                }
        }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
           return WinDefDlgProc( hWnd, msg, mp1, mp2 );
        }
}


////////////////////////////////////////////////////////////////////////////////
// message handler for the dialog "edit an item's values"
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY EditItemDataProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
    switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and put
        // the current data into control fields
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            // put item name and length of longest possible name in entry field
            WinSendDlgItemMsg( hWnd, ITEMNAME, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXITEMNAMELENGTH-1, 0 ), 0 );
            WinSetDlgItemText( hWnd, ITEMNAME, ItemName[MenuSelection][ItemSelection]);
            // put path name and length of longest possible name in entry field
            WinSendDlgItemMsg( hWnd, PATHNAME, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXACTIONSTRINGLENGTH-1, 0 ), 0 );
            WinSetDlgItemText( hWnd, PATHNAME, ActionToDo[MenuSelection][ItemSelection]);
            // put argument and length of longest possible in entry field
            WinSendDlgItemMsg( hWnd, ARGUMENTS, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXARGSTRINGLENGTH-1, 0 ), 0 );
            WinSetDlgItemText( hWnd, ARGUMENTS, CmdLnArgs[MenuSelection][ItemSelection]);
            // put directory and length of longest possible directory in entry field
            WinSendDlgItemMsg( hWnd, DIRECTORY, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXDIRSTRINGLENGTH-1, 0 ), 0 );
            WinSetDlgItemText( hWnd, DIRECTORY, Directory[MenuSelection][ItemSelection]);
            // set appropriate radio button for program startup option
            if (ProgType[MenuSelection][ItemSelection] & STARTMAX)
                WinCheckButton( hWnd, MAXIMIZED, TRUE );
            else if (ProgType[MenuSelection][ItemSelection] & STARTMIN)
                WinCheckButton( hWnd, MINIMIZED, TRUE );
            // set appropriate radio button for program startup option
            if (ProgType[MenuSelection][ItemSelection] & PM)
                WinCheckButton( hWnd, PMAPP, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & DOS) &&
                    (ProgType[MenuSelection][ItemSelection] & WINDOWED))
                WinCheckButton( hWnd, DOSWIN, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & DOS) &&
                    (ProgType[MenuSelection][ItemSelection] & FULLSCREEN))
                WinCheckButton( hWnd, DOSFS, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & OS2) &&
                    (ProgType[MenuSelection][ItemSelection] & WINDOWED))
                WinCheckButton( hWnd, OS2WIN, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & OS2) &&
                    (ProgType[MenuSelection][ItemSelection] & FULLSCREEN))
                WinCheckButton( hWnd, OS2FS, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & WINOS2) &&
                    (ProgType[MenuSelection][ItemSelection] & WINDOWED))
                WinCheckButton( hWnd, WINOS2WIN, TRUE );
            else if ( (ProgType[MenuSelection][ItemSelection] & WINOS2) &&
                    (ProgType[MenuSelection][ItemSelection] & FULLSCREEN))
                WinCheckButton( hWnd, WINOS2FS, TRUE );
            // center dialog on screen
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // process a command message received from the system
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            USHORT command = SHORT1FROMMP(mp1);
            switch( command )
                {
                //--------------------------------------------------------------
                // the user wants to find a file to call as a menu item.  Hook
                // into OS/2's file dialog procedure to ease the finding process
                // for us to program!  Then once a file is selected, fill in
                // the program path, directory and query the application for its
                // application type and mark the appropriate radio button
                //--------------------------------------------------------------
                case FINDFILE: {
                    CHAR title[] = "FileBar - Find A File To Add";
                    ULONG s, t;
                    HWND hwndDialog;

                    fileDlgInfo.fl = FDS_OPEN_DIALOG|FDS_CENTER;
                    fileDlgInfo.pszTitle = title;
                    strcat(fileDlgInfo.szFullFile, "*.*\0");

                    hwndDialog = WinFileDlg( HWND_DESKTOP, hWnd, &fileDlgInfo );
                    if (hwndDialog && (fileDlgInfo.lReturn == DID_OK)) {
                        strcpy( ActionToDo[MenuSelection][ItemSelection], fileDlgInfo.szFullFile );

                        s=0;
                        while(fileDlgInfo.szFullFile[s]!='\0')
                            s++;
                        while((fileDlgInfo.szFullFile[s]!='\\') && (s>=0))
                            s--;

                        t = 0;
                        while (t<s)
                            Directory[MenuSelection][ItemSelection][t] = fileDlgInfo.szFullFile[t++];
                        Directory[MenuSelection][ItemSelection][t] = '\0';

                        DosQueryAppType( ActionToDo[MenuSelection][ItemSelection], &t);
                        ProgType[MenuSelection][ItemSelection] = OS2 + WINDOWED;
                        if (t == FAPPTYP_WINDOWAPI)
                            ProgType[MenuSelection][ItemSelection] = PM;
                        if (t == FAPPTYP_WINDOWCOMPAT)
                            ProgType[MenuSelection][ItemSelection] = OS2 + WINDOWED;
                        if (t == FAPPTYP_NOTWINDOWCOMPAT)
                            ProgType[MenuSelection][ItemSelection] = OS2 + FULLSCREEN;
                        if (t == FAPPTYP_DOS)
                            ProgType[MenuSelection][ItemSelection] = DOS + WINDOWED;
                        if ((t == FAPPTYP_WINDOWSREAL) || (t == FAPPTYP_WINDOWSPROT))
                            ProgType[MenuSelection][ItemSelection] = WINOS2 + FULLSCREEN;

                        WinSendMsg( hWnd, WM_INITDLG, 0, 0);

                        if (fileDlgInfo.szFullFile[s]=='\\')
                            fileDlgInfo.szFullFile[s+1]='\0';
                        else
                            fileDlgInfo.szFullFile[0]='\0';
                        }
                    else
                        fileDlgInfo.szFullFile[0]='\0';
                    return 0;
                    }
                //--------------------------------------------------------------
                // user pressed OK, save current information for this item
                //--------------------------------------------------------------
                case DID_OK: {
                    if ( WinQueryButtonCheckstate( hWnd, MAXIMIZED ) &&
                         WinQueryButtonCheckstate( hWnd, MINIMIZED ) ) {
                        char text[]="Cannot have the item start both as minimized AND maximized!";
                        WinMessageBox( HWND_DESKTOP, hWnd, text, NULL, 0,
                                       MB_MOVEABLE|MB_ERROR|MB_OK);
                        return 0;
                        }

                    // save program type and max/min startup status
                    ProgType[MenuSelection][ItemSelection] = 0;
                    if (WinQueryButtonCheckstate( hWnd, OS2WIN ))
                        ProgType[MenuSelection][ItemSelection] = OS2 + WINDOWED;
                    if (WinQueryButtonCheckstate( hWnd, OS2FS ))
                        ProgType[MenuSelection][ItemSelection] = OS2 + FULLSCREEN;
                    if (WinQueryButtonCheckstate( hWnd, DOSWIN ))
                        ProgType[MenuSelection][ItemSelection] = DOS + WINDOWED;
                    if (WinQueryButtonCheckstate( hWnd, DOSFS ))
                        ProgType[MenuSelection][ItemSelection] = DOS + FULLSCREEN;
                    if (WinQueryButtonCheckstate( hWnd, WINOS2WIN ))
                        ProgType[MenuSelection][ItemSelection] = WINOS2 + WINDOWED;
                    if (WinQueryButtonCheckstate( hWnd, WINOS2FS ))
                        ProgType[MenuSelection][ItemSelection] = WINOS2 + FULLSCREEN;
                    if (WinQueryButtonCheckstate( hWnd, PMAPP ))
                        ProgType[MenuSelection][ItemSelection] = PM;
                    if (WinQueryButtonCheckstate( hWnd, MAXIMIZED ))
                        ProgType[MenuSelection][ItemSelection] = ProgType[MenuSelection][ItemSelection] | STARTMAX;
                    if (WinQueryButtonCheckstate( hWnd, MINIMIZED ))
                        ProgType[MenuSelection][ItemSelection] = ProgType[MenuSelection][ItemSelection] | STARTMIN;

                    // save name, path, directory, command line args
                    WinQueryDlgItemText( hWnd, ITEMNAME, MAXITEMNAMELENGTH,
                                         ItemName[MenuSelection][ItemSelection]);
                    WinQueryDlgItemText( hWnd, PATHNAME, MAXACTIONSTRINGLENGTH,
                                         ActionToDo[MenuSelection][ItemSelection]);
                    WinQueryDlgItemText( hWnd, ARGUMENTS, MAXARGSTRINGLENGTH,
                                         CmdLnArgs[MenuSelection][ItemSelection]);
                    WinQueryDlgItemText( hWnd, DIRECTORY, MAXDIRSTRINGLENGTH,
                                         Directory[MenuSelection][ItemSelection]);
                    UpdateMenu[MenuSelection] = TRUE;
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
            default:
                return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// AddAnItemProc - the message handler for the "add an item to a menu" dialog
////////////////////////////////////////////////////////////////////////////////
MRESULT EXPENTRY AddAnItemProc(HWND hWnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
   switch( msg )
    {
        //----------------------------------------------------------------------
        // when the dialog is being initialized, center it on desktop and put
        // the current data into control fields
        //----------------------------------------------------------------------
        case WM_INITDLG: {
            SWP swp;
            WinSendDlgItemMsg( hWnd, ITEMNAME, EM_SETTEXTLIMIT,
                               MPFROM2SHORT( MAXITEMNAMELENGTH-1, 0 ), 0 );
            WinQueryWindowPos( hWnd, (PSWP)&swp);
            WinSetWindowPos( hWnd, (HWND)0,
                             ((SHORT)((ScreenSizeX-swp.cx)/2)),
                             ((SHORT)((ScreenSizeY-swp.cy)/2)),
                             0, 0, SWP_MOVE);
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
            }
        //----------------------------------------------------------------------
        // process a command message received from the system
        //----------------------------------------------------------------------
        case WM_COMMAND:
        {
            USHORT command = SHORT1FROMMP(mp1);
            switch( command )
                {
                //--------------------------------------------------------------
                // if they pressed OK, then save the data in the dialog as an
                // item that we can now launch from the fileBar.
                //--------------------------------------------------------------
                case DID_OK: {
                    WinQueryDlgItemText( hWnd, ITEMNAME, MAXMENUNAMELENGTH, ItemName[MenuSelection][ (NumItems[MenuSelection]) ]);
                    ActionToDo[MenuSelection][ (NumItems[MenuSelection]) ][0] = '\0';
                    CmdLnArgs[MenuSelection][ (NumItems[MenuSelection]) ][0] = '\0';
                    Directory[MenuSelection][ (NumItems[MenuSelection]) ][0] = '\0';
                    ProgType[MenuSelection][ (NumItems[MenuSelection]) ] = PM;
                    UpdateMenu[MenuSelection] = TRUE;
                    WinDismissDlg( hWnd, TRUE );
                    ItemSelection = NumItems[MenuSelection];
                    NumItems[MenuSelection]++;
                    WinDlgBox(HWND_DESKTOP,
                              hWnd,
                              (PFNWP)EditItemDataProc,
                              0,
                              EDITITEMDATA,
                              (PVOID)NULL);
                    return 0;
                    }
                //--------------------------------------------------------------
                // if they pressed cancel, save no data and return
                //--------------------------------------------------------------
                case DID_CANCEL: {
                    WinDismissDlg( hWnd, TRUE );
                    return 0;
                    }
                //--------------------------------------------------------------
                // nothing further we care about, pass on for default processing
                //--------------------------------------------------------------
                default:
                    return WinDefDlgProc( hWnd, msg, mp1, mp2 );
                }
        }
        //----------------------------------------------------------------------
        // if nothing further we want to intercept, pass message onto system
        //----------------------------------------------------------------------
        default:
            return WinDefDlgProc( hWnd, msg, mp1, mp2 );
    }
}


////////////////////////////////////////////////////////////////////////////////
// startApplication uses DosStartSession to start a batch file to start an
// application pointed to in one of the user menus by menu and item variables.
////////////////////////////////////////////////////////////////////////////////
APIRET startApplication( SHORT menu, SHORT item )
{
    APIRET rc;
    STARTDATA startData;
    ULONG sessionId;
    PID ppId;
    UCHAR ObjBuf[2];
    FILE* outputFile;

    //--------------------------------------------------------------------------
    // this launches a command shell (DOS or OS2 (Windowed or FS session))
    //--------------------------------------------------------------------------
    if (ActionToDo[menu][item][0] == '\0') {
        ULONG currentDrive;
        ULONG driveMap;
        CHAR InputDir[CCHMAXPATH + 16];

        DosQueryCurrentDisk( &currentDrive, &driveMap );
        DosSetDefaultDisk( (ULONG)(toupper(Directory[menu][item][0])-'A' + 1) );

        memset( &startData, 0, sizeof(STARTDATA) );
        startData.Related = SSF_RELATED_INDEPENDENT;
        startData.FgBg = SSF_FGBG_FORE;
        startData.TraceOpt = SSF_TRACEOPT_NONE;
        startData.InheritOpt = SSF_INHERTOPT_PARENT;
        startData.ObjectBuffer = ObjBuf;
        startData.ObjectBuffLen = sizeof(ObjBuf);
        startData.Length = sizeof(STARTDATA);
        startData.PgmTitle = ItemName[menu][item];
        strcpy( InputDir, "/K cd  \0");
        strcpy( InputDir+6, Directory[menu][item] );
        startData.PgmInputs = InputDir;

        startData.PgmControl = SSF_CONTROL_VISIBLE;
        if (ProgType[menu][item] & MAXIMIZED)
            startData.PgmControl = SSF_CONTROL_VISIBLE | SSF_CONTROL_MAXIMIZE;
        else if (ProgType[menu][item] & MINIMIZED)
            startData.PgmControl = SSF_CONTROL_VISIBLE | SSF_CONTROL_MINIMIZE;

        if (ProgType[menu][item] & DOS) {
            if (ProgType[menu][item] & WINDOWED)
                startData.SessionType = SSF_TYPE_WINDOWEDVDM;
            else
                startData.SessionType = SSF_TYPE_VDM;
            rc = DosStartSession( (STARTDATA*) &startData, (ULONG*)&sessionId,
                                  (PID*) &ppId );
            DosSetDefaultDisk( currentDrive );
            return rc;
            }
        else if (ProgType[menu][item] & OS2) {
            if (ProgType[menu][item] & WINDOWED)
                startData.SessionType = SSF_TYPE_WINDOWABLEVIO;
            else
                startData.SessionType = SSF_TYPE_FULLSCREEN;
            rc = DosStartSession( (STARTDATA*) &startData, (ULONG*)&sessionId,
                                  (PID*) &ppId );
            DosSetDefaultDisk( currentDrive );
            return rc;
            }
        DosBeep(100,200);
        return 0;
        }

    //--------------------------------------------------------------------------
    // this section of code launches a program (non-command shell application)
    //--------------------------------------------------------------------------
    outputFile = fopen(LAUNCHFILE, "wt");
    if (!outputFile) {
        char title[] = "Launch an application";
        char text[] = "Could not start the application due to an error accessing the drive";
        WinMessageBox( HWND_DESKTOP, hwndFrame, text, title, 0,
                       MB_MOVEABLE|MB_ERROR|MB_OK);
        return 0;
        }

    if (Directory[menu][item][0] != '\0') {
        if ((isalpha( Directory[menu][item][0] )) && ( Directory[menu][item][1]==':'))
            fprintf( outputFile, "%c:\n", Directory[menu][item][0]);
        fprintf( outputFile, "cd %s\n", Directory[menu][item]);
        }
    fprintf( outputFile, "start " );
    if ((ActionToDo[menu][item][0] != '\0') && (!(ProgType[menu][item] & PM)))
        fprintf( outputFile, "/C ");
    if (ProgType[menu][item] & FULLSCREEN)
        fprintf( outputFile, "/FS ");
    else if (ProgType[menu][item] & WINDOWED)
        fprintf( outputFile, "/WIN ");
    if (ProgType[menu][item] & PM)
        fprintf( outputFile, "/PM ");
    else if (ProgType[menu][item] & DOS)
        fprintf( outputFile, "/DOS ");
    if (ProgType[menu][item] & STARTMAX)
        fprintf( outputFile, "/MAX ");
    else if (ProgType[menu][item] & STARTMIN)
        fprintf( outputFile, "/MIN ");
    fprintf( outputFile, "%s %s", ActionToDo[menu][item], CmdLnArgs[menu][item]);
    fclose( outputFile );

    {
    CHAR title[] = "FileBar -\nLaunch Util";
    CHAR program[] = OS2SHELL;
    CHAR inputs[] = LAUNCHINPUTS;

    memset( &startData, 0, sizeof(STARTDATA) );
    startData.Related = SSF_RELATED_INDEPENDENT;
    startData.FgBg = SSF_FGBG_FORE;
    startData.TraceOpt = SSF_TRACEOPT_NONE;
    startData.InheritOpt = SSF_INHERTOPT_PARENT;
    startData.SessionType = SSF_TYPE_WINDOWABLEVIO;
    startData.PgmControl = SSF_CONTROL_INVISIBLE | SSF_CONTROL_MINIMIZE;
    startData.PgmTitle = title;
    startData.PgmName = program;
    startData.PgmInputs = inputs;
    startData.ObjectBuffer = ObjBuf;
    startData.ObjectBuffLen = sizeof(ObjBuf);
    startData.Length = sizeof(STARTDATA);

    return DosStartSession( (STARTDATA*) &startData, (ULONG*)&sessionId,
                            (PID*) &ppId );
    }
}



