/*-------------------------------------------------------------------------*/
/*                                                                         */
/*   XFEEL.C    : Compile this Module to XFEEL.EXE                         */
/*                                                                         */
/*   Version    : V1.1b                                                    */
/*                                                                         */
/*   Date       : 31.07.92                                                 */
/*                                                                         */
/*   Copyright  : Markus Hof & Roman Fischer                               */
/*					EMAIL : mhof@iiic.ethy.ch                              */
/*							rofische@iiic.ethz.ch						   */
/*                                                                         */
/*-------------------------------------------------------------------------*/

#define INCL_DOSPROCESS
#define INCL_WINHOOKS
#define INCL_WINBUTTONS
#define INCL_WINFRAMEMGR
#define INCL_WINTIMER
#define INCL_DOSSEMAPHORES
#define INCL_DOSMEMMGR
#define INCL_DOSMODULEMGR
#include <os2pm.h>


//#define DEBUG		// if defined, xfeel is shown in switch list


/*--------------------------------------------------------------------------*/
MRESULT EXPENTRY myproc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
	{
	return (WinDefWindowProc (hwnd, msg, mp1, mp2));
	}

/*--------------------------------------------------------------------------*/
unsigned long GetAddr(HMODULE *handle, char *filename, char *command)
    {
    char            errorname[6];
    unsigned long   adr;

    if (DosLoadModule (errorname, 5, filename, handle))
        return (0L);

    if (DosGetProcAddr (*handle, command, (PFN FAR * )&adr))
        return (0L);

    return (adr);
    }

/*--------------------------------------------------------------------------*/
void main ()
	{
	HAB			hab;
	HMQ			hmq;
	QMSG		qmsg;
	HMODULE		mhand;
	ULONG		adr;
	HWND		hwnd, hwndclient;
#ifdef DEBUG
	ULONG		ff = FCF_TASKLIST;
#else
	ULONG		ff = 0L;
#endif
	
	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);

	WinRegisterClass (hab, "XFEELCLASS", myproc, 0L, 0);
	hwnd = WinCreateStdWindow (HWND_DESKTOP, 0, &ff, "XFEELCLASS",
					NULL, 0L, NULL, 0, &hwndclient);


   	adr = GetAddr (&mhand, "XFEEL", "XFUNC");
	if (!adr)
		{
   		WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
   				 "Could not find xfeel.dll. Program aborted !",
   				 NULL, 0, MB_OK|MB_ICONEXCLAMATION);
   		return;
		}
		
   	if (!WinSetHook (hab, (HMQ)NULL, HK_INPUT, (PFN)adr, mhand))
   		{
   		WinMessageBox (HWND_DESKTOP, HWND_DESKTOP,
   				 "Could not set hook. Program aborted !",
   				 NULL, 0, MB_OK|MB_ICONEXCLAMATION);
   		return;
   		}

	while (WinGetMsg (hab, &qmsg, NULL, 0, 0))
		WinDispatchMsg (hab, &qmsg);
    	

   	WinReleaseHook (hab, (HMQ)NULL, HK_INPUT, (PFN)adr, mhand);
   	DosFreeModule (mhand);

	WinDestroyWindow (hwnd);   	
	WinDestroyMsgQueue (hmq);
	WinTerminate (hab);
	}
