/*-------------------------------------------------------------------------*/
/*                                                                         */
/*   XFEEL2.C   : Compile this Module to XFEEL.DLL and place it in the     */
/*                LIBPATH.                                                 */
/*                                                                         */
/*   Version    : V1.1b                                                    */
/*                                                                         */
/*   Date       : 31.07.92                                                 */
/*                                                                         */
/*   Copyright  : Markus Hof & Roman Fischer                               */
/*					EMAIL : mhof@iiic.ethy.ch                              */
/*							rofische@iiic.ethz.ch						   */
/*                                                                         */
/*	History:
	
	28.10.92	MH	Removed Shared Segment
	5.1.93		MH	DONTCHANGEZORDER
	11.2.93		MH	Bugfix for lost characters
*/
/*-------------------------------------------------------------------------*/
#define INCL_DOSPROCESS
#define INCL_WININPUT
#define INCL_WINWINDOWMGR
#define INCL_WINFRAMEMGR
#define INCL_DOSMEMMGR

#include <os2pm.h>
#include <stdio.h>


#define DONTCHANGEZORDER


HWND lastone = NULL;
HWND lastowner = NULL;


BOOL PASCAL XFUNC (HAB hab, PQMSG qmsg, USHORT msgf)
	{
	HWND		active;
    HWND		w, wo;
    HWND		parent, desktop;
	char		classname[31];
	HWND		title;


	/*-------------------------------------------------------------*/
	/* Only care for WM_MOUSEMOVE messages                         */

    if (qmsg->msg != WM_MOUSEMOVE)
		return (FALSE);
		
	/*-------------------------------------------------------------*/
	/* If mouse captured do nothing                                */
	
	if (WinQueryCapture (HWND_DESKTOP, FALSE))
		return (FALSE);


	/*-------------------------------------------------------------*/
	/* Get active window. Break if active window is a frame window */
	/* with the title 'Window List'. This means, that the tasklist */
	/* is active => xfeel not active.                              */
	
	active	=	WinQueryActiveWindow (HWND_DESKTOP, FALSE);
	WinQueryClassName (active, 30, (PCH)classname);
	if (classname[1]=='1')
		{
		WinQueryWindowText (active, 30, (PCH)classname);
		if (!strcmp (classname, "Window List"))
			return (FALSE);
		}

	/*-------------------------------------------------------------*/
	/* Get info about new window.				                   */

	desktop	=	WinQueryDesktopWindow (hab, NULL);
	wo = w	=	qmsg->hwnd;
    parent	=	WinQueryWindow (w, QW_PARENT, FALSE);
	while (parent != desktop)
		{
		wo = w;
		w = parent;
	    parent = WinQueryWindow (w, QW_PARENT, FALSE);
		}

	/*-------------------------------------------------------------*/
	/* If new window is a menu break                               */

	WinQueryClassName (wo, 30, (PCH)classname);
	if (!strcmp (classname, "#4"))
		return (FALSE);

	/*-------------------------------------------------------------*/
	/* Make new active if not active                               */

	if (w!=lastone)
		{
		lastone = w;
		
#ifndef DONTCHANGEZORDER
		WinSetFocus (HWND_DESKTOP, WinWindowFromID (w, FID_CLIENT));
#else
		WinFocusChange (HWND_DESKTOP, WinWindowFromID (w, FID_CLIENT),
						FC_NOSETACTIVE);
						
		title = WinWindowFromID (w, FID_TITLEBAR);
		if (title)
			WinPostMsg (w, WM_ACTIVATE, -1L, title);
#endif
		}

	return (FALSE);
	}
