/* errno.h (emx+gcc) */

#if !defined (_ERRNO_H)
#define _ERRNO_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_LIBM_H)
#if !defined (_ERRNO)
#define _ERRNO
#if defined (__MT__)
extern int *_errno_fun (void);
#define errno (*_errno_fun ())
#else
extern int errno;
#endif
#endif
#endif

#define EPERM           1   /* Operation not permitted              */
#define ENOENT          2   /* No such file or directory            */
#define ESRCH           3   /* No such process                      */
#define EINTR           4   /* Interrupted system call              */
#define EIO             5   /* I/O error                            */
#define E2BIG           7   /* Arguments or environment too big     */
#define ENOEXEC         8   /* Invalid executable file format       */
#define EBADF           9   /* Bad file number                      */
#define ECHILD          10  /* No child processes                   */
#define EAGAIN          11  /* No more processes                    */
#define ENOMEM          12  /* Not enough memory                    */
#define EACCES          13  /* Permission denied                    */
#define EEXIST          17  /* File exists                          */
#define EXDEV           18  /* Cross-device link                    */
#define ENOTDIR         20  /* Not a directory                      */
#define EISDIR          21  /* Is a directory                       */
#define EINVAL          22  /* Invalid argument                     */
#define EMFILE          24  /* Too many open files                  */
#define ENOSPC          28  /* Disk full                            */
#define ESPIPE          29  /* Illegal seek                         */
#define EROFS           30  /* Read-only file system                */
#define EPIPE           32  /* Broken pipe                          */
#define EDOM            33  /* Domain error                         */
#define ERANGE          34  /* Result too large                     */
#define EMSDOS          37  /* Not supported under MS-DOS           */
#define ENAMETOOLONG    38  /* File name too long                   */

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_ERRNO_H) */
