/* os2thunk.h (emx+gcc) */

#if !defined (_OS2THUNK_H)

#define _OS2THUNK_H

typedef unsigned long _far16ptr;

_far16ptr _emx_32to16 (void *ptr);
void *_emx_16to32 (_far16ptr ptr);

unsigned long _emx_thunk1 (void *args, void *fun);

#define _THUNK_PROLOG(SIZE) \
  ({ char _tb[(SIZE)+4]; void *_tp = _tb + sizeof (_tb); \
       *(unsigned long *)_tb = (SIZE);

#define _THUNK_CHAR(ARG)  _THUNK_SHORT (ARG)
#define _THUNK_SHORT(ARG) *--((unsigned short *)_tp) = (ARG)
#define _THUNK_LONG(ARG)  *--((unsigned long *)_tp) = (ARG)
#define _THUNK_FLAT(ARG)  _THUNK_LONG (_emx_32to16 (ARG))
#define _THUNK_FAR16(ARG) _THUNK_LONG (ARG)

#define _THUNK_FUNCTION(FUN) _16_##FUN

#define _THUNK_CALL(FUN) _emx_thunk1 (_tb, (void *)(_16_##FUN)); })

#define MAKE16P(sel,off)   ((_far16ptr)((sel) << 16 | (off)))
#define MAKEP(sel,off)     _emx_16to32 (MAKE16P (sel, off))
#define SELECTOROF(farptr) ((SEL)((farptr) >> 16))
#define OFFSETOF(farptr)   ((USHORT)(farptr))

#endif /* !defined (_OS2THUNK_H) */
