/* process.h (emx+gcc) */

#if !defined (_PROCESS_H)
#define _PROCESS_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (P_WAIT)
#define P_WAIT    0
#define P_NOWAIT  1
#define P_OVERLAY 2
#define P_DEBUG   3
#define P_SESSION 4
#define P_DETACH  5

#define P_DEFAULT    0x0000
#define P_MINIMIZE   0x0100
#define P_MAXIMIZE   0x0200
#define P_FULLSCREEN 0x0300
#define P_WINDOWED   0x0400

#define P_FOREGROUND 0x0000
#define P_BACKGROUND 0x1000

#define P_NOCLOSE    0x2000

#endif

void abort (void);
int atexit (void (*func)(void));
int execl (__const__ char *name, __const__ char *arg0, ...);
int execle (__const__ char *name, __const__ char *arg0, ...);
int execlp (__const__ char *name, __const__ char *arg0, ...);
int execlpe (__const__ char *name, __const__ char *arg0, ...);
int execv (__const__ char *name, __const__ char * __const__ *argv);
int execve (__const__ char *name, __const__ char * __const__ *argv,
    __const__ char * __const__ *envp);
int execvp (__const__ char *name, __const__ char * __const__ *argv);
int execvpe (__const__ char *name, __const__ char * __const__ *argv,
    __const__ char * __const__ *envp);
void __volatile__ exit (int ret);
void __volatile__ _exit (int ret);
int fork (void);
int getpid (void);
int getppid (void);
int spawnl (int mode, __const__ char *name, __const__ char *arg0, ...);
int spawnle (int mode, __const__ char *name, __const__ char *arg0, ...);
int spawnlp (int mode, __const__ char *name, __const__ char *arg0, ...);
int spawnlpe (int mode, __const__ char *name, __const__ char *arg0, ...);
int spawnv (int mode, __const__ char *name, __const__ char * __const__ *argv);
int spawnve (int mode, __const__ char *name, __const__ char * __const__ *argv,
    __const__ char * __const__ *envp);
int spawnvp (int mode, __const__ char *name, __const__ char * __const__ *argv);
int spawnvpe (int mode, __const__ char *name,
    __const__ char * __const__ *argv, __const__ char * __const__ *envp);
int system (__const__ char *name);
int wait (int *status);
int waitpid (int pid, int *status, int options);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_PROCESS_H) */
