/* string.h (emx+gcc) */

#if !defined (_STRING_H)
#define _STRING_H

#if defined (__cplusplus)
extern "C" {
#endif

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (NULL)
#define NULL ((void *)0)
#endif

#if !defined (_MEMDIF_EQ)
#define _MEMDIF_EQ 0xffffffff
#endif

void *memccpy (void *s1, __const__ void *s2, int c, size_t n);
void *memchr (__const__ void *s, int c, size_t n);
int memcmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memcpy (void *s1, __const__ void *s2, size_t n);
int memicmp (__const__ void *s1, __const__ void *s2, size_t n);
void *memmove (void *s1, __const__ void *s2, size_t n);
void *memset (void *s, int c, size_t n);

char *strcat (char *string1, __const__ char *string2);
char *strchr (__const__ char *string, int c);
int strcmp (__const__ char *string1, __const__ char *string2);
char *strcpy (char *string1, __const__ char *string2);
size_t strcspn (__const__ char *string1, __const__ char *string2);
char *strdup (__const__ char *string);
char *strerror (int errnum);
int stricmp (__const__ char *string1, __const__ char *string2);
size_t strlen (__const__ char *string);
char *strlwr (char *string);
char *strncat (char *string1, __const__ char *string2, size_t count);
int strncmp (__const__ char *string1, __const__ char *string2, size_t count);
char *strncpy (char *string1, __const__ char *string2, size_t count);
int strnicmp (__const__ char *string1, __const__ char *string2, size_t count);
char *strnset (char *string, int c, size_t count);
char *strpbrk (__const__ char *string1, __const__ char *string2);
char *strrchr (__const__ char *string, int c);
char *strrev (char *string);
char *strset (char *string, int c);
size_t strspn (__const__ char *string1, __const__ char *string2);
char *strstr (__const__ char *string1, __const__ char *string2);
char *strtok (char *string1, __const__ char *string2);
char *strupr (char *string);

size_t _memcount (__const__ void *mem, int c, size_t n);
size_t _memdif (__const__ void *mem1, __const__ void *m2m, size_t n);
void _memswap (void *s1, void *s2, size_t n);
char *_strncpy (char *string1, __const__ char *string2, size_t size);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (_STRING_H) */
