/* sys/types.h (emx+gcc) */

#if !defined (_SYS_TYPES_H)
#define _SYS_TYPES_H

#if !defined (_SIZE_T)
#define _SIZE_T
typedef unsigned long size_t;
#endif

#if !defined (_TIME_T)
#define _TIME_T
typedef unsigned long time_t;
#endif

#if !defined (_INO_T)
#define _INO_T
typedef long ino_t;
#endif

#if !defined (_DEV_T)
#define _DEV_T
typedef long dev_t;
#endif

#if !defined (_OFF_T)
#define _OFF_T
typedef long off_t;
#endif

#if !defined (_MODE_T)
#define _MODE_T
typedef long mode_t;
#endif

#if !defined (_NLINK_T)
#define _NLINK_T
typedef long nlink_t;
#endif

#if !defined (_UID_T)
#define _UID_T
typedef long uid_t;
#endif

#if !defined (_GID_T)
#define _GID_T
typedef long gid_t;
#endif

#if !defined (FD_SETSIZE)

#define	FD_SETSIZE      256

typedef struct _fd_set
{
  unsigned long fds_bits[(FD_SETSIZE+31) / 32];
} fd_set;

#define	FD_SET(n,s)    ((s)->fds_bits[(n)/32] |=  (1L << ((n) & 0x1f)))
#define	FD_CLR(n,s)    ((s)->fds_bits[(n)/32] &= ~(1L << ((n) & 0x1f)))
#define	FD_ISSET(n,s)  ((s)->fds_bits[(n)/32] &   (1L << ((n) & 0x1f)))
#define FD_ZERO(s)     (void)memset (s, 0, sizeof (*(s)))

#endif

#endif /* !defined (_SYS_TYPES_H) */
