/* sys/wait.h (emx+gcc) */

#if !defined (_SYS_WAIT_H)
#define _SYS_WAIT_H

#if defined (__cplusplus)
extern "C" {
#endif

#define WNOHANG         1
#define WUNTRACED       2

#define WIFEXITED(st)   (((st) & 0xff) == 0)
#define WIFSIGNALED(st) (((st) & 0xff) != 0x7f && ((st) >> 8) == 0)
#define WIFSTOPPED(st)  (((st) & 0xff) == 0x7f)

#define WEXITSTATUS(st) ((st) >> 8)
#define WSTOPSIG(st)    ((st) >> 8)
#define WTERMSIG(st)    ((st) & 0x7f)

int wait (int *status);
int waitpid (int pid, int *status, int options);

#if defined (__cplusplus)
}
#endif

#endif /* !defined (SYS_WAIT_H) */
