/*
@echo off
cls
echo.
echo.
echo ERROR:
echo REXX support not installed
echo You must have REXX support installed to run this
echo program.
echo.
echo To run this program, run Selective Install from
echo your System Setup folder, and install REXX.
exit
*/
/*----------------------------------------------*/
/*-- REXX                                     --*/
/*----------------------------------------------*/
/*-- PROGRAM NAME:                            --*/
/*-- install                                  --*/
/*--                                          --*/
/*-- DESCRIPTION:                             --*/
/*-- Installs the demo version of PMD         --*/
/*----------------------------------------------*/
/*-- AUTHOR:                                  --*/
/*-- Kelly Schrock                            --*/
/*----------------------------------------------*/
/*-- DATE:                                    --*/
/*-- 12.13.93                                 --*/
/*----------------------------------------------*/

TRACE n
signal on HALT
call LoadLibs

/*-- get the command line --*/
parse arg sourcedir destdir

/*-- Do the intro --*/
call SysCls
say ''
say '                        PM Designer Installation'
say '                               Demo version'

/*-- get dest dir --*/
if destdir = '' then do
  say ''
  say 'Please enter a directory name for PM Designer'
  say '(Default: C:\PMD):'
  parse pull destdir
  /*-- if error --*/
  if destdir = ' ' then do
    destdir = 'C:\PMD'
  end
end

if sourcedir = ' ' then do
  thisdir = directory()
  say ''
  say 'Please enter the directory where the program is being installed'
  say 'from(Default: 'thisdir'):'
  parse pull sourcedir
  /*-- if another error --*/
  if sourcedir = ' ' then do
    sourcedir = thisdir
    say 'using the current directory as the source directory.'
end

/*-- make sure path is good --*/
If substr( sourcedir, length(sourcedir), 1 ) \= '\' then
    sourcedir = sourcedir||'\'

/*-- do main screen --*/
call SysCls
say
say '                   PM Designer Installation'
say '                         Demo version'
say
say 'PM Designer will be Installed with the following settings:'
say
say 'Source directory:      "'sourcedir'"'
say 'Destination directory: "'destdir'"'
say
say
say
say 'Okay to continue(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then do
  say
  say 'Installation cancelled.'
  exit
end

/*-- see if the dest directory exists --*/
Call SysFileTree destdir, file, 'D'

if file.0 = '0' then do
  say 'The directory: 'destdir' does not exist on your disk. Create it(Y/n)?'
  k = SysGetKey('NOECHO')
  if k = 'N'| k = 'n' then do
    say
    say 'Installation cancelled.'
    exit
  end
  /*-- create the dest. dir --*/
  rc = SysMkDir(destdir)
  if rc = 0 then do
    say 'The directory ' destdir ' was created successfully.'
  end
  else do
    say 'The directory ' destdir ' could not be created successfully; cancelling.'
    exit
  end
end


/*--
create the directory tree
--*/
basedir =  destdir
bin =      '\bin'
bitmap =   '\bitmap'
doc =      '\doc'
examples = '\examples'
icons =    '\icons'
include =  '\include'
lib =      '\lib'
skeleton = '\skeleton'
basic =    examples||'\basic'
buttons =  examples||'\buttons'
dialog =   examples||'\dialog'
calc =     examples||'\calc'
m_thread = examples||'\m_thread'
edit =     examples||'\edit'

dirs.0 = 14
dirs.1 = bin
dirs.2 = bitmap
dirs.3 = doc
dirs.4 = examples
dirs.5 = icons
dirs.6 = include
dirs.7 = lib
dirs.8 = skeleton
dirs.9 = basic
dirs.10 = buttons
dirs.11 = dialog
dirs.12 = calc
dirs.13 = m_thread
dirs.14 = edit

do i = 1 to dirs.0
  Call SysFileTree basedir||dirs.i, file, 'D'
  if file.0 = '0' then do
    rc = SysMkDir(basedir||dirs.i)
    if rc <> 0 then
      if rc <> 5 then do
        say 'Error creating the 'basedir||dirs.i' directory; cancelling...'
        exit
      end
    end
  end
  dirs.i = basedir||dirs.i||'\'
end

say 'Source dir: 'sourcedir
say 'Dest dir: 'basedir


/*-- copy the files --*/
call SysCls
say
say 'Install is copying files, please wait...'
call CopyFile 'README.INF', sourcedir, basedir
call CopyFile 'PMD.ICO', sourcedir, basedir'\BIN'

say 'Install is unpacking files, please wait...'
/*-- unpack the archive to the destination directory --*/
command = '@echo y |'||sourcedir||'\PMDDBIN.exe 'basedir '>NUL'
command

/*-- create a program object --*/
call SysCls
say
say 'PM Designer can be installed as an object on your desktop.'
say 'Do you want to create it now(Y/n)?'
k = SysGetKey('NOECHO')
if k = 'N' | k = 'n' then call GoodBye

say
say 'Creating the program folder,'
x = SysCreateObject("WPFolder",,
                    "PM Designer demo",,
                    "<WP_DESKTOP>",,
        "OBJECTID=<PMD>;ICONFILE="||destdir||"\BIN\PMD.ICO", "replace")
if x = 0 then do
  say 'Unable to create folder; cancelling.'
  exit
end

say 'Adding the'

say 'ReadMe file,'
x = SysCreateObject("WPProgram",,
                    "Read Me First",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\README.INF")

say 'Order form,'
x = SysCreateObject("WPProgram",,
                    "Order form",,
                    "<PMD>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\ORDER.FRM")

say 'License Agreement,'
x = SysCreateObject("WPProgram",,
                    "License Agreement",,
                    "<PMD>",,
                    "EXENAME=E.EXE;PARAMETERS="||destdir||"\LICENSE.TXT")

say 'Manual,'
x = SysCreateObject("WPProgram",,
                    "Manual",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\PMD.INF")

say 'Developers guide,'
x = SysCreateObject("WPProgram",,
                    "Developer's Guide",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\DEVGUIDE.INF")

say 'API Reference,'
x = SysCreateObject("WPProgram",,
                    "API Reference",,
                    "<PMD>",,
                    "EXENAME=VIEW.EXE;PARAMETERS="||destdir||"\DOC\PMDAPI.INF")


say 'Program object,'
x = SysCreateObject("WPProgram",,
                    "PM Designer",,
                    "<PMD>",,
  "EXENAME="||destdir||"\BIN\PMD.EXE;STARTUPDIR="||destdir"\BIN;ASSOCFILTER=*.APP")

say 'Examples folder,'
x = SysCreateObject("WPShadow",,
                    "Examples",,
                    "<PMD>",,
  "SHADOWID="||destdir||"\EXAMPLES")

say 'Projects folder,'
x = SysCreateObject("WPShadow",,
                    "Projects",,
                    "<PMD>",,
  "SHADOWID="||destdir||"\Projects")

say 'Project template,'
x = SysSetObjectData(destdir||"\Projects\project", "TEMPLATE=YES")
if x = 0 then do
 say 'Unable to set the "TEMPLATE" attribute on the project template.'
 say 'You will have to do this manually...'
end


GoodBye:
/*-- exit with a goodbye --*/
say
say 'Done.'
say
say
say 'PM Designer has been installed on your system.'
say
say 'Be sure to read the file README.TXT for up-to-date information.'
say
say 'Press any key to exit installation...'
k = SysGetKey('NOECHO')
call SysCls
'@view.exe '||destdir||'\readme Introduction'
exit

/*----------------------------------------------*/
/*-- FUNCTION:                                --*/
/*-- LoadLibs                                 --*/
/*-- ACTION:                                  --*/
/*-- loads the libraries needed by this REXX  --*/
/*----------------------------------------------*/
LoadLibs:
  if RxFuncQuery('SysLoadFuncs') THEN
  do
    /*-- load the load-function --*/
    CALL RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
    /*-- load the Sys* utilities --*/
    CALL SysLoadFuncs
  end
return

HALT:
  say
  say 'Program cancelled; Interrupted by user.'
  exit

/*-----------------------------------------------------------------------------*/
/*-- CopyFile                                                                --*/
/*-----------------------------------------------------------------------------*/
CopyFile: Arg ArgFile2Copy, ArgSourceDir, ArgInstallDir

    Say 'Copying 'ArgSourceDir||ArgFile2Copy' to 'ArgInstallDir||'\'||ArgFile2Copy'...'
    Command = '@Copy 'ArgSourceDir||ArgFile2Copy' 'ArgInstallDir||'\'||ArgFile2Copy' >NUL'
    Command
    if rc \= 0 Then Do
        say 'Error! 'ArgFile2Copy' was not installed properly.'
        Pull ConfirmIt
    End
    Return
