.* DOC.ipf - Information Tag Language file for the Yachtzee .INF file
:userdoc.
:Title.Yachtzee

.*=============================================================================
.* Introduction
.* res = PANEL_INTRO
.*--------------------------------------------------------------
:h1 res=2000 name=PANEL_INTRO.Introduction
.*
:p.:hp8.Yachtzee:ehp8. is a Presentation Manager application (for OS/2 2.x) that implements the
classic Yachtzee dice game.
.*
:p.Some of the words in this manual are highlighted in bold text, such as :hp2.Roll:ehp2..  These are
words that refer to software :hp1.controls:ehp1. (ie, buttons, sliders, checkboxes) which you
manipulate in the Yachtzee window.  Other words are in colored text such as
:hp4.Full House:ehp4..  These refer to catagories on the Yachtzee scorecard.  Underlined words,
such as :hp5.New Game:ehp5., refer to pull-down menu items.  Words that are in colored text such
as as :hp8.Read This:ehp8. are meant to be emphasized.  Words in italics refer to aspects of
OS/2.
.*
:p.This is version 1.0 copyright 1993 by Jeff Glatt.
.*
.*
.*=============================================================================
.* Game Play
.* res = PANEL_GAME
.*--------------------------------------------------------------
:h1 res=2005 name=PANEL_GAME.Game Play
:i1 id=Game.Game Play
:p.There are 13 catagories on a Yachtzee scorecard.  They are labeled&colon.
:hp2.
:p.Ones
.br
Twos
.br
Threes
.br
Fours
.br
Fives
.br
Sixes
.br
3 of a kind
.br
4 of a kind
.br
Full House
.br
Small Straight
.br
Large Straight
.br
Yachtzee
.br
Chance
:ehp2.
.*
:p.The 13 catagories are arranged in a column.  The first 6 catagories are grouped together on the
upper half of the scorecard.  The scores in these 6 catagories are summed together, and this sum
is displayed in the :hp2.Upper:ehp2. box.  If this sum rises above 63 points, then a
:hp2.Bonus:ehp2. of 35 points is automatically awarded.  :hp2.Upper Total:ehp2. represents the
sum of the first 6 catagories, along with any bonus.
.*
:p.The remaining 7 catagories are grouped together on the lower half of the scorecard.  They are
also summed together, and this sum is displayed in the :hp2.Lower:ehp2. box.
.*
:p.The :hp2.Grand Total:ehp2. box represents all combined sums (ie, your game score).
.*
:p.When you fill in scores for all 13 catagories, then the game is over.  The object is to get the
highest possible :hp2.Grand Total:ehp2..
.*
:p.There are 5 dice.  You have upto 3 opportunities to roll all (or some) of the dice upon each
turn.  At the end of a turn, you must fill in one of the catagories which has not already been
scored.  So, you will have a total of 13 turns; one for each catagory.
.*
:p.The computer automatically rolls all 5 dice at the beginning of your turn.  Then, the computer
displays the possible scores (on the scorecard) that you could make from these 5 dice.  It displays
all possible scores in a purple color.
.*
:p.For example, assume that you have rolled the following values for the five dice&colon.
.*
:p.2 4 4 2 2
.*
:p.With such a combination of values, you could put a score of 6 into the :hp2.Twos:ehp2.
catagory, or you could put a score of 8 into the :hp2.Fours:ehp2. catagory, or you could put a
score of 25 in the :hp2.Full House:ehp2. catagory, etc.  For some catagories, this dice roll is not
good, and may result in a 0 score.  The computer will display those 0 scores as well, since it's
legal for you to accept a 0 score in some catagory (although this is something that you want to
avoid doing being that the object is to end up with the highest possible Grand Total).
.*
:p.If you'd like to accept one of the possible scores right now, simply move the mouse pointer
onto the displayed score, and click the Mouse Button 1 once.  For example, if you want to accept
a score of 25 in the :hp2.Full House:ehp2. catagory, move the mouse pointer onto the "25", and
click Mouse Button 1.
.*
:nt.All of the catagories have keyboard shortcuts.  The keyboard shortcut is the underlined letter
in the catagory label.  For example, the :hp2.Full House:ehp2. label has an underlined
:hp5.F:ehp5..  To select this catagory for scoring, simply press the "f" key (caps not
necessary).  Use this as an alternative to moving and clicking the mouse pointer on the scores
of the scorecard.:ent.
.*
:p.Now that you've selected the :hp2.Full House:ehp2. catagory's score, this turn is done.  The
computer will display the :hp2.Full House:ehp2. score (ie, 25) in a black color to indicate that this
catagory has now been scored.  You won't be able to select this catagory again for the remainder
of the game, even if you roll another Full House score later.
.*
:p.The computer then immediately starts the next turn.  In other words, all 5 dice are
automatically rolled by the computer again, and then the computer displays the possible scores for
these dice values.
.*
:p.Now, you don't have to select a catagory for scoring after the first roll of all 5 dice.  If you
don't like the choice of scores, you have the option of rolling all or some of the dice again in
order to try to obtain a better selection of dice values.  (You get to do this 2 more times after
the computer's initial roll).  Let's say that the computer initially rolls the following 5 dice
values&colon.
.*
:p.2 3 4 1 2
.*
:p.There happens to be a :hp2.Small Straight:ehp2. in this combination.  But, you notice that you
haven't scored the :hp2.Large Straight:ehp2. catagory yet.  If you could take one of those dice with
the value 2, roll it again, and come up with a value of 5 for that die, you would have a
:hp2.Large Straight:ehp2..  Let's assume that you wish to roll that last die again (ie, the second
"2").  First, you need to blank out that die.  You do this by moving the mouse pointer onto the
die itself, and clicking Mouse Button 1 once.  The two spots on the die will disappear (ie, it will
change into a blank die).  This means that the die is now ready to be rolled again.  Don't click
the mouse on the other dice.  Leave their spots showing.  This tells the computer that you don't
want to roll those other 4 dice.  You want to leave their values as is.  Now, move the mouse
pointer onto the :hp2.Roll:ehp2. button, and click once.  The computer will roll that die, and
hopefully, you'll end up with a new value for it.  Let's assume that the new value is 6.
.*
:nt.If you blank out a die (ie, choose it to be rolled again), and change your mind, simply click
the mouse on that blank die again, and its previous spots will come back.  You can blank and
unblank dice as much as you want while deciding which ones to roll.  (But, you still only get to
click on the :hp2.Roll:ehp2. button two more times).  Furthermore, all 5 dice have keyboard
shortcuts to blank and unblank them.  The keyboard shortcut is the die number.  For example,
to blank the first (ie, topmost) die, press the :hp8.1:ehp8. key.  To blank the next die down,
press the :hp8.2:ehp8. key.  Etc.  Use this as an alternative to moving and clicking the mouse
pointer on the dice.  Also, the :hp2.Roll:ehp2. button has a keyboard shortcut; the ENTER
key or SPACE BAR.  Finally, note that Mouse Button 2 selects all 5 dice for rolling.  Mouse
Button 3 does the opposite (ie, causes no dice to be selected for rolling).:ent.
.*
:p.Now, our 5 dice values are as follows&colon.
.*
:p.2 3 4 1 6
.*
:p.That still doesn't give us the :hp2.Large Straight:ehp2..  Note that the computer redisplays the
possible scores after each roll.  You have one more Roll available before you must select a score,
so you can blank that "6" die value again, and roll once more.  Let's assume that the final roll is
a "4".  That still doesn't give us the :hp2.Large Straight:ehp2., but now we must choose a score
(ie, finish this turn) as the dice have been rolled 3 times.  The computer disables the
:hp2.Roll:ehp2. button to remind you that you must now choose a score.  Look at the possible
scores, and select the best one.
.*
:p.The game continues as so until all 13 catagories are scored.  At this point, you can start a
new game, by pulling down the :hp5.File:ehp5. menu and selecting :hp5.New Game:ehp5..  (Or,
you can simultaneously press the :hp9.CTRL:ehp9. and :hp9.g:ehp9. keys).
.*
:p.You exit Yachtzee by selecting :hp5.Close:ehp5. from its System Menu, or double-clicking on
the window upper left corner icon.  You can exit at any time, even in the middle of a game.
.*
.*
.*=============================================================================
.* Audio
.* res = PANEL_AUDIO
.*--------------------------------------------------------------
:h1 res=2010 name=PANEL_AUDIO.Audio
:i1 id=Aud.Audio
:p.Yachtzee generates MIDI :hp4.Note On:ehp4. and :hp4.Note Off:ehp4. messages on selected MIDI
channels to trigger sound effects on a sound card or external MIDI sound module.
.*
:p.You'll hear a bell "ding" when you make a good score.  You'll hear a scratch sound when you're
score is not so good.  Be very careful of low scores on the upper half of the scorecard, as you
could jeopardize receiving a bonus.  If you always get 3 dice for each upper catagory (ie, 3 ones,
3 twos, 3 fours, etc), then you'll earn the bonus.  You'll hear a cymbal crash if you get the
Yachtzee catagory.  This is a hard catagory to score, so sometimes, if you :hp8.must:ehp8. accept
some 0 score, this may be the safest catagory to sacrifice.  Each time that the dice are rolled,
you'll hear a rolling sound.  When a game is over, you'll hear applause.
.*
:p.The :hp5.Audio:ehp5. menu item brings up the Audio Dialog.
.*
:p.There is a checkbox for :hp2.Sound:ehp2..  Make sure that this box is checked if you want to
hear sound effects.  If the box is not checked, then sound effects are disabled (ie, quiet play).
.*
:p.If you ever get any "stuck" sounds, use the :hp2.Reset:ehp2. :hp1.button:ehp1. to turn
them off.
.*
:p.By default, MIDI :hp4.Note On:ehp4. messages are sent with a velocity of 127 (ie, the highest
possible velocity).  Generally, velocity is used to set the volume on a :hp8.per note:ehp8. basis,
although some modules can use velocity for other effects such as attack time of a voltage
controlled generator (VCA).  The :hp2.Volume:ehp2. slider allows you to adjust the volume of the
sound effects, where moving the knob all of the way to the left is minimum volume.
.*
:p.You operate a :hp1.slider:ehp1. by "grabbing" its knob with mouse button 1 and moving it to a
new position.  Alternately, if you want to increment/decrement the knob's position, move the
mouse pointer inside of the slider's shaft, but not on top of the knob itself (ie, to either side of
the knob), and click the Mouse Button 1 once.  If you're to the left of the knob, it will increment
by 1 position.  If you're to the right of the knob, it will decrement by 1 position.
.*
:p.The slider has a small arrow above it.  This arrow marks Full Volume.  If you want to quickly
set the slider to this default position, click on that arrow, and the knob will move to that
position.
.*
:p.Press the :hp8.ENTER:ehp8. key, or click on the Close Icon to accept for settings.  Or, press
:hp8.ESC:ehp8. to cancel.
.*
.*
.*--------------------------------------------------------------
.*    General MIDI Standard
.*    res = PANEL_GM
.*--------------------------------------------------------------
:h2 res=2020 name=PANEL_GM.General MIDI Standard
:i2 refid=Aud.GM
:p.Nowadays, most sound cards and MIDI modules have specific Patches setup in a specific order
according to a standard known as :hp9.General MIDI:ehp9. (or GM).  All this means is that on
every GM module, a :hp9.Piano:ehp9. patch must be the very first patch.  Patch #49 must be a
:hp9.Flute:ehp9..  Patch #25 must be a :hp9.Nylon String Guitar:ehp9..  There are 128 defined
patches that a GM module must have, in the proper order.
.*
:p.Furthermore, all patches must sound a middle C when receiving a MIDI note number of 60.
.*
:p.If the GM module also has a built-in "drum module", then each MIDI note (on the channel
assigned to the drums) triggers a different drum sound.  The assignments of drum sounds to
MIDI notes is also standardized.  The Drum sounds are usually set to receive MIDI data on
channel 10.
.*
:p.Yachtzee assumes that the sound card receives data on MIDI channels 1 and 10.  The GM
drum kit is on channel 10.  The "Applause" patch is assigned to Program Change number 127 (as
it should be on a GM module).  If you have a sound card or external module that meets these
simple GM standards, then Yachtzee should be able to play back sound effects using your hardware.
.*
.*
.*--------------------------------------------------------------
.*    Driver
.*    res = PANEL_DRIVER
.*--------------------------------------------------------------
:h2 res=2030 name=PANEL_DRIVER.Driver Requirements and Setup
:i2 refid=Aud.Driver
:p.For sound effects, Yachtzee requires that your MIDI interface or Sound Card has an OS/2
driver.  Information sent to this driver via DosWrite() must be interpreted as MIDI data.  (It would
have to be a rather strange driver if it didn't interpret data in this way, but if you're using a
sound card with WAVE playback in addition to a MIDI interface, it's conceivable that the Sound
Card might interpret DosWrite() data to be WAVE data).
.*
:p.You must also know your driver's internal name (which might be different than the filename of
the driver).  Often, this is the driver filename minus the :hp8..SYS:ehp8. extension.  For example,
I use a Roland RAP-10 audio card which has an MPU-401 compatible MIDI interface built into
it.  There is a shareware OS/2 driver available for the MPU-401 by the following manufacturer&colon.
.*
:p.Delta Music Systems
.br
2615 Ginghamsburg-Frederick Rd.
.br
Tipp City, OH 45371
.*
:p.This driver's internal name is :hp8.MPU401:ehp8..  It properly interprets DosWrite() data as
MIDI data, and ships it out of any MPU-401 compatible interface.  So, you can use this driver
with Yachtzee, and any card that has an MPU-401 compatible interface (in hardware, not just a
software driver simulation) or attach an external MIDI unit (GM standard) to your MIDI interface.
.*
:p.By default, Yachtzee will use that driver, and so you don't have to supply it with that name.  If
you want Yachtzee to use a different driver, then you must supply the name of the driver to
Yachtzee.  If you run Yachtzee from an OS/2 Command Prompt, then simply type the name of your
driver as an argument.
.*
:p.If you run Yachtzee from a :hp1.Desktop:ehp1. icon, open up the :hp1.Settings:ehp1. menu for
that program.  In the :hp1.Parameters:ehp1. field, type the name of your driver.  Now whenever
you run Yachtzee from the Desktop, it will use that driver.
.*
:nt.Remember to omit the :hp8..SYS:ehp8. extension from the driver name.:ent.
.*
:p.If Yachtzee can't open the specified driver, it will display an error dialog box.  At this point,
the program will run, but sound will be disabled.
.*
.*
.*=============================================================================
.* CATAGORIES
.* res = PANEL_CAT
.*--------------------------------------------------------------
:h1 res=2040 name=PANEL_CAT.Catagories
:i1 id=Cat.Catagories
:p.What follows is a description of the 13 catagories on the Yachtzee scorecard; how they are
scored, and an example of such.  To bring up help on a catagory during play, press the F1 key
and then click on the catagory (or press its keyboard shortcut).
.*
.*
.*--------------------------------------------------------------
.*      Ones
.*      res = PANEL_ONES
.*--------------------------------------------------------------
:h2 res=2500 name=PANEL_ONES.Ones
:i2 refid=Cat.Ones
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.one:ehp8. (ie, one dot).  Each of these dice is
worth 1 point.  Do not count any other dice values.  Enter the score in the :hp4.Ones:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 3 of the dice were each showing a one, and the other 2 dice were other values, then the
score would be 3.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Twos
.*      res = PANEL_TWOS
.*--------------------------------------------------------------
:h2 res=2501 name=PANEL_TWOS.Twos
:i2 refid=Cat.Twos
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.two:ehp8. (ie, two dots).  Each of these dice is
worth 2 points.  Do not count any other dice values.  Enter the score in the :hp4.Twos:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 4 of the dice were each showing a two, and the other die was some other values, then the
score would be 8.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Threes
.*      res = PANEL_THREES
.*--------------------------------------------------------------
:h2 res=2502 name=PANEL_THREES.Threes
:i2 refid=Cat.Threes
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.three:ehp8. (ie, three dots).  Each of these dice is
worth 3 points.  Do not count any other dice values.  Enter the score in the :hp4.Threes:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 1 die was showing a three, and the other 4 dice were other values, then the score would be
3.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Fours
.*      res = PANEL_FOURS
.*--------------------------------------------------------------
:h2 res=2503 name=PANEL_FOURS.Fours
:i2 refid=Cat.Fours
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.four:ehp8. (ie, four dots).  Each of these dice is
worth 4 points.  Do not count any other dice values.  Enter the score in the :hp4.Fours:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 2 of the dice were each showing a four, and the other 3 dice were other values, then the
score would be 8.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Fives
.*      res = PANEL_FIVES
.*--------------------------------------------------------------
:h2 res=2504 name=PANEL_FIVES.Fives
:i2 refid=Cat.Fives
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.five:ehp8. (ie, five dots).  Each of these dice is
worth 5 points.  Do not count any other dice values.  Enter the score in the :hp4.Fives:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 3 of the dice were each showing a five, and the other 2 dice were other values, then the
score would be 15.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Sixes
.*      res = PANEL_SIXES
.*--------------------------------------------------------------
:h2 res=2505 name=PANEL_SIXES.Sixes
:i2 refid=Cat.Sixes
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.Count only the dice that have the value :hp8.six:ehp8. (ie, six dots).  Each of these dice is
worth 6 points.  Do not count any other dice values.  Enter the score in the :hp4.Sixes:ehp4.
catagory (upper half).
:pt.:hp8.Example:ehp8.
:pd.If 4 of the dice were each showing a six, and the other die was some other values, then the
score would be 24.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      3 of a kind
.*      res = PANEL_3
.*--------------------------------------------------------------
:h2 res=2506 name=PANEL_3.3 of a kind
:i2 refid=Cat.3 of a kind
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.3 (or more) of the dice must all have the same value (ie, same number of spots).  Add up
the values of all 5 dice, and enter the total in the :hp4.3 of a kind:ehp4. catagory (lower half).
:nt.The computer automatically sums the dice for you.:ent.
:pt.:hp8.Example:ehp8.
:pd.If at least 3 of the dice were each showing a six, then you would add the values of all 5
dice.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      4 of a kind
.*      res = PANEL_4
.*--------------------------------------------------------------
:h2 res=2507 name=PANEL_4.4 of a kind
:i2 refid=Cat.4 of a kind
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.4 (or more) of the dice must all have the same value (ie, same number of spots).  Add up
the values of all 5 dice, and enter the total in the :hp4.4 of a kind:ehp4. catagory (lower half).
:nt.The computer automatically sums the dice for you.:ent.
:pt.:hp8.Example:ehp8.
:pd.If at least 4 of the dice were each showing a three, then you would add the values of all 5
dice.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Full House
.*      res = PANEL_FULL
.*--------------------------------------------------------------
:h2 res=2508 name=PANEL_FULL.Full House
:i2 refid=Cat.Full House
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.3 of the dice must all have the same value (ie, same number of spots), and the other two dice
must be the same, but a different value than the other 3.  Score is always 25 points.  Enter 25 in
the :hp4.Full House:ehp4. catagory (lower half).
:pt.:hp8.Example:ehp8.
:pd.If 3 of the dice were each showing a six, and the other 2 dice were each showing a four,
then score 25.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Small Straight
.*      res = PANEL_SML
.*--------------------------------------------------------------
:h2 res=2509 name=PANEL_SML.Small Straight
:i2 refid=Cat.Small Straight
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.4 (or 5) of the dice must be in ascending sequence (ie, 1, 2, 3, 4).  Score is always
30.  Enter 30 in the :hp4.Small Straight:ehp4. catagory (lower half).
:pt.:hp8.Example:ehp8.
:pd.If 4 of the dice were the values 2, 3, 4, and 5 respectively (or 1, 2, 3, 4, or 3, 4, 5, 6) then
score 30.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Large Straight
.*      res = PANEL_LAR
.*--------------------------------------------------------------
:h2 res=2510 name=PANEL_LAR.Large Straight
:i2 refid=Cat.Large Straight
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.All 5 of the dice must be in ascending sequence (ie, 1, 2, 3, 4, 5).  Score is always
40.  Enter 40 in the :hp4.Large Straight:ehp4. catagory (lower half).
:pt.:hp8.Example:ehp8.
:pd.If the 5 dice were the values 1, 2, 3, 4, and 5 respectively (or 2, 3, 4, 5, and 6), then score
40.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Yachtzee
.*      res = PANEL_YAH
.*--------------------------------------------------------------
:h2 res=2511 name=PANEL_YAH.Yachtzee
:i2 refid=Cat.Yahtzee
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.All 5 dice must have the same value (ie, same number of spots).  Score is always 50.  Enter
50 in the :hp4.Yachtzee:ehp4. catagory (lower half).
:pt.:hp8.Example:ehp8.
:pd.If all 5 dice were each showing a two, then score 50.
:eparml.
.*
.*
.*--------------------------------------------------------------
.*      Chance
.*      res = PANEL_CHA
.*--------------------------------------------------------------
:h2 res=2512 name=PANEL_CHA.Chance
:i2 refid=Cat.Chance
:parml tsize=15 break=none.
:pt.:hp8.Score:ehp8.
:pd.The 5 dice can be any values.  You simply add the values of all 5 dice, and place that sum in
in the :hp4.Chance:ehp4. catagory (lower half).  Obviously, higher dice values are better.
:nt.The computer automatically sums the dice for you.:ent.
:pt.:hp8.Example:ehp8.
:pd.Any dice values would suffice for an example.
:eparml.
.*
.*
:euserdoc.
