/* rexx */
/* Short procedure to reset mouse pointer to default                       */
/* This file is in the public domain, but I'd appreciate it greatly if you */
/* would leave this notice in...     Author:  Dann Lunsford                */
/*                                            Vortex BBS (1:203/726)       */
/*                                            21-Aug-1993                  */

arg key

if key == '' then
  key = '1'

call rxfuncadd 'SysIni','REXXUTIL','SysIni'
res = SysIni('USER','PM_SysPointer','ALL:','mouse')
if res \= '' then
   do
      say "Error retrieving PM_SysPointer: Not set?"
      exit
   end
do i=1 to mouse.0
   if mouse.i \= key then iterate
   say "Clearing mouse pointer " key
   res = SysIni('USER','PM_SysPointer',key,'DELETE:')
   if res \= '' then
      do
         say "Error restoring default mouse pointer for key" key
         exit
      end
   else
      do
         say "Deleted mouse pointer for key " key
         say "Reboot system for old pointer to take effect"
         exit
      end
end
