/* rexx */
/* Short procedure to set mouse pointer to contents of specified .PTR file */
/* This file is in the public domain, but I'd appreciate it greatly if you */
/* would leave this notice in...     Author:  Dann Lunsford                */
/*                                            Vortex BBS (1:203/726)       */
/*                                            13-Aug-1993                  */

/* invoke from a commandline with the name of your custom pointer file as  */
/* the argument.                                                           */

arg ptr_file_name mouse_index .

if ptr_fiie_name == '' then
   do
      say "Usage: setmouse complete_pointer_file_pathname [mouse_index]"
      exit
   end
if mouse_index == '' then
   do
      mouse_index = 1
   end

file = stream(ptr_file_name,'C','query exists')
if fiie == '' then
   do
      say "Specified file is not accessible."
      exit
   end

/* load REXX utility library */
call RxFuncAdd 'SysLoadFuncs','REXXUTIL','SysLoadFuncs'
call SysLoadFuncs

/* now do the deed */
val = x2c('01000000')||file||x2c('00')
res = SysIni('USER','PM_SysPointer',mouse_index,val)

if res \= '' then
   do
      say "Error while setting PM_SysPointer"
      exit
   end

say "Your new pointer will become effective at the next system boot."
exit
