;*************************************************************
;* DATA ASSISTANT Daily Capture Template Script
;*
;* Captures daily quotes from CompuServe BASICQUOTES Section
;*
;*************************************************************

;-------------------------------------------------------------
;         Delete and Create the daily capture file.
;
; *** THESE LINES SHOULD NOT BE CHANGED OR DELETED ***
;-------------------------------------------------------------
KILL    &DAILY_CAPTURE&
CAPTURE &DAILY_CAPTURE&
CAPTURE N
;-------------------------------------------------------------
; Establish a connection to CompuServe.  This logic is based 
; on direct access to CompuServe using local access numbers.
;
; The modem initialization string is sent automatically when
; the connection is initially made before script execution.
;
; Generally, you can change this section as necessary for
; your own access.  The goal is to enter CompuServe such that
; the following logic section ("GO MQINT") and beyond can be
; executed for retrieving BASICQUOTES data.
;-------------------------------------------------------------
S &MODEM_DIAL&&CIS_DAILY_PHONE&^M
W &MODEM_CONNECT&
P 2
U ^C
W ID:
S &CIS_DAILY_USERID&^M
W word:
U &CIS_DAILY_PASSWORD&^M
W !
;-------------------------------------------------------------
; Retrieve the operative date for the data. We access MQINT
; for this date.
;-------------------------------------------------------------
S GO MQINT^M
W face:
C Y
S DATE^M
W face:
C N
;-------------------------------------------------------------
; Repeat the following retrieval procedure from BASICQUOTES
; for each group of "SYMBOLxx" symbols specified in the
; "Daily Symbols" dialog box.
;
; Reentry to BASICQUOTES is performed since the maximum number
; of quotations that can be retrieved from this section is 20
; during a signle session.
;-------------------------------------------------------------
&BLOCKDAILY
   S GO BASICQUOTE^M
   W Issue:
   C Y
   S &SYMBOL20&^M
   W Issue:
   C N
   S /EXIT^M
   W !
&ENDBLOCK
;-------------------------------------------------------------
; Log off from CompuServe.
;-------------------------------------------------------------
S OFF^M
W &MODEM_NOCARRIER&
P 2
