//===========================================================
// HK - A Hotkey program for Windows.
// Copyright (C) 1993 Douglas Boling
//
// Revision History:
//
// 1.0   Initial Release
//
//===========================================================
// Returns no. of elements
#define dim(x) (sizeof(x) / sizeof(x[0]))   

#define MAXFNAMELEN       128
#define MAXCMDLINELEN     256
#define MAXKEYNAMELEN     40
#define MAXHOTKEYS        64

#define ID_TIMER          1
//
// Undocumented things
//
#define WM_SETHOTKEY      0x32
#define WM_GETHOTKEY      0x33
//
// Custom messages
//
#define MYMSG_HKWINRIP    WM_USER+10
#define MYMSG_HKWINERR    WM_USER+11

#define MYMSG_ENABLEHK    WM_USER+1
//-----------------------------------------------------------
// Include files
//-----------------------------------------------------------
#include "windows.h"
#include "commdlg.h"
#include "stdlib.h"
#include "string.h"

#include "HK.h"

//-----------------------------------------------------------
// Global data
//-----------------------------------------------------------
// Message dispatch table for MainWindowProc
struct decodeUINT MainMessages[] = {
	WM_CREATE, DoCreateMain,
	WM_COMMAND, DoCommandMain,
	WM_TIMER, DoTimerMain,
	WM_SIZE, DoSizeMain,
	WM_CLOSE, DoCloseMain,
	WM_DESTROY, DoDestroyMain,
	MYMSG_HKWINRIP, DoHKWinRIPMain,
	MYMSG_HKWINERR, DoHKWinErrMain,
};
// Command Message dispatch for MainWindowProc
struct decodeCMD MainMenuItems[] = {
	IDD_KEYLIST, DoMainCtlKeyList,
	IDD_ADD, DoMainCtlAdd,
	IDD_DEL, DoMainCtlDel,
	IDD_EDIT, DoMainCtlEdit,
	IDD_ABOUT, DoMainCtlAbout,
	IDD_EXIT, DoMainCtlExit,
	IDOK, DoMainCtlExit,
	IDCANCEL, DoMainCtlExit,
};
HANDLE	hInst;
HWND		hMain;
UINT		wVersion = 10;
INT 		sTimerFreq;

char	szAppName[] = "WinHK";         // Application name
char	szIconName[] = "WinHKIcon";    // Icon name
char	szProfileName[] = "HK.ini";    // INI file name
char	szHKWinClass[] = "HKChildWin";  // Child Window Class name

// Edit box subclass vars
FARPROC lpfnEditSCProc, lpfnOldEditWndProc;

// Hotkey array vars   
INT		sNumHKs = 0;
INT		sNumRunning = 0;
PHKENTRY	phkArray;

// Return values from Add dialog
char szNewCL[MAXCMDLINELEN];
UINT wAddKey;
//============================================================
// WinMain -- entry point for this application from Windows.
//============================================================
INT APIENTRY WinMain(HANDLE hInstance, HANDLE hPrevInstance, 
                     LPSTR lpCmdLine, INT nCmdShow) {
	MSG	msg;
	INT	rc;

	hInst = hInstance;
	// Only allow one instance of HK at a time
   if(hPrevInstance)	return 1;
	if((rc = InitApp(hInstance)) != 0)
		return rc;
	// Initialize this instance
	if((rc = InitInstance(hInstance, lpCmdLine, nCmdShow)) != 0)
		return rc;
	//
	// Application message loop
	//
	while (GetMessage (&msg, NULL, 0, 0)) {
		if (!IsDialogMessage (hMain, &msg)) {
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}	
	}
	// Instance cleanup
	return TermInstance(hInstance, msg.wParam);
}
  
//-----------------------------------------------------------
// InitApp - Global initialization code for this application.
//-----------------------------------------------------------
INT InitApp(HANDLE hInstance) {
	WNDCLASS 	wc;
	//
	// Register App Main Window class
	//
	wc.style = 0;                             // Window style
	wc.lpfnWndProc = MainWndProc;             // Callback function
	wc.cbClsExtra = 0;                        // Extra class data
	wc.cbWndExtra = DLGWINDOWEXTRA;           // Extra window data
	wc.hInstance = hInstance;                 // Owner handle
	wc.hIcon = LoadIcon(hInst, szIconName);   // Application icon
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); // Default cursor
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH); // Background color 
	wc.lpszMenuName =  NULL;                  // Menu name
	wc.lpszClassName = szAppName;             // Window class name

	if (RegisterClass(&wc) == 0)
		return 1;
	//
	// Register App Child Window class
	//
	wc.style = 0;                             // Window style
	wc.lpfnWndProc = HKChildWndProc;          // Callback function
	wc.cbClsExtra = 0;                        // Extra class data
	wc.cbWndExtra = sizeof (DWORD);           // Extra window data
	wc.hInstance = hInstance;                 // Owner handle
	wc.hIcon = NULL;                          // Application icon
	wc.hCursor = LoadCursor(NULL, IDC_ARROW); // Default cursor
	wc.hbrBackground = GetStockObject(LTGRAY_BRUSH); // Background color 
	wc.lpszMenuName =  NULL;                  // Menu name
	wc.lpszClassName = szHKWinClass;          // Window class name

	if (RegisterClass(&wc) == 0)
		return 2;
	
	return 0;
}
//-----------------------------------------------------------
// InitInstance - Instance initialization code for this app.
//-----------------------------------------------------------
INT InitInstance(HANDLE hInstance, LPSTR lpCmdLine, INT nCmdShow) {
   int	i,j;
	PHKENTRY phkPtr;
	char	szTemp[MAXCMDLINELEN+12];
	char	*pszCmd;

	phkArray = (PHKENTRY) LocalAlloc (LPTR, sizeof (HKENTRY) * MAXHOTKEYS);
	if (phkArray == 0)
		return 11;
	sTimerFreq = GetPrivateProfileInt (szAppName, PRO_TIMERFREQ, 
	                                   1000, szProfileName);
	//
	// Read hot key information from the INI file
	//
	j = GetPrivateProfileInt (szAppName, PRO_HKCNT, 0, szProfileName);
	sNumHKs = 0;
	phkPtr = phkArray;
	for (i = 0; i < j; i++) {
		itoa (i, szTemp, 10);
		GetPrivateProfileString (PRO_HKLST, szTemp, "0,", szTemp, sizeof (szTemp),
		                         szProfileName);
		pszCmd = strchr (szTemp,',');
		if (pszCmd != 0) {
			*pszCmd++ = '\0';
			phkPtr->wKey = atoi (szTemp);
			strcpy (phkPtr->szCmdLine, pszCmd);
			phkPtr++;
			sNumHKs++;
		}	
	}	
	i = GetPrivateProfileInt (szAppName, PRO_XPOS, 100,
	                          szProfileName);
	j = GetPrivateProfileInt (szAppName, PRO_YPOS, 100,
	                          szProfileName);
	// Create main window
	hMain = CreateDialog (hInstance, szAppName, 0, NULL);
	if(!hMain) return 0x10;

	SetWindowPos (hMain, NULL, i, j, 0, 0, SWP_NOSIZE);
	ShowWindow(hMain, nCmdShow | SW_SHOW);
	UpdateWindow(hMain);              // force WM_PAINT message
	return 0;                         // return success flag
}
//------------------------------------------------------------
// TermInstance - Instance termination code for this app.
//------------------------------------------------------------
INT TermInstance(HANDLE hinstance, int sDefRC) {

	return sDefRC;
}
//============================================================
// Message handling procedures for MainWindow
//============================================================
//------------------------------------------------------------
// MainWndProc - Callback function for application window
//------------------------------------------------------------
LONG CALLBACK MainWndProc(HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	INT i;
	//
	// Search message list to see if we need to handle this
	// message.  If in list, call procedure.
	//
	for(i = 0; i < dim(MainMessages); i++) {
		if(wMsg == MainMessages[i].Code)
			return (*MainMessages[i].Fxn)(hWnd, wMsg, wParam, lParam);
	}
	return DefDlgProc(hWnd, wMsg, wParam, lParam);
}
//------------------------------------------------------------
// DoCreateMain - process WM_CREATE message for frame window.
//------------------------------------------------------------ 
LONG DoCreateMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	PHKENTRY phkPtr;

	phkPtr = phkArray;
	for (i = 0; i < sNumHKs; i++) {
		CreateHKWindow (hWnd, phkPtr);
		phkPtr++;
	}
	SetActiveWindow (hWnd);
	return 0;
}
//------------------------------------------------------------
// DoSizeMain - process WM_SIZE message for frame window.
//------------------------------------------------------------ 
LONG DoSizeMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	PHKENTRY phkPtr;

	if (wParam == SIZE_MINIMIZED) {
		phkPtr = phkArray;
		for (i = 0; i < sNumHKs; i++) {
			PostMessage (phkPtr->hwndChild, MYMSG_ENABLEHK, 3, 0);
			phkPtr++;
		}
	} else		
		FillLB (hWnd);

	return DefDlgProc(hWnd, wMsg, wParam, lParam);
}
//------------------------------------------------------------
// DoTimerMain - process WM_TIMER message for frame window.
//------------------------------------------------------------ 
LONG DoTimerMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT i, j;
	PHKENTRY phkPtr;
	HKENTRY	hkTemp;

	if ((sNumRunning == 0) && (sTimerFreq)) {
		KillTimer (hWnd, ID_TIMER);
		return 0;
	}	
		
	phkPtr = phkArray;
	j = sNumRunning;		
	for (i = 0; (i < sNumHKs) && (j > 0); i++) {
		if (phkPtr->fRunning) {
			if (IsWindow (phkPtr->hwndChild) == FALSE) {
				CreateHKWindow (hWnd, phkPtr);
				hkTemp.wKey = 0;
				CreateHKWindow (hWnd, &hkTemp);
				SetActiveWindow (hWnd);
				SetFocus (hWnd);
				PostMessage (phkPtr->hwndChild, MYMSG_ENABLEHK, 3, 0);
				SetActiveWindow (GetNewAct (hWnd));
				sNumRunning--;
				PostMessage (hkTemp.hwndChild, WM_CLOSE, 0, 0);
			}	
			j--;				
		}	
		phkPtr++;
	}	
	return 0;
}
//------------------------------------------------------------
// DoCommandMain - process WM_COMMAND message for frame window 
// by decoding the menubar item with the menuitems[] array, 
// then running the corresponding function to process the command.
//------------------------------------------------------------ 
LONG DoCommandMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT	i;
	UINT	idItem, wNotifyCode;
	HWND	hwndCtl;

	idItem = (UINT) wParam;                      // Parse Parameters
	hwndCtl = (HWND) LOWORD(lParam);
	wNotifyCode = (UINT) HIWORD(lParam);
	//
	// Call routine to handle control message
	//
	for(i = 0; i < dim(MainMenuItems); i++) {
		if(idItem == MainMenuItems[i].Code)
			return (*MainMenuItems[i].Fxn)(hWnd, idItem, hwndCtl, 
			                               wNotifyCode);
	}
	return DefDlgProc(hWnd, wMsg, wParam, lParam);
}
//------------------------------------------------------------
// DoHKWinRIPMain - process MYMSG_HKWINRIP message for window.
//------------------------------------------------------------ 
LONG DoHKWinRIPMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {

	PHKENTRY phkPtr;
	
	phkPtr = FindHKEntry (wParam);
	if (phkPtr) {
		phkPtr->hwndChild = LOWORD (lParam);
		if (phkPtr->hwndChild) {
			phkPtr->fRunning = TRUE;
			sNumRunning++;
			if ((sNumRunning == 1) && (sTimerFreq)) 
				SetTimer (hWnd, ID_TIMER, sTimerFreq, NULL);
		}	
	}	
	return 0;         
}
//------------------------------------------------------------
// DoHKWinErrMain - process MYMSG_HKWINERR message for window.
//------------------------------------------------------------ 
LONG DoHKWinErrMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	char szStr[128];
	PHKENTRY phkPtr;

	phkPtr = FindHKEntry (LOWORD (lParam));
	
	LoadString (hInst, 32, szStr, sizeof (szStr));
	strncat (szStr, phkPtr->szCmdLine, 
	         sizeof (szStr) - strlen (szStr) - 2);
	szStr[sizeof (szStr)-2] = 0;
	strcat (szStr, "\n\n");	
	LoadString (hInst, wParam, szStr+strlen (szStr), 
	            sizeof (szStr)-strlen (szStr));
	MessageBox (NULL, szStr, szAppName, MB_OK);
	return 0;         
}
//------------------------------------------------------------
// DoCloseMain - process WM_CLOSE message for frame window.
//------------------------------------------------------------ 
LONG DoCloseMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT i;
	PHKENTRY phkPtr;

	phkPtr = phkArray;
	for (i = 0; i < sNumHKs; i++) {
		if ((phkPtr->hwndChild) && (!phkPtr->fRunning)) {
			SendMessage (phkPtr->hwndChild, MYMSG_ENABLEHK, 0, 0);
			DestroyWindow (phkPtr->hwndChild);
		}	
		phkPtr++;
	}
	DestroyWindow (hMain);
	return TRUE;
}
//------------------------------------------------------------
// DoDestroyMain - process WM_DESTROY message for frame window.
//------------------------------------------------------------ 
LONG DoDestroyMain (HWND hWnd, UINT wMsg, UINT wParam, LONG lParam) {
	INT i;
	PHKENTRY phkPtr;
   RECT	rect;
	char	szTemp[MAXCMDLINELEN+MAXKEYNAMELEN+12];
	char	szNum[8];

	//Save Window position
	if	(!IsIconic (hWnd) && !IsZoomed (hWnd)) {
		GetWindowRect (hWnd, &rect);
		MyWritePrivateProfileInt (szAppName, PRO_XPOS, rect.left,
		                          10, szProfileName);
		MyWritePrivateProfileInt (szAppName, PRO_YPOS, rect.top,
		                          10, szProfileName);
	}
	WritePrivateProfileString (PRO_HKLST, NULL, NULL, szProfileName);
	phkPtr = phkArray;
	for (i = 0; i < sNumHKs; i++) {
		itoa (phkPtr->wKey, szTemp, 10);
		strcat (szTemp, ",");
		strcat (szTemp, phkPtr->szCmdLine);
		itoa (i, szNum, 10);
		WritePrivateProfileString (PRO_HKLST, szNum, szTemp,
		                           szProfileName);
		phkPtr++;
	}
	MyWritePrivateProfileInt (szAppName, PRO_HKCNT, sNumHKs,
	                          10, szProfileName);
	MyWritePrivateProfileInt (szAppName, PRO_TIMERFREQ, sTimerFreq,
	                          10, szProfileName);
	PostQuitMessage (0);
	return DefDlgProc(hWnd, wMsg, wParam, lParam);
}
//============================================================
// Control handling procedures for MainWindow
//============================================================
//------------------------------------------------------------
// DoMainCtlKeyList - Process Hot Key Listbox
//------------------------------------------------------------ 
LONG DoMainCtlKeyList (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
	INT sCurSel;								

	if (wNotifyCode == LBN_SELCHANGE) {
		sCurSel = (INT) SendDlgItemMessage (hWnd, IDD_KEYLIST, 
		                                    LB_GETCURSEL, 0, 0);
		if (sCurSel == LB_ERR)
			sCurSel = (INT) SendDlgItemMessage (hWnd, IDD_KEYLIST, 
			                                    LB_SETCURSEL, -1, 0);
		SetButtons (hWnd);
	} else if (wNotifyCode == LBN_DBLCLK) {
		PostMessage (hWnd, WM_COMMAND, IDD_EDIT, 
		             MAKELONG (0, BN_CLICKED));
	}
	return TRUE;
}
//------------------------------------------------------------
// DoMainCtlAdd - Process Add button
//------------------------------------------------------------ 
LONG DoMainCtlAdd (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
	PHKENTRY 	phkPtr;
	
	if (wNotifyCode != BN_CLICKED)
		return 0;
		
	if (sNumHKs < MAXHOTKEYS) {
		if (MyDisplayDialog(hInst, "AddBox", hWnd, (WNDPROC) AddDlgProc, 0)) {
			phkPtr = FindHKEntry (wAddKey);
			if (phkPtr != 0) {
				if (MessageBox (hWnd, 
				       "This Hot key is already assigned. Replace the current entry?",
				       "Add HotKey", 
				       MB_YESNO | MB_ICONEXCLAMATION) == IDYES) {
					phkPtr->wKey = wAddKey;
					strcpy (phkPtr->szCmdLine, szNewCL);
					FillLB (hWnd);
				} 
				return TRUE;
			}
			AddHotKey (hWnd, wAddKey, szNewCL);
			AddLBEntry (hWnd, FindHKEntry (wAddKey));
			SetFocus (hWnd);
		}
	}
	return TRUE;
}
//------------------------------------------------------------
// DoMainCtlDel - Process Del button
//------------------------------------------------------------ 
LONG DoMainCtlDel (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
	INT sCurSel;

	if (wNotifyCode != BN_CLICKED)
		return 0;
		
	if (SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_GETCURSEL, 0, 0)
	    != LB_ERR) {
		sCurSel = (INT) SendDlgItemMessage (hWnd, IDD_KEYLIST, 
		                                    LB_GETCURSEL, 0, 0);
		if (sCurSel >= sNumHKs) return 0;
		DelHotKey (hWnd, sCurSel);
		FillLB (hWnd);
	}
	return 0;
}
//------------------------------------------------------------
// DoMainCtlEdit - Process Change button
//------------------------------------------------------------ 
LONG DoMainCtlEdit (HWND hWnd, UINT idItem, HWND hwndCtl, 
                    UINT wNotifyCode) {
	INT	sCurSel;
	WORD 	wKeySave;
	PHKENTRY 	phkPtr;
	
	
	if (wNotifyCode != BN_CLICKED)
		return 0;
		
	if (SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_GETCURSEL, 0, 0)
	    != LB_ERR) {
		sCurSel = (INT) SendDlgItemMessage (hWnd, IDD_KEYLIST, 
		                                    LB_GETCURSEL, 0, 0);
		if (sCurSel >= sNumHKs) return 0;
		//Copy key info, then delete key.
		phkPtr = phkArray + sCurSel;
		strcpy (szNewCL, phkPtr->szCmdLine);
		wAddKey = phkPtr->wKey;			
		wKeySave = wAddKey;
		DelHotKey (hWnd, sCurSel);
		
		if (MyDisplayDialog(hInst, "AddBox", hWnd, (WNDPROC) AddDlgProc, 1)) {
			phkPtr = FindHKEntry (wAddKey);
			if (phkPtr != 0) {
				if (MessageBox (hWnd, 
				       "This Hot key is already assigned. Replace the current entry?",
				       "Add HotKey", 
				       MB_YESNO | MB_ICONEXCLAMATION) == IDYES) {
					phkPtr->wKey = wAddKey;
					strcpy (phkPtr->szCmdLine, szNewCL);
					FillLB (hWnd);
				} 
				return TRUE;
			}
			wKeySave = wAddKey;
		}	
		AddHotKey (hWnd, wKeySave, szNewCL);
		FillLB (hWnd);
		SetFocus (hWnd);
	}
	return 0;
}
//------------------------------------------------------------
// DoMainCtlExit - Process Exit button
//------------------------------------------------------------ 
LONG DoMainCtlExit (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {

	if (wNotifyCode == BN_CLICKED)
		SendMessage (hWnd, WM_CLOSE, 0, 0);
	return 0;
}
//------------------------------------------------------------
// DoMainCtlAbout - Process About button
//------------------------------------------------------------ 
LONG DoMainCtlAbout (HWND hWnd, UINT idItem, HWND hwndCtl, 
                     UINT wNotifyCode) {
								
	if (wNotifyCode != BN_CLICKED)
		return 0;

	MyDisplayDialog(hInst, "AboutBox", hWnd, 
   	             (WNDPROC) AboutDlgProc, (LONG) wVersion);
	return 0;
}
//============================================================
// AboutDlgProc - About dialog box dialog procedure
//============================================================
BOOL CALLBACK AboutDlgProc (HWND hWnd, UINT wMsg, UINT wParam, 
                            LONG lParam) {
	char	szAboutStr[128];
                              
	if (wMsg == WM_INITDIALOG) {
		GetDlgItemText (hWnd, IDD_PROGSTR, szAboutStr, sizeof (szAboutStr));
		itoa ((INT)lParam/10, &szAboutStr[strlen (szAboutStr)], 10);
		strcat (szAboutStr, ".");
		itoa ((INT)lParam%10, &szAboutStr[strlen (szAboutStr)], 10);
		SetDlgItemText (hWnd, IDD_PROGSTR, szAboutStr);
		return TRUE;
	}   
	if (wMsg == WM_COMMAND) 
	   if ((wParam == IDOK) || (wParam == IDCANCEL)) {
			EndDialog(hWnd, 0);
			return TRUE;
		} 
	return FALSE;
}
//============================================================
// AddlgProc - Add dialog box dialog procedure
//============================================================
BOOL CALLBACK AddDlgProc (HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	
	char	szFileName[MAXCMDLINELEN];
	static char *szFilter[] = {"Programs", "*.EXE;*.COM;*.PIF;*.BAT", 
	                           "All Files (*.*)", "*.*", 
										"" };
	switch (wMsg) {
		case WM_INITDIALOG:
			SendDlgItemMessage (hWnd, IDD_ADDCMD, EM_LIMITTEXT,
			                    MAXCMDLINELEN, 0);

			lpfnEditSCProc = MakeProcInstance ((FARPROC) EditSCProc, hInst);
			lpfnOldEditWndProc = MySubClassWindow (GetDlgItem (hWnd, IDD_ADDKEY),
			                                       lpfnEditSCProc);
			if (lParam == 0)																
				wAddKey = 0;
			else {	
				SetDlgItemText (hWnd, IDD_ADDKEY, 
				                DispKeyText (wAddKey, szFileName,
				                             sizeof (szFileName)));
				SetDlgItemText (hWnd, IDD_ADDCMD, szNewCL);
				SetWindowText (hWnd, "Change HotKey");
				SetDlgItemText (hWnd, IDOK, "&Change");
			}																 
			return TRUE;

		case WM_SYSCOMMAND:
			if ((wParam == SC_KEYMENU) && 
			    (GetFocus () == GetDlgItem (hWnd, IDD_ADDKEY)))
				return TRUE;
			break;
			
		case WM_COMMAND:
			switch (wParam) {
		   	case IDD_ADDBROWSE:
					if (MyGetFilename (hWnd, szFileName, 
					                   sizeof (szFileName), *szFilter, 1))
					SetDlgItemText (hWnd, IDD_ADDCMD, szFileName);
					return TRUE;

		   	case IDOK:
					GetDlgItemText (hWnd, IDD_ADDCMD, szNewCL, MAXCMDLINELEN);
					if (strlen (szNewCL) == 0) {
						MessageBox (hWnd,
						   "No command line entered.  Hot key not set", 
				          "Add Hot Key", MB_OK | MB_ICONEXCLAMATION);
					} else if (wAddKey == 0) {
						MessageBox (hWnd,  
						   "No Hot Key entered.  Hot key not set", 
				          "Add Hot Key", MB_OK | MB_ICONEXCLAMATION);
					} else if ((wAddKey & 0xff) == 0) {
						MessageBox (hWnd,  
						   "Shift must be accompanied by key.  Hot key not set", 
				          "Add Hot Key", MB_OK | MB_ICONEXCLAMATION);
					} else {
						MySubClassWindow (GetDlgItem (hWnd, IDD_ADDKEY),
				                        lpfnOldEditWndProc);
						FreeProcInstance ((FARPROC) lpfnEditSCProc);
						EndDialog(hWnd, 1);
					}	
					return TRUE;

		   	case IDCANCEL:
					EndDialog(hWnd, 0);
					return TRUE;
			}	
			break;	
	} 
	return FALSE;
}
//============================================================
// Editbox subclass procedure
//============================================================
LONG CALLBACK EditSCProc (HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	char szKeyText[50];
	static LONG lLastKey;

	switch (wMsg) {
		
		case WM_SETFOCUS:
			lLastKey = 0;
			break;
		
		case WM_SYSKEYDOWN:
			if ((wParam == VK_TAB)   || 
			    (wParam == VK_SPACE) ||
			    (wParam == VK_ESCAPE))
				break;
		case WM_KEYDOWN:
			//Ignore repeat WM_KEYDOWN messages
			if (lParam == lLastKey)
				return 0;
			lLastKey = lParam;
			// Turn key state into text
			wAddKey = wParam;
			if ((wAddKey == VK_CONTROL) || (wAddKey == VK_MENU) ||
			    (wAddKey == VK_SHIFT))
				wAddKey = 0;

			szKeyText[0] = '\0';
			if (lParam & 0x20000000)
				wAddKey |= 0x400;
			if (GetKeyState (VK_CONTROL) & 0x8000)
				wAddKey |= 0x200;
			if (GetKeyState (VK_SHIFT) & 0x8000)
				wAddKey |= 0x100;
			// Hide extended key bit in VK word
			if (lParam & 0x1000000)
				wAddKey |= 0x1000;

			SetWindowText (hWnd, DispKeyText (wAddKey, szKeyText, 
			                                  sizeof (szKeyText)));
			return 0;

		case WM_SYSCHAR:
		case WM_SYSKEYUP:
			if ((wParam == VK_TAB)   || 
			    (wParam == VK_SPACE) ||
			    (wParam == VK_ESCAPE))
				break;
		case WM_KEYUP:
		case WM_CHAR:
			return 0;
	}
	return CallWindowProc (lpfnOldEditWndProc, hWnd, wMsg,
	                       wParam, lParam);
}
//------------------------------------------------------------
// DispKeyText - Converts a key value into text
//------------------------------------------------------------ 
char *DispKeyText (UINT wKey, char *pszOut, INT sOutMax) {
	UINT wFlags;

	sOutMax--;
	*pszOut = '\0';

	if (sOutMax < 6) return pszOut;							 
	if (wKey & 0x400) {
		strcat (pszOut, "Alt + ");
		sOutMax -= 6;
	}
	if (sOutMax < 7) return pszOut;							 
	if (wKey & 0x200) {
		strcat (pszOut, "Ctrl + ");
		sOutMax -= 7;
	}
	if (sOutMax < 8) return pszOut;							 
	if (wKey & 0x100) {
		strcat (pszOut, "Shift + ");
		sOutMax -= 8;
	}
	if (wKey & 0x1000)
		wFlags = 0x300;
	else		
		wFlags = 0x200;

	wKey &= 0xff;
	if (wKey)
		GetKeyNameText (MAKELONG (0, wFlags | MapVirtualKey(wKey, 0)),
		                &pszOut[strlen (pszOut)], sOutMax);
	return pszOut;							 
}							 
//------------------------------------------------------------
// FillLB - Clears, then refills the hot key listbox
//------------------------------------------------------------ 
void FillLB (HWND hWnd) {
	INT i, sTab[3];
	PHKENTRY phkPtr;
	
	SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_RESETCONTENT, 0, 0);
	SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_SETHORIZONTALEXTENT, 
  		                 1000, 0L);
	sTab[0] = 75;
	sTab[1] = 100;
	sTab[2] = 0;
	SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_SETTABSTOPS, 2, 
	                    (LPARAM)(LPINT)sTab);
	phkPtr = phkArray;
	for (i = 0; i < sNumHKs; i++) {
		AddLBEntry (hWnd, phkPtr);
		phkPtr++;
	}
	SetButtons (hWnd);
	return;
}	
//------------------------------------------------------------
// AddLBEntry - Adds an item to the hot key listbox
//------------------------------------------------------------ 
void AddLBEntry (HWND hWnd, PHKENTRY phkPtr) {

	char	szTemp[MAXCMDLINELEN+MAXKEYNAMELEN+12];

	DispKeyText (phkPtr->wKey, szTemp, sizeof (szTemp));
	strcat (szTemp, "\t");
	strcat (szTemp, phkPtr->szCmdLine);

	SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_ADDSTRING, 0, 
	                    (LPARAM) (LPSTR) szTemp);
	return;
}	
//------------------------------------------------------------
// SetButtons - Enables and disables the buttons depending on
// the current state of the window.
//------------------------------------------------------------ 
void SetButtons (HWND hWnd) {
	
	if (SendDlgItemMessage (hWnd, IDD_KEYLIST, LB_GETCURSEL, 0, 0)
	    == LB_ERR) {
		EnableWindow (GetDlgItem (hWnd, IDD_DEL), FALSE);
		EnableWindow (GetDlgItem (hWnd, IDD_EDIT), FALSE);
	} else {
		EnableWindow (GetDlgItem (hWnd, IDD_DEL), TRUE);
		EnableWindow (GetDlgItem (hWnd, IDD_EDIT), TRUE);
	}
	if (sNumHKs == MAXHOTKEYS)
		EnableWindow (GetDlgItem (hWnd, IDD_ADD), FALSE);
	else		
		EnableWindow (GetDlgItem (hWnd, IDD_ADD), TRUE);
	return;		
}		
//------------------------------------------------------------
// AddHotKey - Adds a hotkey entry
//------------------------------------------------------------ 
void AddHotKey (HWND hWnd, WORD wHotKey, char *pszCmdLine) {
	PHKENTRY phkPtr;
	HKENTRY	hkTemp;

	phkPtr = phkArray + sNumHKs;
	sNumHKs++;
	phkPtr->wKey = wHotKey;
	strcpy (phkPtr->szCmdLine, pszCmdLine);
	//Create hotkey window
	CreateHKWindow (hWnd, phkPtr);  
	//Create then destroy top level window to trigger 
	// wm_gethotkey message from DOS box windows.
	hkTemp.wKey = 0;
	CreateHKWindow (HWND_DESKTOP, &hkTemp);  
	PostMessage (hkTemp.hwndChild, WM_CLOSE, 0, 0);
	return;
}
//------------------------------------------------------------
// DelHotKey - Deletes a hotkey entry
//------------------------------------------------------------ 
void DelHotKey (HWND hWnd, WORD sEntry) {
	INT i;
	PHKENTRY phkPtr, phkPtr1;

	phkPtr = phkArray + sEntry;
	if (phkPtr->hwndChild)
		if (phkPtr->fRunning) {
			SendMessage (phkPtr->hwndChild, WM_SETHOTKEY, 0, 0);
			sNumRunning--;
		} else	
			PostMessage (phkPtr->hwndChild, WM_CLOSE, 0, 0);
	// Compress the keylist			
	phkPtr1 = phkPtr + 1;
	for (i = sEntry; i < sNumHKs; i++) {
		phkPtr->wKey = phkPtr1->wKey;
		strcpy (phkPtr->szCmdLine, phkPtr1->szCmdLine);
		phkPtr++;
		phkPtr1++;
	}
	sNumHKs--;
	return;
}
//------------------------------------------------------------
// FindHKEntry - Returns a pointer to the entry with the 
// matching key value.
//------------------------------------------------------------ 
PHKENTRY FindHKEntry (WORD wKey) {
	INT i;
	PHKENTRY phkPtr;
	
	phkPtr = phkArray;
	for (i = 0; i < sNumHKs; i++) {
		if (phkPtr->wKey == wKey)
			break;
		phkPtr++;
	}
	if (i == sNumHKs)
		return 0;
	else		
		return phkPtr;
}				
//------------------------------------------------------------ 
// GetNewAct - Returns window that should be activated next.
//------------------------------------------------------------ 
HWND GetNewAct (HWND hWnd) {
	HWND handle;
	char szCls[40];
	
	handle = GetWindow (hWnd, GW_HWNDFIRST);
	while (handle) {
		GetClassName (handle, szCls, sizeof (szCls));
		if ((handle != hWnd) &&
			 (IsWindowVisible (handle)) && 
			 (!GetWindow (handle, GW_OWNER)))
			break;
		handle = GetWindow (handle, GW_HWNDNEXT);
	}
	if (handle == 0) handle = hWnd;
	return handle;
}			 
//------------------------------------------------------------ 
// CreateHKWindow - Creates a hotkey window
//------------------------------------------------------------ 
void CreateHKWindow (HWND hWnd, PHKENTRY phkPtr) {

	phkPtr->fRunning = FALSE;
	phkPtr->hwndChild = CreateWindow (szHKWinClass, "",
	                          WS_OVERLAPPED | WS_VISIBLE, 
		                       16000, 12000, 10, 10,	
	                          hWnd, NULL, hInst, &phkPtr);
	return;									  
}									  
//============================================================
// Message handling procedure for HKChild Window
//============================================================
//------------------------------------------------------------
// HKChildWndProc - Callback function for HotKey Child
//------------------------------------------------------------
LONG CALLBACK HKChildWndProc(HWND hWnd, UINT wMsg, UINT wParam, 
                          LONG lParam) {
	PHKENTRY phkPtr;
	DWORD dwData;
	WORD wKey;
	INT sEnabled;
	HANDLE hExecInst;
	HWND hwndLast;

	switch (wMsg) {
		case WM_CREATE:
			phkPtr = (PHKENTRY)*((LPWORD)((LPCREATESTRUCT) lParam)->lpCreateParams);
			SetWindowLong (hWnd, 0, MAKELONG (phkPtr->wKey, 0));
			PostMessage (hWnd, WM_SETHOTKEY, phkPtr->wKey & 0x0fff, 0);
			return 0;

		case MYMSG_ENABLEHK:
			if (wParam == 3) {
				ShowWindow (hWnd, SW_SHOWNOACTIVATE);
				break;
			}	
			dwData = GetWindowLong (hWnd, 0);
			wKey = LOWORD (dwData);
			SetWindowLong (hWnd, 0, MAKELONG (wKey, wParam));
			return 0;
			
		case WM_SETFOCUS:
			SetFocus (hMain);
			return 0;

		case WM_ACTIVATE:
			// sEnabled:  0 = Window created   1 = Armed. 
			//            2 = Prog Launched   -1 = Disabled
			hwndLast = LOWORD (lParam);
			dwData = GetWindowLong (hWnd, 0);
			sEnabled = HIWORD (dwData);
			wKey = LOWORD (dwData);

			switch (wParam) {
				case WA_INACTIVE:
					if (sEnabled == 2) {
						SetWindowLong (hWnd, 0, MAKELONG (wKey, -1));
						if (hwndLast)
							SendMessage (hwndLast, WM_SETHOTKEY, wKey, 0);
						PostMessage (GetWindow (hWnd, GW_OWNER), 
						             MYMSG_HKWINRIP, LOWORD (dwData), 
						             MAKELONG (hwndLast, 0));
						PostMessage (hWnd, WM_CLOSE, 0, 0);
					}	
					break;
					
				case WA_ACTIVE:
					phkPtr = FindHKEntry (wKey);
					if (phkPtr == 0) {
						SetWindowLong (hWnd, 0, MAKELONG (wKey, -2));
						break;
					}
					if (sEnabled == 0) {
						SetWindowLong (hWnd, 0, MAKELONG (wKey, 1));
						SetWindowPos (hWnd, HWND_BOTTOM, 0, 0, 0, 0,
						              SWP_NOMOVE | SWP_NOSIZE);
					} else if (sEnabled == 1) {	
						if (!hwndLast)	break;
						if ((GetWindow (hWnd, GW_HWNDLAST) == hwndLast) &&
						    (IsIconic (hwndLast))) {
							SetActiveWindow (GetWindow (hMain, GW_HWNDNEXT));
							break;
						}	
						SetWindowLong (hWnd, 0, MAKELONG (wKey, 2));
						hExecInst = WinExec (phkPtr->szCmdLine, SW_SHOWNORMAL);
						if (hExecInst < 32) {
							SetWindowLong (hWnd, 0, MAKELONG (wKey, -1));
							PostMessage (GetWindow (hWnd, GW_OWNER), 
							             MYMSG_HKWINERR, hExecInst, (LONG) wKey);
							PostMessage (hWnd, WM_CLOSE, 0, 0);
							if (hwndLast)
								SetActiveWindow (hwndLast);
						}
					}
					break;		
			}	
			return 0;
			
		case WM_CLOSE:
			DestroyWindow (hWnd);
			return 0;
	}
	return DefWindowProc(hWnd, wMsg, wParam, lParam);
}
//============================================================  
// General Helper Routines 
//============================================================  
//------------------------------------------------------------
// MyDisplayDialog - Display a dialog box
//------------------------------------------------------------ 
INT MyDisplayDialog (HINSTANCE hInstance, LPCSTR szDlgName,
                     HWND hWnd, WNDPROC lpDialogProc, 
                     LPARAM lParam) {
    WNDPROC lpDlgProcInst;
    INT		rc;

    lpDlgProcInst = MakeProcInstance(lpDialogProc, hInst);
    rc = DialogBoxParam (hInstance, szDlgName, hWnd, 
                         lpDlgProcInst, lParam);
    FreeProcInstance(lpDlgProcInst);
    return rc;                              
}
//------------------------------------------------------------
// MyWritePrivateProfileInt - Writes an integer to the profile
//------------------------------------------------------------
BOOL MyWritePrivateProfileInt (char *szSec, char *szEntry, 
                               int Num, int Base, char *szProfile) {
	char	szStr[33];
	                           
	itoa (Num, szStr, Base);
	return WritePrivateProfileString (szSec, szEntry, szStr, 
	                                  szProfile);
}

//------------------------------------------------------------
// MyGetFilename - Uses the common File Open dialog box to
// query the user for a filename
//------------------------------------------------------------
BOOL MyGetFilename (HWND hWnd, char *szFilename, INT sMaxLen, char *szFilter,
                    INT sFilterIndex) {

   OPENFILENAME ofn;

   *szFilename = '\0';

	ofn.lStructSize = sizeof (OPENFILENAME);
	ofn.hwndOwner = hWnd;
	ofn.hInstance = hInst;
	ofn.lpstrFilter = szFilter;
	ofn.lpstrCustomFilter = 0;
	ofn.nMaxCustFilter = 0;
	ofn.nFilterIndex = sFilterIndex;
	ofn.lpstrFile = szFilename;
	ofn.nMaxFile = sMaxLen;
	ofn.lpstrFileTitle = 0;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = 0;
	ofn.lpstrTitle = 0;
	ofn.Flags = OFN_FILEMUSTEXIST;
	ofn.nFileOffset = 0;
	ofn.nFileExtension = 0;
	ofn.lpstrDefExt = "WBT";
	ofn.lCustData = 0;
	ofn.lpfnHook = 0;
	ofn.lpTemplateName = 0;

 	return (GetOpenFileName (&ofn));
}
//------------------------------------------------------------
// MySubClassWindow - Subclasses a window 
//------------------------------------------------------------
WNDPROC MySubClassWindow (HWND hWnd, WNDPROC lpfnNewProc) {
   WNDPROC lpfnOldProc;

	lpfnOldProc = (WNDPROC) GetWindowLong (hWnd, GWL_WNDPROC);
	SetWindowLong (hWnd, GWL_WNDPROC, (LONG) lpfnNewProc);
	return lpfnOldProc;				               
}				               
