//===========================================================
// HK.H -- Header File 
// Copyright (c) 1993 Douglas Boling
//===========================================================
//-----------------------------------------------------------
// Generic defines and data types
//-----------------------------------------------------------
#if !defined(WIN32)
  #define WIN16     TRUE
  #define WIN31

  #define INT       int
  #define UINT      WORD
  #define APIENTRY  PASCAL
  #define WNDPROC   FARPROC
#else
  #define WIN16     FALSE
#endif

struct decodeUINT {                         // structure associates
    UINT Code;                              // messages 
    LONG (*Fxn)(HWND, UINT, UINT, LONG);    // with a function
}; 
struct decodeCMD {                          // structure associates
    UINT Code;                              // menu IDs with a 
    LONG (*Fxn)(HWND, UINT, HWND, UINT);    // function
};
//
// Function prototypes used by generic template
//
INT  APIENTRY WinMain(HANDLE, HANDLE, LPSTR, INT);
LONG CALLBACK MainWndProc(HWND, UINT, UINT, LONG);
BOOL CALLBACK AboutDlgProc (HWND, UINT, UINT, LONG);

INT  InitApp(HANDLE);
INT  InitInstance(HANDLE, LPSTR, INT);
INT  TermInstance(HANDLE, INT);
INT  MyDisplayDialog (HINSTANCE, LPCSTR, HWND, WNDPROC, LPARAM);
BOOL MyGetFilename (HWND, char *, INT, char *, INT);
BOOL MyWritePrivateProfileInt (char *, char *, int, int, char *);
WNDPROC MySubClassWindow (HWND, WNDPROC);
//
// Data types needed for program
typedef struct {
	UINT	wKey;
	HWND	hwndChild;
	BOOL	fRunning;
	char	szCmdLine[MAXCMDLINELEN];
} HKENTRY;
typedef HKENTRY *PHKENTRY;
//
// Program specific prototypes
//
// Window procedures
LONG CALLBACK HKChildWndProc(HWND, UINT, UINT, LONG);
LONG CALLBACK EditSCProc(HWND, UINT, UINT, LONG);
// Dialog box functions
BOOL CALLBACK AddDlgProc (HWND, UINT, UINT, LONG);
// Message handler functions
LONG DoCreateMain (HWND, UINT, UINT, LONG);
LONG DoTimerMain (HWND, UINT, UINT, LONG);
LONG DoSizeMain (HWND, UINT, UINT, LONG);
LONG DoCloseMain (HWND, UINT, UINT, LONG);
LONG DoDestroyMain (HWND, UINT, UINT, LONG);
LONG DoCommandMain (HWND, UINT, UINT, LONG);
LONG DoGetHotKeyMain (HWND, UINT, UINT, LONG);
LONG DoHKWinRIPMain (HWND, UINT, UINT, LONG);
LONG DoHKWinErrMain (HWND, UINT, UINT, LONG);
// Control function Prototypes
LONG DoMainCtlKeyList (HWND, UINT, HWND, UINT);
LONG DoMainCtlAdd (HWND, UINT, HWND, UINT);
LONG DoMainCtlDel (HWND, UINT, HWND, UINT);
LONG DoMainCtlEdit (HWND, UINT, HWND, UINT);
LONG DoMainCtlExit (HWND, UINT, HWND, UINT);
LONG DoMainCtlAbout (HWND, UINT, HWND, UINT);
// Utility function prototypes
void FillLB (HWND);
void AddHotKey (HWND, WORD, char *);
void DelHotKey (HWND, WORD);
void AddLBEntry (HWND, PHKENTRY);
char *DispKeyText (UINT, char *, INT);
void SetButtons (HWND);
HWND GetNewAct (HWND);
PHKENTRY FindHKEntry (WORD);
void CreateHKWindow (HWND, PHKENTRY);
//
// Profile String Names
//
#define     PRO_XPOS      "WinPosX"
#define     PRO_YPOS      "WinPosY"

#define     PRO_HKLST     "HKArray"
#define     PRO_HKCNT     "HKArrayCnt"
#define     PRO_TIMERFREQ "TimerFreq"
//
// Resource Idendifiers
//
#define     IDD_ADD        101
#define     IDD_DEL        102
#define     IDD_EDIT       103
#define     IDD_ABOUT      104
#define     IDD_EXIT       105
#define     IDD_KEYLIST    106

#define     IDD_ADDCMD     200
#define     IDD_ADDKEY     201
#define     IDD_ADDBROWSE  202

#define     IDD_PROGSTR    300

