VERSION 2.00
Begin Form frmBrowse 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "WINDOWS Magazine Version Browser"
   ClientHeight    =   3495
   ClientLeft      =   2040
   ClientTop       =   3300
   ClientWidth     =   6900
   Height          =   4245
   Icon            =   BROWSE.FRX:0000
   Left            =   1950
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3495
   ScaleWidth      =   6900
   Top             =   2640
   Width           =   7080
   Begin TextBox tbName 
      Height          =   285
      Left            =   240
      TabIndex        =   1
      Text            =   "tbName"
      Top             =   480
      Width           =   3135
   End
   Begin ComboBox cbTypes 
      Height          =   300
      Left            =   240
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   3000
      Width           =   3135
   End
   Begin FileListBox filBrowse 
      Height          =   1590
      Left            =   240
      MultiSelect     =   2  'Extended
      TabIndex        =   2
      Top             =   960
      Width           =   3135
   End
   Begin DirListBox dirBrowse 
      Height          =   1830
      Left            =   3600
      TabIndex        =   5
      Top             =   720
      Width           =   3135
   End
   Begin DriveListBox drvBrowse 
      Height          =   315
      Left            =   3600
      TabIndex        =   8
      Top             =   3000
      Width           =   3135
   End
   Begin Label Label12 
      BackStyle       =   0  'Transparent
      Caption         =   "Dri&ves:"
      Height          =   255
      Left            =   3600
      TabIndex        =   6
      Top             =   2760
      Width           =   1095
   End
   Begin Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "List Files of &Type:"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   2760
      Width           =   1815
   End
   Begin Label lblCurDir 
      BackStyle       =   0  'Transparent
      Caption         =   "lblCurDir"
      Height          =   255
      Left            =   3600
      TabIndex        =   9
      Top             =   480
      Width           =   3135
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "&Directories:"
      Height          =   255
      Left            =   3600
      TabIndex        =   4
      Top             =   240
      Width           =   1335
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "File &Name:"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   975
   End
   Begin Menu mnuFile 
      Caption         =   "&File"
      Begin Menu mnuFilePrint 
         Caption         =   "&Print ..."
         Shortcut        =   ^P
      End
      Begin Menu mnuFileSep 
         Caption         =   "-"
      End
      Begin Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu mnuHelp 
      Caption         =   "&Help"
      Begin Menu mnuHelpAbout 
         Caption         =   "&About ..."
         WindowList      =   -1  'True
      End
   End
End

Sub cbTypes_Click ()
    Dim Pat As String
    Dim l, r As Integer

    Pat = cbTypes.List(cbTypes.ListIndex)
    l = InStr(Pat, "(") + 1
    r = InStr(l, Pat, ")")
    filBrowse.Pattern = Mid$(Pat, l, r - l)
    tbName.Text = filBrowse.Pattern
End Sub

Sub dirBrowse_Change ()
    lblCurDir.Caption = dirBrowse.List(dirBrowse.ListIndex)
    filBrowse.Path = dirBrowse.Path
End Sub

Sub drvBrowse_Change ()
    dirBrowse.Path = drvBrowse.Drive
End Sub

Sub filBrowse_DblClick ()
    Dim FullName As String
    Dim Result As Integer
    Dim VI As VerInfo

    FullName = filBrowse.Path + "\" + filBrowse.List(filBrowse.ListIndex)
    frmDisp!lblName.Caption = FullName
    frmDisp!lblSize.Caption = Format$(FileLen(FullName), "###,###,###,##0 \b\y\t\e\s")
    frmDisp!lblDate.Caption = Format$(FileDateTime(FullName), "dddd, mmmm d, yyyy \a\t h:mm AM/PM")
    
    Result = GetFileVersion(FullName, VI)
    frmDisp!lblFileVersion.Caption = VI.FileVersion
    frmDisp!lblFileDescription.Caption = VI.FileDescription
    frmDisp!lblCompanyName.Caption = VI.CompanyName
    frmDisp!lblLanguage.Caption = VI.Language
    frmDisp!lblComments.Caption = VI.Comments
    frmDisp!lblOriginalFileName.Caption = VI.OriginalFileName
    frmDisp!lblInternalName.Caption = VI.InternalName
    frmDisp!lblCopyright.Caption = VI.LegalCopyright
    frmDisp!lblTrademarks.Caption = VI.LegalTrademarks
    frmDisp!lblProductName.Caption = VI.ProductName
    frmDisp!lblProductVersion.Caption = VI.ProductVersion
    frmDisp!lblPrivateBuild.Caption = VI.PrivateBuild
    frmDisp!lblSpecialBuild.Caption = VI.SpecialBuild
    frmDisp.Show 0
End Sub

Sub Form_Load ()
    Dim Default As Integer
    Dim Result As Integer
    
    ' Load choices into File Type Dropdown list box
    cbTypes.AddItem "All Executables (*.EXE;*.DLL;*.DRV;*.VBX;*.CPL;*.286;*.386;*.2GR;*.3GR;*.FOT;*.FON)"
    cbTypes.AddItem "EXEs (*.EXE)"
    cbTypes.AddItem "DLLs (*.DLL)"
    cbTypes.AddItem "Drivers (*.DRV)"
    cbTypes.AddItem "VB eXtensions (*.VBX)"
    cbTypes.AddItem "Control Panel Applet (*.CPL)"
    cbTypes.AddItem "Standard Mode Driver (*.286)"
    cbTypes.AddItem "Enhanced Mode Driver (*.386)"
    cbTypes.AddItem "Standard Mode Grabber (*.2GR)"
    cbTypes.AddItem "Enhanced Mode Grabber (*.3GR)"
    cbTypes.AddItem "TrueType Fonts (*.FOT)"
    cbTypes.AddItem "Other Fonts (*.FON)"
    cbTypes.ListIndex = 0 ' set default to All Executables

    lblCurDir.Caption = dirBrowse.List(dirBrowse.ListIndex)

    ' move forms to position they had at end of last run
    Default = (Screen.Height - frmBrowse.Height) / 2
    Result = GetPrivateProfileInt("VerBrowse", "Top", Default, "WINMAG.INI")
    frmBrowse.Top = Result
    Default = (Screen.Width - frmBrowse.Width) / 2
    Result = GetPrivateProfileInt("VerBrowse", "Left", Default, "WINMAG.INI")
    frmBrowse.Left = Result
    
    Default = (Screen.Height - frmDisp.Height) / 2
    Result = GetPrivateProfileInt("VerDisp", "Top", Default, "WINMAG.INI")
    DispTop = Result
    frmDisp.Top = DispTop
    Default = (Screen.Width - frmDisp.Width) / 2
    Result = GetPrivateProfileInt("VerDisp", "Left", Default, "WINMAG.INI")
    DispLeft = Result
    frmDisp.Left = DispLeft
    
    Default = (Screen.Height - frmPrint.Height) / 2
    Result = GetPrivateProfileInt("VerPrint", "Top", Default, "WINMAG.INI")
    PrintTop = Result
    frmPrint.Top = PrintTop
    Default = (Screen.Width - frmPrint.Width) / 2
    Result = GetPrivateProfileInt("VerPrint", "Left", Default, "WINMAG.INI")
    PrintLeft = Result
    frmPrint.Left = PrintLeft
End Sub

Sub Form_Unload (Cancel As Integer)
    Unload frmDisp
    Unload frmPrint

    ' save the form position for next time
    Result = WritePrivateProfileString("VerBrowse", "Top", Format$(frmBrowse.Top), "WINMAG.INI")
    Result = WritePrivateProfileString("VerBrowse", "Left", Format$(frmBrowse.Left), "WINMAG.INI")
    Result = WritePrivateProfileString("VerDisp", "Top", Format$(DispTop), "WINMAG.INI")
    Result = WritePrivateProfileString("VerDisp", "Left", Format$(DispLeft), "WINMAG.INI")
    Result = WritePrivateProfileString("VerPrint", "Top", Format$(PrintTop), "WINMAG.INI")
    Result = WritePrivateProfileString("VerPrint", "Left", Format$(PrintLeft), "WINMAG.INI")
    End
End Sub

Sub MnuFileExit_Click ()
    Unload frmBrowse
End Sub

Sub MnuFilePrint_Click ()
    frmPrint.Show 1 ' modal
End Sub

Sub mnuHelpAbout_Click ()
    frmAbout.Show 1 ' show About box, wait till it exits
End Sub

Sub tbName_Change ()
    On Error Resume Next ' so we can stuff incomplete info into .Pattern
    filBrowse.Pattern = tbName.Text
End Sub

