/*
 *  CONTROL.C
 *
 *  Written on 10-Jul-94 by John Dennis and released to the public domain.
 *
 *  The display routines for controls of various different types.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "winsys.h"
#include "menu.h"
#include "keys.h"
#include "unused.h"
#include "specch.h"

static char text[255];

/* char *MakeButton(button *b);
   **
   ** Makes up a button.
 */

char *MakeButton(button * b, int sel)
{
    if (sel)
        sprintf(text, "%c %s %c", SC14, b->btext, SC15);
    else
        sprintf(text, "  %s  ", b->btext);

    return text;
}

/* void ShowButton(button *b);
   **
   ** Puts a button onto the screen, handling
   ** all the states of the button.
   **
 */

void ShowButton(button * b)
{
    char *s;
    static unsigned char ublock[2] =
    {SC16, '\0'};
    int len;
    unsigned char attr;

    s = MakeButton(b, b->select);
    len = strlen(s);
    if (b->select)
        attr = (unsigned char)b->sattr;
    else
        attr = (unsigned char)b->fattr;

    if (!b->down)
    {
        WWriteStr(b->x, b->y, attr, s);
        WWriteStr(b->x + len, b->y, b->battr, (char *)ublock);

        memset(text, SC17, sizeof(text));
        *(text + len) = '\0';

        WPutsn(b->x + 1, b->y + 1, len, b->battr, text);
    }
    else
    {
        WWriteStr(b->x + 1, b->y, attr, s);
        WWriteStr(b->x, b->y, b->battr, " ");

        memset(text, ' ', sizeof(text));
        *(text + len) = '\0';

        WPutsn(b->x + 1, b->y + 1, len, b->battr, text);
    }
    return;
}

/* void ShowCkbutton(ckbutton *i);
   **
   ** Puts a Check box button onto the screen, handling
   ** all the states of the check box.
   **
 */

void ShowCkbutton(ckbutton * i)
{
    int fa = (i->select) ? i->sattr : i->fattr;

    if (i->down)
        strcpy(text, " [x] ");
    else
        strcpy(text, " [ ] ");

    WWriteStr(i->x, i->y, fa, text);
    WWriteStr(i->px, i->y, fa, i->prtext);
}

/* void ShowEditField(editf *i);
   **
   ** Displays an editf control.
   **
 */

void ShowEditField(editf * i)
{
    if (!i->select)
        WPutsn(i->x, i->y, i->len, i->fattr, i->buf);
    else
        WPutsn(i->x, i->y, i->len, i->sattr, i->buf);
}

void D_ShowTxt(textl * i)
{
    if (i->text)
        WWriteStr(i->x, i->y, i->fattr, i->text);
}

void D_ShowWBox(wbox * i)
{
    int x;

    WBox(i->x1, i->y1, i->x2, i->y2, i->fattr, i->type);

    if (i->title)
    {
        x = ((i->x2 - i->x1) / 2) - (strlen(i->title) / 2) + i->x1;
        WWriteStr(x, i->y1, i->tattr, i->title);
    }
}

#if 0
/*
   **
   ** Please note, scroll bars are not implemented yet - this is
   ** preliminary code only.
   **
 */

/* void D_ShowScrollBar(sbar *i);
   **
   ** Shows the entire scrollbar.
   **
 */

void D_ShowScrollBar(sbar * i, int newpos)
{
    int cnt;
    char *b[2] =
    {
        {SC15, '\0'},
        {SC14, '\0'}};
    char *v[2] =
    {
        {SC17, '\0'},
        {SC18, '\0'}};
    static char t[] =
    {SC13, '\0'};
    static char s[] = " ";

    if (newpos)
    {
        WWriteStr(i->spos + i->xy1, i->xy, i->sattr, t);
        WWriteStr(newpos + i->xy1, i->xy, i->sattr, s);
        i->spos = newpos;
        return;
    }
    if (i->type)
    {
        WWriteStr(i->xy1, i->xy, i->battr, b[0]);
        WWriteStr(i->xy2, i->xy, i->battr, b[1]);

        for (cnt = i->xy1 + 1; cnt < i->xy2; cnt++)
            WWriteStr(cnt, i->xy, i->battr, t);

        WWriteStr(i->spos + i->xy1, i->xy, i->sattr, s);
    }
    else
    {
        WWriteStr(i->xy, i->xy1, i->battr, v[0]);
        WWriteStr(i->xy, i->xy2, i->battr, v[1]);

        for (cnt = i->xy1 + 1; cnt < i->xy2; cnt++)
            WWriteStr(i->xy, cnt, i->battr, t);

        WWriteStr(i->xy, i->spos + i->xy1, i->sattr, s);
    }
    return;
}

/*
   **
   ** Handles messages to the scrollbar.
   **
 */

int HandleScrollBar(sbar * sb, int x, int y, int lines, int pos)
{
    int wx, wy;
    int npos;
    int msg = 0;

    unused(lines);
    unused(pos);
    WndGetRel(x, y, &wx, &wy);

    if (sb->type)
    {
        npos = x - sb->xy1;
        if (npos == 0)
            msg = WM_SCRLFT;
        else if (npos == (sb->xy2 - sb->xy1))
            msg = WM_SCRRGT;
    }
    else
    {
        npos = y - sb->xy1;
        if (npos == 0)
            msg = WM_SCRLUP;
        else if (npos == (sb->xy2 - sb->xy1))
            msg = WM_SCRLDN;
    }
    if (!msg)
    {
        if (npos > sb->spos)
            msg = WM_SPGDN;
        else
            msg = WM_SPGUP;
    }
    return msg;
}

#endif
