Program tagmake; (* converts slmr/txt taglines to nfx format *)
uses dos;

function pad(inStr : String; size : Integer) : String;
Var
 TStr : String;
begin
 TStr:=InStr;
 While Length(TStr) < size do
 begin
  TStr:=Concat(TStr,' ');
 end;
 pad:=Copy(TStr,1,size);
end;

Procedure Convert(infile,outfile  : PathStr);
Var
 F1,F2 : Text;
 TStr  : String;
 Error : Word;
begin
 Assign(F1,infile);
 Assign(F2,outfile);
{$I-}
 Reset(F1);
 Error:=IORESULT;
 If Error<>0 then
 begin
   writeln('Error opening input file.');
   exit;
 end;

 Rewrite(F2);
 Error:=IORESULT;
 If Error<>0 then
 begin
   writeln('Error opening output file.');
   exit;
 end;

 If (POS('.MR',infile) > 0) OR (POS('.mr',infile) > 0) then
 begin
   Readln(F1,TStr);
 end;

 While (NOT EOF(F1)) And (Error=0) do
 begin
   Readln(f1,TStr);
   Write(f2,Pad(Tstr,72));
   Error:=IORESULT;
 end;

 Close(F1);
 Close(F2);
 Error:=IORESULT;
{$I+}
end;


procedure printinfo;
begin
 writeln('TagMake - Creates NFX v2.x taglines from SLMR TAGLINES.MR file or any text file');
 Writeln('Usage: Tagmake infile outfile');
 Writeln;
 writeln(' infile = SLMR TAGLINES.MR file or Text file.');
 Writeln('outfile = NFX tagline file (TAGLIST.PL) ');
 writeln;
 Writeln('Copy the NFX Tagline file (TAGLIST.PL) to NFX''s USER directory.');
end;

begin
 If paramCount < 2 then
  printInfo
 else Convert(paramStr(1),paramStr(2));

end.