UNIT DIZLSTRC;
Interface
USES DOS,CRT;
{
 COPYRIGHT 1996, ALL RIGHTS ARE RESERVED BY MARK BLOSS/MIND OVER BYTE SOFTWARE
 Ŀ
                                               
                These Structures define   
                the format that DIZL.EXE, 
                  and DZSETUP use for v1.0  
                 to store the data they    
               need.  You may use the    
                                   same structures to access 
                             this data in your own     
                                     support and/or kludge     
                                 programs if you choose.   
                                                                
                                 Public release of any     
                                        program for DIZL.EXE's    
                                  data must be approved     
            S  O  F  T  W  A  R  E  (tm)          by Mind Over Byte Software
            A SPYER BBS (615)831-9284                                       
 
}

Const BufSize = 500;       { DO NOT CHANGE ANY VALUES IN THIS FILE }


CONST
    f_no_des     = 0;        { descOrigin definitions }
    f_fileid     = 1;        { See DescriptionRecord defined below }
    f_desdi      = 2;        { DESC.SDI }
    f_ndos       = 4;        { DESCRIPT.ION }
    f_fbbs       = 8;        { FILES.BBS }
    f_sdnid      = 16;       { SDN.ID }
    f_vend       = 32;       { VENDINFO.DIZ }
    pack         = false;    { used in ExecArray as indices }
    unpack       = true;

TYPE
   DizType    = Array [0..BufSize-1] of Char;
   DesignType = (BASIC,SHORT,GOTHIC,BOXED,JAILHOUSE,STRATA,RIVER,FBBSL);
   { PLEASE NOTE THAT UC2 IS NOT SUPPORTED }
   ArchiveType = (ARJ,ZIP,RAR,UC2,ARC,SQZ,ZOO,LZH,UNKNOWN);
   DescrType = (FBBS,NDOS,ALL,D_NONE);

   DescriptionRecord = Record   { *.DAT STRUCTURE }
     fpath       : PathStr;     { path to file }
     validdesc   : boolean;     { does desc reflect good description? }
     remove      : boolean;     { set to true if file no longer exists }
     Desc        : DizType;     { The Description from file_id.diz, etc }
     Fn          : String[12];  { filename = string[12] }
     Sz          : longint;     { filesize }
     Dt          : longint;     { file date/time }
     DpDesc      : String[45];  { AREA Description from *.INI }
     Duped       : boolean;     { Two or more same file in different dirs }
     DescOrigin  : byte;        { 0=none,1=file_id.diz,2=desc.sdi,4=4dos,8=files.bbs}
     Purge       : boolean;     { True if two duplicate records of same file, or...}
                                { if record no longer defined in configuration. }
     uubuffer    : Array [0..38] of byte;  { Unused buffer }
   End;

   DescDataFile = File of DescriptionRecord;  { The *.DAT file }

   FfPtr = ^FileFindRec;        { Pointer used with LL }

   FileFindRec = Record         { *.IDX STRUCTURE }
     filename : String[12];     { The FileName }
     areanum  : byte;           { Area Number (from Config (*.INI) }
     RecPos   : LongInt;        { Seek(*.DAT, RecPos) then Read/Write }
     uubyte   : byte;           { Unused byte }
     listed   : boolean;        { Already written to list file? Only... }
                                { used during creating list file itself.}
                                { Always Save to disk as false! }
     Next     : ffptr;          { Pointer to next node in LL }
   End;

   FileFindFile = file of FileFindRec;       { The *.IDX file }

   { NESTED IN *.INI FILE }
   ExecRec  =  record        { Record Definition of ExecArray Element }
    Progname :  PathStr;     { Program Path/Name }
    Cmdline  :  PathStr;     { Commandline parameters }
    Found    :  Boolean;     { Set true if found in PATH }
   End;    { Found boolean updated each time DIZL is run }

  ExecArray = Array [pack..unpack,ARJ..UNKNOWN] of ExecRec;

  ConfigRec  = Record                   { *.INI STRUCTURE }
   VersionNum       : String[5];        { Ex: 'v38'); }
   DataBaseName     : String[8];          { "DIZLIST" is default }
   MinToPack        : Byte ;            { default = 8  (8%) }
   CurrDsgn         : DesignType;
   AltDescribe      : DescrType; { defines what to use for alt. descriptions }
   MagicArchiveType,             { ArchiveType used when archiving MiniList}
   ListArchiveType  : String[3]; { ArchiveType used when archiving lists }

   uuarray          : array [0..14] of byte;

   SWAP,                        { SWAP out memory? }
   Logging,                     { Enable logging? }
   LogCfgEnable,                { Log Configuration? }
   AddDiz,                      { add descriptions to archives when allowed? }
   OnlyAlternate,               { Use ONLY alternate files (no unpacking) }
   ArchiveList,                 { Create an Archive of lists at eoj? }
   CreateAll,                   { Create an ALLFILES list? }
   CreateAreas,                 { Create an Areas List? }
   SkipCheckDesc,               { If invalid description, check for one again? }
   SkipDesc,                    { Skip inclusion of Non-descriptions in list? }
   Magics,                      { Magic names in List? }
   MagicMini,                   { Create Magic Mini-List? }
   MagicMiniArchive,            { Create Archive of Mini-List? }
   NoticeCDRom,                 { If CD-Rom directory, treat differently? }
   SortAreas        : Boolean;  { Sort areas? }
   Xcl              : String[48];   { excluded extensions }
   uuword           : Word;     { unused }
   FBBSDescColumn   : Word;     { Column actual description begins in FBBS }
   LogFile,                     { "DIZL.LOG" }
   TempDir,                     { "DIZLWORK.TMP" }
   MagicFile,                   { Path+Name of Magic Names File }
   ListArchiveName,             { Name of archive used when archiving lists }
   MagicArchiveName,            { Name of archive created for MiniList }
   IncludeWithArc   : PathStr;  { Name of any file to add to archive }
   ListFileName,                { = 'ALLFILES.LST';  }
   AreasFilename,               { = 'AREAFILE.LST'; }
   HeaderFile,                  { = 'DIZHEAD.FRM'; }
   FooterFile,                  { = 'DIZFOOT.FRM';}
   FilesBBS,                    { = 'FILES.BBS';}
   MagicMiniListName,           { Name of MiniList (in Home dir) }
   MagicDizInclude,             { Name of Description file to add to MiniList}
   MagicHeaderFile,             { Name of Header file for Majik List }
   MagicFooterFile,             { Name of Footer file for Majik List }
   DizIncludeName   : String[12];{ Name of Description file to add to archive }
   NoDescStr        : String[99]; { = 'No description for this file is currently available.';}
   ExecCmds         : ExecArray;
  End;
Implementation
End.

