
Uses CRT,DOS,DTIME;

{$I RG0405.INC }                      { the Renegade Structures }

CONST
       fm_Read_DenyNone           = 64;
       fm_ReadWrite_DenyNone      = 66;

VAR
       user  : userrec;                   { USERS.DAT }
       fuser : file of userrec;
       stat  : generalrec;                { RENEGADE.DAT }
       fstat : file of generalrec;
       time  : longint;
       r     : uflags;
       ts    : string;
       ch2,
       ch    : char;

{ support functions }

function atoi(s:string):longint;
Var i:LongInt;e:Integer;
begin
Val(S,i,e);
atoi:=i;
end;

function Directory(s:string):string;
begin
if s[length(s)] <> '\' then
   Directory := s+'\'
else
   Directory := s;
end;

function env_Share:boolean;
var Regs : Registers;
begin
Regs.AH := $10;
Regs.AL := 0;
Intr($2F,Regs);
env_Share := (Regs.AL = $FF);
end;

{ main }

Begin
Writeln;
Writeln('TCR-RG 1.10   Renegade & TCR Callback Interface');
Writeln('Copyright 1993,1996 by Tim Strike.  All rights reserved.');
Writeln;

{ check parameters, do we have enough? }

if paramcount < 2 then
   begin
   Writeln('Usage: TCR-RG <account_#> <to_level>');
   Halt(5);
   end;

{ find RENEGADE.DAT }

if GetEnv('RENEGADE') <> '' then ts:=Directory(GetEnv('RENEGADE'))+'RENEGADE.DAT' else
   if GetEnv('BBS') <> '' then ts:=Directory(GetEnv('BBS'))+'RENEGADE.DAT' else
      if FSearch('RENEGADE.DAT',GetEnv('PATH')) <> '' then
         ts:=FSearch('RENEGADE.DAT',GetEnv('PATH')) else ts:='RENEGADE.DAT';

{ open RENEGADE.DAT, USERS.DAT }

Assign(fstat,ts);
if env_Share then filemode:=fm_Read_DenyNone;
{$I-} Reset(fstat); {$I+}
   If IoResult > 0 then
      BEGIN
      Writeln('* Unable to open RENEGADE.DAT data file.  Please switch into the main');
      Writeln('  BBS directory, or create a SET BBS= or SET RENEGADE= environment variable.');
      Halt(5);
      END;
Read(fstat,stat);
Close(fstat);

Assign(fUser,stat.datapath+'USERS.DAT');
if env_Share then filemode:=fm_ReadWrite_DenyNone;
{$I-} Reset(fUser); {$I+}
If IoResult > 0 Then
   begin
   Writeln('* Unable to open USERS.DAT data file.');
   halt(5);
   end;
Seek(fUser,atoi(Paramstr(1)));
Read(fUser,User);

Writeln('User: ',user.name);
Writeln;

{ upgrade user! }

ts:=Paramstr(2);
Ch:=upcase(ts[1]);
if ch in ['A'..'Z'] then
   BEGIN
   time:=stat.timeallow[stat.validation[ch].newsl]-stat.timeallow[user.sl];
   if user.sl <> stat.validation[ch].newsl then
      Writeln('Upgrading SL ',user.sl,' -> SL ',stat.validation[ch].newsl);
   user.sl:=stat.validation[ch].newsl;
   if user.dsl <> stat.validation[ch].newdsl then
      Writeln('Upgrading DSL ',user.dsl,' -> DSL ',stat.validation[ch].newdsl);
   user.dsl:=stat.validation[ch].newdsl;
   if stat.validation[ch].softar then
      begin
      Write('Upgrading AR (soft) +');
      for ch2 := 'A' to 'Z' do
      if ch2 in stat.validation[Ch].newar then
         begin
         user.ar:=user.ar+[ch2];
         Write(ch2);
         end;
      Writeln;
      end
   else
      begin
      if user.ar <> stat.validation[ch].newar then
         Writeln('Upgrading AR (hard)');
      user.ar:=stat.validation[ch].newar;
      end;
   if stat.validation[ch].softac then
      begin
      Writeln('Upgrading flags (soft)');
      for r := rlogon to rmsg do
         if r in stat.validation[ch].newac then
            user.flags:=user.flags+[r];
      for r := fnodlratio to fnodeletion do
         if r in stat.validation[ch].newac then
            user.flags:=user.flags+[r];
      end
   else
      begin
      Writeln('Upgrading flags (hard)');
      for r := rlogon to rmsg do
         begin
         user.flags:=user.flags-[r];
         if r in stat.validation[ch].newac then
            user.flags:=user.flags+[r];
         end;
      for r := fnodlratio to fnodeletion do
         begin
         user.flags:=user.flags-[r];
         if r in stat.validation[ch].newac then
            user.flags:=user.flags+[r];
         end;
      end;
   if stat.validation[ch].newcredit <> 0 then
      Writeln('Upgrading credits +',stat.validation[ch].newcredit,' credits');
   Inc(user.credit,stat.validation[ch].newcredit);
   if stat.validation[ch].expiration = 0 then
      Writeln('Account never expires')
   else
      begin
      Writeln('Upgrading expiry date -> ',stat.validation[ch].expiration,' days');
      Writeln('Account expires to level ',upcase(stat.validation[ch].expireto));
      end;
   if stat.validation[ch].expiration = 0 then
      user.expiration:=0
   else
      user.expiration:= ltime +(24*60*60*longint(stat.validation[ch].expiration));
   user.expireto:=stat.validation[ch].expireto;
   user.userstartmenu:=stat.validation[ch].newmenu;
   if time > 0 then
      begin
      Writeln('Upgrading time +',time,' minutes');
      user.tltoday:=user.tltoday+time;
      end;
   seek(fuser,atoi(paramstr(1)));
   write(fuser,user);
   Writeln;
   Writeln('Done.');
   end
else
   Writeln('* Unknown validation level "',Ch,'".');
Close(fUser);
END.

