
             
                       Alternative Worlds Presents                      
   Ŀ
    Mod Name        FMD-40b.MOD                                        
    Difficulty      ۱ (3/10)                                 :
    WWIV Version    4.24                                               
    Date Affected   08/02/95                                           
   : Files Affected  SYSOPF.C / BBS.C / BBSOVL1.C / READMAIL.C / MMENU.C
    Description     Use WWIVsys Inside WWIV - Pulldown Menu Interface  
    ſ
           A French Mod Division Release - (C) 1995 FMD Software         
          


 Ϳ
  Long Description 
  

    This modification will allow WWIVsys registered users to use WWIVsys from
inside their WWIV and to replace all internal sysop functions.

    You will be able to remove internal functions also if you don't have any
remote SysOp, so it will save you a lot of Dgroup and will discrease the size
of your BBS.EXE and you will have more memory available.

Revision A:

 - Updated for WWIV v4.24

Revision B:

 - New pulldown menu interface added, inspired from One Eyed Willy's pulldown
   menu modification for WWIV v4.10

Notes: If you only want to add the pulldown menu interface, do Step 1 and
       7 only.

 Ϳ
  Tests 
  

  This modification has been tested on a virgin WWIV v4.24 source using
  Borland C++ v4.5


                                   Legend
                          Ϳ
                           +  Add This Line    
                           -  Delete This Line 
                           *  Modify This Line 
                           =  Existing Line    
                          ͼ
[Step 1]

Load SYSOPF.C and do the following changes:

=#include "vars.h"
=
=#pragma hdrstop
=
+#include "wwivsys.h"

And add the following function at the end of the file:

void wwivsys(int fcns)
{
  char s[81];

  if (incom) {
    npr("\r\nCannot load WWIVsys from remote.\r\n\r\n");
    return;
  }
  save_status();
  save_config();

  switch(fcns)
  {
    case 0:
      sprintf(s, "SYS.EXE");
    break;
    case ZLOG:
      sprintf(s, "SYS.EXE -ZL");
    break;
    case AUTOVAL:
      sprintf(s, "SYS.EXE -AV");
    break;
    case BACKUP:
      sprintf(s, "SYS.EXE -BK");
    break;
    case BBSINFO:
      sprintf(s, "SYS.EXE -BI");
    break;
    case CONFDIR:
      save_confs(CONF_DIRS, -1, NULL);
      sprintf(s, "SYS.EXE -CD");
    break;
    case DIREDIT:
      sprintf(s, "SYS.EXE -DE");
    break;
    case CHAINEDIT:
      sprintf(s, "SYS.EXE -CE");
    break;
    case FSED:
      save_config();
      sprintf(s, "SYS.EXE -FSED");
    break;
    case EXTERNAL:
      save_config();
      sprintf(s, "SYS.EXE -EP");
    break;
    case FILEEDIT:
      sprintf(s, "SYS.EXE -FE");
    break;
    case GFILES:
      sprintf(s, "SYS.EXE -GF");
    break;
    case GFILEEDIT:
      sprintf(s, "SYS.EXE -GE");
    break;
    case INSTANCE:
      sprintf(s, "SYS.EXE -IE");
    break;
    case LANGUAGE:
      sprintf(s, "SYS.EXE -LE");
    break;
    case MODEM:
      sprintf(s, "SYS.EXE -ME");
    break;
    case NETEDITOR:
      sprintf(s, "SYS.EXE -NE");
    break;
    case PATH:
      sprintf(s, "SYS.EXE -PATH");
    break;
    case PROTOCOL:
      sprintf(s, "SYS.EXE -PE");
    break;
    case SLRECEDIT:
      sprintf(s, "SYS.EXE -SE");
    break;
    case CALLOUT:
      sprintf(s, "SYS.EXE -CA");
    break;
    case CONFIG:
      sprintf(s, "SYS.EXE -CFG");
    break;
    case SSMEDITOR:
      sprintf(s, "SYS.EXE -SSM");
    break;
    case STATISTICS:
      sprintf(s, "SYS.EXE -STAT");
    break;
    case STRINGEDIT:
      close_strfiles();
      sprintf(s, "SYS.EXE -ESE");
    break;
    case CONFBOARD:
      save_confs(CONF_SUBS, -1, NULL);
      save_subs();
      sprintf(s, "SYS.EXE -CB");
    break;
    case BOARDEDIT:
      save_subs();
      sprintf(s, "SYS.EXE -BE");
    break;
    case SUBLIST:
      save_subs();
      sprintf(s, "SYS.EXE -SL");
    break;
    case UEDIT:
      sprintf(s, "SYS.EXE -UE");
    break;
    case IVOTE:
      sprintf(s, "SYS.EXE -IV");
    break;
    case INISWITCH:
      sprintf(s, "SYS.EXE -INI");
    break;
    case INIEDITOR:
      sprintf(s, "SYS.EXE -INIE");
    break;
    case WHO:
      sprintf(s, "SYS.EXE -WHO");
    break;
  }
  extern_prog(s, EFLAG_SHRINK|EFLAG_INTERNAL|EFLAG_TOPSCREEN|EFLAG_COMIO);
  read_config();
  read_status();
  switch(fcns)
  {
    case CONFDIR:
      read_in_conferences(CONF_DIRS);
      read_dirs();
    break;
    case DIREDIT:
      read_dirs();
    break;
    case CHAINEDIT:
      read_chains();
    break;
    case GFILES:
      read_gfile();
    break;
    case CONFIG:
      read_ini_info();
    break;
    case STRINGEDIT:
      set_language(thisuser.language);
    break;
    case CONFBOARD:
      read_in_conferences(CONF_SUBS);
      read_subs();
    break;
    case BOARDEDIT:
      read_subs();
    break;
    case SUBLIST:
      read_subs();
    break;
    case IVOTE:
      read_voting();
    break;
    case INISWITCH:
    case INIEDITOR:
      read_ini_info();
    break;
  }
}

Save SYSOPF.C

[Step 2]

Now you have to select if you would like to remove internal functions or not.
If you have remote SysOps, you shouldn't remove them, and if you do remove
them, you will save a lot of Dgroup space, but in another hand, if you remove
them you will ALWAYS use WWIVsys, so you better think about it.

Step 2a is to keep internal functions.

Step 2b is to remove all internal SysOp functions.


[Step 2a]

Load MMENU.C and do the following changes:

=#include "vars.h"
=
=#pragma hdrstop
=
=#include "ripint.h"
=#include <ctype.h>
+#include "wwivsys.h"

And now in function mainmenu:

/**************************************************/
=  if (so()) {
=    if ((strcmp(s,"ALLOWEDIT")==0) || (strcmp(s,"AE")==0))
=      edit_database();
=    if ((strcmp(s,"READINI")==0) || (strcmp(s,"RI")==0)) {
=      if (!read_ini_info()) {
=        printf(get_string(1504));
=        end_bbs(noklevel);
=      }
=      if (!chains_reg)
=        sysinfo.flags &= ~OP_FLAGS_CHAIN_REG;
=      topscreen();
=    }
=    if ((strcmp(s,"INSTEDIT")==0) || (strcmp(s,"IE")==0))
=      instance_edit();
=    if ((strcmp(s,"CONFEDIT")==0) || (strcmp(s,"JE")==0)) {
=      write_inst(INST_LOC_CONFEDIT,0,INST_FLAGS_ONLINE);
=      edit_confs();
=    }
=    if ((strcmp(s,"BOARDEDIT")==0) || (strcmp(s,"BE")==0)) {
=      write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,2));
+      if (incom)
=        boardedit();
+      else
+        wwivsys(BOARDEDIT);
=    }
=    if ((strcmp(s,"CHAINEDIT")==0) || (strcmp(s,"CE")==0)) {
=      write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,4));
+      if (incom)
=        chainedit();
+      else
+        wwivsys(CHAINEDIT);
=    }
=    if (strcmp(s, "CHAT")==0) {
=      nl();
=      pl(((*(char far *)0x00000417L ^= 0x10) & 0x10) ?
=                       get_string(21) :
=                       get_string(22));
=      sysoplog(get_stringx(1,9));
=      topscreen();
=    }
=    if ((strcmp(s,"CHUSER")==0) || (strcmp(s,"CU")==0)) {
=      write_inst(INST_LOC_CHUSER,0,INST_FLAGS_ONLINE);
=      chuser();
=    }
=    if (strcmp(s,"CLOUT")==0) {
=      npr("\r\nNot Yet.\r\n");
=    /*  force_callout(2); */
=    }
=    if (strncmp(s,"DEBUG",5)==0) {
=      if((s[5]) && (s[5]!=' '))
=        debuglevel=s[5]-'0';
=      else if(s[6])
=        debuglevel=s[6]-'0';
=    }
=    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
=      write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,3));
+      if (incom)
=        dlboardedit();
+      else
+        wwivsys(DIREDIT);
=    }
=    if (strcmp(s,"DOS")==0) {
=      if (checkpw()) {
=        write_inst(INST_LOC_DOS,0,INST_FLAGS_ONLINE);
=        sysoplog(get_stringx(1,6));
=        extern_prog(getenv("COMSPEC"), EFLAG_SHRINK|EFLAG_COMIO|EFLAG_ABORT);
=      }
=    }
=    if ((strcmp(s,"EDIT")==0)) {
=      if (checkpw()) {
=        write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
=        nl();
=        prt(2,get_string(7));
=        input(s1,50);
=        if (s1[0]) {
=          if ((okansi()) && (thisuser.defed))
=            external_edit(s1,"",thisuser.defed-1,500,".",s1,1);
=          else
=            tedit(s1);
=        }
=      }
=    }
=    if ((strcmp(s,"GFILEEDIT")==0) || (strcmp(s,"GE")==0)) {
=      write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,5));
+      if (incom)
=        gfileedit();
+      else
+        wwivsys(GFILEEDITOR);
=    }
=    if (strcmp(s,"LOAD")==0) {
=      nl();
=      prt(2,get_string(7));
=      input(s1,50);
=      if (s1[0]) {
=        nl();
=        prt(5,get_string(17));
=        if (yn()) {
=          nl();
=          load_workspace(s1,0);
=        } else {
=          nl();
=          load_workspace(s1,1);
=        }
=      }
=    }
=    if (strcmp(s,"MAILR")==0) {
=      if (checkpw()) {
=        write_inst(INST_LOC_MAILR,0,INST_FLAGS_ONLINE);
=        sysoplog(get_stringx(1,8));
=        mailr();
=      }
=    }
=    if ((strcmp(s,"REBOOT")==0) && (checkpw())) {
=      write_inst(INST_LOC_REBOOT,0,INST_FLAGS_ONLINE);
=      dtr(0);
=      sysoplog(get_stringx(1,7));
=      logoff();
=      sl1(1,"");
=      if (ok_modem_stuff)
=        closeport();
=      close_strfiles();
=      Wait(3.0);
=#ifdef __OS2__
=      sprintf(s2, "/IBD:%c", syscfg.ramdrive);
=      execlp("setboot.exe", "setboot.exe", s2, NULL);
=#else
=      setvect(0xff,(void interrupt (*) ()) MK_FP(0xffff,0x0000));
=      geninterrupt(0xff);
=#endif
=    }
=    if (strcmp(s,"RELOAD")==0) {
=      write_inst(INST_LOC_RELOAD,0,INST_FLAGS_ONLINE);
=      read_new_stuff();
=    }
=    if (strcmp(s,"RESETF")==0) {
=      write_inst(INST_LOC_RESETF,0,INST_FLAGS_ONLINE);
=      reset_files();
=    }
=    if (strcmp(s, "RESETQSCAN")==0) {
=      prt(5,get_string(970));
=      if (yn()) {
=        write_inst(INST_LOC_RESETQSCAN,0,INST_FLAGS_NONE);
=        for (i=0; i<=number_userrecs(); i++) {
=          read_qscn(i, qsc, 1);
=          memset(qsc_p,
=                 0,
=                 syscfg.qscn_len - 4*(1+((max_dirs+31)/32)+((max_subs+31)/32)));
=          write_qscn(i, qsc, 1);
=        }
=        read_qscn(1, qsc, 0);
=        close_qscn();
=      }
=    }
=    if (strcmp(s,"STAT")==0) {
=      read_status();
=      nl();
=#ifndef __OS2__
=      outstr(get_string(18));
=      pln(_stklen);
=#endif
=      outstr(get_string(19));
=      npr("%dk\r\n", (int) (farcoreleft()/1024));
=      outstr(get_string(20));
=      npr("%d%%\r\n", cachestat());
=      outstr(get_string(938));
=      npr("%lu\r\n",status.qscanptr);
=      nl();
=    }
=  }
=    if (strcmp(s,"PACK")==0) {
=      nl();
=      prt(5, get_string(1505));
=      if (yn())
=        pack_all_subs();
=      else
=        pack_sub(usub[cursub].subnum);
=    }
=  }
=/**************************************************/
=  if (cs()) {
=    if (strcmp(s,"IVOTES")==0) {
=      write_inst(INST_LOC_VOTE,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,11));
+      if (incom)
=        ivotes();
+      else
+        wwivsys(IVOTE);
=    }
=    if (strcmp(s,"LOG")==0) {
=      slname(date(), s1);
=      print_local_file(s1,"");
=    }
=    if (strcmp(s,"NLOG")==0) {
=      print_local_file("NET.LOG","");
=    }
=    if (strcmp(s,"PENDING")==0) {
=      print_pending_list();
=    }
=    if (strcmp(s,"STATUS")==0) {
=      prstatus();
=    }
=    if (strcmp(s,"TEDIT")==0) {
=      write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,12));
=      text_edit();
=    }
=    if ((strcmp(s,"UEDIT")==0) || (strcmp(s,"UE")==0)) {
=      write_inst(INST_LOC_UEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,10));
+      if (incom)
=        uedit(usernum,0);
+      else
+        wwivsys(UEDIT);
=    }
=    if (strcmp(s,"VOTEPRINT")==0) {
=      write_inst(INST_LOC_VOTEPRINT,0,INST_FLAGS_ONLINE);
=      voteprint();
=    }
=    if (strcmp(s,"YLOG")==0) {
=      read_status();
=      print_local_file(status.log1,"");
=    }
=    if (strcmp(s,"ZLOG")==0) {
+      if (incom)
=        zlog();
+      else
+        wwivsys(ZLOG);
=    }
+    if (strcmp(s, "WWIVSYS")==0) {
+      if (!incom)
+        wwivsys(0);
+    }
=    if ((strcmp(s,",")==0) && ((net_sysnum>0) || (net_num_max>1))) {
=      nl();
=      prt(2,get_string(23));
=      ch=onek("Q012");
=      switch(ch) {
=        case '0': print_local_file(get_string(1027),""); break;
=        case '1': print_local_file(get_string(1028),""); break;
=        case '2': print_local_file(get_string(1029),""); break;
=      }
=    }
=    if (strcmp(s,"/?")==0) {
=      printmenu(5);
=    }
=  }
=/*************************************************/

Lower in function dlmainmenu:

=    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
=      sysoplog(get_stringx(1,3));
+      if (incom)
=        dlboardedit();
+      else
+        wwivsys(DIREDIT);
=    }
=
=    if (strncmp(s,"DEBUG",5)==0) {

Load BBS.C and modify this at the top of the file:

=#define _DEFINE_GLOBALS_
=#include "vars.h"
=#include "subxtr.h"
=#include <math.h>
+#include "wwivsys.h"
=
=#ifdef __OS2__

Then, in function getcaller:

=        case 'B':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(BOARDEDIT);
=            cleanup_net();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'C':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(CHAINEDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'D':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(DIREDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'W':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_TEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
=            text_edit();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'F':
=          if (ok_local()) {
=            write_inst(INST_LOC_DOS,0,INST_FLAGS_NONE);
=            holdphone(1);
=            nl();
=            pl(get_string(43));
=            nl();
=            setvect(save_dos,NULL);
=            do_remote(getenv("COMSPEC"),0);
=            setvect(save_dos, getvect(INT_REAL_DOS));
=            out1ch(12);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'G':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(GFILEEDITOR);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'I':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_VOTEEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(IVOTE);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'J':
=          if (ok_local()) {
=            holdphone(1);
=            edit_confs();
=            holdphone(0);
=          }
=          break;
=        case 'K':
=          if (ok_local()) {
=            usernum=1;
=            useron=1;
=            holdphone(1);
=            okskey=1;
=            prt(2,get_string(44));
=            input(s,50);
=            load_workspace(s,0);
=            send_email();
=            okskey=0;
=            useron=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'L':
=          if (ok_local()) {
=            read_status();
=            slname(date(), s);
=            print_local_file(s,status.log1);
=          }
=          break;
=        case 'M':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_MAILR,0,INST_FLAGS_NONE);
=            holdphone(1);
=            mailr();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'N':
=          if (ok_local())
=            print_local_file("NET.LOG","NETDAT*.LOG");
=          break;
=        case 'P':
=          if (ok_local())
=            print_pending_list();
=          break;
=        case 'Q':
=          end_bbs(QUIT_LEVEL);
=          break;
=        case 27:
=          outstr(get_string(1043));
=          if (yn())
=            end_bbs(QUIT_LEVEL);
=          clrscrb();
=          break;
=        case 'R':
=          if (ok_local()) {
=            usernum=1;
=            holdphone(1);
=            okskey=1;
=            readmail();
=            okskey=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'S':
=          if (ok_local()) {
=            prstatus();
=            getkey();
=          }
=          break;
=        case 'T':
=          if ((ok_local()) && (syscfg.terminal[0])) {
=            if (syscfg.sysconfig & sysconfig_shrink_term)
=              shrink_out(syscfg.terminal,0,0,0,1);
=            else
=              run_external(syscfg.terminal);
=            imodem(1);
=            imodem(0);
=          }
=          break;
=        case 'U':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_UEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
+            wwivsys(UEDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'E':
=          if (ok_local()) {
=            usernum=1;
=            useron=1;
=            holdphone(1);
=            okskey=1;
=            send_email();
=            okskey=0;
=            useron=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'X':
=          for(i=0;i<50;i++) {
=            if(xenviron[i]!=NULL)
=              npr("\r\nxenv %d=%s",i,xenviron[i]);
=          }
=          npr("\r\nreal=%x, new=%x",INT_REAL_DOS,save_dos);
=          nl();
=          pausescr();
=        break;
=        case 'Y':
=          if (ok_local()) {
=            read_status();
=            slname(date(), s);
=            print_local_file(status.log1,s);
=          }
=          break;
=        case 'Z':
=          if (ok_local()) {
*            wwivsys(ZLOG);
=            nl();
=            getkey();
=          }
=          break;
=        case '/':
=          if ((net_sysnum) && (ok_local()))
=            force_callout(0);
=          break;
=        case '.':
=          if ((net_sysnum) && (ok_local()))
=            force_callout(1);
=          break;
=        case ',':
=          if ((net_sysnum>0) || (net_num_max>1) && ok_local()) {
=            nl();
=            prt(2,get_string(23));
=            ch=onek("Q012");
=            switch (ch) {
=              case '0':
=                print_local_file(get_string(1027),"");
=                break;
=              case '1':
=                print_local_file(get_string(1028),"");
=                break;
=              case '2':
=                print_local_file(get_string(1029),"");
=                break;
=            }
=          }
=          break;
=        case '`':
=          if ((net_sysnum) && (ok_local())) {
=            holdphone(1);
=            print_net_listing(1);
=            holdphone(0);
=          }
=          break;
=        case 9:
=          if (ok_local()) {
=            holdphone(1);
=            instance_edit();
=            holdphone(0);
=          }
=          break;
+        case '@':
+          if (ok_local()) {
+            holdphone(1);
+            wwivsys(0);
+            holdphone(0);
+          }
+          break;
=      }
=      if (!incom && !lokb) {


Save BBS.C

[Step 2b]

Load MMENU.C and do the following changes:

=#pragma hdrstop
=
=#define _DEFINE_GLOBALS_
=#include "vars.h"
=#include "subxtr.h"
+#include "wwivsys.h"
=
=#include <math.h>

And now in function mainmenu:

/**************************************************/
=  if (so()) {
=    if ((strcmp(s,"ALLOWEDIT")==0) || (strcmp(s,"AE")==0))
=      edit_database();
=    if ((strcmp(s,"READINI")==0) || (strcmp(s,"RI")==0)) {
=      if (!read_ini_info()) {
=        printf(get_string(1504));
=        end_bbs(noklevel);
=      }
=      if (!chains_reg)
=        sysinfo.flags &= ~OP_FLAGS_CHAIN_REG;
=      topscreen();
=    }
=    if ((strcmp(s,"INSTEDIT")==0) || (strcmp(s,"IE")==0))
=      instance_edit();
=    if ((strcmp(s,"CONFEDIT")==0) || (strcmp(s,"JE")==0)) {
=      write_inst(INST_LOC_CONFEDIT,0,INST_FLAGS_ONLINE);
=      edit_confs();
=    }
=    if ((strcmp(s,"BOARDEDIT")==0) || (strcmp(s,"BE")==0)) {
=      write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,2));
+      wwivsys(BOARDEDIT);
=    }
=    if ((strcmp(s,"CHAINEDIT")==0) || (strcmp(s,"CE")==0)) {
=      write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,4));
+      wwivsys(CHAINEDIT);
=    }
=    if (strcmp(s, "CHAT")==0) {
=      nl();
=      pl(((*(char far *)0x00000417L ^= 0x10) & 0x10) ?
=                       get_string(21) :
=                       get_string(22));
=      sysoplog(get_stringx(1,9));
=      topscreen();
=    }
=    if ((strcmp(s,"CHUSER")==0) || (strcmp(s,"CU")==0)) {
=      write_inst(INST_LOC_CHUSER,0,INST_FLAGS_ONLINE);
=      chuser();
=    }
=    if (strcmp(s,"CLOUT")==0) {
=      npr("\r\nNot Yet.\r\n");
=    /*  force_callout(2); */
=    }
=    if (strncmp(s,"DEBUG",5)==0) {
=      if((s[5]) && (s[5]!=' '))
=        debuglevel=s[5]-'0';
=      else if(s[6])
=        debuglevel=s[6]-'0';
=    }
=    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
=      write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,3));
+      wwivsys(DIREDIT);
=    }
=    if (strcmp(s,"DOS")==0) {
=      if (checkpw()) {
=        write_inst(INST_LOC_DOS,0,INST_FLAGS_ONLINE);
=        sysoplog(get_stringx(1,6));
=        extern_prog(getenv("COMSPEC"), EFLAG_SHRINK|EFLAG_COMIO|EFLAG_ABORT);
=      }
=    }
=    if ((strcmp(s,"EDIT")==0)) {
=      if (checkpw()) {
=        write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
=        nl();
=        prt(2,get_string(7));
=        input(s1,50);
=        if (s1[0]) {
=          if ((okansi()) && (thisuser.defed))
=            external_edit(s1,"",thisuser.defed-1,500,".",s1,1);
=          else
=            tedit(s1);
=        }
=      }
=    }
=    if ((strcmp(s,"GFILEEDIT")==0) || (strcmp(s,"GE")==0)) {
=      write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,5));
+      wwivsys(GFILEEDITOR);
=    }
=    if (strcmp(s,"LOAD")==0) {
=      nl();
=      prt(2,get_string(7));
=      input(s1,50);
=      if (s1[0]) {
=        nl();
=        prt(5,get_string(17));
=        if (yn()) {
=          nl();
=          load_workspace(s1,0);
=        } else {
=          nl();
=          load_workspace(s1,1);
=        }
=      }
=    }
=    if (strcmp(s,"MAILR")==0) {
=      if (checkpw()) {
=        write_inst(INST_LOC_MAILR,0,INST_FLAGS_ONLINE);
=        sysoplog(get_stringx(1,8));
=        mailr();
=      }
=    }
=    if ((strcmp(s,"REBOOT")==0) && (checkpw())) {
=      write_inst(INST_LOC_REBOOT,0,INST_FLAGS_ONLINE);
=      dtr(0);
=      sysoplog(get_stringx(1,7));
=      logoff();
=      sl1(1,"");
=      if (ok_modem_stuff)
=        closeport();
=      close_strfiles();
=      Wait(3.0);
=#ifdef __OS2__
=      sprintf(s2, "/IBD:%c", syscfg.ramdrive);
=      execlp("setboot.exe", "setboot.exe", s2, NULL);
=#else
=      setvect(0xff,(void interrupt (*) ()) MK_FP(0xffff,0x0000));
=      geninterrupt(0xff);
=#endif
=    }
=    if (strcmp(s,"RELOAD")==0) {
=      write_inst(INST_LOC_RELOAD,0,INST_FLAGS_ONLINE);
=      read_new_stuff();
=    }
=    if (strcmp(s,"RESETF")==0) {
=      write_inst(INST_LOC_RESETF,0,INST_FLAGS_ONLINE);
=      reset_files();
=    }
=    if (strcmp(s, "RESETQSCAN")==0) {
=      prt(5,get_string(970));
=      if (yn()) {
=        write_inst(INST_LOC_RESETQSCAN,0,INST_FLAGS_NONE);
=        for (i=0; i<=number_userrecs(); i++) {
=          read_qscn(i, qsc, 1);
=          memset(qsc_p,
=                 0,
=                 syscfg.qscn_len - 4*(1+((max_dirs+31)/32)+((max_subs+31)/32)));
=          write_qscn(i, qsc, 1);
=        }
=        read_qscn(1, qsc, 0);
=        close_qscn();
=      }
=    }
=    if (strcmp(s,"STAT")==0) {
=      read_status();
=      nl();
=#ifndef __OS2__
=      outstr(get_string(18));
=      pln(_stklen);
=#endif
=      outstr(get_string(19));
=      npr("%dk\r\n", (int) (farcoreleft()/1024));
=      outstr(get_string(20));
=      npr("%d%%\r\n", cachestat());
=      outstr(get_string(938));
=      npr("%lu\r\n",status.qscanptr);
=      nl();
=    }
=  }
=    if (strcmp(s,"PACK")==0) {
=      nl();
=      prt(5, get_string(1505));
=      if (yn())
=        pack_all_subs();
=      else
=        pack_sub(usub[cursub].subnum);
=    }
=  }
=/**************************************************/
=  if (cs()) {
=    if (strcmp(s,"IVOTES")==0) {
=      write_inst(INST_LOC_VOTE,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,11));
+      wwivsys(IVOTE);
=    }
=    if (strcmp(s,"LOG")==0) {
=      slname(date(), s1);
=      print_local_file(s1,"");
=    }
=    if (strcmp(s,"NLOG")==0) {
=      print_local_file("NET.LOG","");
=    }
=    if (strcmp(s,"PENDING")==0) {
=      print_pending_list();
=    }
=    if (strcmp(s,"STATUS")==0) {
=      prstatus();
=    }
=    if (strcmp(s,"TEDIT")==0) {
=      write_inst(INST_LOC_TEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,12));
=      text_edit();
=    }
=    if ((strcmp(s,"UEDIT")==0) || (strcmp(s,"UE")==0)) {
=      write_inst(INST_LOC_UEDIT,0,INST_FLAGS_ONLINE);
=      sysoplog(get_stringx(1,10));
+      wwivsys(UEDIT);
=    }
=    if (strcmp(s,"VOTEPRINT")==0) {
=      write_inst(INST_LOC_VOTEPRINT,0,INST_FLAGS_ONLINE);
=      voteprint();
=    }
=    if (strcmp(s,"YLOG")==0) {
=      read_status();
=      print_local_file(status.log1,"");
=    }
=    if (strcmp(s,"ZLOG")==0) {
+      wwivsys(ZLOG);
=    }
+    if (strcmp(s, "WWIVSYS")==0) {
+        wwivsys(0);
+    }
=    if ((strcmp(s,",")==0) && ((net_sysnum>0) || (net_num_max>1))) {
=      nl();
=      prt(2,get_string(23));
=      ch=onek("Q012");
=      switch(ch) {
=        case '0': print_local_file(get_string(1027),""); break;
=        case '1': print_local_file(get_string(1028),""); break;
=        case '2': print_local_file(get_string(1029),""); break;
=      }
=    }
=    if (strcmp(s,"/?")==0) {
=      printmenu(5);
=    }
=  }
=/*************************************************/

Lower in function dlmainmenu:

=    if ((strcmp(s,"DIREDIT")==0) || (strcmp(s,"DE")==0)) {
=      sysoplog(get_stringx(1,3));
+      wwivsys(DIREDIT);
=    }
=
=    if (strncmp(s,"DEBUG",5)==0) {

Load BBS.C and modify the following at the top of the file:

#define _DEFINE_GLOBALS_
=#include "vars.h"
=#include "subxtr.h"
=#include <math.h>
+#include "wwivsys.h"
=
=#ifdef __OS2__

Then, in function getcaller:

=        case 'B':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_BOARDEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(BOARDEDIT);
=            cleanup_net();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'C':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_CHAINEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(CHAINEDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'D':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_DIREDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(DIREDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'W':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_TEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
=            text_edit();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'F':
=          if (ok_local()) {
=            write_inst(INST_LOC_DOS,0,INST_FLAGS_NONE);
=            holdphone(1);
=            nl();
=            pl(get_string(43));
=            nl();
=            setvect(save_dos,NULL);
=            do_remote(getenv("COMSPEC"),0);
=            setvect(save_dos, getvect(INT_REAL_DOS));
=            out1ch(12);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'G':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_GFILEEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(GFILEEDITOR);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'I':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_VOTEEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
*            wwivsys(IVOTE);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'J':
=          if (ok_local()) {
=            holdphone(1);
=            edit_confs();
=            holdphone(0);
=          }
=          break;
=        case 'K':
=          if (ok_local()) {
=            usernum=1;
=            useron=1;
=            holdphone(1);
=            okskey=1;
=            prt(2,get_string(44));
=            input(s,50);
=            load_workspace(s,0);
=            send_email();
=            okskey=0;
=            useron=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'L':
=          if (ok_local()) {
=            read_status();
=            slname(date(), s);
=            print_local_file(s,status.log1);
=          }
=          break;
=        case 'M':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_MAILR,0,INST_FLAGS_NONE);
=            holdphone(1);
=            mailr();
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'N':
=          if (ok_local())
=            print_local_file("NET.LOG","NETDAT*.LOG");
=          break;
=        case 'P':
=          if (ok_local())
=            print_pending_list();
=          break;
=        case 'Q':
=          end_bbs(QUIT_LEVEL);
=          break;
=        case 27:
=          outstr(get_string(1043));
=          if (yn())
=            end_bbs(QUIT_LEVEL);
=          clrscrb();
=          break;
=        case 'R':
=          if (ok_local()) {
=            usernum=1;
=            holdphone(1);
=            okskey=1;
=            readmail();
=            okskey=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'S':
=          if (ok_local()) {
=            prstatus();
=            getkey();
=          }
=          break;
=        case 'T':
=          if ((ok_local()) && (syscfg.terminal[0])) {
=            if (syscfg.sysconfig & sysconfig_shrink_term)
=              shrink_out(syscfg.terminal,0,0,0,1);
=            else
=              run_external(syscfg.terminal);
=            imodem(1);
=            imodem(0);
=          }
=          break;
=        case 'U':
=          okskey=1;
=          if (ok_local()) {
=            write_inst(INST_LOC_UEDIT,0,INST_FLAGS_NONE);
=            holdphone(1);
+            wwivsys(UEDIT);
=            holdphone(0);
=          }
=          okskey=0;
=          break;
=        case 'E':
=          if (ok_local()) {
=            usernum=1;
=            useron=1;
=            holdphone(1);
=            okskey=1;
=            send_email();
=            okskey=0;
=            useron=0;
=            write_user(1,&thisuser);
=            cleanup_net();
=            holdphone(0);
=          }
=          break;
=        case 'X':
=          for(i=0;i<50;i++) {
=            if(xenviron[i]!=NULL)
=              npr("\r\nxenv %d=%s",i,xenviron[i]);
=          }
=          npr("\r\nreal=%x, new=%x",INT_REAL_DOS,save_dos);
=          nl();
=          pausescr();
=        break;
=        case 'Y':
=          if (ok_local()) {
=            read_status();
=            slname(date(), s);
=            print_local_file(status.log1,s);
=          }
=          break;
=        case 'Z':
=          if (ok_local()) {
*            wwivsys(ZLOG);
=            nl();
=            getkey();
=          }
=          break;
=        case '/':
=          if ((net_sysnum) && (ok_local()))
=            force_callout(0);
=          break;
=        case '.':
=          if ((net_sysnum) && (ok_local()))
=            force_callout(1);
=          break;
=        case ',':
=          if ((net_sysnum>0) || (net_num_max>1) && ok_local()) {
=            nl();
=            prt(2,get_string(23));
=            ch=onek("Q012");
=            switch (ch) {
=              case '0':
=                print_local_file(get_string(1027),"");
=                break;
=              case '1':
=                print_local_file(get_string(1028),"");
=                break;
=              case '2':
=                print_local_file(get_string(1029),"");
=                break;
=            }
=          }
=          break;
=        case '`':
=          if ((net_sysnum) && (ok_local())) {
=            holdphone(1);
=            print_net_listing(1);
=            holdphone(0);
=          }
=          break;
=        case 9:
=          if (ok_local()) {
=            holdphone(1);
=            instance_edit();
=            holdphone(0);
=          }
=          break;
+        case '@':
+          if (ok_local()) {
+            holdphone(1);
+            wwivsys(0);
+            holdphone(0);
+          }
+          break;
=      }
=      if (!incom && !lokb) {

[Step 3]

Load BBSOVL1.C and do the following addition:

=#include "vars.h"
=
=#pragma hdrstop
=
=#include "subxtr.h"
=
=#include "ripint.h"
+#include "wwivsys.h"
=
=#define FRAME 7


Same here, step A is if you keep internal functions, step B is if you wish to
remove them.


[Step 3a]

Load BBSOVL1.C and replace function edit_confs:

void edit_confs(void)
{
  char ch;

  if (!checkpw())
    return;

  nln(2);
  pl(get_string(1023));
  nl();
  pl(get_string(1024));
  pl(get_string(1025));
  nl();
  outstr(get_string(1026));
  ch=onek("12Q");
  switch (ch) {
    case '1':
      if (incom)
        conf_edit(CONF_SUBS);
      else
        wwivsys(CONFBOARD);
      break;
    case '2':
      if (incom)
        conf_edit(CONF_DIRS);
      else
        wwivsys(CONFDIR);
      break;
    default:
      break;
  }
}

Save BBSOVL1.C

[Step 3b]

Load BBSOVL1.C and replace function edit_confs:

void edit_confs(void)
{
  char ch;

  if (!checkpw())
    return;

  nln(2);
  pl(get_string(1023));
  nl();
  pl(get_string(1024));
  pl(get_string(1025));
  nl();
  outstr(get_string(1026));
  ch=onek("12Q");
  switch (ch) {
    case '1':
      wwivsys(CONFBOARD);
      break;
    case '2':
      wwivsys(CONFDIR);
      break;
    default:
      break;
  }
}

Save BBSOVL1.C

[Step 4]

Load READMAIL.C

=#include "vars.h"
=
=#pragma hdrstop
=
+#include "wwivsys.h"

Same here, step A is if you keep internal functions, step B is if you wish to
remove them.

[Step 4a]

Load READMAIL.C and edit function readmail:

=              valuser(m.fromuser);
*            else if (ch=='U') {
+              if (incom)
=                uedit(m.fromuser,0);
+              else
+                wwivsys(UEDIT);
*            } else {
+              if (incom)
=                uedit(m.fromuser,3);
+              else
+                wwivsys(UEDIT);
+            }
=          else if (cs()) {
=            nl();
=            pl(get_string(722));

Save READMAIL.C

[Step 4b]

Load READMAIL.C and edit function readmail:

=              valuser(m.fromuser);
*            else if (ch=='U') {
+              wwivsys(UEDIT);
*            } else {
+              wwivsys(UEDIT);
+            }
=          else if (cs()) {
=            nl();
=            pl(get_string(722));

Save READMAIL.C

[Step 5]

If you have selected to remove internal function, here is a list of the
functions you can now delete. Simply search for those functions and delete
them entirely. DO NOT remove the other functions in the file, if there is no
more functions in the C file, you can remove it from the makefile if you wish.

/* File: SUBEDIT.C */

void boarddata(int n, char *s);
void showsubs(void);
void modify_sub(int n);
void swap_subs(int sub1, int sub2);
void insert_sub(int n);
void delete_sub(int n);
void boardedit(void);

/* File: CHNEDIT.C */

void chaindata(int n, char *s);
void showchains(void);
void modify_chain(int n);
void insert_chain(int n);
void delete_chain(int n);
void chainedit(void);

/* File: DIREDIT.C */

void dirdata(int n, char *s);
void showdirs(void);
void modify_dir(int n);
void swap_dirs(int dir1, int dir2);
void insert_dir(int n);
void delete_dir(int n);
void dlboardedit(void);


/* File: GFLEDIT.C */

void gfiledata(int n, char *s);
void showsec(void);
int exist_dir(char *s);
void modify_sec(int n);
void insert_sec(int n);
void delete_sec(int n);
void gfileedit(void);


/* File: VOTEEDIT.C */

void print_quests(void);
void set_question(int ii);
void ivotes(void);

/* File: UEDIT.C */

void print_data(int un, userrec *u, int lng, int cls);
int matchuser(int un);
int match_user(userrec *u);
void changeopt(void);
void uedit(int usern, int other);


/* File: SYSOPF.C */

void zlog(void);

[Step 6]

Copy WWIVSYS.H in your source directory

[Step 7]

PULLDOWN MENU ENTRY

Load BBS.C and do the following change to function getcaller:

=      wfc=1;
=    }
=    okskey=0;
*    ch=upcase(getch());
=    if (ch) {
=      wfc=2;
=      any=1;
=      switch(ch) {
+        case 59:
+          pulldown_menu();
+          break;
=        case '=':
=          if (ok_local()) {
=            holdphone(1);
=            reset_files();

[Step 8]

Load CONIO.C and do this small change in function skey:

=        set_autoval(ch-104);
=      } else {
=        switch ((unsigned char) ch) {
=          case 59: /* F1 */
+            if (exist("SYS.EXE"))
+              pulldown_menu();
+            else
=              val_cur_user();
=            break;
=          case 60: /* F2 */

[Step 9]

Load BBSOVL2.C and copy the following functions at the end of the file:

#include "wwivsys.h"

void menu_item(int which, int select, int lgt)
{
  char s[80],s1[80],s2[80];

  curatr=select ? 0x3f : 0x1f;
  switch(which)
  {
    case 0:
      movecsr(4,1);
      strcpy(s,"Editors");
      break;
    case 1:
      movecsr(27,1);
      strcpy(s,"Utilities");
      break;
    case 2:
      movecsr(48,1);
      strcpy(s,"System Info");
      break;
    case 3:
      movecsr(4,4);
      strcpy(s,wfc?"Tetrix":"Online Editor");
      break;
    case 4:
      movecsr(4,5);
      strcpy(s,"Board Editor");
      break;
    case 5:
      movecsr(4,6);
      strcpy(s,"Dir Editor");
      break;
    case 6:
      movecsr(4,7);
      strcpy(s,"Door Editor");
      break;
    case 7:
      movecsr(4,8);
      strcpy(s,"Gfile Editor");
      break;
    case 8:
      movecsr(4,9);
      strcpy(s,"SubConf Editor");
      break;
    case 9:
      movecsr(4,10);
      strcpy(s,"DirConf Editor");
      break;
    case 10:
      movecsr(4,11);
      strcpy(s,"User Editor");
      break;
    case 11:
      movecsr(4,12);
      strcpy(s,"INI Switches");
      break;
    case 12:
      movecsr(4,13);
      strcpy(s,"INI Editor");
      break;
    case 13:
      movecsr(4,14);
      strcpy(s,wfc?"Who's Online":"Show User Info");
      break;
    case 20:
      movecsr(27,4);
      strcpy(s,"String Editor");
      break;
    case 21:
      movecsr(27,5);
      strcpy(s,"SubList Selector");
      break;
    case 22:
      movecsr(27,6);
      strcpy(s,"SSM Editor");
      break;
    case 23:
      movecsr(27,7);
      strcpy(s,"Network Editor");
      break;
    case 24:
      movecsr(27,8);
      strcpy(s,"CALLOUT.NET Editor");
      break;
    case 25:
      movecsr(27,9);
      strcpy(s,"Vote Editor");
      break;
    case 26:
      movecsr(27,10);
      strcpy(s,"Backup");
      break;
    case 40:
      movecsr(47,4);
      strcpy(s,"Acitivity Log");
      break;
    case 41:
      movecsr(47,5);
      strcpy(s,"Statistics");
      break;
    case 42:
      movecsr(47,6);
      strcpy(s,"BBS Informations");
      break;
    case 43:
      movecsr(47,7);
      strcpy(s,"WWIVsys Config");
      break;
    case 44:
      movecsr(47,8);
      strcpy(s,"WWIVsys Main Menu");
      break;
  }
  sprintf(s1,lgt ? " %%-%ds" : " %%s " ,lgt);
  sprintf(s2,s1,s);
  outfast(s2);
}

void prst(char *stat, char *val,char *stat2, char *val2)
{
  char s[80];

  sprintf(s,"%-13s: ",stat);
  outfast(s);
  curatr--;
  outfast(val);
  curatr++;
  movecsr(55,WhereY());
  sprintf(s,"%-11s: ",stat2);
  outfast(s);
  curatr--;
  outfast(val2);
  curatr++;
  movecsr(8,WhereY()+1);
}

void user_stats(void)
{
  char s[81],ar[17],dar[17],restrict[17],rst[17];
  int i;

  strcpy(rst,restrict_string);
  for (i=0; i<=15; i++) {
    if (thisuser.ar & (1 << i))
      ar[i]='A'+i;
    else
      ar[i]=32;
    if (thisuser.dar & (1 << i))
      dar[i]='A'+i;
    else
      dar[i]=32;
    if (thisuser.restrict & (1 << i))
      restrict[i]=rst[i];
    else
      restrict[i]=32;
  }
  dar[16]=0;
  ar[16]=0;
  restrict[16]=0;

  makewindow(6,8,72,12);
  movecsr(8,9);
  prst("User Handle",thisuser.name,"User Lev",itoa(thisuser.sl,s,10));
  prst("Real Name",thisuser.realname,"Xfer Lev",itoa(thisuser.dsl,s,10));
  prst("Phone",thisuser.phone,"Uploaded",itoa(thisuser.uploaded,s,10));
  prst("Computer",ctypes[thisuser.comp_type],"Upload K",ltoa(thisuser.uk,s,10));
  prst("Password",thisuser.pw,"Downloaded",itoa(thisuser.downloaded,s,10));
  prst("ARs",ar,"Download K",ltoa(thisuser.dk,s,10));
  prst("DARs",dar,"User Gold",itoa(thisuser.gold,s,10));
  prst("Restriction",restrict,"Msg Read",ltoa(thisuser.msgread,s,10));
  prst("Last on",thisuser.laston,"Msg Posted",
              ltoa(thisuser.msgpost+thisuser.postnet,s,10));
  outfast("User Note    : ");
  curatr--;
  outfast(thisuser.note);
  curatr++;
  getchd();
}

char action(int acton)
{
  char exitm;
  char far *oldscr;

  oldscr=farmalloc(screenlen);

  _setcursortype(_NORMALCURSOR);
  exitm=0;
  memmove(oldscr,scrn,screenlen);
  curatr=0x4f;
  switch(acton)
  {
    case 3:
      if (wfc)
      {
        curatr=0x07;
        extern_prog("TETRIX", EFLAG_SHRINK|EFLAG_INTERNAL);
        curatr=0x4f;
      }
      else
        val_cur_user();
    break;
    case 4: wwivsys(BOARDEDIT); break;
    case 5: wwivsys(DIREDIT); break;
    case 6: wwivsys(CHAINEDIT); break;
    case 7: wwivsys(GFILEEDIT); break;
    case 8: wwivsys(CONFBOARD); break;
    case 9: wwivsys(CONFDIR); break;
    case 10: wwivsys(UEDIT); break;
    case 11: wwivsys(INISWITCH); break;
    case 12: wwivsys(INIEDITOR); break;
    case 13:
      if (wfc)
        wwivsys(WHO);
      else
        user_stats();
    break;
    case 20: wwivsys(STRINGEDIT); break;
    case 21: wwivsys(SUBLIST); break;
    case 22: wwivsys(SSMEDITOR); break;
    case 23: wwivsys(NETEDITOR); break;
    case 24: wwivsys(CALLOUT); break;
    case 25: wwivsys(IVOTE); break;
    case 26: wwivsys(BACKUP); break;
    case 40: wwivsys(ZLOG); break;
    case 41: wwivsys(STATISTICS); break;
    case 42: wwivsys(BBSINFO); break;
    case 43: wwivsys(CONFIG); break;
    case 44: wwivsys(0); break;
  }

  _setcursortype(_NOCURSOR);
  if (!exitm)
    memmove(scrn,oldscr,screenlen);
  farfree(oldscr);
  return(exitm);
}


char domenu(int *returncode,int lo,int numop, int mnus, int mnulen)
{
  int i,ch,pos,opos,done;
  char far *oldscr,rc;

  oldscr=farmalloc(screenlen);

  _setcursortype(_NOCURSOR);

  memmove(oldscr,scrn,screenlen);
  makewindow(mnus,3,mnulen,numop+3);
  for(i=lo;i<numop+lo+1;i++)
    menu_item(i,0,0);
  pos=0;
  done=0;
  rc=0;
  do {
    opos=pos+lo;
    menu_item(opos,1,mnulen-3);
    ch=getchd();
    
    if (ch==0)
    {
      ch=getchd();
      switch (ch)
      {
        case 59:
          done=1;
          *returncode=4;
         break;
         case 71: pos=0; break;
         case 79: pos=numop; break;
         case 80:
           if (pos<numop)
             pos++;
            else
             pos=0;
         break;
         case 72:
           if (pos>0)
             pos--;
           else
             pos=numop;
         break;
         case 75:
         case 15:
           done=1;
           *returncode=*returncode-1;
           if (*returncode<0)
             *returncode=2;
         break;
         case 77:
           done=1;
           *returncode=*returncode+1;
           if (*returncode>2)
             *returncode=0;
         break;
      }
    } else {
      switch(ch)
      {
        case 27:
          done=1;
          *returncode=4;
        break;
        case 13:
          rc=action(pos+lo);
          if (rc) {
            *returncode=4;
            done=1;
          }
        break;
      }
    }
    menu_item(opos,0,mnulen-3);
  } while (!done);

  memmove(scrn,oldscr,screenlen);
  farfree(oldscr);
  _setcursortype(_NORMALCURSOR);
  return(rc);
}




void pulldown_menu(void)
{
  int cp, done, i, tl;

  pr_Wait(1);
  tl=topline;
  topline=0;
  savescreen(&screensave);
  curatr=0x1f;
  makewindow(0,0,79,3);
  for(i=0;i<3;i++)
    menu_item(i,0,0);
  cp=0;
  done=0;
  while (!done) {
    i=curatr;
    if (cp<4)
      menu_item(cp,1,0);
    curatr=i;
    i=cp;
    switch(cp) {
    case 0: domenu(&cp,3,10,3,18); break;
    case 1: domenu(&cp,20,6,26,24); break;
    case 2: domenu(&cp,40,4,46,28); break;
    case 3:
      out1ch(7);
      cp=1;
      break;
    case 4:
      done=1;
      break;
    }
    menu_item(i,0,0);
  }
  restorescreen(&screensave);
  topline=tl;
  if (wfc)
    clrscr();
  else
    changedsl();
  pr_Wait(0);
}

[Step 10]

That's it, simply do a MAKE FCNS and recompile the entire system.

We recommand that you change the color of the F1 color in WWIV.INI to something
else, you'll see why.

To use WWIVsys command internally, it is quite simple, simply use:

                           wwivsys(CODENAME);

The list of the code names is available in WWIVSYS.H or by doing SYS -?.
Custumize them as you wish.

To activate Pulldown menus, press F1 either at WFC or either when a user is
on, if WWIVsys is not present, you will have the normal F1 menu, the menu
is a bit different at WFC, where you can load Tetrix (if present) and use the
Instance Monitor function (WWIVsys v1.6 and later).

French Proverb: La fortune vient en dormant.

For comments, bug report and suggestion, e-mail at the following address:

Nicolas LeBlanc  2@20302.WWIVnet (aka Spotnick)
                 -> spotnick@gamemaster.qc.ca
Martin Bourdages 242@20306 / 3@20302.WWIVnet (aka Dark Shadow)
                 -> martin.bourdages@radio.magicnet.com

                 =>   French Mod Division Support Sub   <=
                                SubType: FMD
                           Host: @20302 (WWIVnet)
                      Scan sublist for other networks

        Read PRODUCTS.FMD for the full list of our support systems.

[EOF]
