/*
WW4PAL.C
A WWIV Palette Changer by Xanth, IceNET #1 @9404, Internet aev@cis.ufl.edu
Last updated on June 23, 1996.

This program is designed to be run as a WWIV chain.  It will redefine
everyone's colors to match the user who runs it.  This is useful
for boards that have a paint coordinator, that is, someone in charge
with periodically changing the colors to make things interesting.

This source code is freeware and may be freely used, modified, and
distributed without credit to the author.  It has been compiled successfully
under Borland's Turbo C++ v3.0 for DOS.

A typical CHAINEDIT configuration might look like:

A. Description  : WWIV Palette Changer
B. Filename     : WW4PAL.EXE %1 putpasswordhere
C. SL           : 10
D. AR           : None.
E. ANSI         : Optional
F. DOS Interrupt: Used      !!! THIS OPTION MUST BE SET TO "USED" !!!
G. 300 Baud     : Allowed
H. Shrink       : Yes
I. Disable pause: Yes
J. Local only   : No
K. Multi user   : No
L. Registered by: MAHARET
M. Usage        : 21
N. Age limit    : 0 - 255
R. RIP mode     : Optional

*/

#include <stdio.h>
#include <dir.h>
#include "vardec.h"

int yesno (void);

/***************************************************************************/

void main (int argc, char *argv[])
{
    char *initial  = "\r";
    char *progress = "";
    char temp[80];
    char userdata[MAXPATH];
    FILE *fp;
    int  usernum,
         numusers,
         i,
         j;
    float sofar;
    userrec master,
            tmpusr;

    puts ("\n\nWWIV Palette Changer");
    puts ("A little program by Xanth, 1@9404.IceNET\n");
    if (argc < 3)
    {
        puts ("## USAGE: ww4pal <chain.txt> <password>");
        puts ("   Giving up...");
        exit (1);
    }

    printf ("Do you wish to change everyone's colors to match yours? ");

    if (!yesno())
    {
        puts ("\nVery well.  Now exiting...\n");
        exit (0);
    }

    printf ("\nPlease enter the Paint Coordinator Password: ");
    gets (temp);
    if (stricmp (temp, argv[2]) != 0)
    {
        puts ("\nYou did not enter the correct password.  Butthead.");
        puts ("Now exiting...\n");
        exit (0);
    }

    fp = fopen (argv[1], "rt");
    fgets (temp, sizeof (temp), fp); // grab the user number off the 1st line
    usernum = atoi (temp);           // and convert from string to integer
    for (i = 1; i < 17; i++)         // move to the end of line #17
        fgets (temp, sizeof (temp), fp);

    fgets (userdata, sizeof (userdata), fp);  // grab datadir off line #18
    userdata[strlen (userdata) - 1] = '\0';  // strip trailing \n
    fclose (fp);

    strcat (userdata, "USER.LST");
    fp = fopen (userdata, "r+b");
    fseek (fp, 0L, SEEK_END);
    numusers = ftell (fp) / sizeof (userrec);
    numusers--;  // on account of the unused zeroth record
    rewind (fp);
    fseek (fp, usernum * sizeof (userrec), SEEK_SET);
    fread (&master, sizeof (userrec), 1, fp);
    puts ("");
    printf (initial);
    for (i = 1; i < numusers; i++)
    {
        sofar = (float) i / (float) numusers;
        sofar *= strlen (progress);
        printf ("%.*s\r", (int) sofar+1, progress);
        fseek (fp, i * sizeof (userrec), SEEK_SET);
        fread (&tmpusr, sizeof (userrec), 1, fp);
        for (j = 0; j < 10; j++)
        {
            tmpusr.colors[j] = master.colors[j];
            tmpusr.bwcolors[j] = master.bwcolors[j];
        }
        fseek (fp, i * sizeof (userrec), SEEK_SET);
        fwrite (&tmpusr, sizeof (userrec), 1, fp);
    }
    fclose (fp);
    puts ("\nDone!");
}

/***************************************************************************/

int yesno (void)
{
    int inchar;

    repeat:
    inchar = toupper (getch());

    if ( (inchar == 'Y') || (inchar == '\r') )
    {
        printf ("Yes\n");
        return 1;
    } else if (inchar == 'N')
    {
        printf ("No\n");
        return 0;
    } else goto repeat;  // My regards to Edsgar Dijkstra
}

/***EOF*********************************************************************/

