; // sample ERRFLAGS.CTL suitable for RC20 //
;
; Key word ZONE states default zone.
ZONE 2
;
; Key word NET states default net, and is only really necessary for hub
; level segment checks.
NET 204
;
; Key word NOTOUCH can be used to instruct ErrFlags not to change the
; submitted nodelist segment, making it possible to just send notifications
; on errors in the segment, instead of fixing other peoples problems.
;NOTOUCH
;
; Key word TABFILE can be used to override the default file name of the
; approved flag file table
;TABFILE ERRFILE.TAB
;
; Key word CMTFILE can be used to override the default file name of the
; comment file.
;CMTFILE ERRFILE.CMT
;
; Key word INBOUND states the directory where inbound segment files are to
; be found. Default value is currect directory
INBOUND C:\FD\NETFILE
;
; Key word FILE states the filename of the updates to check and who should
; recieve the notification for the particular file (If using the
; notification function). Up to 80 file names are supported.
; It is also possible to name the report file. Default report file name
; is input file name with extension RPT.
;      file name      Notify   [report file]
FILE   NET200.UPD     200/0    REP200.TXT
FILE   NET201.UPD     201/0    REP201.TXT
FILE   NET203.UPD     203/0    REP203.TXT
FILE   NET204.UPD     204/0    REP204.TXT
FILE   NET205.UPD     205/0    REP205.TXT
FILE   NET206.UPD     206/0    REP206.TXT
;
; Key word NOTIFY states the robot program and parameters to mail
; the notification file. This might also be a batch file if You wish 
; to process more than one notification for each file.
; The macros %node% and %file% will be expanded to the notify address
; and report file name.
; The example below uses the AUTOMAIL program by Mats Wallin, but any
; program capable of creating a netmail from a text file will suffice.
NOTIFY AUTOMAIL %node% -F "Flag errors" -T %file% -c
;
; Key word NOTIFYPATH states the directory that ErrFlags should execute
; the notification command in. Note that the %file% macro above only contains
; an unqualified filename, so you'll have to add the full path of the report
; file if you use this key word. The report file is created in the program
; directory.
NOTIYPATH C:\FD\ERRFLAGS
;
; Key word EXECUTE states any program to execute if any files has been
; processed. This makes it possible for executing MakeNl only when files
; has actually been received.
EXECUTE MAKENL.EXE REGION.CTL /P >> MAKENLOG.LOG
;
; Key word EXECUTEPATH states the directory that ErrFlags should execute
; the above program.
EXECUTEPATH C:\FD\MAKENL
;
; // end of file //
