; MMLG Control File

; All lines preceeded by a semi-colon are comments and are ignored.
; Order of keywords in this control file is irrelevant.

;------------------------------------------------------------------------------
; This is your Maximus directory where the FAREA.DAT and FAREA.IDX files
; are located.
; (Necessary)

MaxDir P:\MAX3

;------------------------------------------------------------------------------
; This is the list of all the files on your system
; Default is not to create one

MasterList ALLFILES.LST

;------------------------------------------------------------------------------
; This is the list of the new files on your system
; Default is not to create one

NewList NEWFILES.LST

;------------------------------------------------------------------------------
; This is list of the directories accessable
; Default is not to create one

DirList FREQ.CTL

;------------------------------------------------------------------------------
; Where to write the log.
; Default is no log.

LogFile MMLG.LOG

;------------------------------------------------------------------------------
; Amount of information to log (1-6)
; Default = 6

;LogLevel 3

;------------------------------------------------------------------------------
; Priv level to match for file areas.  Only areas accessable to users with
; this priv level will be listed.  To include keys, add a / to the priv
; level and then list the keys (eg. Normal/123)
; Default = Normal

;Priv Worthy/1

;------------------------------------------------------------------------------
; Include the following:
; (Optional)

;Include Comments         Any line in FILES.BBS that is not a file spec
Include AreaTotals       Total bytes and files in each area
Include GrandTotal       Total bytes and files for all areas

;------------------------------------------------------------------------------
; Header file will appear at the top of the list file
; (Optional)

HeaderFile BBSINFO.TXT

;------------------------------------------------------------------------------
; Extra file will appear after the canned title box and the first area
; (Optional)

ExtraFile EXTRA.FIL

;------------------------------------------------------------------------------
; Footer file will appear after the grand total but before the canned
; copyright box
; (Optional)

FooterFile FOOTER.FIL

;------------------------------------------------------------------------------
; Wrap Margin for long descriptions
; Default = 32

WrapMargin 38

;------------------------------------------------------------------------------
; Type of boxes:
;    0 = + (ASCII)
;    1 =  (Single line)
;    2 =  (Double line)
;    3 =  (Double horizontal)
;    4 =  (Double vertical)
; Default = 1

Box 2

;------------------------------------------------------------------------------
; Flag new files within this many days
; Default = 7

New Days 14

;------------------------------------------------------------------------------
; Flag new files with this character
; Default = *

;New Char %

;-----------------------------------------------------------------------------
; Show file size in K rather than bytes
; (Optional)

;Kilobytes

;------------------------------------------------------------------------------
; Change Format of the date.
; (Optional - default is M/D/Y)

;Date D/M/Y
;Date Y/M/D

;------------------------------------------------------------------------------
; Show files that are (offline)
; (Optional)

ShowOffline

;------------------------------------------------------------------------------
; Use this line if the file has no description.
; Default="(no description available)".

;NoDesc (Sorry, I don't know what this file is)

;------------------------------------------------------------------------------
; Use this line to insert commas into large numbers.
; Default is no commas.

NiceNumbers

;------------------------------------------------------------------------------
; Use this line to include a summary of the files and bytes for all the
; included areas.

Summary

;------------------------------------------------------------------------------
; Use this line to save the summary in this file instead of the master file.
; Default is to include the summary in the master file.

;SummaryFile SUMMARY.LST

;------------------------------------------------------------------------------
; Schedules

;         Name_Of_Schedule  Areas_To_Include_In_Generated_List...
;         (one word name)   (can be an area name, or a numeric range)

Schedule  SDS               SMAX SFD 41 65
Schedule  PDN               PPAS 1-20 23 40-100
Schedule  PICS              PICS XRTD ANI FAM 
Schedule  PICS              4 5 7 12 20-29
Schedule  HD                1-71 
Schedule  PICS              PIC*
