@echo off
rem:RAPSA v1.0 - RemoteAccess Paging Status Adjuster by Jason Raphael, 2-8-96.
rem:

cls
if "%RA%" == "" goto error1
if not exist %RA%\RA.EXE goto error2
if "%1" == "" goto help
goto %1

:ERROR1
echo.
echo [30;1m [37;1mRAPSA ERROR:
echo   [0;37mRemoteAccess environment variable not set.  Please set the RA environment 
echo   variable to your RemoteAccess system path, or see RAPSA.DOC for more 
echo   information.  Ex: SET RA=D:\RA
echo.
echo  RAPSA ERROR: >>d:\rapsa.err
echo   RemoteAccess environment variable not set.  Please set the RemoteAccess >>d:\rapsa.err
echo   environment variable to your RemoteAccess system path, or see RAPSA.DOC >>d:\rapsa.err
echo   for more information.  Ex: SET RA=D:\RA >>d:\rapsa.err
pause
goto end

:ERROR2
echo.
echo [30;1m [37;1mRAPSA ERROR:
echo   [0;37mRemoteAccess environment variable set incorrectly.  Please set 
echo   the RA environment variable to your RemoteAccess system path, or see 
echo   RAPSA.DOC for more information.  Ex: SET RA=D:\RA
echo.
echo  RAPSA ERROR: >>d:\rapsa.err
echo   RemoteAccess environment variable set incorrectly.  Please set >>d:\rapsa.err
echo   the RA environment variable to your RemoteAccess system path, or see >>d:\rapsa.err
echo   RAPSA.DOC for more information.  Ex: SET RA=D:\RA >>d:\rapsa.err
pause
goto end

:ERROR3
echo.
echo [30;1m [37;1mRAPSA ERROR:
echo   [0;37mAt least one of the RAPSA system files are not located in your
echo   RemoteAccess system directory.  Please make sure that RAPSA.BAT, PAGEON,
echo   PAGEOFF, and PAGEHRS are in your RA system directory.
echo.
echo  RAPSA ERROR: >>d:\rapsa.err
echo   At least one of the RAPSA system files are not located in your >>d:\rapsa.err
echo   RemoteAccess system directory.  Please make sure that RAPSA.BAT, PAGEON, >>d:\rapsa.err
echo   PAGEOFF, and PAGEHRS are in your RA system directory. >>d:\rapsa.err
pause
goto end

:?
cls
echo.
echo [30;1m [37;1mRAPSA v1.0
echo.
Choice [0;37mTurn paging ON, OFF, use paging HOURS, or ABORT[0;36m /C:NFHA
If errorlevel 4 goto abort
If errorlevel 3 goto hrs
If errorlevel 2 goto off
If errorlevel 1 goto on
goto end

:OFF
del %RA%\pagestat.ra
echo 2>>%RA%\pagestat.ra
cls
echo.
echo [30;1m [37;1mPaging is now off.[0;37m
echo.
goto end

:ON
del %RA%\pagestat.ra
echo 3>>%RA%\pagestat.ra
cls
echo.
echo [30;1m [37;1mPaging is now on.[0;37m
echo.
goto end

:HRS
del %RA%\pagestat.ra
echo 1>>%RA%\pagestat.ra
cls
echo.
echo [30;1m [37;1mPaging hours will now be used.[0;37m
echo.
goto end

:HELP
echo [30;1m [37;1mNo commandline parameters specified.  Syntax:
echo.
echo [0;37mRAPSA ON [0;36m(Toggles paging on)
echo [0;37mRAPSA OFF [0;36m(Toggles paging off)
echo [0;37mRAPSA HRS [0;36m(Uses paging hours as defined in RACONFIG)
echo [0;37mRAPSA ? [0;36m(Allows you to select from a menu)[0;37m
echo.
goto end

:ABORT
cls
echo.
echo [30;1m [37;1mAborted.[0;37m
echo.

:END
