// T.A.G. Bulletin Board System
// Copyright (c) 1986-1994 by The T.A.G. Team
// All rights reserved.
//
//                    ----------------------------------
//                    T.A.G. Version 2.7 Data Structures
//                    ----------------------------------
//             Converted from Turbo Pascal to C by Martin Pollard
//
// All we ask if you use these record structures is to give credit where
// credit is due.
//
// Additional structure information may be given out on an individual
// basis depending on the situation.
//
// RELEASE HISTORY:
//
// 01/24/93 - Initial release.
// 02/17/93 - Corrected errors in definitions for SystatRec, ModemRec, and
//            MboardType.
// 04/27/93 - Re-Released without change for version 2.6e (Paul Williams)
// 09/01/93 - Updated for version 2.6f (Victor Capton)
// 05/09/94 - Updated for version 2.7 (Victor Capton)
// 10/01/94 - Modified for 32-bit DOSX programming (Mike Owen)

#ifndef __TAGREC_H      // Prevents header from being included
#define __TAGREC_H      // twice in the same program or module

#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char Boolean;  // C equivalent for TP "boolean" type
                                // (0 is FALSE, non-0 is TRUE)
typedef unsigned char Byte;     // C equivalent for TP "byte" type
typedef unsigned char Char;     // C equivalent for TP "char" type
                                // (ensures values in 0..255 range)
typedef short Integer;          // C equivalent for TP "integer" type
typedef long Longint;           // C equivalent for TP "longint" type
typedef unsigned short Word;    // C equivalent for TP "word" type

typedef unsigned char Real[6];  // C has no equivalent for TP "real" type!

typedef unsigned short Bit;     // shorthand operator for bit fields
                                // (ensures returning positive values)

// The following values are used by the system for user fields
// "ask"  values will be asked of the user the next time they logon if the
//        question is part of the new user logon
// "none" values are normally for optional fields where the user simply
//        pressed <enter>

#define USER_STRING_ASK     " "     // Ask for user string fields
#define USER_STRING_NONE    ""      // None for user string fields
#define USER_DATE_ASK       0xFE21  // Ask for user date fields - 1/1/2027
#define USER_DATE_NONE      0x0021  // None for user date fields - 1/1/0
#define USER_WORD_ASK       65535U  // Ask for user word fields
#define USER_WORD_NONE      65534U  // None for user word fields
#define USER_CHAR_ASK       '~'     // Ask for user character fields
#define USER_CHAR_NONE      ' '     // None for user character fields
#define USER_PHONE_ASK      " "     // Ask for user phone fields
#define USER_PHONE_NONE     ""      // None for user phone fields


#define DYN_DEFAULT     0           // Default
#define DYN_YES         1           // Yes
#define DYN_NO          2           // No

typedef Byte DefaultYesNoType;     // Default/yes/no type

typedef Char ArFlagType;        // AR flags (@..Z)
typedef Byte ArFlagset[4];      // Set of AR flags
                                // Byte 0 = bits 0..7 = Flags @..G
                                // Byte 1 = bits 0..7 = Flags H..O
                                // Byte 2 = bits 0..7 = Flags P..W
                                // Byte 3 = bits 0..2 = Flags X..Z

typedef struct      // User special flags
{
    unsigned char
        AutoPrivDel : 1,    // A = Force user to delete private mail
        NoPostCall : 1,     // B = No post call ratio
        ForceULScan : 1,    // C = Force this user to automatically scan
                            //     when uploading
        Ranon : 1,          // D = Restrict from posting anonymous
        RbbsList : 1,       // E = Restrict from adding to other BBS list
        Rchat : 1,          // F = Restrict from chatting
        NoDLlimit : 1,      // G = No download ratio limit
        RpubMsg : 1;        // H = Restrict from posting public mail
    unsigned char
        RprivMsg : 1,       // I = Restrict from sending private mail
        Rvoting : 1,        // J = Restrict from voting
        OneCall : 1,        // K = One call per day allowed
        PubNotVal : 1,      // L = Public posts are not validated
        ProtDel : 1,        // M = Protect from deletion
        NoFilePts : 1,      // N = No file point checks
        RfileVal : 1,       // O = Credit from upload on validation
        Pause : 1;          // P = [PAUSE] active
    unsigned char
        Ansi : 1,           // Q = ANSI graphics active
        Color : 1,          // R = Color active if ANSI present
        OneKey : 1,         // S = Onekey input used instead of line input
        Alert : 1,          // T = Alert active from user's next call
        FlagRecUnused : 1,  // U = Unused
        MboxClosed : 1,     // V = Mail box closed to all but SysOp's
        Tabs : 1,           // W = VT100 tabs are used to optimize display
        ClsChar : 1;        // X = Clear screen characters used
}
FlagSet;    // 3 bytes used for 24 flags in set

typedef struct
{
    unsigned char
        IsCdRom : 1,
        uuUlRecFlag1 : 1,
        uuUlRecFlag2 : 1,
        uuUlRecFlag3 : 1,
        uuUlRecFlag4 : 1,
        uuUlRecFlag5 : 1,
        uuUlRecFlag6 : 1,
        uuUlRecFlag7 : 1;

} UlRecFlagSet;


typedef struct      // User configuration flags
{
    unsigned char
        UseCustomMenus : 1,          // A = Allow custom ANSI menus
        ClsMsgRead : 1,              // B = Clear screen between reading messages
        DoNotDisturbUser : 1,        // C = Do not disturb user (multi-user only)
        LogonScanAllMsgSections : 1, // D = Scan all msg sections at logon for mail
        QWKNewBulletins : 1,         // E = Put new bulletins in QWK packet
        QWKNewFiles : 1,             // F = Put new files list in QWK packet
        uuCFFlag18 : 1,              // G = Reserved
        uuCFFlag17 : 1;              // H = Reserved
    unsigned char
        uuCFFlag16 : 1,              // I = Reserved
        uuCFFlag15 : 1,              // J = Reserved
        uuCFFlag14 : 1,              // K = Reserved
        uuCFFlag13 : 1,              // L = Reserved
        uuCFFlag12 : 1,              // M = Reserved
        uuCFFlag11 : 1,              // N = Reserved
        uuCFFlag10 : 1,              // O = Reserved
        uuCFFlag9 : 1;               // P = Reserved
    unsigned char
        uuCFFlag8 : 1,               // Q = Reserved
        uuCFFlag7 : 1,               // R = Reserved
        uuCFFlag6 : 1,               // S = Reserved
        uuCFFlag5 : 1,               // T = Reserved
        uuCFFlag4 : 1,               // U = Reserved
        uuCFFlag3 : 1,               // V = Reserved
        uuCFFlag2 : 1,               // W = Reserved
        uuCFFlag1 : 1;               // X = Reserved
}
ConfigFlagSet;      // 3 bytes used for 24 flags in set


// ColorRec = Array of B&W / Color  Color Bytes

typedef Byte ColorRec[2][10];   // ColorRec[0][x] = B&W
                                // ColorRec[1][x] = Color
                                // x = 0..9 = Actual Color Codes

typedef struct      // User name index - NAMES.LST
{
    Char Name[37];      // User name
    Integer Number;     // User number
}
SmalRec;

typedef struct      // User log - USER.LST
{
    Char Uname[37];             // User name
    Char Rname[37];             // Real name
    Char ADDR[31];              // Address
    Char ComType[31];           // Computer type
    Char CityState[31];         // City/State
    Char Snote[31];             // SysOp note

    Word LastDate;              // Last date on - Semi-MS-DOS 1900 based fmt
    Word LastTime;              // Last time on - MS-DOS format

    Char PW[17];                // Password
    Char Phone[13];             // Phone number 1
    Char Zcode[11];             // Zip code
    Char Phone2[13];            // Phone number 2

    Char ExtraStr1[41];         // Extra string 1
    Char ExtraStr2[41];         // Extra string 2
    Char ExtraStr3[41];         // Extra string 3

    Word ExtraDate1;            // Extra date 1 - Semi-MS-DOS 1900 based fmt
    Word ExtraDate2;            // Extra date 2 - Semi-MS-DOS 1900 based fmt

    Word ExtraWord1;            // Extra word 1
    Word ExtraWord2;            // Extra word 2
    Word ExtraWord3;            // Extra word 3
    Word ExtraWord4;            // Extra word 4

    Char ExtraChar1;            // Extra character 1
    Char ExtraChar2;            // Extra character 2
    Char ExtraChar3;            // Extra character 3
    Char ExtraChar4;            // Extra character 4

    Char ExtraPhone[13];        // Extra phone

    Byte uureserved[3];         // Reserved

    // Vote  = An array of Voting Answers, One for each question
    Byte Vote[20];              // Voting

    // Call spread for last 15 calls - Number  of days between each call:
    // 0      = Called the same day
    // 1..253 = X number of days between
    // 254    = 254 or more days between
    // 255    = Element not used yet
    Byte CallSpr[15];           // Call spread

    Real Ttimeon;               // Total time on system in minutes
    Real UlK;                   // UL K-Bytes
    Real Dlk;                   // DL K-Bytes

    // UserNum = The User number
    //           0  -----------------------------> Deleted
    //           Same as Record Number ----------> Normal
    //           Different from Record Number ---> Locked Out
    Integer UserNum;            // User number

    Word PrivPost;              // Private posts
    Word PubPost;               // Public posts
    Word FeedBack;              // Feedback sent to SysOp
    Word NumCalls;              // Total number of calls to system
    Word NumUL;                 // Number of uploads
    Word NumDL;                 // Number of downloads

    // Fmail = Status of Mail Forwarding
    //           0  --------> Forwarding inactive
    //           Other  ----> User Number to forward mail to
    Integer Fmail;              // Forward mail to which user number

    Word Hbaud;                 // Highest baud rate user supports
    Word TimeToday;             // Minutes on system date of last call
    Word Credit;                // Credit for mail in cents
    Word Debit;                 // Debit for mail in cents
    Word Points;                // File points
    Word TimeBank;              // Minutes in time bank
    Word Bday;                  // Birthdate of user - Semi-MS-DOS format
    Word LastChange;            // Reserved

    Byte StrtMenu;              // Reserved
    Byte SL;                    // Security level - SL
    Byte DSL;                   // Download security level - DSL
    Byte Hlvl;                  // Help level
    Byte Colms;                 // Number of screen columns
    Byte Lines;                 // Number of screen lines
    Byte Callstoday;            // Number of calls to system today
    Byte Illegal;               // Illegal logon attempts

    Char Gender;                // User gender M/F/' '=not specified

    Byte uulMsgBase;            // Reserved
    Byte uuLdlBase;             // Reserved
    Byte Cls;                   // Reserved

    DefaultYesNoType FullEdit;  // Full screen editor status

    ArFlagset Ar;               // AR flag set

    FlagSet Flags;              // Special flag set

    Word FirstOn;               // Date first on - Semi-MS-DOS format
    Word Expires;               // Date expires - Semi-MS-DOS format

    Byte UserRecUnused[29];     // Reserved

    ColorRec Colors;            // User colors

    Byte TBdeposit;             // Time deposited in bank today
    Byte TBwithdraw;            // Time withdraw from bank today

    Integer AdjTime;            // Adjusted time date of last call

    ConfigFlagSet ConfigFlags;  // Configuration Flags

    Word lMbase;                // Last message section
    Word lFbase;                // Last file section

    Longint LastQWKCRC;         // CRC of last QWK .REP packet uploaded

    Byte Unused;                // Reserved
}
UserRec;


typedef struct      // Short messages - SHORTMSG.DAT
{
    Char Msg[161];      // Message text
    Integer Destin;     // User number of who message is to
}
SmallMessageRec;


typedef struct      // Voting questions - VOTING.DAT
{
    Char Question[75];      // Question
    Word NumA;              // Number of answers in below array
    struct                  // Array of answer data
    {
        Char Ans[41];       // Answer
        Word NumRes;        // Number of users who chose this response
    }
    Answ[10];
}
Vdatar;


typedef struct      // File section - FBOARDS.DAT
{
    Char Name[40];          // Section name 26 Real Len, Rest Colors
    Char Filename[9];       // Listing filename (does not include ".DIR")
                            //   If UL and DL paths are different,
                            //     filename for upload section is "FILES"
                            //   If first character is "@" then *.DIR file
                            //     is found in main data files directory
    Char DlPathname[31];    // Download pathname
    Char UlPathName[31];    // Upload pathname
    Char Password[16];      // Password required
    UlRecFlagSet Flags;
    Byte DSL;               // DSL required
    Byte SeeNames;          // DSL required to see uploader names
    ArFlagType ArLvl;       // AR flag required
    Byte NoRatioGroupNum;   // Bit 0    = Ratio disabled
                            // Bits 1-7 = Group number
}
UlRec;


typedef struct      // Set of file flags
{
    unsigned char
        NotValidated : 1,       // File is not validated
        OwnerRestricted : 1,    // Uploader did not receive credit on upload
        uuF6 : 1,               // Reserved
        uuF5 : 1,               // Reserved
        uuF4 : 1,               // Reserved
        uuF3 : 1,               // Reserved
        uuF2 : 1,               // Reserved
        uuF1 : 1;               // Reserved
}
FlagRecSet;     // 1 byte used for 8 flags in set

typedef struct      // File listing - *.DIR
{
    Char Filename[13];      // File name
    Char Description[79];   // Description
    Word Nacc;              // Number of times file downloaded
    Byte Unused;            // Reserved
    Word Blocks;            // Number of 128 byte blocks in file
    Char Owner[37];         // Uploader of file
    Char Date[9];           // Date file uploaded
    Word DateN;             // Date uploaded in days since Jan 1, 1985
    FlagRecSet Flag;        // File status
    Byte Points;            // File points
}
UlfRec;


#define NUMSHELLFILES       13  // # currently defined internal shell files

typedef struct
{
    DefaultYesNoType useswap;   // Swap shell setting
//  struct                      // Shell file flags
//  {
//      Bit shellshowcall : 1;
//      Bit shelllogcall : 1;
//  }
//  flags;
    char flags;
}
shellfilerec;

typedef shellfilerec                    // Array of shell files
        shellfilelist[NUMSHELLFILES];

#define NUMNEWUSERQUESTS    29  // Number of current new user questions

typedef struct
{
    Byte itemnum;       // Item number to ask or 0=inactive
    Boolean required;   // Required/optional
}
newuserquestrec;

typedef newuserquestrec                         // Array of new
        newuserquestlist[NUMNEWUSERQUESTS];     // user questions

typedef Word Range[256];    // Range of values for all security levels

// Provide for full 4D awareness (And point support)

typedef struct      // Fidonet Style Address (23 Bytes)
{
    Word Zone;          // Zone, 1   = N. America
    Word Net;           // Net,  120 = SE Michigan
    Word Node;          // Node, 116 = CRIMP BBS
    Word Point;         // Point, 99% of the time = 0
    Char Domain[16];    // As in FIDONET
}
AddressType;


typedef struct      // System status - STATUS.DAT
{
    Char AltPath[41];           // Alternate file path
    Char DictPath[41];          // Dictionary path

    Byte DefReadMsgMenu;        // Wait screen read message menu

    Boolean dynamicmsg;         // Dynamic message numbering active
    Boolean dynamicfile;        // Dynamic file numbering active
    Boolean waitscreendisable;  // Wait screen activity disable
    Boolean requiredvoting;     // Require voting when user logs on

    Byte automsglines;          // Auto message number of lines
    Byte uunewuserexpdays;      // Reserved
    Byte addwordsl;             // Add word to dictionary SL

    Char expvalkey;             // User expired validation key (#13=None)

    Byte expwarning;            // # of days to give warning before expires
    Byte modifymailflags;       // Sl when allowed to modify mail flags
    Byte netmailfilerequest;    // SL for NetMail file requests
    Byte netmailfileattach;     // SL for NetMail file attach

    Boolean ModemDebug;         // Modem debug information written to log
    Boolean UseXMS;             // Use XMS memory for swap shell
    Boolean ShowFilesOpen;      // Show Files Open on Top Screen
    Boolean LocalSysopWindow;   // SysOp window when on locally
    Boolean AllowSuperFast;     // Allow SHIFT password override
    Boolean WaitSend;           // FOSSIL buffer inactive
    Boolean OverlayEMS;         // Attempt EMS of overlays
    Boolean EMSOverXMS;         // Use EMS over XMS memory for swap
    Boolean DirectScreen;       // Direct screen writes
    Boolean UseEMS;             // Use EMS memory for swap shell
    Boolean useswap;            // Use swap shell
    Boolean UseFossil;          // Use FOSSIL driver
    Boolean SnowCheck;          // Snow checking active

    Byte BrowseDSL;             // DSL to have U/D commands on
                                //   File Browse Menu

    Char BbsID[9];              // !2.6f - ID used for Qwk Packets

    Char TempDlPath[41];        // Temp File Download Path

    Word MinKpost;              // Minimum K-Bytes to post
    Word MinKul;                // Minimum K-Bytes to upload

    Boolean AutoChatBufOpen;    // Auto chat buffer open

    Char nettype[21];           // Multi-user network type

    Byte uusystatrec2[15];      // Reserved

    Byte LogonPassword;         // SL when SysOp PW #1 needed to logon
    Byte ReadTextMsg;           // SL when allowed to use /READ command

    Boolean AlertChatOnly;      // Alert active only when chat on
    Boolean genericinfo;        // Generic mode active
    Boolean LogonPhone;         // Logon requires phone number

    Char DefMsgGroup[21];       // Default msg section group mask
    Char DefFileGroup[21];      // Default file section group mask

    Word MaxQWKMsgsSection;     // Maximum QWK messages allowed per section
    Word MaxQWKMsgsTotal;       // Maximum QWK messages allowed total

    Byte uusystatrec3[9];       // Reserved

    Char LastCaller[43];        // Name and number of last caller

    Char MenuFastKeys[21];      // Menu fast keys (e.g. "/")

    Char BoardPW[17];           // New user password (Null=None)
    Char BoardPhone[13];        // Board phone number

    Byte SysopColor;            // Chat SysOp color
    Byte UserColor;             // Chat user color

    ArFlagType PostCallFlag;    // Post call ratio AR flag

    Byte NoPostCallChk;         // SL when post call ratio ignored
    Byte ReinitTime;            // Minutes to re-init modem when no calls
    Byte StartMenu;             // Starting menu for users

    Boolean UseAutoMsg;         // Display auto-message during logon
    Boolean LogonOffHook;       // Take phone off-hook on local logon

    Byte NoPointChk;            // DSL when file points ignored

    Char LastDate[9];           // Date last user logged on

    AddressType Address;        // Zone/Net/Node/Point/Domain

    Boolean UserOn11x;          // Use USERON.BBS version 1.1x

    shellfilelist shellfile;    // Shell file information

    Byte uushellfile[10];       // Reserved for shell files

    newuserquestlist newuserquest; // New user question information

    Byte uunewuserquest[270];   // Reserved

    Byte ActiveModemRecNum;     // Active Modem Record Number

    Char MultiUserPath[41];     // Multi-user path

    Byte defusereditlist;       // Default user editor list mode
                                //   0=short, 1=normal, 2=extended, 3=info

    Byte uusystatrec5[10];      // Reserved

    Char GfilesPath[41];        // Main data files path

    Boolean StoreBadLogon;      // Store bad logon info in SysOp log

    Byte MaxBdNum;              // Maximum number of batch DL files
    Byte MaxBuNum;              // Maximum number of batch UL files

    Char BoardName[49];         // Board name

    Byte SysopMenuSL;           // SL required for SysOp Control-Q menu
//  ArFlagType SysopMenuAR;     // AR flag required from Control-Q menu
    unsigned char SysopMenuAR;

    Char SysopName[37];         // SysOp name

    Char SwapPath[41];          // Swap shell path

    Char ChatPW[17];            // Chat password

    Char LastTAGVersion[21];    // Last version of TAG to run

    Char nodelistpath[41];      // Nodelist directory

    Char BoardCityState[33];    // !2.6f Board City, State for QWK Pkt

    Char QWKPath[41];           // !2.6f QWK Path

    Char RIPPath[41];           // RIP Path

    Byte uusystatrec6[2193];    // Reserved

    Char SysopPW[3][17];        // Array of SysOp passwords

    Byte uusystatrec7[120];     // Reserved

    Real CallerNum;             // Total number of calls to system
    Real UlKtoday;              // K-Bytes uploaded today
    Real DlkToday;              // K-Bytes downloaded today
    Real uur1;                  // Reserved
    Real uur2;                  // Reserved
    Real uur3;                  // Reserved

    Word Users;                 // Number of active users
    Word ActiveToday;           // Minutes active today
    Word Callstoday;            // Calls today
    Word MsgPostToday;          // Public messages posted today
    Word EmailToday;            // Private messages posted today
    Word FbackToday;            // Feedback sent to SysOp today
    Word UlToday;               // Number of uploads today
    Word uuw1;                  // Reserved
    Word uuw2;                  // Reserved
    Word uuw3;                  // Reserved
    Word MaxUsers;              // Maximum users allowed to be active
    Word ErrorsToday;           // Number of errors today
    Word NusersToday;           // Number of new users today
    Word DlToday;               // Number of downloads today

    Integer NewUserMsgTo;       // User number new user message sent to
    Integer uui1;               // Reserved
    Integer SysopMailTo;        // User number mail to "SYSOP" is sent to
    Integer GuestUser;
    Integer FailedLogonMsgTo;   // Guest user number (0=None)
    Integer uuw5;               // Reserved
    Integer UsageLogDays;       // Number of days to keep USAGE.LOG
    Integer WaitMailUser;       // Mail waiting on wait screen (0=none)

    Byte UEditJumpSL;           // SL required for SysOp Control-U menu
    ArFlagType UEditJumpAR;     // AR flag required from Control-U menu

    Byte NoviceDisplay;         // Number of calls to display novice msg

    Byte NodeNumber;            // Multi-user node number

    Boolean UEditJumpPassword;  // Use System pswd for Quick User Edit
    Boolean ScanOnUploads;      // System permits forced scan on uploads

    Word MaxTimeInBank;         // Maximum minutes in time bank

    Boolean ShowGifRes;         // Show GIF resolution
    Boolean CheckUploadSpace;   // Show upload drive space
    Boolean SystemSecur;        // Full keyboard security active
    Boolean MultiUser;          // Board in multi-user mode

    Byte TBmaxDeposit;          // Maximum daily time bank deposit
    Byte TBmaxWithdraw;         // Maximum daily time bank withdraw
    Byte SysopLvl;              // SL for SysOp
    Byte CoSysopLvl;            // SL for CoSysOp
    Byte uub1;                  // Reserved
    Byte AddBbsLvl;             // SL for adding boards to bbs listing
    Byte EmailLvl;              // SL for sending normal private mail
    Byte uub2;                  // Reserved
    Byte uub3;                  // Reserved
    Byte SeeUnvalLvl;           // DSL for seeing unvalidated files
    Byte DlCoSysopLvl;          // DSL for Download CoSysOp
    Byte NoRatioChk;            // DSL for no ratio
    Byte ReadAnon;              // SL to know see anonymous real name
    Byte ReplyAnon;             // SL to reply to anonymous private mail
    Byte PublicAnonAny;         // SL to post anonymous on any public base
    Byte PrivateAnonAny;        // SL to send private anonymous mail
    Byte MaxPublicCall;         // Maximum public posts per call
    Byte MaxPrivCall;           // Maximum private messages per call
    Byte MaxFbackCall;          // Maximum feedback to SysOp per call
    Byte uub4;                  // Reserved 
    Byte SeePasswords;          // SL to see user passwords remotely
    Byte uub5;                  // Reserved
    Byte uub6;                  // Reserved 
    Byte ComPort;               // Communications port 
    Byte TimeOut;               // Minutes for inactivity time-out 
    Byte TimeOutBell;           // Minutes for inactivity bell
    Byte Backlogdays;           // Number of days to keep SYSOP.LOG's 
    Byte PrivilegeSL;           // Privilege SL
    Byte PrivilegeDSL;          // Privilege DSL
    Byte CDmask;                // Carrier detect mask
    Byte MaxLogonTries;         // Maximum logon attempts per call
    Byte uub7;                  // Reserved
    Byte uub8;                  // Reserved
    Byte UlTimePercent;         // UL time percent refund
    Byte MaxChats;              // Maximum chat pages per call
    Byte uub9;                  // Reserved
    Byte TagLineSL;             // SL for tag line command

    Boolean ClosedSystem;       // System closed
    Boolean TitlePause;         // Allow [PAUSE] on welcome screen
    Boolean LogonBulletin;      // Logon to the bulletin section
    Boolean BlankWait;          // Blank the wait screen if no activity
    Boolean Handles;            // Allow handles
    Boolean AutoANSIDetect;     // Logon auto-detect ANSI
    Boolean SecureSystem;       // Keyboard security active
    Boolean TimePerDay;         // Time limits represent time per day
    Boolean Mailer;             // External mailer active
    Boolean SysopFemale;        // SysOp is female
    Boolean scantosysoplog;     // File scans are saved in SysOp log

    Range TimeAllowed;          // SL array of time per call/per day
    Range UlDlNumRatio;         // DSL array of number of file UL ratios
    Range UlDlKratio;           // DSL array of K-Byte UL ratios
    Range CallsAllowed;         // SL array of calls allowed per day
    Range PostCall;             // SL array of posts per 1/10 call

    Boolean AutoRIPDetect;      // Logon auto-detect RIP

    Byte uusystatrec8[7];       // Reserved
}
SystatRec;


typedef struct      // Set of menu flags 
{
    Bit MenuOrCheck : 1,              // SL or AR - When off SL and AR
        MenuTimeHelpDisplay : 1,      // Time/Help display
        MenuBoardDisplayOverride : 1, // Board display override
        MenuNamePrompt : 1,           // Menu name prompt
        AscIIClearBeforeMenu : 1,     // ASCII Clear screen before printing menu
        AnsiClearBeforeMenu : 1,      // ANSI Clear screen before printing menu
        RipClearBeforeMenu : 1,       // RIP Clear screen before printing menu
        UUMF9 : 1,                    // Reserved
        UUMF8 : 1,                    // Reserved
        UUMF7 : 1,                    // Reserved
        UUMF6 : 1,                    // Reserved
        UUMF5 : 1,                    // Reserved
        UUMF4 : 1,                    // Reserved
        UUMF3 : 1,                    // Reserved
        UUMF2 : 1,                    // Reserved
        UUMF1 : 1;                    // Reserved
}
MenuFlagSet;    // 2 bytes used for 16 flags in set

typedef struct      // Set of command flags
{
    Bit CmdOrCheck : 1,          // SL or AR - When off SL and AR
        CmdHidden : 1,           // Hidden status
        CmdLinkToNext : 1,       // Link to next
        AscIIClearBeforeCmd : 1, // ASCII clean screen before command
        AscIIPauseAfterCmd : 1,  // ASCII pause after command completed
        AnsiClearBeforeCmd : 1,  // ANSI clean screen before command
        AnsiPauseAfterCmd : 1,   // ANSI pause after command completed
        RipClearBeforeCmd : 1,   // RIP clean screen before command
        RipPauseAfterCmd : 1,    // RIP pause after command completed
        AnsiOnly : 1,            // Command requires ANSI or RIP
        RipOnly : 1,             // Command requires RIP
        UUMF5 : 1,               // Reserved
        UUMF4 : 1,               // Reserved
        UUMF3 : 1,               // Reserved
        UUMF2 : 1,               // Reserved
        UUMF1 : 1;               // Reserved
}
CommandFlagSet;    // 2 bytes used for 16 flags in set

// Note: There is a serious bug in the release version for this header.
// The struct below will work. Use the variant variable to determine if
// the record is a MENU or a COMMAND. It is TRUE if it is a menu. - MJO

typedef struct      // Menus - MENUS.LST
{
    Char LongD[81];  // Menu description (menu) -or-
                     // Long command desc (command)

    Byte SL;         // Security level (SL)
    Byte DSL;        // Download security level (DSL)

    ArFlagset ArFlags; // AR flag set

    Byte UUMenu[10]; // Reserved

    Byte variant;       // TRUE if this record is a MENU, else a COMMAND

    union   // Menu or command - Variant section
    {
        struct      // Menu information
        {
            MenuFlagSet MenuFlags; // Menu flag set
            Byte MenuNum;          // Menu number
            Char mPrompt[49];      // Menu prompt unless MenuNamePrompt active
            Char Password[17];     // Menu password
            Byte FallBack;         // Fallback menu number
            Char HelpFile[8];      // Help file ID name
            Byte StartHelp;        // Starting help level 0=default
            Byte Location;         // Menu location
                                   //   (0=Main, 1=File, 2=ReadMessage)
        }
        vMenu;
        struct      // Command information
        {
            CommandFlagSet CmdFlags;  // Command flag set
            Byte Pkey;                // Command PKey
            Char Pdata[31];           // Command PData
            Char Shortd[33];          // Command short description
            Char CmdKey[13];          // Command execution key
        }
        vCommand;
    }
    Menu;
}
MenuRec;


typedef struct      // Macro list - MACROS.LST
{
    Integer UserN;      // User number of macro owner
    Char Key[4][161];   // Text for each of the macros
}
MacroRec;


typedef struct      // Single protocols - SPROT.DAT 
{
    Char Key[13];           // Execution key 
    Char Desc[61];          // Description
    Word MinBaud;           // Minimum baud rate to use 
    Word MaxBaud;           // Maximum baud rate to use 
    Byte DSL;               // DSL required 
    Char TempLog[53];       // Temp log path and name 
    Char UlLog[53];         // UL log path and name 
    Char DlLog[53];         // DL log path and name
    Char UlString[71];      // UL string for DOS call 
    Char DlString[71];      // DL string for DOS call 
    Boolean GoodCode;       // Result codes mean good transfer 
    Byte DlCode[6];         // DL error level result codes
    Byte ULcode[6];         // DL error level result codes 
}
SprotocolRec;

typedef struct      // Batch protocols - BPROT.DAT 
{
    Char Key[13];           // Execution key
    Char Desc[61];          // Description 
    Word MinBaud;           // Minimum baud rate to use 
    Word MaxBaud;           // Maximum baud rate to use
    Byte DSL;               // DSL required 
    Char UlString[71];      // UL string for DOS call 
    Char DlString[71];      // DL string for DOS call 
    Char UlList[53];        // UL file list file path and name 
    Char DlList[53];        // DL file list file path and name 
    Char TempLog[53];       // Temp log path and name 
    Char UlLog[53];         // UL log path and name 
    Char DlLog[53];         // DL log path and name
    Byte MaxCmdLen;         // Maximum command line length 
    Byte PosFn;             // Position of filename in log
    Byte PosStatus;         // Position of status in log 
    Boolean GoodCode;       // Result codes mean good transfer 
    Char DlCode[6][11];     // DL status result codes 
    Char ULcode[6][11];     // UL status result codes 
}
BprotocolRec;


typedef struct      // Validation information - VALIDATE.DAT
{
    Char Key;           // Execution key
    Char Desc[161];     // Descrip sent to user after validation
                        // 76 max real length - Rest for color
    Byte SL;            // SL to set on validation 
    Byte DSL;           // DSL to set on validation 
    Word Credit;        // Credit in cents to set on validation 
    Word Points;        // File points to set on validation 
    Word TimeBank;      // Time bank minutes to set on validation 
    ArFlagset Ar;       // AR flags to set on validation 
    FlagSet Flags;      // Special flags to set on validation
    Word UnusedWord;    // Reserved 
}
ValidationRec;


typedef struct      // Event flags
{
    Bit UnknownEvent : 1;       // 1-1. Unknown
    Bit EventIsExternal : 1;    // 1-2. External/Internal
    Bit EventIsActive : 1;      // 1-3. Active/InActive
    Bit EventIsShell : 1;       // 1-4. Shell/Error
    Bit EventIsMonthly : 1;     // 1-5. Monthly/Daily 
    Bit EventIsPermission : 1;  // 1-6. Permission/Restriction 
    Bit EventIsChat : 1;        // 1-7. Chat Event 
    Bit EventIsSoft : 1;        // 1-8. Soft/Hard 

    Bit BaudIsActive : 1;       // 2-1. Baud Rate Flag 
    Bit SLisActive : 1;         // 2-2. SL Flag 
    Bit DSLisActive : 1;        // 2-3. DSL Flag 
    Bit ARisActive : 1;         // 2-4. ARflag required
    Bit InRatioIsActive : 1;    // 2-5. InRatioFlag 
    Bit TimeIsActive : 1;       // 2-6. Time Flag
    Bit SetARisActive : 1;      // 2-7. Set AR flag 
    Bit ClearARisActive : 1;    // 2-8. Clear AR Flag 

    Bit uuEvent24 : 1;          // Byte 3 ... 
    Bit uuEvent23 : 1;
    Bit uuEvent22 : 1;
    Bit uuEvent21 : 1;
    Bit uuEvent20 : 1;
    Bit uuEvent19 : 1;
    Bit uuEvent18 : 1;
    Bit uuEvent17 : 1;

    Bit uuEvent16 : 1;          // Byte 4 ... 
    Bit uuEvent15 : 1;
    Bit uuEvent14 : 1;
    Bit uuEvent13 : 1;
    Bit uuEvent12 : 1;
    Bit uuEvent11 : 1;
    Bit uuEvent10 : 1;
    Bit uuEvent9 : 1;

    Bit uuEvent81 : 1;          // Byte 5 ...
    Bit uuEvent7 : 1;
    Bit uuEvent6 : 1;
    Bit uuEvent5 : 1;
    Bit uuEvent4 : 1;
    Bit uuEvent3 : 1;
    Bit uuEvent2 : 1;
    Bit uuEvent1 : 1;
}
EventType;  // 5 bytes used for 40 flags

typedef Byte EventDaysType;     // Set of event days
                                // (bits 0-6 = Sun..Sat)

// The Record Structure of the EventFile

typedef struct      // Events - EVENTS.DAT
{
    EventType EventFlags;       // Kinds of Events Supported 
    Byte EventDayOfMonth;       // If monthly, the Day of Month 
    EventDaysType EventDays;    // If Daily, the Days Active 
    Word EventStartTime;        // Start Time in Min from Mid. 
    Word EventFinishTime;       // Finish Time
    Char EventDesc[33];         // Description of the Event 
    Char EventQualMsg[65];      // Msg/Path if he qualifies 
    Char EventNotQualMsg[65];   // Msg/Path if he doesn't 
    Byte EventPreTime;          // Min. B4 event to rest. Call
    Boolean EventOffHook;       // Take phone Offhook ? 
    Char EventLastDate[9];      // Last Date Executed 
    Byte EventErrorLevel;       // For Ext Event ErrorLevel 
    Char EventShellPath[9];     // File for Ext Event Shell 
    Word LoBaud;                // Low baud rate limit 
    Word HiBaud;                // High baud rate limit 
    Byte LoSL;                  // Low SL limit
    Byte HiSL;                  // High SL limit 
    Byte LoDSL;                 // Low DSL limit 
    Byte HiDSL;                 // High DSL limit
    Char ARflagRequired;        // AR flag required 
    Word MaxTimeAllowed;        // Max Time per user this event 
    Char SetARflag;             // AR Flag to Set
    Char ClearARflag;           // AR Flag to Clear
    Byte EventUnused[128];      // Reserved
}
EventRecordType;


#define MAXMODEMRESULTCODES 45  // Maximum number of modem result codes

typedef Byte modemresulttype;   // Modem result type 

#define RESULTERROR             0       // Command error 
#define RESULTOK                1       // Command accepted 
#define RESULTRING              2       // Phone ringing 
#define RESULTNOCARRIER         3       // Connect attempt failed 
#define RESULTCONNECT           4       // Connect succcessful 
#define RESULTWAITSCREEN        5       // Go to wait screen
#define RESULTLOCALLOGON        6       // Logcal logon
#define RESULTSHELLBATCH        7       // Shell to batch file 
#define RESULTEXITERRORLEVEL    8       // Exit system with error level 
#define RESULTEXITSYSTEM        9       // Exit system with error level 255 
#define RESULTNODIALTONE        10      // Reserved 
#define RESULTRINGING           11      // Reserved 
#define RESULTBUSY              12      // Reserved 
#define RESULTNOANSWER          13      // Reserved 
#define RESULTVOICE             14      // Reserved 

typedef struct
{
    modemresulttype typeofresult;   // Type of result 
    Char result[51];                // Test of result
    Longint connectrate;            // Connect rate modem to modem
    Longint realrate;               // Real rate computer to modem
    Longint controlcode;            // Error level or startup code
    Boolean fullduplex;             // Full duplex operation?
    Boolean errorcorrecting;        // Error correcting modem?
    Byte Unused[8];                 // Reserved
}
resultrec;

// Modem string mapping codes:
//
// Char.  Name             Action
// -----  ---------------  ------------------------------
//  ^     Carat            Control code of next character
//  |     Pipe, Split Bar  Carriage return sent
//  `     Accent Mark      1/20th second delay
//  ~     Tilde            1/2 second delay
//  ^-    Carat & Minus    Lower DTR line
//  ^+    Carat & Plus     Raise DTR line

typedef struct      // Modem record - MODEM.DAT
{
    Boolean uuunused;           // Unused
    Char modemdescription[65];  // Description on modem
    Byte characterdelay;        // Miliseconds
    Boolean ctsrts;             // Hardware flow control active
    Boolean samering;           // Reserved
    Boolean nocollide;          // Reserved
    Byte numberresults;         // Number of modem result codes defined 
    resultrec result[MAXMODEMRESULTCODES]; // Array of results
    Char preinitialization[65]; // Pre-initialization string 
    Char initialization[65];    // Initialization string 
    Char answer[65];            // Answer string 
    Char busy[65];              // Busy string 
    Char hangupprimary[65];     // Hangup primary string 
    Char hangupsecondary[65];   // Hangup secondard string 
    Char afterhangup[65];       // After hangup string
    Char exitsystem[65];        // Exit system string 
    Char predial[65];           // Reserved 
    Char dialprefix[65];        // Reserved 
    Char dialsuffix[65];        // Reserved
    Longint waitbaud;           // Init modem speed 
    Boolean lockedbaud;         // Is baud rate locked - Not used by T.A.G. 
    Byte ecefficiency;          // Error correcting efficiency
    Byte ncefficiency;          // Normal connect efficiency
    Byte Unused[249];           // Reserved
}
modemrec;


#define MAXSUBOPS   10      // Maximum number of message section SubOps 

typedef Byte NoYesForcedType;   // Message section type 

#define NO          0       // Anonymous messages not allowed 
#define YES         1       // Anonymous messages allowed 
#define FORCED      2       // Messages forced anonymous
#define ATUNUSED    3       // Reserved 

// Standard Attributes for Messages

typedef struct
{
    Bit Msg_Private : 1;                  // 1  fPrivate,RaPrivate,JamPrivate
    Bit Msg_Crash : 1;                    // 2  fCrash,Crash,JamCrash
    Bit Msg_Received : 1;                 // 3  fReceived,Received,JamRead
    Bit Msg_Sent : 1;                     // 4  fSent,Sent,JamSent
    Bit Msg_FileAttached : 1;             // 5  fFileAttached,FileAttach,
                                          //    JamFileAttach
    Bit Msg_KillSent : 1;                 // 6  fKillSent,KillSent,JamKillSent
    Bit Msg_Local : 1;                    // 7  fLocal,LocalMessage,JamLocal
    Bit Msg_ReturnReceiptRequest : 1;     // 8  fReportReceiptRequest,RequestReceipt,
                                          //    JamReceiptReq 
    Bit Msg_IsReturnReceipt : 1;          // 9  fIsReturnReceipt,ReturnReceipt
    Bit Msg_AuditRequest : 1;             // 10 fAuditRequest,AuditRequest 

    Bit Msg_InTransit : 1;                // 11 fInTransit,JamIntransit
    Bit Msg_Orphan : 1;                   // 12 fOrphan,JamOrphan 
    Bit Msg_HoldForPickup : 1;            // 13 fHoldForPickup,JamHold 
    Bit Msg_Fido_UnusedBit10 : 1;         // 14 fUnusedBit10 
    Bit Msg_FileRequest : 1;              // 15 fFileRequest,JamFileRequest 
    Bit Msg_Fido_FileUpdateRequest : 1;   // 16 fFileUpdateRequest 

    Bit Msg_Deleted : 1;                  // 17 Deleted,JamDeleted 
    Bit Msg_Ra_NetmailPendingExport : 1;  // 18 NetmailPendingExport
    Bit Msg_NetMailMessage : 1;           // 19 NetMailMessage,JamTypeNet 
    Bit Msg_Ra_EchomailPendingExport : 1; // 20 EchomailPendingExport
    Bit Msg_Ra_UnusedMsgBit7 : 1;         // 21 UnusedMsgBit7 
    Bit Msg_Ra_UnusedNetBit7 : 1;         // 22 UnusedNetBit7 

    Bit Msg_Jam_ArchiveSent : 1;          // 23 JamArchiveSent 
    Bit Msg_Jam_Immediate : 1;            // 24 JamImmediate 
    Bit Msg_Jam_Direct : 1;               // 25 JamDirect 
    Bit Msg_Jam_Gate : 1;                 // 26 JamGate 
    Bit Msg_Jam_ConfirmRequest : 1;       // 27 JamConfirmReq 
    Bit Msg_Jam_ForcePickUp : 1;          // 28 JamFpu
    Bit Msg_Jam_TypeLocal : 1;            // 29 JamTypeLocal
    Bit Msg_Jam_TypeEcho : 1;             // 30 JamTypeEcho 
    Bit Msg_Jam_NoDisplay : 1;            // 31 JamNoDisp 
    Bit Msg_Jam_Locked : 1;               // 32 JamLocked 
}
MessageAttrFlagSet;     // 4 bytes used for 32 flags 

typedef Byte MBstyle;   // Message section style flags 

#define UUMBBSTYLE      0   // Was For Private Mail Board 
#define LOCALSTYLE      1   // Local
#define ECHOSTYLE       2   // Echomail 
#define NETMAILSTYLE    3   // Netmail
#define GROUPSTYLE      4   // Groupmail 

typedef Byte MBtype;    // Message section type flags 

#define UUMBTYPE        0   // Was For Netmail Board 
#define FIDOFORMAT      1   // Fido 1.Msg Format 
#define RAFORMAT        2   // Remote Access Format 
#define JAMFORMAT       3   // Jam Format

typedef struct      // Message boards - MBOARDS.DAT 
{
    Char Name[65];                  // Name of the Board 
    MBstyle Mstyle;                 // Local/Echo/Netmail 
    MBtype Mtype;                   // Message Board Type 
    Byte RaBoard;                   // Board Number if RA/QBBS type 
    Char Path[65];                  // Directory PathName 
    Char OriginLine[66];            // Origin Line 
    ArFlagType AccessAR;            // AR flag Required to Access
    ArFlagType PostAR;              // AR flag required to Post 
    Byte AccessSL;                  // Security Level Required to Access
    Byte PostSL;                    // Security Level Required to Post 
    Word MsgCount;                  // Count of Msgs on the Board 
    Word MaxMsgs;                   // Max Number of Messages 
    Word uuMaxOld;                  // Max Days for Messages
    Char Password[17];              // Password Required
    NoYesForcedType Anon;           // Anonymous Type
    Boolean AllowAnsi;              // Should we allow ANSI
    NoYesForcedType AllowHandle;    // Should we allow handles

    // Message Board SubOpts List  - Up to 10 - User Numbers
    Integer SubOps[MAXSUBOPS+1];    // SubOps - Item 0 = How many

    Char EchoTag[33];                // Echo Tag for Writing ECHOMAIL.BBS 
    Boolean UseOtherAddress;         // Use something other than system 
    Char JamBoard[9];                // JAM 8 character file name 
    Boolean AskPrivate;              // Ask if in area private message (echos) 
    Byte Reserved[13];               // Unused 
    Byte MenuNumber;                 // Default read message number
                                     //  (if 0, use system default) 
    Char PrePostFile[9];             // Prepost file name 
    Byte MinMsgs;                    // Minimum number of messages 
    Char QuoteStart[71];             // Override starting quote
    Char QuoteEnd[71];               // Override ending quote 
    Word QwkConf;                    // QWK Conference Number 
    Byte GroupNumber;                // What group the board belongs 
    AddressType OtherAddress;        // The Address to use! 
    NoYesForcedType RestrictPrivate; // Private mail status 
    MessageAttrFlagSet DefaultAttr;  // Default message flags
    Char QwkName[11];                // QWK Conference Name 
    Boolean Filter7Bit;              // Only allow 7 bit characters 
}
MboardType;


typedef Char LastOnType[8][161];    // Last Few Callers - LASTON.DAT


#define MAXBITS     1024    // Means a 128 byte bit set, bits 0 to 1023

typedef Byte bitSetType[MAXBITS / 8];   // Board Flags - ?ZSCAN.DAT


typedef struct      // Who's online - $WHO.DAT 
{
    Boolean Active;
    Byte Node;              // Node number for this rec     
    Boolean Available;      // Is he available for anything 
    Char Uname[37];         // Users Name
    Char CityState[31];     // City and State               
    Longint Baud;           // Baud Rate
    Byte Paging;            // Paging Node Number           
    Byte InPrivateChat;     // Node in private chat with    
    Boolean InGroupChat;    // Is he in Group Chat          
    Char Desc[65];          // Long Description             
}
WhoRecType;


typedef struct      // USERON.BBS file version 1.00
{
    Char Name[36];          // User name
    Byte Line;              // Node number
    Word Baud;              // Connect rate
    Char City[26];          // City/State
    Boolean DoNotDisturb;   // Do not disturb
    Byte Status;            // Status
}
UserOnType100;


typedef struct      // USERON.BBS file version 1.1x
{
    Char Name[36];          // Real name
    Char Handle[36];        // User name
    Byte Line;              // Node number
    Word Baud;              // Connect rate
    Char City[26];          // City/State
    Boolean DoNotDisturb;   // Do not disturb
    Byte Status;            // Status         
    Byte Attribute;         // Attribute      
}
UserOnType11x;

#ifdef __cplusplus
}
#endif

#endif
