// usercnv.cpp
// TAG 2.7x to Maximus 3.1 User Record Conversion
// 02/10/96 - Version 1.0
// (C) Copyright 1996, TranStar Technologies - All Rights Reserved

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <malloc.h>
#pragma pack(1)
#include "\bbsdev\tag.h"
#include "max.h"
#pragma pack()
#include <math.h>
#include <share.h>

#define TRUE    1
#define FALSE   0

typedef unsigned short WORD;
typedef unsigned char BYTE;

FILE *instream, *outstream;
UserRec Urec;
struct _usr MaxUser;
short month, day, year;
double tp6_to_double(const unsigned char *tp6);

void __pascal pas2c(char *source, char *dest);
void ConvertRecord();
void ConvertDate(WORD adate);
void ConvertAR();

void main(int argc, char **argv)
{
    WORD count = 0;

    printf("USERCNV 1.0 - Tag to Maximus User Record Converter\n");
    printf("(C) Copyright 1996, TranStar Technologies - All Rights Reserved\n\n");

    if (argc!=3) {
        printf("Usage: USERCNV Tag-User.LST  Max-Users.BBS\n");
        exit(0);
    }
    if ((instream = _fsopen(argv[1], "rb", _SH_DENYNO)) == NULL) {
        printf("Cannot open %s\n", argv[1]);
        exit(0);
    }
    if ((outstream = fopen(argv[2], "wb")) == NULL) {
        printf("Cannot open %s\n", argv[2]);
        fclose(instream);
        exit(0);
    }

    // For every tag user make the conversion. If the user number is 0, then the record has
    // been deleted. In making the conversion, the AR flags will correspond more or less to
    // the Maximus flags. Conversions must be made for certain TAG variables which use the
    // non-standard Pascal Real field (download counts and the like).
    
    while(!feof(instream)) {
        if (fread(&Urec, sizeof(UserRec), 1, instream) !=1) break;
        if (Urec.UserNum==0) continue;    // deleted record
        ConvertRecord();
        count++;
    }
    fclose(instream);
    fclose(outstream);
    printf("\n%u User Records were converted.\n", count);
}


void __pascal pas2c(char *source, char *dest)
{
    short slen;
    char *p;

    p = source;
    slen = *p;
    p++;
    memcpy(dest, p, slen);
    dest[slen] = 0;
}


void ConvertRecord()
{
    char tmp[132];
    double val;

    pas2c((char *)Urec.Uname, tmp); tmp[21] = 0;
    strcpy((char *)MaxUser.alias, tmp);
    printf("User %3d: %s\n", Urec.UserNum, (char *)MaxUser.alias);
    pas2c((char *)Urec.Rname, (char *)MaxUser.name);
    pas2c((char *)Urec.CityState, (char *)MaxUser.city);
    pas2c((char *)Urec.Phone, (char *)MaxUser.phone);
    pas2c((char *)Urec.PW, tmp); tmp[16] = 0;
    strcpy((char *)MaxUser.pwd, tmp);
    MaxUser.times = Urec.NumCalls;
    MaxUser.help = 0;
    MaxUser.group = 0;
    MaxUser.video = (Urec.Flags.Ansi) ? GRAPH_ANSI : GRAPH_TTY;
    MaxUser.nulls = 0;
    MaxUser.bits = 0;
    if (Urec.Flags.OneKey) MaxUser.bits |= BITS_HOTKEYS;
    if (Urec.ConfigFlags.DoNotDisturbUser) MaxUser.bits |= BITS_NOTAVAIL;
    MaxUser.bits |= BITS_FSR;
    if (Urec.Flags.Rchat) MaxUser.bits |= BITS_NERD;
    MaxUser.bits |= BITS_TABS;

    ConvertDate(Urec.Bday);
    MaxUser.dob_year = (WORD)year;
    MaxUser.dob_month = (BYTE)month;
    MaxUser.dob_day = (BYTE)day;
    MaxUser.bits2 = 0;
    MaxUser.bits2 |= BITS2_IBMCHARS;
    MaxUser.bits2 |= BITS2_MORE;
    if (Urec.Flags.Ansi) MaxUser.bits2 |= BITS2_RSVD2;
    if (Urec.Flags.ClsChar) MaxUser.bits2 |= BITS2_CLS;
    MaxUser.bits2 |= BITS2_CONFIGURED;

    // MaxUser.max2priv =
    MaxUser.dataphone[0] = 0;
    MaxUser.time = 0;
    // MaxUser.delflag =
    MaxUser.msgs_posted = Urec.PrivPost + Urec.PubPost + Urec.FeedBack;
    // MaxUser.msgs_read =
    MaxUser.width = Urec.Colms;
    MaxUser.len = Urec.Lines;
    MaxUser.credit = Urec.Credit;
    MaxUser.debit = Urec.Debit;
    // MaxUser.xp_priv =

    // MaxUser.xp_date
    // MaxUser.xp_mins =
    // MaxUser.xp_flag =
    MaxUser.sex = (Urec.Gender == 'M') ? SEX_MALE : SEX_FEMALE;
    // MaxUser.ludate

    // Convert TAG AR flags to Maximus XKeys
    ConvertAR();

    MaxUser.struct_len = sizeof(struct _usr) / 20;
    MaxUser.lang = 0;
    // MaxUser.def_proto =

    // val = tp6_to_double((BYTE *)Urec.UlK);
    MaxUser.up = 0L;
    val = tp6_to_double((BYTE *)Urec.Dlk);
    MaxUser.down = (dword)val;

    // MaxUser.downtoday =
    MaxUser.call = 0;
    // MaxUser.compress =
    // MaxUser.df_save =
    // MaxUser.extra =

    ConvertDate(Urec.FirstOn);
    MaxUser.date_1stcall.msg_st.date.mo = month;
    MaxUser.date_1stcall.msg_st.date.da = day;
    MaxUser.date_1stcall.msg_st.date.yr = year + 20;
    MaxUser.date_1stcall.dos_st.time = 0;

    MaxUser.date_pwd_chg.dos_st.date = MaxUser.date_1stcall.dos_st.date;
    MaxUser.date_pwd_chg.dos_st.time = 0;

    MaxUser.nup = (dword)Urec.NumUL;
    MaxUser.ndown = (dword)Urec.NumDL;
    MaxUser.ndowntoday = 0;
    MaxUser.point_credit = (dword)Urec.Points;
    MaxUser.point_debit = 0;

    MaxUser.priv = (WORD)Urec.SL;

    strcpy((char *)MaxUser.msg, "1");
    strcpy((char *)MaxUser.files, "1");

    fwrite(&MaxUser, sizeof(struct _usr), 1, outstream);
    memset(&MaxUser, 0, sizeof(struct _usr));
}

void ConvertDate(WORD adate)
{
    day = (short)(adate & 31);
    adate >>= 5;
    month = (short)(adate & 15);
    adate >>= 4;
    year = (short)adate;
}

void ConvertAR()
{
    BYTE *p, arstring[40], val, tmp[40];
    short i, j, k = 0;

    p = (BYTE *)&Urec.Ar[0];
    for (j = 0; j<4; j++) {
        val = *p;
        for (i = 0; i<8; i++) {
            if (val & 1) arstring[k] = 'X';
            else arstring[k] = ' ';
            val >>= 1;
            k++;
        }
        p++;
    }
    arstring[k] = 0;

    p = (BYTE *)&MaxUser.xkeys;
    p++;
    k = 1;
    for(i = 0; i<3; i++) {
        val = 1;
        for (j = 0; j<8; j++) {
            if (arstring[k] == 'X') *p |= val;
            val <<= 1;
            k++;
        }
        p++;
    }

    p = (BYTE *)&MaxUser.xkeys;
    val = 1;
    for (i = 0; i<3; i++) {
        if (arstring[k] == 'X') *p |= val;
        val <<= 1;
        k++;
    }
}

#pragma pack(1)

double tp6_to_double(const unsigned char *tp6)
{
      struct {
            unsigned char be  ;     /* biased exponent           */
            unsigned int  v1  ;     /* lower 16 bits of mantissa */
            unsigned int  v2  ;     /* next  16 bits of mantissa */
            unsigned int  v3:7;     /* upper  7 bits of mantissa */
            unsigned int  s :1;     /* sign bit                  */
      } real;

      memcpy (&real, tp6, 6);
      if (real.be == 0)
            return 0.0;
      return (((((128 +real.v3) * 65536.0) + real.v2) * 65536.0 + real.v1)
*
            ldexp ((real.s? -1.0: 1.0), real.be - (129+39)));
}

#pragma pack()

