// =========================================================================
//
// TUEXPORT.C -- Allows export of user records from TBBS USERLOG.BBS file
//               to a comma delimited (CSV) format file.
//
// -------------------------------------------------------------------------
//
// History:  version    Notes:
//
// 23-10-96  0.1 	Wrote user export utility
//
// -------------------------------------------------------------------------
//
// NOTE: DONT try compiling and using this with word alignment on...
// it don't go...make sure this is off in the compiler options....
//
// =========================================================================

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <io.h>
#include <time.h>
#include "tbbs_2.h"

USERLOG	tusers;

long filesize(FILE *stream)
{
   long filepos,length;

   filepos = ftell(stream);
   fseek(stream, 0L, SEEK_END);
   length = ftell(stream);
   fseek(stream, filepos, SEEK_SET);
   return length;
}

void main()
{
    long filelength;
    fpos_t filepos;
    int x;
    FILE *TBBS_USERS,*USER_RPT;
    char buf[512],password[9],notes[65];

    clrscr();
    x = 0;

    printf("TBBS user base export utility, version 0.1, 23rd October 1996\n");
    printf("Copyright (c) Robert Dyball, 1996  email: bob.dyball@dse.com.au \n\n");

// -------------------------------------------------------------------------
// open up for input the TBBS userlog.bbs users file, this is hard wired
// to assume this is in the C:\TBBS directory.
// -------------------------------------------------------------------------

    if ((TBBS_USERS = fopen("c:\\tbbs\\userlog.bbs", "r+b")) == NULL) {
	printf("Error opening TBBS USERLOG.BBS file for reading\n");
	exit(0);
    };

    filelength = filesize(TBBS_USERS);

// ---------- move to the beginning of the input file ----------------------

    fseek(TBBS_USERS, SEEK_SET, 0);

    filepos=0L;

// -------------------------------------------------------------------------
// open up output file, hard wired at this stage to USER_RPT.CSV in current
// directory that the utility is ran from.
// -------------------------------------------------------------------------

    if ((USER_RPT = fopen("user_rpt.csv", "w+b")) == NULL) {
		printf("Error opening User list output file for writing\n");
		exit(0);
    };


    printf("ͻ\n");
    printf(" Exporting record #:                                                  \n");
    printf("ͼ\n");

    do {

	gotoxy(5,15);

// ---------------- report the file pointer position ----------------------

	fseek(TBBS_USERS, filepos,SEEK_SET);


// ---------------- read the data -----------------------------------------

	fread(&tusers, 512, 1, TBBS_USERS);

// ------------------------------------------------------------------------
// print on screen a part of the user record being read, so as to show the
// progress through the user log.
// ------------------------------------------------------------------------

	gotoxy(25,5);
	printf("%05d  %-035s", x, tusers.name_locn );
	x++;


// ------------------------------------------------------------------------
// extract password, as it is not null (0) terminated, making it a regular
// C style string, with a null on the end. Maximum 8 bytes + null = 9 bytes
// ------------------------------------------------------------------------

	strncpy(password,tusers.password,8);
	password[8]='\0';


// ------------------------------------------------------------------------
// extract notes, as this is not null (0) terminated, to make it a regular
// C style string, with a null on the end.  Max 64 bytes + null = 65 bytes
// ------------------------------------------------------------------------

	strncpy(notes,tusers.notes,64);
	notes[64]='\0';



// ------------------------------------------------------------------------
// output to a comma delimited file.
//
// Add extra fields here, refer to the TBBS_2.H file for extra fields, if
// necessary.
//
// If you prefer not to have inverted commas (") around each field, then
// remove the \" parts from the second section of the fprintf statement
//
// The fprintf statement should be set up like:
//
// eg,   fprintf(OUTPUT_NAME," format info \n", variables);
//
// the \n is to add a carriage return to each line, the " " are needed in
// the format section.
//
// ------------------------------------------------------------------------


	fprintf(USER_RPT,"\"%05ld\",\"%-50s\",\"%02i\",\"%02i\",\"%02i\",\"%-8s\",\"%-64s\"\n", filepos/512, tusers.name_locn, tusers.expiration.dd, tusers.expiration.mm, tusers.expiration.yy,password,tusers.notes);


// ------------------------------------------------------------------------
// Move to the next block of data in the user log.
// ------------------------------------------------------------------------

	filepos=ftell(TBBS_USERS);

    } while (filepos<filelength);

// ------------------------------------------------------------------------
// Close up files, print a "I'm finished message" ..... that's all folks.
// ------------------------------------------------------------------------


    fclose(TBBS_USERS);
    fclose(USER_RPT);

    printf ("\n\n\n\nExport of TBBS user file USERLOG.BBS has been completed.\n\n");

}

