; ===========================================================================
; =                    eXtended Downloadcounter 1.35                        =
; =         Copyright (C) 1995-96 Christian Coehn (2:2480/412)              =
; ===========================================================================
; =                                                                         =
; =                    SAMPLE CONFIGURATION FILE                            =
; =                                                                         =
; ===========================================================================

; =========================================================================== 
; Priority: the priority at which you want XDLC to run
; Valid settings (ranging from lowest to highest) are:
; Idle, Regular, TimeCritical, Foreground
; NOTE: The DOS version of XDLC ignores this keyword.
; =========================================================================== 
Priority Regular


; =========================================================================== 
; FArea: path to your Maximus 3.x farea.dat file (farea.idx is expected in
;        the same directory)
; XDLC fully supports CD-ROM ('Filelist' and 'Type DateList' statements in
; FILEAREA.CTL). Note however that _you_ have to insert file size and date
; in 'Type DateList' areas (Wilfried Brinkmann's MaxList is a great tool for
; this). In fact, XDLC will mess up your Files.Bbs if you flag areas as
; 'Type DateList' and don't put file size and date into your Files.Bbs
; =========================================================================== 
FArea c:\max\farea.dat


; =========================================================================== 
; MaxFilesIdx: path to your Maximus 3.x maxfiles.idx file
; If enabled XDLC will scan Maximus's filebase index in case it can't find a
; matching FILES.BBS in farea.dat or the download dir.
; This is useful for increasing DLCs of passthru files or CD ROM files that
; were copied to a staging area by Max 3.0 or an external request processor.
; However, the major drawback is that only the DLC of the first matching file
; in maxfiles.idx will be increased.
; Note: Obviously you can't use this together with 'IgnorePath'
; =========================================================================== 
MaxFilesIdx c:\max\maxfiles.idx


; =========================================================================== 
; RelaxedIndexMatch: tells XDLC whether to check filename _and_ extension
; (No) when scanning maxfiles.idx or to check the filename only (Yes).
; Useful for folks who rearchive files for their local filebase and send the
; originals passthru to their downlinks.
; Example: you receive FILE.ZIP and convert it to FILE.RAR. FILE.ZIP is sent
;          passthru to your downlinks. XDLC scans maxfiles.idx for FILE.ZIP
;          and finds only FILE.RAR. If RelaxedIndexMatch is set to Yes the
;          DLC of FILE.RAR will be incremented, otherwise XDLC will complain
;          about not finding FILE.ZIP and skip the file.
; =========================================================================== 
RelaxedIndexMatch No


; =========================================================================== 
; AsciiAreaFile: path to an additional plain ascii area definition file.
;                Here you may specify additional file areas, that are not
;                part of your Maximus setup. See AREADAT.ASC for an example
; =========================================================================== 
;AsciiAreaFile c:\comm\xenia\xdlc\areadat.asc


; =========================================================================== 
; LogFile: path to XDLC log file
; If omitted actions will not be logged
; =========================================================================== 
LogFile c:\logs\xdlc.log


; =========================================================================== 
; UploadLog: if enabled, XDLC will search your Maximus log files for uploads
;            as well as downloads and write a summary to the log you specify
;            here. Nice thing to have on large systems.
;            NOTE: This log file has to be different from the log above !
; ===========================================================================
UploadLog c:\logs\upload.log


; =========================================================================== 
; BBSLog: path to your Maximus log file(s)
;         (there's no limitation to the number of Max log files)
; =========================================================================== 
BBSLog c:\logs\max01.log
BBSLog c:\logs\max02.log
BBSLog c:\logs\max03.log


; =========================================================================== 
; MailerLog: path to your mailer log file(s)
;            (there's no limitation to the number of mailer log files)
; =========================================================================== 
MailerLog c:\logs\xenia1.log
MailerLog c:\logs\xenia2.log
MailerLog c:\logs\xenia3.log


; =========================================================================== 
; IgnorePath: XDLC will ignore all files that were sent from this path.
;             This feature is useful for systems that have a lot of passthru
;             file echos. Specifying your storage dirs for passthru areas
;             here will save some time and supress the endless "No FILES.BBS
;             for..." passages in XDLC.LOG
;             (there's no limitation to the number of 'IgnorePath' statements)
; =========================================================================== 
IgnorePath c:\allfix\queue


; ===========================================================================
; MailerString: These are the strings that XDLC will look for
;               when it searches your mailer logs for downloaded files
;               The strings you specify here should be immediately followed by
;               a filename (including path). Example:
;
; 02 Mar 17:20:25 XEN  ZSEND/32 C:\MAX\FILE\FIDONEWS\FNEWSC08.RAR (13281b)
;                      ^^^^^^^^ ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ 
;                      Keyword  Path and filename                 [ignored]
;
; NOTES: - String matching is CASE SENSITIVE
;        - Maximus strings are hardcoded
; ===========================================================================
;
; Xenia Users:
MailerString HSEND:
MailerString ZSEND/32
;
; Binkley-Users:
;MailerString Sent-Z/32
;MailerString Sent-H/32
;MailerString Sent-J/32
;
; McMail Users:
;MailerString Sent-
;
; CantaLoup Users:
;MailerString Hydra: Sent
;MailerString ZedZap: Sent
;MailerString Janus: Sent
;
; Others:
; Have a look at your logs and find out yourself. :-)


; =========================================================================== 
; CounterStyle: style of counter delimiters
; Style 1 = [ ]   Style 2 = { }   Style 3 = ( )   Style 4 = < >
;
; NOTE: When accessing its file database (new file scan, locate), Maximus
; always reformats the download counter regardless of your CounterStyle and
; CounterLength settings. To force Max to correctly display your counters
; you have to change your language file (file area heap, section :f_area).
; fbbs_counter=LBRACKET "%2d" RBRACKET " "; would give you a two digit
; counter and fbbs_counter= LBRACKET "%03d" RBRACKET " "; would give you a
; three digit counter with leading zeros.
; =========================================================================== 
CounterStyle 1


; =========================================================================== 
; CounterLength: tells XDLC how many digits to use in the counter
; 1: [0], 2: [ 0], 3: [  0], ... you got the idea ...
; =========================================================================== 
CounterLength 2


; =========================================================================== 
; ZeroPadd: use [000] (Yes) instead of [  0] (No)
; =========================================================================== 
ZeroPadd No


; =========================================================================== 
; Tabulate: position at which a DLC is set in 'AutoDate' file areas and
;           position at which a DLC is set in 'Type DateList' file areas
;           separated by a space. This value is honored during initialization
;           runs and when creating DLCs on the fly. The registered version
;           will also reposition all existing counters on init runs.
;           Defaults to 14/32.
; =========================================================================== 
Tabulate 14 32


; =========================================================================== 
; SkipLines: some file sort and list utilities on the market reformat
;            all FILES.BBS and add avatar coloured headers to it (e.g.
;            Maxlist). If XDLC misinterprets these headers as filenames,
;            i.e. XDLC /I adds download counters to your headers, you can
;            tell it to skip the first xx lines of each FILES.BBS it
;            processes.
; =========================================================================== 
;SkipLines 10


; =========================================================================== 
; IgnoreTic: tells XDLC whether to increment counters of downloaded files
;            that are followed/preceded by a .TIC file (Yes) or not (No).
; =========================================================================== 
IgnoreTic No


; =========================================================================== 
; TicFile: tells XDLC whether your Tick Manager sends .TIC files 'before' or
;          'after' the actual file. Defaults to 'After'
; =========================================================================== 
TicFile After


; =========================================================================== 
; KillHardSpace: if set to Yes, XDLC will replace all 'hard spaces'
;                (ASCII 255) with normal spaces (ASCII 32) each time it
;                processes a Files.Bbs (normal and initialization runs).
;                Hard spaces cause FB(P) to trap or corrupt the file index.
; =========================================================================== 
KillHardSpace Yes


; =========================================================================== 
; FileNamesUpperCase: if set to Yes, XDLC will convert all filenames to upper
;                     case on init runs. Descriptions will not be changed,
;                     of course.
;                     This is useful for request processor like xOR that do
;                     not accept lower or mixed case filenames in your
;                     Files.Bbs as valid filenames.
; =========================================================================== 
FileNamesUpperCase Yes


; =========================================================================== 
; MaxDescLen: This keyword tells XDLC the maximum length of file
;             descriptions in your FILES.BBS. XDLC will truncate
;             descriptions longer than this value.
;             Set this to 255 if you're running Maximus 2.x. You may
;             use values up to 1024 if you're running Max 3.0.
;             Set this to 0 to disable this function at all.
; =========================================================================== 
MaxDescLen 1024


; =========================================================================== 
; SortBy:    Tells XDLC to sort your FILES.BBS either by 'name' or 'date'
;            on each initialization run (/i). Please note that XDLC is
;            currently not aware of multiline file descriptions (separated
;            by a +). Don't enable this feature when using multiline descs.
; SortOrder: May be 'ascending' or 'descending'
;
; Sorting FILES.BBS is comment aware. Example:
;
; FILE1.ZIP ....
; FILE2.ZIP ....
;
;  Comment blah blah
;
; FILE3.ZIP ....
; FILE4.ZIP ...
;
; XDLC will sort block 1 (FILE1.ZIP/FILE2.ZIP) and block 2
; (FILE3.ZIP/FILE4.ZIP) separately.
;
; Sorting by date will slow down XDLC because it has to query the file date
; of each and every file.
; Comment out both keywords to disable FILES.BBS sorting.
; =========================================================================== 
;SortBy Name
;SortOrder Ascending
              

; =========================================================================== 
; Statistics: if enabled XDLC will keep a simple stat file containing
;             file names and number of downloads. The stat file is self
;             maintaining and won't grow larger than 200K.
;             XDLC /S creates a "best files" Maximus *.BBS file as well
;             a plain text file from this stat file.
; =========================================================================== 
Statistics c:\logs\xdlc.sta


; =========================================================================== 
;                           The Stat File Section
;                        
; If you tell XDLC to keep track of all of your downloads you'll want to
; create reports for your users, to be added to you file lists, etc.
; XDLC allows you to create two different 'Best file' reports - one is meant
; to be text only, the other can be a MECCA or MEX file or whatever you want.
;
; Note: Creating a report takes some time (2 minutes on my machine), because
;       XDLC has to query file date and size of up to 5000 files. Since this
;       is somewhat nasty when configuring header, footers and templates
;       and doing a lot of testing, you mad add /! as a command line parameter
;       to your XDLC call (XDLC /S /!). This tells XDLC not to access any
;       files. The corresponding templates (see below) will be set to "n/a".
;       Once you're satisfied with your reports add XDLC /S to your daily
;       maintenance run.
; =========================================================================== 


; =========================================================================== 
; BBSOut: path and filename of top file list (MECCA or MEX)
; =========================================================================== 
BBSOut c:\max\misc\topfiles.mec


; =========================================================================== 
; TextOut: path and filename of top file list (plain text file)
; =========================================================================== 
TextOut c:\max\filelist\topfiles.txt


; =========================================================================== 
; Top: number of files to list in top files list
; =========================================================================== 
Top 100


; =========================================================================== 
; BBSHeader : XDLC allows configurable headers and footers for each output
; BBSFooter : file. You may use more than one Header or Footer lines for
; TextHeader: both Text and BBS output files. XDLC will copy these lines
; TextFooter: to its reports in order of appearance.
;
; You may leave out each of these statements (=no header/footer). Please note
; that the unregistered version of XDLC will always add the following footer
; after yours: '// [white on black]Created by XDLC 1.35 (unregistered) \\'
; This should do no harm to neither MECCA nor MEX files.
;
; =========================================================================== 
BBSHeader [cls yellow on red]ͻ
BBSHeader                       [white on red]The Top 100 Files at 2nd Edition BBS[yellow on red]                   
BBSHeader ͼ[white on black]
BBSFooter [quit]
TextHeader                             --- Top 100 Downloads ---
TextHeader 
TextHeader      Rank            File            Downloads           Date            Size
TextHeader 
TextFooter 
TextFooter                               Created by XDLC 1.35+


; =========================================================================== 
; BBSPageHeader: The lines you specify here will be copied before and after
; BBSPageFooter: each BBSOut page. This is not available for TextOut.
; PageLength   : The number of files to list on each page
;
; Once again, you may leave out any of these statements.
; =========================================================================== 
BBSPageHeader      Rank            File            Downloads           Date            Size
BBSPageFooter [white enter cls]
PageLength 15

; =========================================================================== 
; BBSLine : These lines contain the actual report. Each file will be written
; TextLine: to a separate line.
;
; The following macros are available:
; Macro       Desc         Field Width (fixed)  Alignment  Examples
; ----------  ------------ -------------------  ---------  ---------------
; @RANK@      Rank                  3             right    "  1" or " 100"
; @DLS@       # Downloads           4             right    " 328" or "  21"
; @NAME@      FILENAME.EXT         12             left     "XDLC.ZIP   "
; @DATE@      File Date             9              --      "Sep/04/95"
; @SIZE@      File Size in K        6             right    "  120K"
; 
; Macro translation is case sensitive! You have to write them UPPER CASE!
; =========================================================================== 
BBSLine [white]     @RANK@.        @NAME@           @DLS@           @DATE@       @SIZE@
TextLine      @RANK@.        @NAME@           @DLS@           @DATE@       @SIZE@


; =========================================================================== 
; ShowOnlyIfExists: If set to 'Yes' XDLC will only put those files into its
;                   report which exist at runtime.
; =========================================================================== 
ShowOnlyIfExists Yes


; =========================================================================== 
; ExcludeFromList: plain ASCII files with filenames you don't want to be
;                  shown in your top files list (one filename per line).
;                  E.g. on my system the file which is downloaded most is
;                  my filelist. Since there's nothing special about it,
;                  I don't want it to be listed.
;                  You may use wildcards in your exclude file.
; =========================================================================== 
ExcludeFromList c:\comm\xenia\xdlc\exclude.lst
