(**************************************************************************)
(*
(*                           
(*                      
(*                       
(*                  
(*            
(*            
(*             
(*             
(*                
(*                           
(*                                       
(*
(*
(*					   Wildcat mail tosser V2.7
(*
(*
(*				 Copyright 1994,95,96 Michael Dailly
(*
(*  Copyright Notice
(*	----------------
(*
(*	  Michael Dailly retains ALL copyright to this program and its source.
(*	  The user may alter or amend the source in anyway he or she wishes.
(*	  However, the program may NOT be sold, but must be given freely and
(*	  any changes (including full source) must be sent to the Author
(*	  (Michael Dailly). Failing to do so is a violation of copyright. 
(*    The Authors name (Michael Dailly) MUST appear in the programs 
(*    copyright notice, and in any documentation, and it must clearly 
(*    state that the program is a modification of wcTOSS. The full modified 
(*	  source code must be included in the programs archive for all to 
(*	  use and examine. 
(*
(*
(*	 This copyright notice,and the authors name(s) must remain in all files.
(*
(*
(***************************************************************************)
unit    QWKSort;

interface

uses    dos,crt,Func,ScreenIO;

type    tmsg = record
               number :  word;          { conf number }
               index  :  longint;       { finle index }
               Size   :  word;
               Next   :  pointer;       { NEXT message in current conf }
               Conf   :  pointer;       { Next conf in QWK packet      }
              end;
        pmsg = ^tmsg;
        tbuffer = array[0..65500] of byte;   { file buffer }
        pbuffer = ^tbuffer;



VAR     f,f2    : file;
        size    : longint;
        index   : longint;
        Buff    : pBuffer;         { disk/file buffer }

        MsgSize : longint;
        MsgIndex: longint;

        ConfNumber : word;

        Start   : pmsg;            { START of list }
        Conf    : pmsg;            { current base CONF pointer }
        msg     : pMsg;            { current MESSAGE pointer }
        MsgNo   : longint;
        Valid   : byte;


Procedure SortQWK;


implementation

(****************************************************************************)
(*
(*   Sort a QWK file, into a LIST on confs!
(*
(****************************************************************************)
Function Number (ind : longint; amt : word) : longint;
         VAR V : longint;
         VAR a : byte;
Begin
     V:=0;
     repeat
           a:=Buff^[ind]; inc (ind); dec (amt);
           if (a<>$20) then
           Begin
                V:=(V*10)+(a-ord('0'));
           End;
     until (a=$20) or (amt=0);

     Number:=V;
End;

(****************************************************************************)
(*
(* Make an entry in the CONF table!
(* Creates a 2d linked list...
(*
(* Conf->NextConf->NextCont->NextConf->NIL
(*  |        |       |         |
(*  Mess    mess     NIL      Mes
(*  |        |                 |
(*  mess     NIL              Mes
(*  |                          |
(*  Mess                      NIL
(*  |
(*  NIL
(*
(****************************************************************************)
Procedure Enter (ConfNumber : word; index : longint; size : word);
          VAR Conf   : pmsg;
          VAR search : pmsg;
          VAR Last   : pmsg;
Begin
     New(Conf);     { create NEW area }
     if Conf=NIL then
     Begin
          MyWriteln (none,none,'Out of memory! Too many messages...('+Rstr(MsgNo)+')');
          exit;
     End;
     Conf^.Next:=NIL;
     Conf^.Conf:=NIL;
     Conf^.Number:=65535;
     Conf^.Index:=0;
     Search:=NIL;
     if Start=NIL then
     Begin
     	MyWriteln (none,none,'Adding conference '+Rstr(ConfNumber)+' into list');
          Start:=Conf;
          Conf^.Number:=ConfNumber;
          Conf^.Next:=NIL;
          Conf^.Conf:=NIL;
          Conf^.index:=index;
          Conf^.Size:=Size*128;
          exit;
     End;


     if (Start^.Number<>ConfNumber) then
     Begin
          Search:=Start;
          repeat
                Last:=Search;
                Search:=Search^.Conf;
          until (Search^.number=ConfNumber) or (Search=NIL);
          if Search=NIL then
          Begin
               MyWriteln (none,none,'Adding conference '+Rstr(ConfNumber)+' into list');
               Last^.Conf:=Conf; { link conf into conf list }
               Search:=Conf;
          End;
     End
     else Search:=Start;


     { Now search DOWN into the conf list. get the LAST entry }
     if Search<>Conf then
     Begin
      if Search^.Next<>NIL then
      Begin
          repeat
                Search:=Search^.Next;
          until (Search^.Next=NIL);
      End;
      Search^.Next:=Conf;
     End;


     Conf^.Number:=ConfNumber;
     Conf^.Next:=NIL;
     Conf^.Conf:=NIL;
     Conf^.index:=index;
     Conf^.Size:=Size*128;
End;


(****************************************************************************)
(*
(*   Sort a QWK file, into a LIST on confs!
(*
(****************************************************************************)
Procedure SortQWK;
Begin
     { allocate DISK buffer }
     new (Buff);

     { Open file! }
     assign (f,'messages.dat');
     reset  (f,1);
     Size:=FileSize(f);

     MsgNo:=1;         { Star message number           }
     index:=128;       { Base index                    }
     seek (f,128);     { past QWK compatability header }
     MyWriteln (none,none,'Pass 1 - sorting');
     repeat
           BlockRead (f,Buff^[0],128);
           Valid:=Buff^[$7a];
           if (Valid=$e1) or (Valid=$e2) then
             Begin
                inc (MsgNo);
                ConfNumber:=Buff^[$7b]+(Buff^[$7c]*256);
                MsgSize:=Number($74,6);
                MsgIndex:=MsgSize*128;
                Enter (ConfNumber,index,MsgSize); { enter into linked list }
                index:=index+MsgIndex;
                seek (f,index);
             End
           else Valid:=0;
     until  (index>=size) or (Valid=0);
     if Valid=0 then
     Begin
          MyWriteln(none,none,'');
          MyWriteln (none,none,'Message file has a SIZE error in message number '+Rstr(MsgNo));
          exit;
     End;



     assign (f2,'qwktemp.$$$');
     rewrite (f2,1);
     seek (f,0);
     Blockread (f,Buff^[0],128);
     Blockwrite(f2,Buff^[0],128);

     index:=0;
     seek (f,index);
     MyWriteln (none,none,'Pass 2 - Copying');
     Conf:=Start;
     repeat
           msg:=Conf;
           MyWriteln (none,none,'Writing conf '+Rstr(Msg^.Number));
           if (msg<>NIL) then
            repeat
                 seek(f,msg^.index);
                 Blockread (f,Buff^[0],Msg^.size);
                 Blockwrite(f2,Buff^[0],Msg^.size);
                 msg:=Msg^.Next;
            until (msg=NIL);
           Conf:=Conf^.Conf;
     until  (index>=size) or (Conf=NIL);;

     close (f);
     close (f2);

	erase (f);				{ delete OLD messages.dat 		}
     rename (f2,'messages.dat');	{ rename TEMP file TO messages.dat }
     Dispose (Buff);
End;



(****************************************************************************)
(*
(*	Init phase
(*
(****************************************************************************)
Begin
End.













