(**************************************************************************)
(*
(*                           
(*                      
(*                       
(*                  
(*            
(*            
(*             
(*             
(*                
(*                           
(*                                       
(*
(*
(*					   Wildcat mail tosser V2.7
(*
(*
(*				 Copyright 1994,95,96 Michael Dailly
(*
(*  Copyright Notice
(*	----------------
(*
(*	  Michael Dailly retains ALL copyright to this program and its source.
(*	  The user may alter or amend the source in anyway he or she wishes.
(*	  However, the program may NOT be sold, but must be given freely and
(*	  any changes (including full source) must be sent to the Author
(*	  (Michael Dailly). Failing to do so is a violation of copyright. 
(*    The Authors name (Michael Dailly) MUST appear in the programs 
(*    copyright notice, and in any documentation, and it must clearly 
(*    state that the program is a modification of wcTOSS. The full modified 
(*	  source code must be included in the programs archive for all to 
(*	  use and examine. 
(*
(*
(*	 This copyright notice,and the authors name(s) must remain in all files.
(*
(*
(***************************************************************************)
unit ScreenIO;

interface

uses	dos,crt,func;

const   none    = 32767;
        Center  =-1;
        HexTab  : string[17]=('0123456789ABCDEF');
{$I L.L}


type    tScr = array[0..2000] of word;
        pScr = ^tScr;
        tScra = array[0..24,0..79] of word;
        pScra = ^tScra;
        tHelps = array[1..1000] of string[25];
	   pHelps = ^tHelps;


var     Scr    : pointer;
        Screen : pScr;
        ScreenA: pScra;
        Saved  : pScr;

{        tx,ty  : integer;     { text pos, X,Y }
        tc,tb  : byte;        { text colours! }
        Disk   : word;
        ls     : word;
        W1     : word;

        Menus	: array[1..20] of string;
        Inputs : array[1..100] of string;

        QuitInput : boolean;
        UpDir     : boolean;
        DownDir   : boolean;

Function Hex (c : char) : integer;
Function GetLen(s : string) : integer;
Function InputText (s : string; x,y,Len,max : word) : string;
Function ReadText (s : string; x,Len,max : word) : string;
Function ReadInText (c,b,Y : integer; S : string; Len,max : integer) : string;
Function PrintOption (col,bak,y : word; s : string) : integer;
Function Menu (col,bak,def,Max : integer; Help : pointer; VAR w : integer) : integer;

Procedure SetXY(x,y : integer);
Procedure MyWrite (x,y: integer; s : string);
Procedure MyWriteln (x,y : integer; s: string);
function GetS (s : string) : string;

implementation
(****************************************************************************)
(*
(*   Decript string.
(*
(****************************************************************************)
function GetS (s : string) : string;
         VAR i : integer;
Begin
     for i:=1 to length(s) do
      s[i]:=chr((ord(s[i])-i) and $ff);
     GetS:=s;
End;

(****************************************************************************)
(* Return the value of a HEX dig
(****************************************************************************)
Function Hex (c : char) : integer;
         VAR i,i2 : word;
Begin
     c:=upcase(c);
     i:=0;
     for i:=1 to 16 do
      if c=HexTab[i] then i2:=i-1;
     Hex:=i2;
End;

(***************************************************************************)
(*
(*   Get the REAL length of a string! (strip control codes!)
(*
(***************************************************************************)
Function GetLen(s : string) : integer;
         VAR i,l : word;
Begin
     if length(s)=0 then Begin i:=0; exit; End;
     i:=1;
     l:=length(s);
     repeat
           if (s[i]='#') or (s[i]=#255) then
            Begin
                dec (l,3);
                inc (i,3);
            End
           else
            inc (i);
     until (i>=length(s));
     GetLen:=l;
End;


(***************************************************************************)
(*
(*   Set X,Y
(*
(***************************************************************************)
Procedure SetXY(x,y : integer);
Begin
	if y<>none then ty:=y else if Cwind>0 then ty:=Windows[Cwind].CY;
     if x=-1 then
          tx:=(80-ls) shr 1
     else
     if x<>none then tx:=x else if Cwind>0 then tx:=Windows[Cwind].CX;
End;

(****************************************************************************)
(*
(*	Inc Y pos in a window (also scroll window)
(*
(****************************************************************************)
Procedure IncYpos;
	VAR i : word;
Begin
	inc (ty);
     if Cwind>0 then
     Begin
      With Windows[Cwind] do
      Begin
     	if (ty>=Wycord+(Wysize-2)) then
     	Begin
     	  ty:=Wycord+Wysize-3;
            for yy:=Wycord+1 to Wycord+Wysize-4 do
              for xx:=Wxcord+1 to Wxcord+Wxsize-3 do
            	ScreenA^[yy,xx]:=ScreenA^[yy+1,xx];

            for xx:=Wxcord+1 to Wxcord+Wxsize-3 do
            Begin
            	i:=ScreenA^[Wycord+Wysize-3,xx];
               i:=(i and $ff00)+$20;
            	ScreenA^[Wycord+Wysize-3,xx]:=i;
            End;
		  Windows[Cwind].Ret:=False;
		End;
          Cy:=ty;
		tx:=Wxcord+1;
      	Cx:=tx;
      End;
     End;
End;

(****************************************************************************)
(*
(*	inc X pos in a window
(*
(****************************************************************************)
Procedure IncXpos;
Begin
	inc (tx);
     if Cwind>0 then
     with Windows[CWind] do
	Begin
     	if (tx>=Wxcord+(Wxsize-2)) then
          Begin
            IncYpos;
          End;
          Cx:=tx;
     End;
End;


(****************************************************************************)
(*
(*   My Writeln with Colours etc!
(*
(****************************************************************************)
Procedure MyWrite (x,y: integer; s : string);
          VAR i : longint;
          VAR b : boolean;
          VAR xx,yy : integer;
Begin
     i:=1; ls:=Getlen(s);
	if Windows[Cwind].Ret then incYpos;
     SetXY(x,y);
     repeat
           if s[i]='#' then
             Begin
                CASE S[I+1] of
                 'c' : tc:=Hex(s[i+2]);
                 'b' : tb:=Hex(s[i+2]);
                End;
                inc (i,3);
             End
           else
             Begin
                  ScreenA^[ty,tx]:=ord(s[i])+(tc*256)+((tb*256) shl 4);
                  inc (i);
                  incXpos;
             End;
     until (i>Length(s));
	Windows[Cwind].Ret:=False;
End;

Procedure MyWriteln (x,y : integer; s: string);
Begin
     if s='' then Begin IncYpos; exit; End;
     MyWrite (x,y,s);
     tx:=0;
     Windows[Cwind].Ret:=True;
End;



(***************************************************************************)
(*
(*   Print up option in a windows!
(*
(***************************************************************************)
Function PrintOption (col,bak,y : word; s : string) : integer;
          VAR len,x : word;
		VAR w1: integer;
Begin
     len:=Getlen(s);
     x:=(80-(len+2)) shr 1;
	w1:=OpenWindow(x,y,len+2,3, col,bak);
     Writeln;
     tc:=col;
     tb:=bak;
     MyWrite(x+1,Y+1,s);
     PrintOption:=w1;
End;

(***************************************************************************)
(*
(*   Read in a line of text
(*
(***************************************************************************)
Function InputText (s : string; x,y,Len,max : word) : string;
         VAR i,i2,i3 : word;
         VAR old,s2 : string;
         VAR ss : string;
         VAR ind : integer;
         VAR Flash : integer;
         VAR c : char;
         VAR start : integer;
Begin
     QuitInput:=False;
     UpDir:=False;
     DownDir:=False;
     dec(len);
     old:=s;
     i:=length(s);
     if i<len then
     Begin
          s2:=s;
     End
     else s2:=copy(s,1,len);

     ind:=length(s)+1;
     C:=' ';
     Flash:=10;
     Start:=length(s);
     repeat
           waitvblank;
           dec(flash);
           if Flash=0 then
           Begin
                if c=' '  then c:='' else c:=' ';
                Flash:=10;
           End;
           i:=length(s);
           s2:=copy (s,1,ind-1);
           s2:=s2+copy(s,ind,(length(s)-ind)+1)+' ';
           if c<>' ' then s2[ind]:=C;


           if i>=len then
           Begin
                if ind>=(i-Len)+3 then
                 Begin
                     i:=length(s2)-len;
                     s2:=copy(s2,i+1,len);
                 End
                else
                 Begin
                      s2:=copy(s2,ind,len);
                 End;
           End;
           tb:=2;
           Mywrite(x,y,spc(len+1));
           Mywrite(x,y,s2);


           key:=#0;
           key:=getkey;
           if FuncKey=False then
           Begin
           	if key=#8 then
               Begin
                    if (ind>1) then
                    Begin
                         ss:=copy(s,1,ind-2);
                         ss:=ss+copy(s,ind,(length(s)-ind)+1);
                         s:=ss;
                         dec (ind);
                    End
               End;
           	if (key>#31) and (key<=#127) and (length(s)<max) then
               Begin
                    ss:=copy(s,1,ind-1);
                    ss:=ss+key;
                    ss:=ss+copy(s,ind,(length(s)-ind)+1);
                    s:=ss;
                    inc (ind);
               end;
           End
           else
           Begin
                case key of
                 'H' : UpDir:=True;
                 'P' : DownDir:=True;
                 'K' : if ind>1 then dec (ind);
                 'M' : if ind<=length(s)  then inc(ind);
                 'S' : if ind<=length(s) then
                       Begin
                          ss:=copy(s,1,ind-1);
                          ss:=ss+copy(s,ind+1,(length(s)-ind));
                          s:=ss;
                       End;
               end;
                FuncKey:=False;
           End;


     until (key=#13) or (key=#27) or (UpDir=true) or (DownDir=true);
     if (key=#13) or (key=#27) then QuitInput:=True;
     if key=#27 then
     Begin
          InputText:=Old;
          exit;
     End;
     tb:=1;
     InputText:=s;
     s:=s+' ';
     s:=copy(s,1,len);
     Mywrite(x,y,spc(len+1));
     Mywrite(x,y,s);
End;


(***************************************************************************)
(*
(*   Read in a line of text
(*
(***************************************************************************)
Function ReadText (s : string; x,Len,max : word) : string;
         VAR i,i2,i3 : word;
         VAR old,s2 : string;
         VAR ss : string;
         VAR ind : integer;
         VAR Flash : integer;
         VAR c : char;
         VAR start : integer;
Begin
     dec(len);
     old:=s;
     i:=length(s);
     if i<len then
     Begin
          s2:=s;
     End
     else s2:=copy(s,1,len);

     ind:=length(s)+1;
     C:=' ';
     Flash:=10;
     Start:=length(s);
     repeat
           waitvblank;
           dec(flash);
           if Flash=0 then
           Begin
                if c=' '  then c:='' else c:=' ';
                Flash:=10;
           End;
           i:=length(s);
           s2:=copy (s,1,ind-1);
           s2:=s2+copy(s,ind,(length(s)-ind)+1)+' ';
           if c<>' ' then s2[ind]:=C;


           if i>=len then
           Begin
                if ind>=(i-Len)+3 then
                 Begin
                     i:=length(s2)-len;
                     s2:=copy(s2,i+1,len);
                 End
                else
                 Begin
                      s2:=copy(s2,ind,len);
                 End;
           End;
           Mywrite(x,none,spc(len+1));
           Mywrite(-1,none,s2);


           key:=#0;
           key:=getkey;
           if FuncKey=False then
           Begin
           	if key=#8 then
               Begin
                    if (ind>1) then
                    Begin
                         ss:=copy(s,1,ind-2);
                         ss:=ss+copy(s,ind,(length(s)-ind)+1);
                         s:=ss;
                         dec (ind);
                    End
               End;
           	if (key>#31) and (key<=#127) and (length(s)<max) then
               Begin
                    ss:=copy(s,1,ind-1);
                    ss:=ss+key;
                    ss:=ss+copy(s,ind,(length(s)-ind)+1);
                    s:=ss;
                    inc (ind);
               end;
           End
           else
           Begin
                case key of
                 'K' : if ind>1 then dec (ind);
                 'M' : if ind<=length(s)  then inc(ind);
                 'S' : if ind<=length(s) then
                       Begin
                          ss:=copy(s,1,ind-1);
                          ss:=ss+copy(s,ind+1,(length(s)-ind));
                          s:=ss;
                       End;
               end;
                FuncKey:=False;
           End;


     until (key=#13) or (key=#27);
     if key=#27 then
     Begin
          ReadText:=Old;
          exit;
     End;
     ReadText:=s;

End;

(***************************************************************************)
(* Get Installation DIR
(***************************************************************************)
Function ReadInText (c,b,Y : integer; S : string; Len,max : integer) : string;
         VAR x,w2 : word;
Begin
     x:=(80-(len+2)) shr 1;
	w2:=OpenWindow(x,Y,len+2,3, c,b);
     tc:=c;
     tb:=b;
     SetXY(none,Y+1);
     MyWriteln(none,none,' ');
     ReadInText:=ReadText(s,x+1,Len,max);
     CloseWindow(w2);
End;

(***************************************************************************)
(*
(*	Do Help
(*
(***************************************************************************)
Procedure DoHelp(Help : pHelps; Cur : integer);
          VAR search,s : string;
          VAR done : boolean;
          VAR cnt,c,b,win,i,i2 : integer;

Begin
     search:=Help^[Cur];

     cnt:=1;
     Done:=False;
     repeat
     	 S:=GetS(Strings[cnt]);
           inc (cnt);
           if s='[END]' then Done:=True;
           if s=Search then
           Begin
                S:=GetS(Strings[cnt]);
                inc (cnt);
                c:=rval(s);
     	 	 S:=GetS(Strings[cnt]);
           	 inc (cnt);
                b:=rval(s);
     	 	 S:=GetS(Strings[cnt]);
           	 inc (cnt);
                i2:=(25-(rval(s))) div 2;

                win:=OpenWindow(6,i2,68,rval(s),c,b);
                for i:=1 to rval(s) do
                Begin
     	 		 S:=GetS(Strings[cnt]);
           		 inc (cnt);
                     MyWriteln (center,none,s);
                End;
                key:=#0;
                repeat key:=getKey; until (key=#27) or (key=#13);
                Done:=True;
                CloseWindow(win);
           End;
     until (done) or (cnt=117);
End;



(***************************************************************************)
(*
(*	Do MENU selection..
(*
(*   Format:
(*		  '#cF#b1text here'      = normal selectable
(*		  '#cF#b1text here'+#255 = non-selectable
(*
(***************************************************************************)
Function Menu (col,bak,def,Max : integer; Help : pointer; VAR w : integer) : integer;
          VAR y,l2,len,x : word;
		VAR i,xx,yy,w1: integer;
          VAR cur : word;
          VAR ch : char;
Begin
	len:=0;
	for w1:=1 to Max do
     Begin
       l2:=getLen(Menus[w1]);
       if l2>len then len:=l2;
     End;

     x:=(80-(len+2)) shr 1;
     y:=(25-Max) div 2;
     if w<=0 then
		w:=OpenWindow(x,y,len+2,Max, col,bak)
     else
        SetWindow(W);


     cur:=def;
     ch:=Menus[cur][3];
     Menus[cur][3]:=Menus[cur][6];
     Menus[cur][6]:=ch;
     key:=#0;
	repeat
     	if (key=';') and (Help<>nil) then
          Begin
               DoHelp(Help,Cur);
               SetWindow(W);
          End;

          if (key IN ['H','P']) then
          Begin
     			ch:=Menus[cur][3];
     			Menus[cur][3]:=Menus[cur][6];
     			Menus[cur][6]:=ch;
          End;
          case key of
            'P' : repeat
            			inc (Cur);
                    	if Cur>Max then Cur:=1;
                  until (Menus[Cur][length(Menus[cur])]<>'');
            'H' : repeat
            		dec (Cur);
                    if Cur=0 then Cur:=Max;
                  until (Menus[Cur][length(Menus[cur])]<>'');
          end;
          if (Key IN ['P','H']) then
          Begin
     			ch:=Menus[cur][3];
     			Menus[cur][3]:=Menus[cur][6];
     			Menus[cur][6]:=ch;
		End;
          xx:=x; yy:=y;
          for i:=1 to MAX do Begin MyWrite (xx,yy,Menus[i]); inc (yy); End;



          key:=#0;
          repeat until (keypressed);
     	key:=getkey;
     until (key=#13) or (key=#27);
	Menu:=Cur;
End;

(****************************************************************************)
(* Install
(****************************************************************************)
Begin
     Scr:=Ptr(segb800,0);
     Screen:=Scr;
     ScreenA:=Scr;
End.
