
! ==========================================================================
! V1.50 5/01/1996
! ---------------------------------------------------------------------------
! (c) 1996, Reichenberger Development Incorporated - All Rights Reserved, World Wide
! (c) 1996, Tin Man Software Corporation - All Rights Reserved World Wide
! ---------------------------------------------------------------------------
TIN_REPORTVIEWER  FUNCTION(PrintPreviewQueue,Titlein)
LeftPageNumber       SHORT,AUTO
RightPageNumber      SHORT,AUTO
Preview:OpMode       BYTE,AUTO
Preview:Op:Normal    EQUATE(0)
Preview:Op:Zoom      EQUATE(1)
Preview:Op:Facing    EQUATE(2)
Preview:Zoomed       BYTE,AUTO
Preview:Facing       BYTE,AUTO
Preview:Pages        BYTE,AUTO
Preview:Jump         LONG,AUTO

!--------------------TINMAN SOFTWARE CORP.----------------------------------
PageMarked           LONG(0)
OptionPrint          BYTE(1)
PageFrom             LONG(1)
PageTo               LONG(1)
PREVIEWCOPIES        LONG(1)
PREVIEWPRINTER       STRING(50)
PREVIEWCOLLATE       BYTE
PREVIEWSAVEFILE      BYTE
PREVIEWFILENAME      STRING(100)
LOCALRESPONSE        LONG
PREV:MetaFileName    string(100),Static
PREV:Metafile   FILE,DRIVER('dos'),NAME(PREV:MetaFileName)
Record            RECORD,PRE()
                  END
                END

MarkQueue       QUEUE,PRE(MQ)
Mark              BYTE
                END
!--------------------TINMAN SOFTWARE CORP.----------------------------------

PreviewWindow WINDOW('Print Preview'),AT(,,308,231),CENTER,STATUS(150,25,50,50,-1),SYSTEM,GRAY,RESIZE
       TOOLBAR,AT(0,0,307,17),NOMERGE
         BUTTON,AT(3,1,15,15),MSG('Cancel Report'),TIP('Cancel Report'),USE(?PreviewCancel),ICON(ICON:Hand)
         BUTTON,AT(22,1,15,15),MSG('Print The Report'),TIP('Print The Report'),USE(?PreviewPrint),ICON(ICON:Print)
         BUTTON,AT(41,1,15,15),MSG('Printer Setup'),TIP('Printer Setup'),USE(?Button8),ICON(ICON:Print), |
             STD(STD:PrintSetup)
         BUTTON,AT(62,1,15,15),MSG('First Page'),TIP('First Page'),KEY(HomeKey),USE(?PreviewTop),ICON(ICON:VCRtop)
         BUTTON,AT(80,1,15,15),MSG('Previous Page'),TIP('Previous Page'),KEY(PgUpKey),USE(?PreviewPreviousPage), |
             ICON(ICON:VCRrewind)
         BUTTON,AT(98,1,15,15),MSG('Next Page'),TIP('Next Page'),KEY(PgDnKey),USE(?PreviewNextPage),ICON(ICON:VCRfastforward)
         BUTTON,AT(116,1,15,15),MSG('Last Page'),TIP('Last Page'),KEY(EndKey),USE(?PreviewBottom),ICON(ICON:VCRbottom)
         BUTTON,AT(134,1,15,15),MSG('Go To Page ???'),TIP('Go To Page ???'),USE(?PreviewJump),ICON(ICON:VCRlocate)
         BUTTON,AT(152,1,15,15),MSG('Delete Page From Report'),TIP('Delete Page From Report'),USE(?PreviewDelete), |
             ICON(ICON:Cut)
         BUTTON('Mark'),AT(172,1,30,15),FONT('Arial',9,,FONT:bold),MSG('Mark Page For Printing'),TIP('Mark Page For Printing'), |
             USE(?Mark)
         BUTTON('+'),AT(209,1,15,15),FONT(,,,FONT:bold),MSG('Zoom In On Page'),TIP('Zoom In / Zoom Out'), |
             USE(?PreviewZoom)
         BUTTON('Facing'),AT(233,1,,15),FONT('Arial',10,,FONT:bold),MSG('View the report two pages at a time'), |
             TIP('Number Of Pages To View'),USE(?PreviewFacing)
       END
       BOX,AT(9,23,136,176),USE(?Page1Frame)
       IMAGE,AT(9,23,136,176),USE(?Page1Image)
       REGION,AT(9,23,136,176),USE(?Page1Zoom)
       BOX,AT(155,23,136,176),USE(?Page2Frame)
       IMAGE,AT(155,23,136,176),USE(?Page2Image)
       REGION,AT(155,23,136,176),USE(?Page2Zoom)
       BOX,AT(84,18,136,176),USE(?SingleFrame)
       IMAGE,AT(84,18,136,176),USE(?SingleImage)
       REGION,AT(84,18,136,176),USE(?SingleZoom)
       IMAGE,AT(0,0),USE(?SingleZoomImage),FULL,HVSCROLL
     END

JumpWindow WINDOW('Jump to a Report Page'),AT(,,150,18),FONT('MS Sans Serif',8,,),CENTER,STATUS,GRAY
       PROMPT('Page:'),AT(4,4,,),USE(?JumpPrompt)
       SPIN(@n5),AT(27,4,32,10),USE(Preview:Jump),RANGE(1,100),STEP(1),MSG('Select a page of the report')
       BUTTON('OK'),AT(74,4,32,10),USE(?OKButton),DEFAULT,MSG('Jump to the selected page')
       BUTTON('Cancel'),AT(111,4,32,10),USE(?CancelButton),MSG('Cancel this selection')
     END

!--------------------TINMAN SOFTWARE CORP.----------------------------------
PrintWindow WINDOW('Print Options'),AT(,,108,105),FONT('System',8,,FONT:bold),CENTER,SYSTEM,GRAY
       STRING('To:'),AT(61,63),FONT('Arial',8,,FONT:regular)
       SPIN(@N_3B),AT(70,64,20,8),FONT('Arial',8,,FONT:regular),MSG('Select Ending Page'),TIP('Select Ending Page'), |
           USE(PAGETO),RANGE(1,999),STEP(1)
       STRING('From:'),AT(22,63),FONT('Arial',8,,FONT:regular)
       SPIN(@N_3B),AT(36,64,20,8),FONT('Arial',8,,FONT:regular),MSG('Select Starting Page'),TIP('Select Starting Page'), |
           USE(PAGEFROM),RANGE(1,999),STEP(1)
       OPTION('Print Ranges'),AT(5,11,96,65),FONT('Arial',9,,FONT:regular),USE(OptionPrint),BOXED
         RADIO('All Pages'),AT(10,21),MSG('Print All Pages'),TIP('Print All Pages'),VALUE('1')
         RADIO('Marked Pages Only'),AT(10,31),MSG('Print Marked Pages Only'),TIP('Print Mark Pages Only'), |
             USE(?OptionPrint:Marked),DISABLE,VALUE('2')
         RADIO('Unmarked Pages Only'),AT(10,41),MSG('Print Unmarked Pages Only'),TIP('Print Unmarked Pages Only'), |
             USE(?OptionPrint:UnMarked),DISABLE,VALUE('3')
         RADIO('Range of Pages'),AT(10,51),MSG('Print A Range Of Pages'),TIP('Print A Range Of Pages'), |
             VALUE('4')
       END
       BUTTON('OK'),AT(16,85,32,10),FONT('Arial',8,,FONT:regular),USE(?PrintOK),DEFAULT
       BUTTON('Cancel'),AT(61,85,32,10),FONT('Arial',8,,FONT:regular),USE(?PrintCancel)
     END
!--------------------TINMAN SOFTWARE CORP.----------------------------------

   CODE

   LOCALRESPONSE = RequestCancelled
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   MQ:Mark = 0
   LOOP Records(PrintPreviewQueue) Times
     ADD(MarkQueue)
   .
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   OPEN(PreviewWindow)
   INIRestoreWindow('ReportViewerWindow','TINTOOLS.INI')
   IF ~OMITTED(2) THEN
     PreviewWindow{Prop:Text} = CLIP(TITLEIN)
   .
   RightPageNumber = 1
   Preview:OpMode = Preview:Op:Normal
   Preview:Zoomed = False
   Preview:Facing = False
   IF RECORDS(PrintPreviewQueue) = 1
     DISABLE(?PreviewFacing)
   END
   DO LoadPages
   ACCEPT
     CASE EVENT()
     OF Event:Accepted
       CASE FIELD()
       OF ?SingleZoom
       OROF ?Page2Zoom
         POST(Event:Accepted,?PreviewZoom)
       OF ?Page1Zoom
         RightPagenumber = LeftPageNumber
         POST(Event:Accepted,?PreviewZoom)
       OF ?PreviewCancel
         POST(Event:CloseWindow)
       OF ?PreviewPrint
!--------------------TINMAN SOFTWARE CORP.----------------------------------
         LOCALRESPONSE = RequestCompleted
         DO PRINTREPORT
         IF LOCALRESPONSE = REQUESTCANCELLED THEN
           CYCLE
         ELSE
           POST(Event:CloseWindow)
         .
!--------------------TINMAN SOFTWARE CORP.----------------------------------
       OF ?PreviewPreviousPage
         IF Preview:OpMode = Preview:Op:Facing
           RightPageNumber -= 2
         ELSE
           RightPageNumber -= 1
         END
         DO LoadPages
       OF ?PreviewNextPage
         IF Preview:OpMode = Preview:Op:Facing
           RightPageNumber += 2
         ELSE
           RightPageNumber += 1
         END
         DO LoadPages
!--------------------TINMAN SOFTWARE CORP.----------------------------------
       OF ?PreviewTop
         RightPageNumber = 1
         DO LoadPages
       OF ?PreviewBottom
         RightPageNumber = RECORDS(PrintPreviewQueue)
         DO LoadPages
       OF ?Mark
         IF Preview:OpMode = Preview:Op:Normal OR Preview:OpMode = Preview:OP:Zoom THEN
           DO MarkPage
         .
       OF ?PREVIEWDELETE
         IF Preview:OpMode = Preview:Op:Normal OR Preview:OpMode = Preview:OP:Zoom THEN
           DO DeletePage
         .
!--------------------TINMAN SOFTWARE CORP.----------------------------------
       OF ?PreviewZoom
         IF Preview:OpMode = Preview:Op:Zoom
           ?PreviewFacing{Prop:Disable} = False
           Preview:Zoomed = False
           ?PreviewZoom{Prop:Text} = '+'
           ?PreviewZoom{Prop:Msg} = 'Zoom in on a page of this report'
           IF Preview:Facing
             Preview:OpMode = Preview:Op:Facing
           ELSE
             Preview:OpMode = Preview:Op:Normal
           END
         ELSE
           ?PreviewFacing{Prop:Disable} = True
           Preview:OpMode = Preview:Op:Zoom
           Preview:Zoomed = False
           ?PreviewZoom{Prop:Text} = '-'
           IF Preview:Facing
             ?PreviewZoom{Prop:Msg} = 'Zoom out to facing page mode'
           ELSE
             ?PreviewZoom{Prop:Msg} = 'Zoom out to full page mode'
           END
         END
         DO LoadPages
       OF ?PreviewFacing
         IF Preview:OpMode = Preview:Op:Facing
           IF RightPageNumber > RECORDS(PrintPreviewQueue)
             RightPageNumber = LeftPageNumber
           END
           Preview:OpMode = Preview:Op:Normal
           Preview:Facing = False
           ?PreviewFacing{Prop:Text} = '&Facing'
           ?PreviewFacing{Prop:Msg} = 'View the report two pages at a time'
         ELSE
           IF RightPageNumber % 2 = 0
             RightPageNumber += 1
             LeftPageNumber += 1
           END
           Preview:Facing = True
           Preview:OpMode = Preview:Op:Facing
           ?PreviewFacing{Prop:Text} = '&Single'
           ?PreviewFacing{Prop:Msg} = 'View the report one page at a time'
         END
         DO LoadPages
       OF ?PreviewJump
         OPEN(JumpWindow)
         IF RightPageNumber > RECORDS(PrintPreviewQueue)
           Preview:Jump = LeftPageNumber
         ELSE
           Preview:Jump = RightPageNumber
         END
         ?Preview:Jump{Prop:RangeHigh} = RECORDS(PrintPreviewQueue)
         ACCEPT
           CASE ACCEPTED()
           OF ?OKButton
             RightPageNumber = Preview:Jump
             POST(Event:CloseWindow)
           OF ?CancelButton
             POST(Event:CloseWindow)
           END
         END
         CLOSE(JumpWindow)
         DO LoadPages
       END
     END
   END
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   FREE(MarkQueue)
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   INISaveWindow('ReportViewerWindow','TINTOOLS.INI')
   CLOSE(PreviewWindow)
   RETURN(LOCALRESPONSE)

LoadPages ROUTINE
   LeftPageNumber = RightPageNumber - 1
   IF Preview:OpMode = Preview:Op:Normal
     IF ?Page1Image{Prop:Hide} = False
       HIDE(?Page1Image)
       HIDE(?Page1Frame)
       DISABLE(?Page1Zoom)
     END
     IF ?Page2Image{Prop:Hide} = False
       HIDE(?Page2Frame)
       HIDE(?Page2Image)
       DISABLE(?Page2Zoom)
     END
     IF ?SingleZoomImage{Prop:Hide} = False
       HIDE(?SingleZoomImage)
     END
     IF ?SingleImage{Prop:Hide} = True
       UNHIDE(?SingleImage)
       UNHIDE(?SingleFrame)
       ENABLE(?SingleZoom)
     END
     GET(PrintPreviewQueue,RightPageNumber)
     ?SingleImage{Prop:Text} = PrintPreviewQueue
     PreviewWindow{Prop:StatusText,2} = ''
     PreviewWindow{Prop:StatusText,3} = 'Single Page'
     PreviewWindow{Prop:StatusText,5} = 'Page ' & RightPageNumber & ' of ' & RECORDS(PrintPreviewQueue)
!--------------------TINMAN SOFTWARE CORP.----------------------------------
     Do CheckMark
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   ELSIF Preview:OpMode = Preview:Op:Facing
     IF RightPageNumber % 2 = 0
       RightPageNumber += 1
       LeftPageNumber += 1
     END
     IF ?SingleZoomImage{Prop:Hide} = False
       HIDE(?SingleZoomImage)
     END
     IF ?SingleImage{Prop:Hide} = False
       HIDE(?SingleImage)
       HIDE(?SingleFrame)
       DISABLE(?SingleZoom)
     END
     IF LeftPageNumber = 0
       IF ?Page1Image{Prop:Hide} = False
         HIDE(?Page1Image)
         HIDE(?Page1Frame)
         DISABLE(?Page1Zoom)
       END
     ELSE
       IF ?Page1Image{Prop:Hide} = True
         UNHIDE(?Page1Image)
         UNHIDE(?Page1Frame)
         ENABLE(?Page1Zoom)
       END
       GET(PrintPreviewQueue,LeftPageNumber)
       ?Page1Image{Prop:Text} = PrintPreviewQueue
     END
     IF LeftPageNumber = RECORDS(PrintPreviewQueue)
       IF ?Page2Image{Prop:Hide} = False
         HIDE(?Page2Image)
         HIDE(?Page2Frame)
         DISABLE(?Page2Zoom)
       END
     ELSE
       IF ?Page2Image{Prop:Hide} = True
         UNHIDE(?Page2Image)
         UNHIDE(?Page2Frame)
         ENABLE(?Page2Zoom)
       END
       GET(PrintPreviewQueue,RightPageNumber)
       ?Page2Image{Prop:Text} = PrintPreviewQueue
     END
     IF LeftPageNumber AND RightPageNumber =< RECORDS(PrintPreviewQueue)
       PreviewWindow{Prop:StatusText,5} = 'Pages ' & LeftPageNumber & ' and ' & RightPageNumber & ' of ' & RECORDS(PrintPreviewQueue)
     ELSIF LeftPageNumber AND RightPageNumber > RECORDS(PrintPreviewQueue)
       PreviewWindow{Prop:StatusText,5} = 'Page ' & LeftPageNumber & ' of ' & RECORDS(PrintPreviewQueue)
     ELSE
       PreviewWindow{Prop:StatusText,5} = 'Page ' & RightPageNumber & ' of ' & RECORDS(PrintPreviewQueue)
     END
     PreviewWindow{Prop:StatusText,2} = ''
     PreviewWindow{Prop:StatusText,3} = 'Facing Pages'
   ELSE
     IF ?Page1Image{Prop:Hide} = False
       HIDE(?Page1Image)
       HIDE(?Page1Frame)
       DISABLE(?Page1Zoom)
     END
     IF ?Page2Image{Prop:Hide} = False
       HIDE(?Page2Frame)
       HIDE(?Page2Image)
       DISABLE(?Page2Zoom)
     END
     IF ?SingleZoomImage{Prop:Hide} = False
       HIDE(?SingleZoomImage)
     END
     IF ?SingleImage{Prop:Hide} = False
       HIDE(?SingleImage)
       HIDE(?SingleFrame)
       DISABLE(?SingleZoom)
     END
     GET(PrintPreviewQueue,RightPageNumber)
     ?SingleZoomImage{Prop:Text} = PrintPreviewQueue
     UNHIDE(?SingleZoomImage)
     PreviewWindow{Prop:StatusText,2} = 'ZOOM'
     PreviewWindow{Prop:StatusText,3} = 'Single Page'
     PreviewWindow{Prop:StatusText,5} = 'Page ' & RightPageNumber & ' of ' & RECORDS(PrintPreviewQueue)
!--------------------TINMAN SOFTWARE CORP.----------------------------------
     Do CheckMark
!--------------------TINMAN SOFTWARE CORP.----------------------------------
   END

   IF RightPageNumber = 1
     DISABLE(?PreviewPreviousPage)
   ELSE
     ENABLE(?PreviewPreviousPage)
   END
   IF RightPageNumber => RECORDS(PrintPreviewQueue)
     DISABLE(?PreviewNextPage)
   ELSE
     ENABLE(?PreviewNextPage)
   END

!--------------------TINMAN SOFTWARE CORP.----------------------------------
MarkPage ROUTINE
  IF MQ:Mark
    PageMarked -= 1
    MQ:Mark = False
!    ?Mark{Prop:Text} = '&Mark'
  ELSE
    PageMarked += 1
    MQ:Mark = True
!    ?Mark{Prop:Text} = 'Un&Mark'
  .
  PUT(MarkQueue)
  DO CHECKMARK

CheckMark ROUTINE
  GET(MarkQueue,POINTER(PrintPreviewQueue))
  IF MQ:Mark
    ?Mark{Prop:Text} = 'Un&Mark'
    ?Mark{Prop:Msg}  = 'Unmark Page'
    PreviewWindow{Prop:StatusText,4} = 'Marked'
  ELSE
    ?Mark{Prop:Text} = '&Mark'
    ?Mark{Prop:Msg}  = 'Mark Page'
    PreviewWindow{Prop:StatusText,4} = ''
  .

DeletePage ROUTINE
  GET(PrintPreviewQueue,RightPageNumber)
  GET(MarkQueue,POINTER(PrintPreviewQueue))
  DELETE(PrintPreviewQueue)
  DELETE(MarkQueue)
  IF RightPageNumber <> 1 THEN RightPageNumber -= 1.
  DO LoadPages

PrintReport     ROUTINE
  OptionPrint = 1
  OPEN(PrintWindow)
  IF PageMarked
    ?OptionPrint:Marked{Prop:Disable} = False
    ?OptionPrint:UnMarked{Prop:Disable} = False
  .
  ?PageFrom{Prop:RangeHigh} = RECORDS(PrintPreviewQueue)
  ?PageTo{Prop:RangeHigh}   = RECORDS(PrintPreviewQueue)
  ACCEPT
    CASE ACCEPTED()
      OF ?PrintOK
        LOCALRESPONSE = RequestCompleted
        POST(Event:CloseWindow)
      OF ?PrintCancel
        LOCALRESPONSE = RequestCancelled
        POST(Event:CloseWindow)
    END
    CASE SELECTED()
      OF PageFrom OROF PageTo
        OptionPrint = 4
    END
    PREVIEWPRINTER = PRINTER{PROPPRINT:Device}
    DISPLAY()
  END
  IF LOCALRESPONSE = RequestCompleted AND OptionPrint <> 1
    DO DiscardPages
  .
  CLOSE(PrintWindow)

DiscardPages        ROUTINE
  LOOP IDiscard# = RECORDS(PrintPreviewQueue) TO 1 BY -1
    IF OptionPrint = 2 OR OptionPrint = 3
      GET(MarkQueue,IDiscard#)
      IF(OptionPrint = 2 AND MQ:Mark) |
      OR(OptionPrint = 3 AND NOT MQ:Mark)
        CYCLE
      .
    ELSE
      IF IDiscard# >= PageFrom AND IDiscard# <= PageTo
        CYCLE
    . .
    GET(PrintPreviewQueue,IDiscard#)
    PREV:MetaFileName = PrintPreviewQueue
    REMOVE(PREV:MetaFile)
    DELETE(PrintPreviewQueue)
  END
!--------------------TINMAN SOFTWARE CORP.----------------------------------
