/*
 *  EXEC.C - external program execution
 *
 *
 *
 *  Comments:
 *
 *  ?????? (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 *  12/??/95 (Svante Frey) ------------------------------------------------
 *    reorganized code
 *
 *  1/6/96 (Tim Norman) ---------------------------------------------------
 *    added this history
 *
 */

#include <stdio.h>
#include <dos.h>
#include <string.h>

typedef unsigned char byte;
typedef unsigned word;

/* align one byte */
#pragma option -a-
   struct ExecBlock {
      word segOfEnv;
      char far*cmdLine;
      struct fcb far*fcb1, far*fcb2;
   };
/* default alignment */
#pragma option -a.

int lowLevelExec(char far *cmd, struct ExecBlock far *bl);

int exec(const char *cmd, char *cmdLine, const unsigned segOfEnv)
{   
   unsigned char buf[128];
   struct fcb fcb1, fcb2;
   struct ExecBlock execBlock;

   /* generate Pascal string from the command line */
   memcpy(&buf[1], cmdLine, buf[0] = strlen(cmdLine));
   memcpy(&buf[1] + buf[0], "\xd", 2);
   
   /* fill execute structure */
   execBlock.segOfEnv = segOfEnv;
   execBlock.cmdLine = (char far*)buf;
   execBlock.fcb1 = (struct fcb far*)&fcb1;
   execBlock.fcb2 = (struct fcb far*)&fcb2;
   
   /* fill FCBs */
   if((cmdLine = parsfnm(cmdLine, &fcb1, 1)) != NULL)
      parsfnm(cmdLine, &fcb2, 1);

   return lowLevelExec(cmd, &execBlock);
}
