/* ============ */
/* tstvrt.c	*/
/* ============ */
/*		*/
/* tests augvrt */
/*		*/
#include "augvrt.c"
#include "getdbl.c"
#include "matmpy.c"
#include "matprt.c"
# if defined (__BORLAND__)
#	include <mem.h>
# else
#	include <memory.h>
# endif

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	augvrt F((double *, int, int, int));
extern	void	getdbl F((char *, double *));
extern	void	matmpy F((double *, int, int, double *, int, int,
			  double *, int, int));
extern	void	matprt F((double *, int, int, FILE *, char *));

# undef F
/* INDENT ON */

/* ---------------------------------------------------- */
/* This test function tests augvrt() on a 4 x 4 matrix.	*/
/* The augmenting right-hand side is held separately.	*/
/* Function augvrt() will invert the 4 x 4 matrix. This	*/
/* test function will then multiply the inverse matrix	*/
/* by the augmenting vector to yield a solution vector.	*/
/* This solution is then compared with the known one.	*/
/* ---------------------------------------------------- */

void
main()
{
    /* ------------ */
    /* Input Matrix */
    /* ------------ */
    static double a[] =
	{
	5.,  7.,  6.,  5.,
	7., 10.,  8.,  7.,
	6.,  8., 10.,  9.,
	5.,  7.,  9., 10.
	};

    /* -------------- */
    /* Target Inverse */
    /* -------------- */
    static double ainv[] =
	{
	 68., -41., -17., 10.,
	-41.,  25.,  10., -6.,
	-17.,  10.,   5., -3.,
	 10.,  -6.,  -3.,  2.
	};

    /* Right-hand side */
    static double v[] =
	{ 1., 2., 3., 4. };
    /* Solution Vector */
    static double s[] =
	{ -25., 15., 6., -3. };

    /* Temps */
    double det, fudge;
    double r[4];
    double x[sizeof(a)/sizeof(double)];

    matprt(a, 4, 4, stdout, "\nSource Matrix:");

    matprt(v, 1, 4, stdout, "\nAugmenting Vector:");

    while (main)			/* Silences Compiler */
    {
	getdbl("Enter Fudge Factor: ", &fudge);

	memcpy(x, a, sizeof(a));

	x[0] += fudge;
	matprt(x, 4, 4, stdout, "\nSource Matrix with Fudge Factor:");

	det = augvrt(x, 4, 4, 4);
	printf("Determinant = %.12e\n", det);

	matprt(x, 4, 4, stdout, "Inverse via augvrt():");
	matprt(ainv, 4, 4, stdout, "Target Inverse:");

	matmpy(x, 4, 4, v, 4, 1, r, 0, 0);
	matprt(r, 1, 4, stdout, "Solution Vector:");
	matprt(s, 1, 4, stdout, "Target Solution:");
	fflush((FILE *)0);
    }
}					/* main */
