/* ============ */
/* tstvrt3.c	*/
/* ============ */
/*		*/
/* tests augvrt */
/*		*/
#include "augvrt.c"
#include "getdbl.c"
#include "matmpy.c"
#include "matprt.c"
# if defined (__BORLAND__)
#	include <mem.h>
# else
#	include <memory.h>
# endif

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	double	augvrt F((double *, int, int, int));
extern	void	getdbl F((char *, double *));
extern	void	matmpy F((double *, int, int, double *, int, int,
			  double *, int, int));
extern	void	matprt F((double *, int, int, FILE *, char *));

# undef F
/* INDENT ON */

/* ---------------------------------------------------- */
/* This test function tests augvrt() on a 4 x 6 matrix.	*/
/* The augmenting right-hand side is in column 5 and	*/
/* column 6 is not used.  Function augvrt() will invert	*/
/* the 4 x 4 matrix, produce the requisite solution in	*/
/* column 5 and leave column 6 untouched.		*/
/* ---------------------------------------------------- */

void
main()
{
    /* ------------ */
    /* Input Matrix */
    /* ------------ */
    static double a[] =
	{
	5.,  7.,  6.,  5., 1., 0.,
	7., 10.,  8.,  7., 2., 1.,
	6.,  8., 10.,  9., 3., 2.,
	5.,  7.,  9., 10., 4., 3.
	};

    /* -------------- */
    /* Target Inverse */
    /* -------------- */
    static double ainv[] =
	{
	 68., -41., -17., 10., -25., 0.,
	-41.,  25.,  10., -6.,  15., 1.,
	-17.,  10.,   5., -3.,   6., 2.,
	 10.,  -6.,  -3.,  2.,  -3., 3.
	};

    /* Temps */
    double x[sizeof(a)/sizeof(double)];
    double det, fudge;

    matprt(a, 4, 6, stdout, "\nSource Matrix:");

    while (main)			/* Silences Compiler */
    {
	getdbl("Enter Fudge Factor: ", &fudge);

	memcpy(x, a, sizeof(a));

	x[0] += fudge;
	matprt(x, 4, 6, stdout, "\nSource Matrix with Fudge Factor:");

	det = augvrt(x, 4, 5, 6);
	printf("Determinant = %.12e\n", det);

	matprt(x, 4, 6, stdout, "Result Matrix via augvrt():");
	matprt(ainv, 4, 6, stdout, "Target Result Matrix:");

	fflush((FILE *)0);
    }
}					/* main */
