#ifndef DPH_TIME_H
#define DPH_TIME_H


#include <dos.h>           // BORLAND HEADER
#include <bios.h>          // BORLAND HEADER
#include <time.h>          // BORLAND HEADER

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
//   class DPH_Time
//       Implements a seconds clock which recycles every hour
//       from 0 - 3600 seconds, and has granularity of 1/18 second.
//       copyright David Perelman-Hall 1995
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

class DPH_Time {
   DPH_Time(const DPH_Time&);            // CAN'T COPY CONSTRUCT
   DPH_Time& operator=(const DPH_Time&); // CAN'T ASSIGN
   public:
      // CTOR   
      DPH_Time() {}

      // DTOR   
      ~DPH_Time() {}

      // USAGE
      int GetSeconds() const { // CONVERTS ALL TIME ELEMENTS TO SECONDS
         gettime(&t);   // RETURN VALUE IS SUM OF SECONDS
         return t.ti_min*60+t.ti_sec;
      }
      long Get18thSeconds() const { return biostime(0,0L); }
      int PastSeconds( int start, int period ) const {
         int current = GetSeconds();   
         if( current >= start )
            return (current - start) > period;
         else
            // TOTAL SECONDS FROM TOP OF HOUR TO TOP OF HOUR
            return ((3600 - start) + current) > period;
      }
      int Past18thSeconds( long start, unsigned int period ) const {
         long current = Get18thSeconds();   
         if( current >= start )
            return (current - start) > period;
         else
            // TOTAL TICKS FROM MIDNIGHT TO MIDNIGHT   
            return ((1572480L - start) + current) > period;
      }
      void PauseSeconds( int seconds ) const { sleep(seconds); }
      inline void Pause18thSeconds( int partSeconds ) const;
   private:
      static struct time t;
};

#endif
