#include "misc.h"    // CLASS HEADERS AND MISCELLANEOUS INCLUDES
#pragma hdrstop      // STOP PRECOMPILED HEADERS
#include "sdi12.h"

// FUNCTION PROTOTYPES
void show_sdi_options();
void exercise_sdi_object( SDI12_Logger& );
void clear_screen_area();

int main( int argc, char *argv[] )
{
   // THE DEFAULT FILE TO CONFIGURE WITH
   String fileName = "SDI12.CFG";

   // GET A FILE OTHER THAN THE DEFAULT ONE IF USER DESIRES
   if( argc == 2 ) 
      fileName = argv[1];

   // TRY TO READ IN A CONFIGURATION FOR THE SDI-12 LOGGER FROM FILE
   ifstream infile( fileName.c_str() ); // CREATES INPUT FILE STREAM
   if( infile.good() ) {
      SDI12_Logger SDI;
      infile >> SDI;    // CONFIGURE OBJECT FROM PARAMETERS STORED IN FILE
      String port;
      infile >> port;
      SDI.Setup( port );
      assert( SDI.IsValid() ); // DOES METHOD-SPECIFIC CHECK
      system( "cls" );    // CLEAR THE SCREEN
      show_sdi_options(); // PRINT THE SDI-12 COMMAND SET MENU
      exercise_sdi_object( SDI ); // USE SDI-12 COMMAND SET TILL USER ABORTS
   }
   else {
      cerr << "Unable to locate the file \"" << fileName << "\" to configure 
SDI-12 object\n";
      cerr << "Aborting without doing any SDI-12 tests\n";
   }
   return 0;
}


// MAIN WORK IS DONE HERE
void exercise_sdi_object( SDI12_Logger& SDI )
{
   int hellFrozeOver = 0;     // LOOP TERMINATING FLAG
   while( !hellFrozeOver ) {  // PERFORM LOOP FOREVER
      gotoxy( 10, 15 );       // POSITION CURSOR BELOW MENU LIST
      char localCommand = getch(); // GET USER'S KEY STROKE
      cout << localCommand << endl; // ECHO KEYSTROKE TO SCVREEN
      if( localCommand == 'q' || localCommand == 'Q' ) // QUIT
         hellFrozeOver = 1;
      else {         // PERFORM THE SDI COMMAND
         String str; // LOCAL String VARIABLE
         clear_screen_area(); // CLEAR THE AREA BELOW THE MENU LIST
         switch( localCommand ) {
            case 'm': localCommand = '\0'; // DEFAULT MEASURE COMMAND
            case '1': // ALL OF THESE FROM 1 THROUGH 9
            case '2': // RESULT IN CONSECUTIVE MEASUREMENT COMMAND
            case '3': // EQUIVALENT TO <aMn!> WHERE n IS 1-9
            case '4':
            case '5':
            case '6':
            case '7':
            case '8':
            case '9':
               {
                  // ISSUE THE TAKE MEASUREMENT COMMAND
                  str = SDI.Measure( String(localCommand) );

                  // CHECK FOR SERVICE REQUEST OR TIMEOUT
                  SDI12_Logger::SDI12_REPLY reply = SDI.DataReady( str );
                  switch( reply ) {
                     case SDI12_Logger::REPLY_OK:
                        cout << "Data Ready\n";
                        break;
                     case SDI12_Logger::REPLY_FAIL:
                        cout << "Failure to get data!\n";
                        break;
                     case SDI12_Logger::REPLY_TIMEOUT:
                        cout << SDI.Model() << " timed out. New data may be 
available.\n";
                        break;
                  }
               }
               break;
            case 'a': // SDI-12 ACKNOWLEDGE
               cout << "Acknowledgement = " << SDI.Acknowledge() << endl;
               break;
            case 'd': // SDI-12 REQUEST DATA. EQUIVALWENT TO <aD0!>
                  cout << "Data = " << SDI.Data() << endl;
                  break;
            case 'i': // SDI-12 IDENTIFY
               cout << "Identify = " << SDI.Identify() << endl;
               break;
            case 's': // SHOW SDI OBJECT SETUP
               cout << endl << SDI << endl;
               break;
            case 'v': // SDI-12 VERIFY
               cout << "Verify = " << SDI.Verify() << endl;
               break;
            case '!': // SDI-12 <aD1!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('1') << endl;
               break;
            case '@': // SDI-12 <aD2!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('2') << endl;
               break;
            case '#': // SDI-12 <aD3!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('3') << endl;
               break;
            case '$': // SDI-12 <aD4!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('4') << endl;
               break;
            case '%': // SDI-12 <aD5!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('5') << endl;
               break;
            case '^': // SDI-12 <aD6!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('6') << endl;
               break;
            case '&': // SDI-12 <aD7!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('7') << endl;
               break;
            case '*': // SDI-12 <aD8!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('8') << endl;
               break;
            case '(': // SDI-12 <aD9!> CONSECUTIVE DATA COMMAND
               cout << "Data = " << SDI.Data('9') << endl;
               break;
            default:
               cerr << "Unrecognized command\n";
         }
      }
   }
   gotoxy( 1, 24 ); // POSITION CURSOR AT SCREEN BOTTOM WHEN QUITTING
}


void clear_screen_area()
{
   String emptyLine = "                                                      
             ";
   gotoxy( 1, 16 );
   for( int i=0; i<8; ++i)
      cout << emptyLine << '\n';
   gotoxy( 1, 16 );
}


void show_sdi_options()
{
   cout << "Type command from command set below.\n\n";
   cout << "  Action You Want \tCommand To Give\n";
   cout << "  ----------------\t---------------\n";
   cout << "  Acknowledge     \tPress 'a'\n";
   cout << "  Identify        \tPress 'i'\n";
   cout << "  Default Measure \tPress 'm'\n";
   cout << "  Specific Measure\tPress '1/2/3/4/5/6/7/8/9' (pick measure 
number)\n";
   cout << "  Default Data    \tPress 'd'\n";
   cout << "  Consecutive data\tPress '!/@/#/$/%/^/&/*/(' (uppercase number)\n";
   cout << "  Verify          \tPress 'v'\n";
   cout << "  Show Setup      \tPress 's'\n";
   cout << "  To Quit         \tPress 'q'\n\n";
   cout << "Command?";
}
