/***************************************************/ 
/* neuron_deltas

   void neuron_deltas(...
   
   This function calculates the deltas for the 
   neurons in the network.  It starts are the
   output stage of the network and works its
   way back through the network to the input
   layer.
*/   

void neuron_deltas(ELEMENT *h, 
                   ELEMENT *h_delta, 
                   ELEMENT *delta, 
                   ELEMENT *whid,
                   ELEMENT *wout, 
                   int     n, 
                   int     o,
                   int     p)
{                   
   ELEMENT *tmp, *tmph, *tmpw;
   ELEMENT one = (ELEMENT)(1.0);
   int     i, j;
   
   
   tmp  = (ELEMENT  *) 
          malloc((int)(p) * sizeof(ELEMENT));
   tmph = (ELEMENT  *) 
          malloc((int)(p) * sizeof(ELEMENT));
   tmpw = (ELEMENT  *) 
          malloc((int)(p*p) * sizeof(ELEMENT));

      /**********************************
      *
      *   First, find the deltas for the
      *   last layer of neurons using the
      *   delta and wout arrays.
      *
      *************************************/   
      
   zero_array(tmp, p);
   matrix_multiply(wout, p, o, delta, 1, tmp);

   for(i=0; i<p; i++){
      /**h_delta[i][n-1] = 
         h[i][n-1] * (one - h[i][n-1]) * tmp[i];**/
      h_delta[i*n + n-1] = 
         h[i*n + n-1] * (one - h[i*n + n-1]) * tmp[i];
      
   }                                            

      /************************************
      *
      *   Now, find the deltas for all the
      *   other layers of neurons.
      *
      *************************************/   

   for(i=(n-1); i>0; i--){

      copy_3d_to_2d(whid, tmpw, (n-1), p, p, (i-1));
      copy_2d_to_1d(tmph, h_delta, p, n, i, "col");

      zero_array(tmp, p);
      matrix_multiply(tmpw, p, p, tmph, 1, tmp);
      
      for(j=0; j<p; j++){
         /**h_delta[j][i-1] = 
            h[j][i-1]*(one - h[j][i-1])*tmp[j];**/
         h_delta[j*n + i-1] = 
            h[j*n + i-1]*(one - h[j*n + i-1])*tmp[j];
      }  /* ends loop over j */
   }  /* ends loop over i */
      
   free(tmp);
   free(tmph);
   free(tmpw);
}  /* ends neuron_deltas */
