/***************************************************/
/* input_layer

   void input_layer(...

   This function performs the calculations
   between the input array and the input weights
   to produce the first layer of neurons.
   
   x[1][m] win[m][p] = first column of h[p][n]
   
   Use a tmp array in the call to matrix_multiply
   then copy the answer back to the first column
   of h.
*/

void input_layer(ELEMENT *h, 
                 ELEMENT *x, 
                 ELEMENT *win, 
                 int     m,
                 int     p,
                 int     n,
                 char    type[])
{
   ELEMENT *tmp;
   tmp = (ELEMENT  *) 
         malloc((int)(p) * sizeof(ELEMENT));

   zero_array(tmp, p);      
   matrix_multiply(x, 1, m, win, p, tmp);
   apply_function(tmp, p, type);
   copy_1d_to_2d(tmp, h, p, n, 0, "col");
   free(tmp);      
   
}  /* ends input_layer */

