-- Implementation of class Shirt --
//  FEWMANY.CPP

#include "fewmany.h"
#include <string.h>
#include <assert.h>
#include <iomanip.h>

const int rows = 3, columns = 6;
const char* enum_names[rows][columns] = {
   { "white",  "blue", "tan", "green", "yellow", "gray" },
   { "regular", "tall", "big", "formfit", "", "" },
   { "shortsleeve", "longsleeve", "", "", "", "" }
};

Shirt::Shirt(sleeve_arg, float x) : color_(dfcolor),
   form_(dfform), style_(dfstyle), sleeve_(x), neck_(dfneck) {
   if (x < 15) style_ = shortsleeve;
   else style_ = longsleeve;
   sleeve_ = x;
}
Shirt& Shirt::operator() (style x) {
   style_ = x;
   if (x == longsleeve && sleeve_ < 15) sleeve_ = 32;
   if (x == shortsleeve && sleeve_ >= 15) sleeve_ = 0;
   return *this;
}
Shirt& Shirt::operator() (sleeve_arg, float x) {
   if (x < 15) style_ = shortsleeve;
   else style_ = longsleeve;
   sleeve_ = x;
   return *this;
}
int Shirt::enum_value(size_t i) {
   // Return enum value (as an int) of the ith variable.
   // This function is used in operator<< (...)
   switch (i) {
      case 0: return color_;
      case 1: return form_;
      case 2: return style_;
      default: assert(i < 3);
      return -1;
   }
}
ostream& operator<< (ostream& os, Shirt& arg) {
   static const int w[rows] = { 7, 8, 0 }; // vary trailing spaces
   for (int i = 0; i < rows; i++) {
      const char* vv = enum_names[i][arg.enum_value(i)];
      if (i < 2 || arg.sleeve_ == 0)
         os << vv << ',' << setw(w[i] - strlen(vv)) << ' ';
      else os << arg.sleeve_ << " sleeve,   ";
   }
   os << arg.neck_ << " neck" << endl;
   return os;
}
// End of file

