-- Definition of class Shirt --
//  FEWMANY.H

#include <iostream.h>
#include <stdlib.h>

// Enum types for enum variables.
enum color { white, blue, tan, green, yellow, gray };
enum form  { regular, tall, big, formfit };
enum style { shortsleeve, longsleeve };

// Specifier enum types for built-in type variables
enum sleeve_arg { sleeve };
enum neck_arg   { neck };

// Default values for data members
const color dfcolor  = white;
const form  dfform   = regular;
const style dfstyle  = longsleeve;
const float dfsleeve = 32.; // default sleeve length, inches
const float dfneck   = 15.; // default neck size, inches

class Shirt {
   // Variables which can be initialized with default values
   color color_;
   form  form_;
   style style_;
   float sleeve_;
   float neck_;
   friend ostream& operator<< (ostream&, Shirt&);
   int enum_value(size_t i); // (int)(value of ith enum)
public:
   // Single argument constructors for enum variables
   Shirt(color x=dfcolor) : color_(x), form_(dfform),
      style_(dfstyle), sleeve_(dfsleeve), neck_(dfneck) {;}
   Shirt(form  x) : color_(dfcolor), form_(x),
      style_(dfstyle), sleeve_(dfsleeve), neck_(dfneck) {;}
   Shirt(style x) : color_(dfcolor), form_(dfform), style_(x),
      sleeve_(x==shortsleeve? 0 : dfsleeve), neck_(dfneck) {;}
   // Two argument constructors for built-in types
   Shirt(neck_arg, float x) : color_(dfcolor), form_(dfform),
      style_(dfstyle), sleeve_(dfsleeve), neck_(x) {;}
   Shirt(sleeve_arg, float x);
   // operator() calls for subsequent parameter changes
   Shirt& operator() (color x)
      { color_ = x; return *this; }
   Shirt& operator() (form x)
      { form_  = x; return *this; }
   Shirt& operator() (style x);
   Shirt& operator() (neck_arg, float x)
      { neck_ = x; return *this; }
   Shirt& operator() (sleeve_arg, float x);
};
// End of file

