-- Test Program and output for class Shirt
// TFEWMANY.CPP -- Test FEWMANY

#include "fewmany.h"
#include <fstream.h>

// This macro was borrowed from Bruce Eckel's
// "Thinking in C++", Prentice Hall, 1995, page 238.
#define D(a) out << '\n' << #a << endl; a

const char* outname = "fewmany.out";
ofstream out(outname);

void main() {
   cout  << "Test FEWMANY.CPP; output written to "
         << outname << endl;
   out   << "Listing 4 -- Test output data for FEWMANY"
         << endl << "File " << outname << endl;
   D(out << Shirt();)
   D(out << Shirt(green);)
   D(out << Shirt(big);)
   D(out << Shirt(sleeve, 30);)
   D(out << Shirt(sleeve, 0);)
   D(out << Shirt(shortsleeve);)
   D(out << Shirt(neck, 14.5);)
   D(out << Shirt(formfit)(blue);)
   D(out << Shirt(big)(blue)(shortsleeve);)
   D(out << Shirt(tall)(neck, 15.5)(tan);)
   D(out << Shirt(big)(yellow)(neck, 16.5)(sleeve,34);)
   D(out << Shirt(neck, 14)(formfit)(gray)(shortsleeve);)
   out   << "\nEnd of file." << endl;
}

Output:

white,  regular, 32 sleeve,   15 neck
green,  regular, 32 sleeve,   15 neck
white,  big,     32 sleeve,   15 neck
white,  regular, 30 sleeve,   15 neck
white,  regular, shortsleeve, 15 neck
white,  regular, shortsleeve, 15 neck
white,  regular, 32 sleeve,   14.5 neck
blue,   formfit, 32 sleeve,   15 neck
blue,   big,     shortsleeve, 15 neck
tan,    tall,    32 sleeve,   15.5 neck
yellow, big,     34 sleeve,   16.5 neck
gray,   formfit, shortsleeve, 14 neck






