/* inverse hyperbolic cosine (i.e., ArcCosh) functions for double and long double */

/* tested for compilation with BCC 4.02 (16 bit only), TC 2.0, TC++ 3.0,
   MS C 5.1, 6.0, MS C/C++ 7.0, 8.0 (i.e., VC 1.0)  */

#include <float.h>
#include <math.h>

/*  BEGINNING OF COPYRIGHT AND PERMISSION NOTICE */

char * copyright_Arc_cosh = "Copyright (c) Kevin G. Rhoads 1995 - All rights reserved.";

/*  Copyright (c) Kevin G. Rhoads 1995 - All rights reserved.

    Permission to copy and distribute the source code is granted provided:
      1) this copyright and permission notice is retained
      2) no charges beyond nominal duplication costs are made
    This permission specifically INCLUDES permission to publish, as in
    magazines and books, together with any related code disks, listings disks,
    wherein publication of computer software and/or code is commonly made.

    Permission to incorporate object code derived from this source in libraries
    or executables for any purpose is granted provided that it is understood:
      1) this code is provided "as is"
      2) no warrantee is made of its correctness
      3) no warrantee is made of its fitness to your intended use(s)
    This permission specifically INCLUDES permission to include object and/or
    executable forms in commercial works, works for hire and/or for profit, and
    all uses of the object code after compilation in any legal manner.

    Permission to make derivative works is granted provided that
      1) this copyright and permission notice is retained with the
	 substitution of:
	 "based on original material copyrighted (c) 1995 Kevin G. Rhoads - All rights reserved."
	 in place of the copyright line above
      2) you include a copyright notice similar to this; e.g., the Free
	 Software Foundation "COPYLEFT" is acceptable

    Use of this code indicates your willingness to indemnify and hold blameless
    the author, and any persons or entities by which this code was supplied to
    you.  You will determine its suitability to your intended tasks.  You
    accept all risk deriving from its use.

    If these terms are not acceptable to you, you are not permitted to make or
    keep copies of this code and should destroy all copies in your possession
    immediately.

    END OF COPYRIGHT AND PERMISSION NOTICE  */


/*  N.B., Cosh maps the entire real line into the positive real line greater
    than 1.0,  need to check input ranges.  Also like sqrt ArcCosh can't
    tell if the original argument to Cosh was positive or negative */

/*------------------------------------------------------------------*/
double arc_cosh(double u) {
    return (
	     ( (u >= 1.0e+000)	?
		    ( +log( fabs(u) + sqrt(u*u - 1.0e+000) ) )
		:
		    /* input range error */ ( log(-1.0e+000) )
	     )
	   );
}

/*------------------------------------------------------------------*/
/* MS Documentation claims that long double routines have extra leading
underscore per ANSI spec. as of MS C/C++ v7.0  -- but MS C/C++ v 7.0 that
I have access to does NOT add the second leading underscore in the library
names, so the C code should not use prepended underscore -- */

/*------------------------------------------------------------------*/
long double arc_coshl(long double u) {
    return (
	     ( (u >= 1.0e+0000L)  ?
		    ( +logl( fabsl(u) + sqrtl(u*u - 1.0e+0000L) ) )
		:
		    /* input range error */ ( -logl(-1.0e+0000L) )
	     )
	   );
}

