
/* hyperbolic sine, cosine and tangent (i.e., Sinh, Cosh and Tanh)
   functions for long double -- */

/* tested for compilation with BCC 4.02 (16 bit only), TC 2.0, TC++ 3.0,
   MS C 5.1, 6.0, MS C/C++ 7.0, 8.0 (i.e., VC 1.0)  */

#include <float.h>
#include <math.h>
/*
#include "float.h"
#include "math.h"
*/

/*  BEGINNING OF COPYRIGHT AND PERMISSION NOTICE
    Copyright (c) Kevin G. Rhoads 1995 - All rights reserved .

    Permission to copy and distribute the source code is granted provided:
      1) this copyright and permission notice is retained
      2) no charges beyond nominal duplication costs are made

    Permission to incorporate object code derived from this source in libraries
    or executables for any purpose is granted provided that it is understood:
      1) this code is provided "as is"
      2) no warrantee is made of its correctness
      3) no warrantee is made of its fitness to your intended use(s)

    Permission to make derivative works is granted provided that
      1) this copyright and permission notice is retained with the
	 substitution of:
	 "based on original material copyrighted (c) 1995 Kevin G. Rhoads - All rights reserved."
	 in place of the copyright line above
      2) you include a copyright notice similar to this; e.g., the Free
	 Software Foundation "COPYLEFT" is acceptable

    Use of this code indicates your willingness to indemnify and hold blameless
    the author, and any persons or entities by which this code was supplied to
    you.  You will determine its suitability to your intended tasks.  You
    accept all risk deriving from its use.

    If these terms are not acceptable to you, you are not permitted to make or
    keep copies of this code and should destroy all copies in your possession
    immediately.

    END OF COPYRIGHT AND PERMISSION NOTICE  */

long double _sinhl(long double x) {
    return ( 0.5e+0000L * (expl(x) - expl(-x)) );
}

long double _coshl(long double x) {
    return ( 0.5e+0000L * (expl(x) + expl(-x)) );
}

long double _tanhl(long double x) {
    return ( (expl(x) - expl(-x)) / (expl(x) + expl(-x)) );
}
