------------- Listing 5: The Interrupt Handler Class ----------

class InterruptHandlerClass
{
  void FirstHandle();  // First function to get called when the
    // interrupt occurs. Takes care of calling the virtual
    // Handle() function.
protected:
  virtual void Handle(); // This function gets called when the
    // interrupt occurs. Child classes typically redefine this
    // function to perform useful work. It should be reentrant
    // if an interrupt can recur before the Handle function finishes.
};

void InterruptHandlerClass::FirstHandle()
{
  Handle();
}

void InterruptHandlerClass::Handle()
{
// Base class does nothing in its Handle() function. Null function
// explicitly defined because version of cfront I used did not
// support "pure virtual" functions.
}

